#include "mex.h"
#include "matrix.h"
#include "math.h"
#include "stdio.h"

void mexFunction( int nlhs, mxArray *plhs[],
                  int nrhs, const mxArray *prhs[] )

{

    /* -- Inputs -- */
	double *nin			= mxGetPr(prhs[0]);
	double *nxin		= mxGetPr(prhs[1]);
	double *nyin		= mxGetPr(prhs[2]);
    double *xss 		= mxGetPr(prhs[3]);
    double *yss 		= mxGetPr(prhs[4]);
	double *parmin 		= mxGetPr(prhs[5]);
	double *nnuin 		= mxGetPr(prhs[6]);
	double *Hs  		= mxGetPr(prhs[7]);
	double *Gs 			= mxGetPr(prhs[8]);
	double *Gsp 		= mxGetPr(prhs[9]);
	double *Psspin  	= mxGetPr(prhs[10]);
	double *dP1sspin	= mxGetPr(prhs[11]);
	double *dP2sspin	= mxGetPr(prhs[12]);

	/* -- Specific Inputs -- */
	int n 				= nin[0];
	int nx 				= nxin[0];
	int ny 				= nyin[0];
	double nnus 		= nnuin[0];
	double bbeta 		= parmin[0];
	double rrho 		= parmin[1];
	double oomega 		= parmin[2];
	double eeta 		= parmin[3];
	double aalpha 		= parmin[4];
	double ddelta 		= parmin[5];
	double pbar 		= parmin[6];
	double ebar 		= parmin[7];
	double iiota 		= parmin[8];
	double pphi 		= parmin[9];
	double rbar 		= parmin[10];
	double kkappa   	= parmin[11];
	double rrhoa 		= parmin[12];
	double rrhoz 		= parmin[13];
	double rrhop 		= parmin[14];
	double rrhor 		= parmin[15];
	double rrhoe 		= parmin[16];
	double rrhod 	 	= parmin[17];
	double varphibar 	= parmin[18];
	double bbar 		= parmin[19];
	double ppsir 		= parmin[20];
	double abar  		= parmin[21];
	double zbar 		= parmin[22];
	double Pssp 		= Psspin[0];
	double dP1ssp 		= dP1sspin[0];
	double dP2ssp 		= dP2sspin[0];

	/* -- Outputs -- */
	plhs[0] = mxCreateDoubleMatrix(n*nx*nx,(n+ny)*nx*nx,mxREAL);
	plhs[1] = mxCreateDoubleMatrix(n*nx*nx,1,mxREAL);
	double *Mxx_sp_s = mxGetPr(plhs[0]);
	double *Nxx_sp_s = mxGetPr(plhs[1]);

    /* -- Definition of Variables -- */
    double E = 2.71828182845905;


    /* -- Mathematica Output Here -- */
	Mxx_sp_s[10752]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mxx_sp_s[786432]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mxx_sp_s[787968]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mxx_sp_s[798720]=-(pow(E,yss[8])*Pssp);
	Mxx_sp_s[800256]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxx_sp_s[801792]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxx_sp_s[3073]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[4609]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[6145]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[787969]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[789505]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[794113]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mxx_sp_s[798721]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mxx_sp_s[800257]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[801793]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[3074]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[4610]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[787970]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[789506]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[794114]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mxx_sp_s[797186]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[798722]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mxx_sp_s[800258]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[801794]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[3]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[1539]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3075]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[4611]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mxx_sp_s[6147]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[7683]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[9219]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[10755]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[794115]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mxx_sp_s[798723]=-(pow(E,yss[8])*Pssp);
	Mxx_sp_s[800259]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mxx_sp_s[801795]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mxx_sp_s[2371587]=(bbeta*pow(E,yss[8])*Pssp*pow(Hs[0],2)*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2396163]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[0]*Hs[1]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2420739]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[0]*Hs[2]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2445315]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[0]*Hs[3]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2469891]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[0]*Hs[4]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2494467]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[0]*Hs[5]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2519043]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[0]*Hs[6]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2543619]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[0]*Hs[7]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2592771]=(bbeta*pow(E,yss[8])*Pssp*pow(Hs[1],2)*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2617347]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[1]*Hs[2]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2641923]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[1]*Hs[3]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2666499]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[1]*Hs[4]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2691075]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[1]*Hs[5]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2715651]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[1]*Hs[6]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2740227]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[1]*Hs[7]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2813955]=(bbeta*pow(E,yss[8])*Pssp*pow(Hs[2],2)*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2838531]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[2]*Hs[3]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2863107]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[2]*Hs[4]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2887683]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[2]*Hs[5]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2912259]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[2]*Hs[6]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2936835]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[2]*Hs[7]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3035139]=(bbeta*pow(E,yss[8])*Pssp*pow(Hs[3],2)*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3059715]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[3]*Hs[4]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3084291]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[3]*Hs[5]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3108867]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[3]*Hs[6]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3133443]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[3]*Hs[7]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3256323]=(bbeta*pow(E,yss[8])*Pssp*pow(Hs[4],2)*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3280899]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[4]*Hs[5]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3305475]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[4]*Hs[6]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3330051]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[4]*Hs[7]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3477507]=(bbeta*pow(E,yss[8])*Pssp*pow(Hs[5],2)*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3502083]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[5]*Hs[6]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3526659]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[5]*Hs[7]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3698691]=(bbeta*pow(E,yss[8])*Pssp*pow(Hs[6],2)*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3723267]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[6]*Hs[7]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3919875]=(bbeta*pow(E,yss[8])*Pssp*pow(Hs[7],2)*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[4]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mxx_sp_s[1540]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mxx_sp_s[3076]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mxx_sp_s[4612]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mxx_sp_s[6148]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mxx_sp_s[7684]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mxx_sp_s[9220]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mxx_sp_s[10756]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mxx_sp_s[795652]=-(kkappa*Pssp*yss[9]);
	Mxx_sp_s[798724]=pow(E,yss[8])*Pssp;
	Mxx_sp_s[800260]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mxx_sp_s[801796]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mxx_sp_s[2360836]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*pow(Hs[0],2));
	Mxx_sp_s[2362372]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*pow(Hs[0],2);
	Mxx_sp_s[2365444]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*pow(Hs[0],2));
	Mxx_sp_s[2371588]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*pow(Hs[0],2))/pow(zbar,rrho);
	Mxx_sp_s[2385412]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[0]*Hs[1];
	Mxx_sp_s[2386948]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[0]*Hs[1];
	Mxx_sp_s[2390020]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[0]*Hs[1];
	Mxx_sp_s[2396164]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[0]*Hs[1])/pow(zbar,rrho);
	Mxx_sp_s[2409988]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[0]*Hs[2];
	Mxx_sp_s[2411524]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[0]*Hs[2];
	Mxx_sp_s[2414596]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[0]*Hs[2];
	Mxx_sp_s[2420740]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[0]*Hs[2])/pow(zbar,rrho);
	Mxx_sp_s[2434564]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[0]*Hs[3];
	Mxx_sp_s[2436100]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[0]*Hs[3];
	Mxx_sp_s[2439172]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[0]*Hs[3];
	Mxx_sp_s[2445316]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[0]*Hs[3])/pow(zbar,rrho);
	Mxx_sp_s[2459140]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[0]*Hs[4];
	Mxx_sp_s[2460676]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[0]*Hs[4];
	Mxx_sp_s[2463748]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[0]*Hs[4];
	Mxx_sp_s[2469892]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[0]*Hs[4])/pow(zbar,rrho);
	Mxx_sp_s[2483716]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[0]*Hs[5];
	Mxx_sp_s[2485252]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[0]*Hs[5];
	Mxx_sp_s[2488324]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[0]*Hs[5];
	Mxx_sp_s[2494468]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[0]*Hs[5])/pow(zbar,rrho);
	Mxx_sp_s[2508292]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[0]*Hs[6];
	Mxx_sp_s[2509828]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[0]*Hs[6];
	Mxx_sp_s[2512900]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[0]*Hs[6];
	Mxx_sp_s[2519044]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[0]*Hs[6])/pow(zbar,rrho);
	Mxx_sp_s[2532868]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[0]*Hs[7];
	Mxx_sp_s[2534404]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[0]*Hs[7];
	Mxx_sp_s[2537476]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[0]*Hs[7];
	Mxx_sp_s[2543620]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[0]*Hs[7])/pow(zbar,rrho);
	Mxx_sp_s[2582020]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*pow(Hs[1],2));
	Mxx_sp_s[2583556]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*pow(Hs[1],2);
	Mxx_sp_s[2586628]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*pow(Hs[1],2));
	Mxx_sp_s[2592772]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*pow(Hs[1],2))/pow(zbar,rrho);
	Mxx_sp_s[2606596]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[1]*Hs[2];
	Mxx_sp_s[2608132]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[1]*Hs[2];
	Mxx_sp_s[2611204]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[1]*Hs[2];
	Mxx_sp_s[2617348]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[1]*Hs[2])/pow(zbar,rrho);
	Mxx_sp_s[2631172]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[1]*Hs[3];
	Mxx_sp_s[2632708]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[1]*Hs[3];
	Mxx_sp_s[2635780]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[1]*Hs[3];
	Mxx_sp_s[2641924]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[1]*Hs[3])/pow(zbar,rrho);
	Mxx_sp_s[2655748]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[1]*Hs[4];
	Mxx_sp_s[2657284]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[1]*Hs[4];
	Mxx_sp_s[2660356]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[1]*Hs[4];
	Mxx_sp_s[2666500]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[1]*Hs[4])/pow(zbar,rrho);
	Mxx_sp_s[2680324]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[1]*Hs[5];
	Mxx_sp_s[2681860]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[1]*Hs[5];
	Mxx_sp_s[2684932]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[1]*Hs[5];
	Mxx_sp_s[2691076]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[1]*Hs[5])/pow(zbar,rrho);
	Mxx_sp_s[2704900]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[1]*Hs[6];
	Mxx_sp_s[2706436]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[1]*Hs[6];
	Mxx_sp_s[2709508]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[1]*Hs[6];
	Mxx_sp_s[2715652]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[1]*Hs[6])/pow(zbar,rrho);
	Mxx_sp_s[2729476]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[1]*Hs[7];
	Mxx_sp_s[2731012]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[1]*Hs[7];
	Mxx_sp_s[2734084]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[1]*Hs[7];
	Mxx_sp_s[2740228]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[1]*Hs[7])/pow(zbar,rrho);
	Mxx_sp_s[2803204]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*pow(Hs[2],2));
	Mxx_sp_s[2804740]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*pow(Hs[2],2);
	Mxx_sp_s[2807812]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*pow(Hs[2],2));
	Mxx_sp_s[2813956]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*pow(Hs[2],2))/pow(zbar,rrho);
	Mxx_sp_s[2827780]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[2]*Hs[3];
	Mxx_sp_s[2829316]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[2]*Hs[3];
	Mxx_sp_s[2832388]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[2]*Hs[3];
	Mxx_sp_s[2838532]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[2]*Hs[3])/pow(zbar,rrho);
	Mxx_sp_s[2852356]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[2]*Hs[4];
	Mxx_sp_s[2853892]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[2]*Hs[4];
	Mxx_sp_s[2856964]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[2]*Hs[4];
	Mxx_sp_s[2863108]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[2]*Hs[4])/pow(zbar,rrho);
	Mxx_sp_s[2876932]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[2]*Hs[5];
	Mxx_sp_s[2878468]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[2]*Hs[5];
	Mxx_sp_s[2881540]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[2]*Hs[5];
	Mxx_sp_s[2887684]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[2]*Hs[5])/pow(zbar,rrho);
	Mxx_sp_s[2901508]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[2]*Hs[6];
	Mxx_sp_s[2903044]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[2]*Hs[6];
	Mxx_sp_s[2906116]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[2]*Hs[6];
	Mxx_sp_s[2912260]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[2]*Hs[6])/pow(zbar,rrho);
	Mxx_sp_s[2926084]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[2]*Hs[7];
	Mxx_sp_s[2927620]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[2]*Hs[7];
	Mxx_sp_s[2930692]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[2]*Hs[7];
	Mxx_sp_s[2936836]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[2]*Hs[7])/pow(zbar,rrho);
	Mxx_sp_s[3024388]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*pow(Hs[3],2));
	Mxx_sp_s[3025924]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*pow(Hs[3],2);
	Mxx_sp_s[3028996]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*pow(Hs[3],2));
	Mxx_sp_s[3035140]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*pow(Hs[3],2))/pow(zbar,rrho);
	Mxx_sp_s[3048964]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[3]*Hs[4];
	Mxx_sp_s[3050500]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[3]*Hs[4];
	Mxx_sp_s[3053572]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[3]*Hs[4];
	Mxx_sp_s[3059716]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[3]*Hs[4])/pow(zbar,rrho);
	Mxx_sp_s[3073540]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[3]*Hs[5];
	Mxx_sp_s[3075076]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[3]*Hs[5];
	Mxx_sp_s[3078148]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[3]*Hs[5];
	Mxx_sp_s[3084292]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[3]*Hs[5])/pow(zbar,rrho);
	Mxx_sp_s[3098116]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[3]*Hs[6];
	Mxx_sp_s[3099652]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[3]*Hs[6];
	Mxx_sp_s[3102724]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[3]*Hs[6];
	Mxx_sp_s[3108868]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[3]*Hs[6])/pow(zbar,rrho);
	Mxx_sp_s[3122692]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[3]*Hs[7];
	Mxx_sp_s[3124228]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[3]*Hs[7];
	Mxx_sp_s[3127300]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[3]*Hs[7];
	Mxx_sp_s[3133444]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[3]*Hs[7])/pow(zbar,rrho);
	Mxx_sp_s[3245572]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*pow(Hs[4],2));
	Mxx_sp_s[3247108]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*pow(Hs[4],2);
	Mxx_sp_s[3250180]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*pow(Hs[4],2));
	Mxx_sp_s[3256324]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*pow(Hs[4],2))/pow(zbar,rrho);
	Mxx_sp_s[3270148]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[4]*Hs[5];
	Mxx_sp_s[3271684]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[4]*Hs[5];
	Mxx_sp_s[3274756]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[4]*Hs[5];
	Mxx_sp_s[3280900]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[4]*Hs[5])/pow(zbar,rrho);
	Mxx_sp_s[3294724]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[4]*Hs[6];
	Mxx_sp_s[3296260]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[4]*Hs[6];
	Mxx_sp_s[3299332]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[4]*Hs[6];
	Mxx_sp_s[3305476]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[4]*Hs[6])/pow(zbar,rrho);
	Mxx_sp_s[3319300]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[4]*Hs[7];
	Mxx_sp_s[3320836]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[4]*Hs[7];
	Mxx_sp_s[3323908]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[4]*Hs[7];
	Mxx_sp_s[3330052]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[4]*Hs[7])/pow(zbar,rrho);
	Mxx_sp_s[3466756]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*pow(Hs[5],2));
	Mxx_sp_s[3468292]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*pow(Hs[5],2);
	Mxx_sp_s[3471364]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*pow(Hs[5],2));
	Mxx_sp_s[3477508]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*pow(Hs[5],2))/pow(zbar,rrho);
	Mxx_sp_s[3491332]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[5]*Hs[6];
	Mxx_sp_s[3492868]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[5]*Hs[6];
	Mxx_sp_s[3495940]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[5]*Hs[6];
	Mxx_sp_s[3502084]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[5]*Hs[6])/pow(zbar,rrho);
	Mxx_sp_s[3515908]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[5]*Hs[7];
	Mxx_sp_s[3517444]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[5]*Hs[7];
	Mxx_sp_s[3520516]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[5]*Hs[7];
	Mxx_sp_s[3526660]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[5]*Hs[7])/pow(zbar,rrho);
	Mxx_sp_s[3687940]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*pow(Hs[6],2));
	Mxx_sp_s[3689476]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*pow(Hs[6],2);
	Mxx_sp_s[3692548]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*pow(Hs[6],2));
	Mxx_sp_s[3698692]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*pow(Hs[6],2))/pow(zbar,rrho);
	Mxx_sp_s[3712516]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[6]*Hs[7];
	Mxx_sp_s[3714052]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[6]*Hs[7];
	Mxx_sp_s[3717124]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[6]*Hs[7];
	Mxx_sp_s[3723268]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[6]*Hs[7])/pow(zbar,rrho);
	Mxx_sp_s[3909124]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*pow(Hs[7],2));
	Mxx_sp_s[3910660]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*pow(Hs[7],2);
	Mxx_sp_s[3913732]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*pow(Hs[7],2));
	Mxx_sp_s[3919876]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*pow(Hs[7],2))/pow(zbar,rrho);
	Mxx_sp_s[5]=iiota*Pssp*zbar;
	Mxx_sp_s[4613]=iiota*Pssp*zbar;
	Mxx_sp_s[795653]=-Pssp;
	Mxx_sp_s[787974]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mxx_sp_s[797190]=-(pow(E,yss[7])*Pssp);
	Mxx_sp_s[800262]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxx_sp_s[801798]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxx_sp_s[1543]=-((Pssp*zbar)/(1 + yss[5]));
	Mxx_sp_s[3079]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[4615]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mxx_sp_s[6151]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mxx_sp_s[9223]=-(pow(E,yss[11])*ebar*Pssp);
	Mxx_sp_s[786439]=-(pow(E,yss[0])*Pssp);
	Mxx_sp_s[787975]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mxx_sp_s[789511]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mxx_sp_s[791047]=-(pow(E,yss[3])*Pssp);
	Mxx_sp_s[794119]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mxx_sp_s[797191]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mxx_sp_s[800263]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxx_sp_s[801799]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxx_sp_s[8]=-(pow(E,xss[0])*Pssp*zbar);
	Mxx_sp_s[4616]=-(pow(E,xss[0])*Pssp*zbar);
	Mxx_sp_s[791048]=pow(E,yss[3])*Pssp;
	Mxx_sp_s[800264]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxx_sp_s[801800]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxx_sp_s[9]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxx_sp_s[1545]=(Pssp*zbar)/(1 + yss[5]);
	Mxx_sp_s[4617]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mxx_sp_s[6153]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxx_sp_s[787977]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxx_sp_s[789513]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxx_sp_s[794121]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mxx_sp_s[795657]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxx_sp_s[797193]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxx_sp_s[800265]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxx_sp_s[801801]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxx_sp_s[800266]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxx_sp_s[801802]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxx_sp_s[1547]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mxx_sp_s[7691]=Pssp;
	Mxx_sp_s[794123]=-Pssp;
	Mxx_sp_s[800267]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxx_sp_s[801803]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxx_sp_s[12]=pow(E,xss[0])*Pssp;
	Mxx_sp_s[792588]=-(pow(E,xss[0])*Pssp);
	Mxx_sp_s[3085]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[4621]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[6157]=pow(E,yss[2])*pbar*Pssp;
	Mxx_sp_s[787981]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[789517]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mxx_sp_s[800269]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxx_sp_s[801805]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxx_sp_s[803341]=pow(E,yss[11])*Pssp;
	Mxx_sp_s[1550]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxx_sp_s[4622]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxx_sp_s[800270]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxx_sp_s[801806]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxx_sp_s[803342]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mxx_sp_s[804878]=Pssp;
	Mxx_sp_s[1551]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxx_sp_s[4623]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxx_sp_s[800271]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxx_sp_s[801807]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxx_sp_s[803343]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mxx_sp_s[806415]=Pssp;
	Mxx_sp_s[9232]=ebar*Pssp;
	Mxx_sp_s[786448]=pow(E,yss[0] - yss[11])*Pssp;
	Mxx_sp_s[791056]=pow(E,yss[3] - yss[11])*Pssp;
	Mxx_sp_s[800272]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxx_sp_s[801808]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxx_sp_s[803344]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mxx_sp_s[807952]=Pssp;
	Mxx_sp_s[17]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[1553]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3089]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[4625]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mxx_sp_s[6161]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[7697]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[9233]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[10769]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[800273]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[801809]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[809489]=Pssp;
	Mxx_sp_s[2371601]=(Pssp*pow(zbar,rrho)*pow(Hs[0],2)*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2396177]=(2*Pssp*pow(zbar,rrho)*Hs[0]*Hs[1]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2420753]=(2*Pssp*pow(zbar,rrho)*Hs[0]*Hs[2]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2445329]=(2*Pssp*pow(zbar,rrho)*Hs[0]*Hs[3]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2469905]=(2*Pssp*pow(zbar,rrho)*Hs[0]*Hs[4]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2494481]=(2*Pssp*pow(zbar,rrho)*Hs[0]*Hs[5]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2519057]=(2*Pssp*pow(zbar,rrho)*Hs[0]*Hs[6]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2543633]=(2*Pssp*pow(zbar,rrho)*Hs[0]*Hs[7]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2592785]=(Pssp*pow(zbar,rrho)*pow(Hs[1],2)*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2617361]=(2*Pssp*pow(zbar,rrho)*Hs[1]*Hs[2]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2641937]=(2*Pssp*pow(zbar,rrho)*Hs[1]*Hs[3]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2666513]=(2*Pssp*pow(zbar,rrho)*Hs[1]*Hs[4]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2691089]=(2*Pssp*pow(zbar,rrho)*Hs[1]*Hs[5]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2715665]=(2*Pssp*pow(zbar,rrho)*Hs[1]*Hs[6]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2740241]=(2*Pssp*pow(zbar,rrho)*Hs[1]*Hs[7]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2813969]=(Pssp*pow(zbar,rrho)*pow(Hs[2],2)*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2838545]=(2*Pssp*pow(zbar,rrho)*Hs[2]*Hs[3]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2863121]=(2*Pssp*pow(zbar,rrho)*Hs[2]*Hs[4]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2887697]=(2*Pssp*pow(zbar,rrho)*Hs[2]*Hs[5]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2912273]=(2*Pssp*pow(zbar,rrho)*Hs[2]*Hs[6]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2936849]=(2*Pssp*pow(zbar,rrho)*Hs[2]*Hs[7]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3035153]=(Pssp*pow(zbar,rrho)*pow(Hs[3],2)*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3059729]=(2*Pssp*pow(zbar,rrho)*Hs[3]*Hs[4]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3084305]=(2*Pssp*pow(zbar,rrho)*Hs[3]*Hs[5]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3108881]=(2*Pssp*pow(zbar,rrho)*Hs[3]*Hs[6]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3133457]=(2*Pssp*pow(zbar,rrho)*Hs[3]*Hs[7]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3256337]=(Pssp*pow(zbar,rrho)*pow(Hs[4],2)*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3280913]=(2*Pssp*pow(zbar,rrho)*Hs[4]*Hs[5]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3305489]=(2*Pssp*pow(zbar,rrho)*Hs[4]*Hs[6]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3330065]=(2*Pssp*pow(zbar,rrho)*Hs[4]*Hs[7]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3477521]=(Pssp*pow(zbar,rrho)*pow(Hs[5],2)*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3502097]=(2*Pssp*pow(zbar,rrho)*Hs[5]*Hs[6]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3526673]=(2*Pssp*pow(zbar,rrho)*Hs[5]*Hs[7]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3698705]=(Pssp*pow(zbar,rrho)*pow(Hs[6],2)*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3723281]=(2*Pssp*pow(zbar,rrho)*Hs[6]*Hs[7]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3919889]=(Pssp*pow(zbar,rrho)*pow(Hs[7],2)*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3090]=-Pssp;
	Mxx_sp_s[4627]=-Pssp;
	Mxx_sp_s[6164]=-Pssp;
	Mxx_sp_s[10773]=-Pssp;
	Mxx_sp_s[9238]=-Pssp;
	Mxx_sp_s[7703]=-Pssp;
	Mxx_sp_s[23064]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mxx_sp_s[811032]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mxx_sp_s[812568]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mxx_sp_s[823320]=-(pow(E,yss[8])*Pssp);
	Mxx_sp_s[824856]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxx_sp_s[826392]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxx_sp_s[15385]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[16921]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[18457]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[812569]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[814105]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[818713]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mxx_sp_s[823321]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mxx_sp_s[824857]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[826393]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[15386]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[16922]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[812570]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[814106]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[818714]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mxx_sp_s[821786]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[823322]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mxx_sp_s[824858]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[826394]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[12315]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[13851]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[15387]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[16923]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mxx_sp_s[18459]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[19995]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[21531]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[23067]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[818715]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mxx_sp_s[823323]=-(pow(E,yss[8])*Pssp);
	Mxx_sp_s[824859]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mxx_sp_s[826395]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mxx_sp_s[2371611]=(bbeta*pow(E,yss[8])*Pssp*Hs[0]*Hs[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2396187]=(bbeta*pow(E,yss[8])*Pssp*(Hs[1]*Hs[8] + Hs[0]*Hs[9])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2420763]=(bbeta*pow(E,yss[8])*Pssp*(Hs[2]*Hs[8] + Hs[0]*Hs[10])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2445339]=(bbeta*pow(E,yss[8])*Pssp*(Hs[3]*Hs[8] + Hs[0]*Hs[11])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2469915]=(bbeta*pow(E,yss[8])*Pssp*(Hs[4]*Hs[8] + Hs[0]*Hs[12])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2494491]=(bbeta*pow(E,yss[8])*Pssp*(Hs[5]*Hs[8] + Hs[0]*Hs[13])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2519067]=(bbeta*pow(E,yss[8])*Pssp*(Hs[6]*Hs[8] + Hs[0]*Hs[14])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2543643]=(bbeta*pow(E,yss[8])*Pssp*(Hs[7]*Hs[8] + Hs[0]*Hs[15])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2592795]=(bbeta*pow(E,yss[8])*Pssp*Hs[1]*Hs[9]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2617371]=(bbeta*pow(E,yss[8])*Pssp*(Hs[2]*Hs[9] + Hs[1]*Hs[10])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2641947]=(bbeta*pow(E,yss[8])*Pssp*(Hs[3]*Hs[9] + Hs[1]*Hs[11])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2666523]=(bbeta*pow(E,yss[8])*Pssp*(Hs[4]*Hs[9] + Hs[1]*Hs[12])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2691099]=(bbeta*pow(E,yss[8])*Pssp*(Hs[5]*Hs[9] + Hs[1]*Hs[13])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2715675]=(bbeta*pow(E,yss[8])*Pssp*(Hs[6]*Hs[9] + Hs[1]*Hs[14])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2740251]=(bbeta*pow(E,yss[8])*Pssp*(Hs[7]*Hs[9] + Hs[1]*Hs[15])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2813979]=(bbeta*pow(E,yss[8])*Pssp*Hs[2]*Hs[10]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2838555]=(bbeta*pow(E,yss[8])*Pssp*(Hs[3]*Hs[10] + Hs[2]*Hs[11])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2863131]=(bbeta*pow(E,yss[8])*Pssp*(Hs[4]*Hs[10] + Hs[2]*Hs[12])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2887707]=(bbeta*pow(E,yss[8])*Pssp*(Hs[5]*Hs[10] + Hs[2]*Hs[13])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2912283]=(bbeta*pow(E,yss[8])*Pssp*(Hs[6]*Hs[10] + Hs[2]*Hs[14])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2936859]=(bbeta*pow(E,yss[8])*Pssp*(Hs[7]*Hs[10] + Hs[2]*Hs[15])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3035163]=(bbeta*pow(E,yss[8])*Pssp*Hs[3]*Hs[11]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3059739]=(bbeta*pow(E,yss[8])*Pssp*(Hs[4]*Hs[11] + Hs[3]*Hs[12])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3084315]=(bbeta*pow(E,yss[8])*Pssp*(Hs[5]*Hs[11] + Hs[3]*Hs[13])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3108891]=(bbeta*pow(E,yss[8])*Pssp*(Hs[6]*Hs[11] + Hs[3]*Hs[14])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3133467]=(bbeta*pow(E,yss[8])*Pssp*(Hs[7]*Hs[11] + Hs[3]*Hs[15])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3256347]=(bbeta*pow(E,yss[8])*Pssp*Hs[4]*Hs[12]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3280923]=(bbeta*pow(E,yss[8])*Pssp*(Hs[5]*Hs[12] + Hs[4]*Hs[13])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3305499]=(bbeta*pow(E,yss[8])*Pssp*(Hs[6]*Hs[12] + Hs[4]*Hs[14])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3330075]=(bbeta*pow(E,yss[8])*Pssp*(Hs[7]*Hs[12] + Hs[4]*Hs[15])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3477531]=(bbeta*pow(E,yss[8])*Pssp*Hs[5]*Hs[13]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3502107]=(bbeta*pow(E,yss[8])*Pssp*(Hs[6]*Hs[13] + Hs[5]*Hs[14])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3526683]=(bbeta*pow(E,yss[8])*Pssp*(Hs[7]*Hs[13] + Hs[5]*Hs[15])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3698715]=(bbeta*pow(E,yss[8])*Pssp*Hs[6]*Hs[14]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3723291]=(bbeta*pow(E,yss[8])*Pssp*(Hs[7]*Hs[14] + Hs[6]*Hs[15])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3919899]=(bbeta*pow(E,yss[8])*Pssp*Hs[7]*Hs[15]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[12316]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mxx_sp_s[13852]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mxx_sp_s[15388]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mxx_sp_s[16924]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mxx_sp_s[18460]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mxx_sp_s[19996]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mxx_sp_s[21532]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mxx_sp_s[23068]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mxx_sp_s[820252]=-(kkappa*Pssp*yss[9]);
	Mxx_sp_s[823324]=pow(E,yss[8])*Pssp;
	Mxx_sp_s[824860]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mxx_sp_s[826396]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mxx_sp_s[2360860]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[0]*Hs[8]);
	Mxx_sp_s[2362396]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[0]*Hs[8];
	Mxx_sp_s[2365468]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[0]*Hs[8]);
	Mxx_sp_s[2371612]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[0]*Hs[8])/pow(zbar,rrho);
	Mxx_sp_s[2385436]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[1]*Hs[8] + Hs[0]*Hs[9]));
	Mxx_sp_s[2386972]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[1]*Hs[8] + Hs[0]*Hs[9]);
	Mxx_sp_s[2390044]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[1]*Hs[8] + Hs[0]*Hs[9]));
	Mxx_sp_s[2396188]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[1]*Hs[8] + Hs[0]*Hs[9]))/pow(zbar,rrho);
	Mxx_sp_s[2410012]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[2]*Hs[8] + Hs[0]*Hs[10]));
	Mxx_sp_s[2411548]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[2]*Hs[8] + Hs[0]*Hs[10]);
	Mxx_sp_s[2414620]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[2]*Hs[8] + Hs[0]*Hs[10]));
	Mxx_sp_s[2420764]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[2]*Hs[8] + Hs[0]*Hs[10]))/pow(zbar,rrho);
	Mxx_sp_s[2434588]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[3]*Hs[8] + Hs[0]*Hs[11]));
	Mxx_sp_s[2436124]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[3]*Hs[8] + Hs[0]*Hs[11]);
	Mxx_sp_s[2439196]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[3]*Hs[8] + Hs[0]*Hs[11]));
	Mxx_sp_s[2445340]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[3]*Hs[8] + Hs[0]*Hs[11]))/pow(zbar,rrho);
	Mxx_sp_s[2459164]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[4]*Hs[8] + Hs[0]*Hs[12]));
	Mxx_sp_s[2460700]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[4]*Hs[8] + Hs[0]*Hs[12]);
	Mxx_sp_s[2463772]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[4]*Hs[8] + Hs[0]*Hs[12]));
	Mxx_sp_s[2469916]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[4]*Hs[8] + Hs[0]*Hs[12]))/pow(zbar,rrho);
	Mxx_sp_s[2483740]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[5]*Hs[8] + Hs[0]*Hs[13]));
	Mxx_sp_s[2485276]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[5]*Hs[8] + Hs[0]*Hs[13]);
	Mxx_sp_s[2488348]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[5]*Hs[8] + Hs[0]*Hs[13]));
	Mxx_sp_s[2494492]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[5]*Hs[8] + Hs[0]*Hs[13]))/pow(zbar,rrho);
	Mxx_sp_s[2508316]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[8] + Hs[0]*Hs[14]));
	Mxx_sp_s[2509852]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[8] + Hs[0]*Hs[14]);
	Mxx_sp_s[2512924]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[6]*Hs[8] + Hs[0]*Hs[14]));
	Mxx_sp_s[2519068]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[6]*Hs[8] + Hs[0]*Hs[14]))/pow(zbar,rrho);
	Mxx_sp_s[2532892]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[8] + Hs[0]*Hs[15]));
	Mxx_sp_s[2534428]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[8] + Hs[0]*Hs[15]);
	Mxx_sp_s[2537500]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[7]*Hs[8] + Hs[0]*Hs[15]));
	Mxx_sp_s[2543644]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[7]*Hs[8] + Hs[0]*Hs[15]))/pow(zbar,rrho);
	Mxx_sp_s[2582044]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[1]*Hs[9]);
	Mxx_sp_s[2583580]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[1]*Hs[9];
	Mxx_sp_s[2586652]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[1]*Hs[9]);
	Mxx_sp_s[2592796]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[1]*Hs[9])/pow(zbar,rrho);
	Mxx_sp_s[2606620]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[2]*Hs[9] + Hs[1]*Hs[10]));
	Mxx_sp_s[2608156]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[2]*Hs[9] + Hs[1]*Hs[10]);
	Mxx_sp_s[2611228]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[2]*Hs[9] + Hs[1]*Hs[10]));
	Mxx_sp_s[2617372]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[2]*Hs[9] + Hs[1]*Hs[10]))/pow(zbar,rrho);
	Mxx_sp_s[2631196]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[3]*Hs[9] + Hs[1]*Hs[11]));
	Mxx_sp_s[2632732]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[3]*Hs[9] + Hs[1]*Hs[11]);
	Mxx_sp_s[2635804]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[3]*Hs[9] + Hs[1]*Hs[11]));
	Mxx_sp_s[2641948]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[3]*Hs[9] + Hs[1]*Hs[11]))/pow(zbar,rrho);
	Mxx_sp_s[2655772]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[4]*Hs[9] + Hs[1]*Hs[12]));
	Mxx_sp_s[2657308]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[4]*Hs[9] + Hs[1]*Hs[12]);
	Mxx_sp_s[2660380]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[4]*Hs[9] + Hs[1]*Hs[12]));
	Mxx_sp_s[2666524]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[4]*Hs[9] + Hs[1]*Hs[12]))/pow(zbar,rrho);
	Mxx_sp_s[2680348]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[5]*Hs[9] + Hs[1]*Hs[13]));
	Mxx_sp_s[2681884]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[5]*Hs[9] + Hs[1]*Hs[13]);
	Mxx_sp_s[2684956]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[5]*Hs[9] + Hs[1]*Hs[13]));
	Mxx_sp_s[2691100]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[5]*Hs[9] + Hs[1]*Hs[13]))/pow(zbar,rrho);
	Mxx_sp_s[2704924]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[9] + Hs[1]*Hs[14]));
	Mxx_sp_s[2706460]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[9] + Hs[1]*Hs[14]);
	Mxx_sp_s[2709532]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[6]*Hs[9] + Hs[1]*Hs[14]));
	Mxx_sp_s[2715676]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[6]*Hs[9] + Hs[1]*Hs[14]))/pow(zbar,rrho);
	Mxx_sp_s[2729500]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[9] + Hs[1]*Hs[15]));
	Mxx_sp_s[2731036]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[9] + Hs[1]*Hs[15]);
	Mxx_sp_s[2734108]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[7]*Hs[9] + Hs[1]*Hs[15]));
	Mxx_sp_s[2740252]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[7]*Hs[9] + Hs[1]*Hs[15]))/pow(zbar,rrho);
	Mxx_sp_s[2803228]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[2]*Hs[10]);
	Mxx_sp_s[2804764]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[2]*Hs[10];
	Mxx_sp_s[2807836]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[2]*Hs[10]);
	Mxx_sp_s[2813980]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[2]*Hs[10])/pow(zbar,rrho);
	Mxx_sp_s[2827804]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[3]*Hs[10] + Hs[2]*Hs[11]));
	Mxx_sp_s[2829340]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[3]*Hs[10] + Hs[2]*Hs[11]);
	Mxx_sp_s[2832412]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[3]*Hs[10] + Hs[2]*Hs[11]));
	Mxx_sp_s[2838556]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[3]*Hs[10] + Hs[2]*Hs[11]))/pow(zbar,rrho);
	Mxx_sp_s[2852380]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[4]*Hs[10] + Hs[2]*Hs[12]));
	Mxx_sp_s[2853916]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[4]*Hs[10] + Hs[2]*Hs[12]);
	Mxx_sp_s[2856988]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[4]*Hs[10] + Hs[2]*Hs[12]));
	Mxx_sp_s[2863132]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[4]*Hs[10] + Hs[2]*Hs[12]))/pow(zbar,rrho);
	Mxx_sp_s[2876956]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[5]*Hs[10] + Hs[2]*Hs[13]));
	Mxx_sp_s[2878492]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[5]*Hs[10] + Hs[2]*Hs[13]);
	Mxx_sp_s[2881564]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[5]*Hs[10] + Hs[2]*Hs[13]));
	Mxx_sp_s[2887708]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[5]*Hs[10] + Hs[2]*Hs[13]))/pow(zbar,rrho);
	Mxx_sp_s[2901532]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[10] + Hs[2]*Hs[14]));
	Mxx_sp_s[2903068]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[10] + Hs[2]*Hs[14]);
	Mxx_sp_s[2906140]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[6]*Hs[10] + Hs[2]*Hs[14]));
	Mxx_sp_s[2912284]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[6]*Hs[10] + Hs[2]*Hs[14]))/pow(zbar,rrho);
	Mxx_sp_s[2926108]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[10] + Hs[2]*Hs[15]));
	Mxx_sp_s[2927644]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[10] + Hs[2]*Hs[15]);
	Mxx_sp_s[2930716]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[7]*Hs[10] + Hs[2]*Hs[15]));
	Mxx_sp_s[2936860]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[7]*Hs[10] + Hs[2]*Hs[15]))/pow(zbar,rrho);
	Mxx_sp_s[3024412]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[3]*Hs[11]);
	Mxx_sp_s[3025948]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[3]*Hs[11];
	Mxx_sp_s[3029020]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[3]*Hs[11]);
	Mxx_sp_s[3035164]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[3]*Hs[11])/pow(zbar,rrho);
	Mxx_sp_s[3048988]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[4]*Hs[11] + Hs[3]*Hs[12]));
	Mxx_sp_s[3050524]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[4]*Hs[11] + Hs[3]*Hs[12]);
	Mxx_sp_s[3053596]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[4]*Hs[11] + Hs[3]*Hs[12]));
	Mxx_sp_s[3059740]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[4]*Hs[11] + Hs[3]*Hs[12]))/pow(zbar,rrho);
	Mxx_sp_s[3073564]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[5]*Hs[11] + Hs[3]*Hs[13]));
	Mxx_sp_s[3075100]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[5]*Hs[11] + Hs[3]*Hs[13]);
	Mxx_sp_s[3078172]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[5]*Hs[11] + Hs[3]*Hs[13]));
	Mxx_sp_s[3084316]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[5]*Hs[11] + Hs[3]*Hs[13]))/pow(zbar,rrho);
	Mxx_sp_s[3098140]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[11] + Hs[3]*Hs[14]));
	Mxx_sp_s[3099676]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[11] + Hs[3]*Hs[14]);
	Mxx_sp_s[3102748]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[6]*Hs[11] + Hs[3]*Hs[14]));
	Mxx_sp_s[3108892]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[6]*Hs[11] + Hs[3]*Hs[14]))/pow(zbar,rrho);
	Mxx_sp_s[3122716]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[11] + Hs[3]*Hs[15]));
	Mxx_sp_s[3124252]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[11] + Hs[3]*Hs[15]);
	Mxx_sp_s[3127324]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[7]*Hs[11] + Hs[3]*Hs[15]));
	Mxx_sp_s[3133468]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[7]*Hs[11] + Hs[3]*Hs[15]))/pow(zbar,rrho);
	Mxx_sp_s[3245596]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[4]*Hs[12]);
	Mxx_sp_s[3247132]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[4]*Hs[12];
	Mxx_sp_s[3250204]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[4]*Hs[12]);
	Mxx_sp_s[3256348]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[4]*Hs[12])/pow(zbar,rrho);
	Mxx_sp_s[3270172]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[5]*Hs[12] + Hs[4]*Hs[13]));
	Mxx_sp_s[3271708]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[5]*Hs[12] + Hs[4]*Hs[13]);
	Mxx_sp_s[3274780]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[5]*Hs[12] + Hs[4]*Hs[13]));
	Mxx_sp_s[3280924]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[5]*Hs[12] + Hs[4]*Hs[13]))/pow(zbar,rrho);
	Mxx_sp_s[3294748]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[12] + Hs[4]*Hs[14]));
	Mxx_sp_s[3296284]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[12] + Hs[4]*Hs[14]);
	Mxx_sp_s[3299356]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[6]*Hs[12] + Hs[4]*Hs[14]));
	Mxx_sp_s[3305500]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[6]*Hs[12] + Hs[4]*Hs[14]))/pow(zbar,rrho);
	Mxx_sp_s[3319324]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[12] + Hs[4]*Hs[15]));
	Mxx_sp_s[3320860]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[12] + Hs[4]*Hs[15]);
	Mxx_sp_s[3323932]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[7]*Hs[12] + Hs[4]*Hs[15]));
	Mxx_sp_s[3330076]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[7]*Hs[12] + Hs[4]*Hs[15]))/pow(zbar,rrho);
	Mxx_sp_s[3466780]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[5]*Hs[13]);
	Mxx_sp_s[3468316]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[5]*Hs[13];
	Mxx_sp_s[3471388]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[5]*Hs[13]);
	Mxx_sp_s[3477532]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[5]*Hs[13])/pow(zbar,rrho);
	Mxx_sp_s[3491356]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[13] + Hs[5]*Hs[14]));
	Mxx_sp_s[3492892]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[13] + Hs[5]*Hs[14]);
	Mxx_sp_s[3495964]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[6]*Hs[13] + Hs[5]*Hs[14]));
	Mxx_sp_s[3502108]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[6]*Hs[13] + Hs[5]*Hs[14]))/pow(zbar,rrho);
	Mxx_sp_s[3515932]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[13] + Hs[5]*Hs[15]));
	Mxx_sp_s[3517468]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[13] + Hs[5]*Hs[15]);
	Mxx_sp_s[3520540]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[7]*Hs[13] + Hs[5]*Hs[15]));
	Mxx_sp_s[3526684]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[7]*Hs[13] + Hs[5]*Hs[15]))/pow(zbar,rrho);
	Mxx_sp_s[3687964]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[6]*Hs[14]);
	Mxx_sp_s[3689500]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[6]*Hs[14];
	Mxx_sp_s[3692572]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[6]*Hs[14]);
	Mxx_sp_s[3698716]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[6]*Hs[14])/pow(zbar,rrho);
	Mxx_sp_s[3712540]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[14] + Hs[6]*Hs[15]));
	Mxx_sp_s[3714076]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[14] + Hs[6]*Hs[15]);
	Mxx_sp_s[3717148]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[7]*Hs[14] + Hs[6]*Hs[15]));
	Mxx_sp_s[3723292]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[7]*Hs[14] + Hs[6]*Hs[15]))/pow(zbar,rrho);
	Mxx_sp_s[3909148]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[7]*Hs[15]);
	Mxx_sp_s[3910684]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[7]*Hs[15];
	Mxx_sp_s[3913756]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[7]*Hs[15]);
	Mxx_sp_s[3919900]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[7]*Hs[15])/pow(zbar,rrho);
	Mxx_sp_s[12317]=iiota*Pssp*zbar;
	Mxx_sp_s[16925]=iiota*Pssp*zbar;
	Mxx_sp_s[820253]=-Pssp;
	Mxx_sp_s[812574]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mxx_sp_s[821790]=-(pow(E,yss[7])*Pssp);
	Mxx_sp_s[824862]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxx_sp_s[826398]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxx_sp_s[13855]=-((Pssp*zbar)/(1 + yss[5]));
	Mxx_sp_s[15391]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[16927]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mxx_sp_s[18463]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mxx_sp_s[21535]=-(pow(E,yss[11])*ebar*Pssp);
	Mxx_sp_s[811039]=-(pow(E,yss[0])*Pssp);
	Mxx_sp_s[812575]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mxx_sp_s[814111]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mxx_sp_s[815647]=-(pow(E,yss[3])*Pssp);
	Mxx_sp_s[818719]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mxx_sp_s[821791]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mxx_sp_s[824863]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxx_sp_s[826399]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxx_sp_s[12320]=-(pow(E,xss[0])*Pssp*zbar);
	Mxx_sp_s[16928]=-(pow(E,xss[0])*Pssp*zbar);
	Mxx_sp_s[815648]=pow(E,yss[3])*Pssp;
	Mxx_sp_s[824864]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxx_sp_s[826400]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxx_sp_s[12321]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxx_sp_s[13857]=(Pssp*zbar)/(1 + yss[5]);
	Mxx_sp_s[16929]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mxx_sp_s[18465]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxx_sp_s[812577]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxx_sp_s[814113]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxx_sp_s[818721]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mxx_sp_s[820257]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxx_sp_s[821793]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxx_sp_s[824865]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxx_sp_s[826401]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxx_sp_s[824866]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxx_sp_s[826402]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxx_sp_s[13859]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mxx_sp_s[20003]=Pssp;
	Mxx_sp_s[818723]=-Pssp;
	Mxx_sp_s[824867]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxx_sp_s[826403]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxx_sp_s[12324]=pow(E,xss[0])*Pssp;
	Mxx_sp_s[817188]=-(pow(E,xss[0])*Pssp);
	Mxx_sp_s[15397]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[16933]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[18469]=pow(E,yss[2])*pbar*Pssp;
	Mxx_sp_s[812581]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[814117]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mxx_sp_s[824869]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxx_sp_s[826405]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxx_sp_s[827941]=pow(E,yss[11])*Pssp;
	Mxx_sp_s[13862]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxx_sp_s[16934]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxx_sp_s[824870]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxx_sp_s[826406]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxx_sp_s[827942]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mxx_sp_s[829478]=Pssp;
	Mxx_sp_s[13863]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxx_sp_s[16935]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxx_sp_s[824871]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxx_sp_s[826407]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxx_sp_s[827943]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mxx_sp_s[831015]=Pssp;
	Mxx_sp_s[21544]=ebar*Pssp;
	Mxx_sp_s[811048]=pow(E,yss[0] - yss[11])*Pssp;
	Mxx_sp_s[815656]=pow(E,yss[3] - yss[11])*Pssp;
	Mxx_sp_s[824872]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxx_sp_s[826408]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxx_sp_s[827944]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mxx_sp_s[832552]=Pssp;
	Mxx_sp_s[12329]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[13865]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[15401]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[16937]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mxx_sp_s[18473]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[20009]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[21545]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[23081]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[824873]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[826409]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[834089]=Pssp;
	Mxx_sp_s[2371625]=(Pssp*pow(zbar,rrho)*Hs[0]*Hs[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2396201]=(Pssp*pow(zbar,rrho)*(Hs[1]*Hs[8] + Hs[0]*Hs[9])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2420777]=(Pssp*pow(zbar,rrho)*(Hs[2]*Hs[8] + Hs[0]*Hs[10])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2445353]=(Pssp*pow(zbar,rrho)*(Hs[3]*Hs[8] + Hs[0]*Hs[11])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2469929]=(Pssp*pow(zbar,rrho)*(Hs[4]*Hs[8] + Hs[0]*Hs[12])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2494505]=(Pssp*pow(zbar,rrho)*(Hs[5]*Hs[8] + Hs[0]*Hs[13])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2519081]=(Pssp*pow(zbar,rrho)*(Hs[6]*Hs[8] + Hs[0]*Hs[14])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2543657]=(Pssp*pow(zbar,rrho)*(Hs[7]*Hs[8] + Hs[0]*Hs[15])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2592809]=(Pssp*pow(zbar,rrho)*Hs[1]*Hs[9]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2617385]=(Pssp*pow(zbar,rrho)*(Hs[2]*Hs[9] + Hs[1]*Hs[10])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2641961]=(Pssp*pow(zbar,rrho)*(Hs[3]*Hs[9] + Hs[1]*Hs[11])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2666537]=(Pssp*pow(zbar,rrho)*(Hs[4]*Hs[9] + Hs[1]*Hs[12])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2691113]=(Pssp*pow(zbar,rrho)*(Hs[5]*Hs[9] + Hs[1]*Hs[13])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2715689]=(Pssp*pow(zbar,rrho)*(Hs[6]*Hs[9] + Hs[1]*Hs[14])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2740265]=(Pssp*pow(zbar,rrho)*(Hs[7]*Hs[9] + Hs[1]*Hs[15])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2813993]=(Pssp*pow(zbar,rrho)*Hs[2]*Hs[10]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2838569]=(Pssp*pow(zbar,rrho)*(Hs[3]*Hs[10] + Hs[2]*Hs[11])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2863145]=(Pssp*pow(zbar,rrho)*(Hs[4]*Hs[10] + Hs[2]*Hs[12])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2887721]=(Pssp*pow(zbar,rrho)*(Hs[5]*Hs[10] + Hs[2]*Hs[13])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2912297]=(Pssp*pow(zbar,rrho)*(Hs[6]*Hs[10] + Hs[2]*Hs[14])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2936873]=(Pssp*pow(zbar,rrho)*(Hs[7]*Hs[10] + Hs[2]*Hs[15])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3035177]=(Pssp*pow(zbar,rrho)*Hs[3]*Hs[11]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3059753]=(Pssp*pow(zbar,rrho)*(Hs[4]*Hs[11] + Hs[3]*Hs[12])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3084329]=(Pssp*pow(zbar,rrho)*(Hs[5]*Hs[11] + Hs[3]*Hs[13])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3108905]=(Pssp*pow(zbar,rrho)*(Hs[6]*Hs[11] + Hs[3]*Hs[14])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3133481]=(Pssp*pow(zbar,rrho)*(Hs[7]*Hs[11] + Hs[3]*Hs[15])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3256361]=(Pssp*pow(zbar,rrho)*Hs[4]*Hs[12]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3280937]=(Pssp*pow(zbar,rrho)*(Hs[5]*Hs[12] + Hs[4]*Hs[13])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3305513]=(Pssp*pow(zbar,rrho)*(Hs[6]*Hs[12] + Hs[4]*Hs[14])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3330089]=(Pssp*pow(zbar,rrho)*(Hs[7]*Hs[12] + Hs[4]*Hs[15])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3477545]=(Pssp*pow(zbar,rrho)*Hs[5]*Hs[13]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3502121]=(Pssp*pow(zbar,rrho)*(Hs[6]*Hs[13] + Hs[5]*Hs[14])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3526697]=(Pssp*pow(zbar,rrho)*(Hs[7]*Hs[13] + Hs[5]*Hs[15])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3698729]=(Pssp*pow(zbar,rrho)*Hs[6]*Hs[14]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3723305]=(Pssp*pow(zbar,rrho)*(Hs[7]*Hs[14] + Hs[6]*Hs[15])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3919913]=(Pssp*pow(zbar,rrho)*Hs[7]*Hs[15]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[15402]=-Pssp;
	Mxx_sp_s[16939]=-Pssp;
	Mxx_sp_s[18476]=-Pssp;
	Mxx_sp_s[23085]=-Pssp;
	Mxx_sp_s[21550]=-Pssp;
	Mxx_sp_s[20015]=-Pssp;
	Mxx_sp_s[35376]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mxx_sp_s[835632]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mxx_sp_s[837168]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mxx_sp_s[847920]=-(pow(E,yss[8])*Pssp);
	Mxx_sp_s[849456]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxx_sp_s[850992]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxx_sp_s[27697]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[29233]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[30769]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[837169]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[838705]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[843313]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mxx_sp_s[847921]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mxx_sp_s[849457]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[850993]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[27698]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[29234]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[837170]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[838706]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[843314]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mxx_sp_s[846386]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[847922]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mxx_sp_s[849458]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[850994]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[24627]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[26163]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[27699]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[29235]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mxx_sp_s[30771]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[32307]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[33843]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[35379]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[843315]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mxx_sp_s[847923]=-(pow(E,yss[8])*Pssp);
	Mxx_sp_s[849459]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mxx_sp_s[850995]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mxx_sp_s[2371635]=(bbeta*pow(E,yss[8])*Pssp*Hs[0]*Hs[16]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2396211]=(bbeta*pow(E,yss[8])*Pssp*(Hs[1]*Hs[16] + Hs[0]*Hs[17])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2420787]=(bbeta*pow(E,yss[8])*Pssp*(Hs[2]*Hs[16] + Hs[0]*Hs[18])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2445363]=(bbeta*pow(E,yss[8])*Pssp*(Hs[3]*Hs[16] + Hs[0]*Hs[19])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2469939]=(bbeta*pow(E,yss[8])*Pssp*(Hs[4]*Hs[16] + Hs[0]*Hs[20])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2494515]=(bbeta*pow(E,yss[8])*Pssp*(Hs[5]*Hs[16] + Hs[0]*Hs[21])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2519091]=(bbeta*pow(E,yss[8])*Pssp*(Hs[6]*Hs[16] + Hs[0]*Hs[22])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2543667]=(bbeta*pow(E,yss[8])*Pssp*(Hs[7]*Hs[16] + Hs[0]*Hs[23])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2592819]=(bbeta*pow(E,yss[8])*Pssp*Hs[1]*Hs[17]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2617395]=(bbeta*pow(E,yss[8])*Pssp*(Hs[2]*Hs[17] + Hs[1]*Hs[18])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2641971]=(bbeta*pow(E,yss[8])*Pssp*(Hs[3]*Hs[17] + Hs[1]*Hs[19])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2666547]=(bbeta*pow(E,yss[8])*Pssp*(Hs[4]*Hs[17] + Hs[1]*Hs[20])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2691123]=(bbeta*pow(E,yss[8])*Pssp*(Hs[5]*Hs[17] + Hs[1]*Hs[21])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2715699]=(bbeta*pow(E,yss[8])*Pssp*(Hs[6]*Hs[17] + Hs[1]*Hs[22])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2740275]=(bbeta*pow(E,yss[8])*Pssp*(Hs[7]*Hs[17] + Hs[1]*Hs[23])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2814003]=(bbeta*pow(E,yss[8])*Pssp*Hs[2]*Hs[18]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2838579]=(bbeta*pow(E,yss[8])*Pssp*(Hs[3]*Hs[18] + Hs[2]*Hs[19])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2863155]=(bbeta*pow(E,yss[8])*Pssp*(Hs[4]*Hs[18] + Hs[2]*Hs[20])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2887731]=(bbeta*pow(E,yss[8])*Pssp*(Hs[5]*Hs[18] + Hs[2]*Hs[21])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2912307]=(bbeta*pow(E,yss[8])*Pssp*(Hs[6]*Hs[18] + Hs[2]*Hs[22])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2936883]=(bbeta*pow(E,yss[8])*Pssp*(Hs[7]*Hs[18] + Hs[2]*Hs[23])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3035187]=(bbeta*pow(E,yss[8])*Pssp*Hs[3]*Hs[19]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3059763]=(bbeta*pow(E,yss[8])*Pssp*(Hs[4]*Hs[19] + Hs[3]*Hs[20])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3084339]=(bbeta*pow(E,yss[8])*Pssp*(Hs[5]*Hs[19] + Hs[3]*Hs[21])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3108915]=(bbeta*pow(E,yss[8])*Pssp*(Hs[6]*Hs[19] + Hs[3]*Hs[22])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3133491]=(bbeta*pow(E,yss[8])*Pssp*(Hs[7]*Hs[19] + Hs[3]*Hs[23])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3256371]=(bbeta*pow(E,yss[8])*Pssp*Hs[4]*Hs[20]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3280947]=(bbeta*pow(E,yss[8])*Pssp*(Hs[5]*Hs[20] + Hs[4]*Hs[21])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3305523]=(bbeta*pow(E,yss[8])*Pssp*(Hs[6]*Hs[20] + Hs[4]*Hs[22])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3330099]=(bbeta*pow(E,yss[8])*Pssp*(Hs[7]*Hs[20] + Hs[4]*Hs[23])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3477555]=(bbeta*pow(E,yss[8])*Pssp*Hs[5]*Hs[21]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3502131]=(bbeta*pow(E,yss[8])*Pssp*(Hs[6]*Hs[21] + Hs[5]*Hs[22])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3526707]=(bbeta*pow(E,yss[8])*Pssp*(Hs[7]*Hs[21] + Hs[5]*Hs[23])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3698739]=(bbeta*pow(E,yss[8])*Pssp*Hs[6]*Hs[22]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3723315]=(bbeta*pow(E,yss[8])*Pssp*(Hs[7]*Hs[22] + Hs[6]*Hs[23])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3919923]=(bbeta*pow(E,yss[8])*Pssp*Hs[7]*Hs[23]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[24628]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mxx_sp_s[26164]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mxx_sp_s[27700]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mxx_sp_s[29236]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mxx_sp_s[30772]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mxx_sp_s[32308]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mxx_sp_s[33844]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mxx_sp_s[35380]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mxx_sp_s[844852]=-(kkappa*Pssp*yss[9]);
	Mxx_sp_s[847924]=pow(E,yss[8])*Pssp;
	Mxx_sp_s[849460]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mxx_sp_s[850996]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mxx_sp_s[2360884]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[0]*Hs[16]);
	Mxx_sp_s[2362420]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[0]*Hs[16];
	Mxx_sp_s[2365492]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[0]*Hs[16]);
	Mxx_sp_s[2371636]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[0]*Hs[16])/pow(zbar,rrho);
	Mxx_sp_s[2385460]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[1]*Hs[16] + Hs[0]*Hs[17]));
	Mxx_sp_s[2386996]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[1]*Hs[16] + Hs[0]*Hs[17]);
	Mxx_sp_s[2390068]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[1]*Hs[16] + Hs[0]*Hs[17]));
	Mxx_sp_s[2396212]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[1]*Hs[16] + Hs[0]*Hs[17]))/pow(zbar,rrho);
	Mxx_sp_s[2410036]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[2]*Hs[16] + Hs[0]*Hs[18]));
	Mxx_sp_s[2411572]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[2]*Hs[16] + Hs[0]*Hs[18]);
	Mxx_sp_s[2414644]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[2]*Hs[16] + Hs[0]*Hs[18]));
	Mxx_sp_s[2420788]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[2]*Hs[16] + Hs[0]*Hs[18]))/pow(zbar,rrho);
	Mxx_sp_s[2434612]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[3]*Hs[16] + Hs[0]*Hs[19]));
	Mxx_sp_s[2436148]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[3]*Hs[16] + Hs[0]*Hs[19]);
	Mxx_sp_s[2439220]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[3]*Hs[16] + Hs[0]*Hs[19]));
	Mxx_sp_s[2445364]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[3]*Hs[16] + Hs[0]*Hs[19]))/pow(zbar,rrho);
	Mxx_sp_s[2459188]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[4]*Hs[16] + Hs[0]*Hs[20]));
	Mxx_sp_s[2460724]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[4]*Hs[16] + Hs[0]*Hs[20]);
	Mxx_sp_s[2463796]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[4]*Hs[16] + Hs[0]*Hs[20]));
	Mxx_sp_s[2469940]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[4]*Hs[16] + Hs[0]*Hs[20]))/pow(zbar,rrho);
	Mxx_sp_s[2483764]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[5]*Hs[16] + Hs[0]*Hs[21]));
	Mxx_sp_s[2485300]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[5]*Hs[16] + Hs[0]*Hs[21]);
	Mxx_sp_s[2488372]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[5]*Hs[16] + Hs[0]*Hs[21]));
	Mxx_sp_s[2494516]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[5]*Hs[16] + Hs[0]*Hs[21]))/pow(zbar,rrho);
	Mxx_sp_s[2508340]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[16] + Hs[0]*Hs[22]));
	Mxx_sp_s[2509876]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[16] + Hs[0]*Hs[22]);
	Mxx_sp_s[2512948]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[6]*Hs[16] + Hs[0]*Hs[22]));
	Mxx_sp_s[2519092]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[6]*Hs[16] + Hs[0]*Hs[22]))/pow(zbar,rrho);
	Mxx_sp_s[2532916]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[16] + Hs[0]*Hs[23]));
	Mxx_sp_s[2534452]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[16] + Hs[0]*Hs[23]);
	Mxx_sp_s[2537524]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[7]*Hs[16] + Hs[0]*Hs[23]));
	Mxx_sp_s[2543668]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[7]*Hs[16] + Hs[0]*Hs[23]))/pow(zbar,rrho);
	Mxx_sp_s[2582068]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[1]*Hs[17]);
	Mxx_sp_s[2583604]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[1]*Hs[17];
	Mxx_sp_s[2586676]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[1]*Hs[17]);
	Mxx_sp_s[2592820]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[1]*Hs[17])/pow(zbar,rrho);
	Mxx_sp_s[2606644]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[2]*Hs[17] + Hs[1]*Hs[18]));
	Mxx_sp_s[2608180]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[2]*Hs[17] + Hs[1]*Hs[18]);
	Mxx_sp_s[2611252]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[2]*Hs[17] + Hs[1]*Hs[18]));
	Mxx_sp_s[2617396]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[2]*Hs[17] + Hs[1]*Hs[18]))/pow(zbar,rrho);
	Mxx_sp_s[2631220]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[3]*Hs[17] + Hs[1]*Hs[19]));
	Mxx_sp_s[2632756]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[3]*Hs[17] + Hs[1]*Hs[19]);
	Mxx_sp_s[2635828]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[3]*Hs[17] + Hs[1]*Hs[19]));
	Mxx_sp_s[2641972]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[3]*Hs[17] + Hs[1]*Hs[19]))/pow(zbar,rrho);
	Mxx_sp_s[2655796]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[4]*Hs[17] + Hs[1]*Hs[20]));
	Mxx_sp_s[2657332]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[4]*Hs[17] + Hs[1]*Hs[20]);
	Mxx_sp_s[2660404]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[4]*Hs[17] + Hs[1]*Hs[20]));
	Mxx_sp_s[2666548]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[4]*Hs[17] + Hs[1]*Hs[20]))/pow(zbar,rrho);
	Mxx_sp_s[2680372]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[5]*Hs[17] + Hs[1]*Hs[21]));
	Mxx_sp_s[2681908]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[5]*Hs[17] + Hs[1]*Hs[21]);
	Mxx_sp_s[2684980]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[5]*Hs[17] + Hs[1]*Hs[21]));
	Mxx_sp_s[2691124]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[5]*Hs[17] + Hs[1]*Hs[21]))/pow(zbar,rrho);
	Mxx_sp_s[2704948]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[17] + Hs[1]*Hs[22]));
	Mxx_sp_s[2706484]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[17] + Hs[1]*Hs[22]);
	Mxx_sp_s[2709556]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[6]*Hs[17] + Hs[1]*Hs[22]));
	Mxx_sp_s[2715700]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[6]*Hs[17] + Hs[1]*Hs[22]))/pow(zbar,rrho);
	Mxx_sp_s[2729524]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[17] + Hs[1]*Hs[23]));
	Mxx_sp_s[2731060]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[17] + Hs[1]*Hs[23]);
	Mxx_sp_s[2734132]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[7]*Hs[17] + Hs[1]*Hs[23]));
	Mxx_sp_s[2740276]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[7]*Hs[17] + Hs[1]*Hs[23]))/pow(zbar,rrho);
	Mxx_sp_s[2803252]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[2]*Hs[18]);
	Mxx_sp_s[2804788]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[2]*Hs[18];
	Mxx_sp_s[2807860]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[2]*Hs[18]);
	Mxx_sp_s[2814004]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[2]*Hs[18])/pow(zbar,rrho);
	Mxx_sp_s[2827828]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[3]*Hs[18] + Hs[2]*Hs[19]));
	Mxx_sp_s[2829364]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[3]*Hs[18] + Hs[2]*Hs[19]);
	Mxx_sp_s[2832436]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[3]*Hs[18] + Hs[2]*Hs[19]));
	Mxx_sp_s[2838580]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[3]*Hs[18] + Hs[2]*Hs[19]))/pow(zbar,rrho);
	Mxx_sp_s[2852404]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[4]*Hs[18] + Hs[2]*Hs[20]));
	Mxx_sp_s[2853940]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[4]*Hs[18] + Hs[2]*Hs[20]);
	Mxx_sp_s[2857012]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[4]*Hs[18] + Hs[2]*Hs[20]));
	Mxx_sp_s[2863156]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[4]*Hs[18] + Hs[2]*Hs[20]))/pow(zbar,rrho);
	Mxx_sp_s[2876980]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[5]*Hs[18] + Hs[2]*Hs[21]));
	Mxx_sp_s[2878516]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[5]*Hs[18] + Hs[2]*Hs[21]);
	Mxx_sp_s[2881588]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[5]*Hs[18] + Hs[2]*Hs[21]));
	Mxx_sp_s[2887732]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[5]*Hs[18] + Hs[2]*Hs[21]))/pow(zbar,rrho);
	Mxx_sp_s[2901556]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[18] + Hs[2]*Hs[22]));
	Mxx_sp_s[2903092]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[18] + Hs[2]*Hs[22]);
	Mxx_sp_s[2906164]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[6]*Hs[18] + Hs[2]*Hs[22]));
	Mxx_sp_s[2912308]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[6]*Hs[18] + Hs[2]*Hs[22]))/pow(zbar,rrho);
	Mxx_sp_s[2926132]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[18] + Hs[2]*Hs[23]));
	Mxx_sp_s[2927668]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[18] + Hs[2]*Hs[23]);
	Mxx_sp_s[2930740]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[7]*Hs[18] + Hs[2]*Hs[23]));
	Mxx_sp_s[2936884]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[7]*Hs[18] + Hs[2]*Hs[23]))/pow(zbar,rrho);
	Mxx_sp_s[3024436]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[3]*Hs[19]);
	Mxx_sp_s[3025972]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[3]*Hs[19];
	Mxx_sp_s[3029044]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[3]*Hs[19]);
	Mxx_sp_s[3035188]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[3]*Hs[19])/pow(zbar,rrho);
	Mxx_sp_s[3049012]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[4]*Hs[19] + Hs[3]*Hs[20]));
	Mxx_sp_s[3050548]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[4]*Hs[19] + Hs[3]*Hs[20]);
	Mxx_sp_s[3053620]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[4]*Hs[19] + Hs[3]*Hs[20]));
	Mxx_sp_s[3059764]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[4]*Hs[19] + Hs[3]*Hs[20]))/pow(zbar,rrho);
	Mxx_sp_s[3073588]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[5]*Hs[19] + Hs[3]*Hs[21]));
	Mxx_sp_s[3075124]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[5]*Hs[19] + Hs[3]*Hs[21]);
	Mxx_sp_s[3078196]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[5]*Hs[19] + Hs[3]*Hs[21]));
	Mxx_sp_s[3084340]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[5]*Hs[19] + Hs[3]*Hs[21]))/pow(zbar,rrho);
	Mxx_sp_s[3098164]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[19] + Hs[3]*Hs[22]));
	Mxx_sp_s[3099700]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[19] + Hs[3]*Hs[22]);
	Mxx_sp_s[3102772]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[6]*Hs[19] + Hs[3]*Hs[22]));
	Mxx_sp_s[3108916]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[6]*Hs[19] + Hs[3]*Hs[22]))/pow(zbar,rrho);
	Mxx_sp_s[3122740]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[19] + Hs[3]*Hs[23]));
	Mxx_sp_s[3124276]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[19] + Hs[3]*Hs[23]);
	Mxx_sp_s[3127348]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[7]*Hs[19] + Hs[3]*Hs[23]));
	Mxx_sp_s[3133492]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[7]*Hs[19] + Hs[3]*Hs[23]))/pow(zbar,rrho);
	Mxx_sp_s[3245620]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[4]*Hs[20]);
	Mxx_sp_s[3247156]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[4]*Hs[20];
	Mxx_sp_s[3250228]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[4]*Hs[20]);
	Mxx_sp_s[3256372]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[4]*Hs[20])/pow(zbar,rrho);
	Mxx_sp_s[3270196]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[5]*Hs[20] + Hs[4]*Hs[21]));
	Mxx_sp_s[3271732]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[5]*Hs[20] + Hs[4]*Hs[21]);
	Mxx_sp_s[3274804]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[5]*Hs[20] + Hs[4]*Hs[21]));
	Mxx_sp_s[3280948]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[5]*Hs[20] + Hs[4]*Hs[21]))/pow(zbar,rrho);
	Mxx_sp_s[3294772]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[20] + Hs[4]*Hs[22]));
	Mxx_sp_s[3296308]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[20] + Hs[4]*Hs[22]);
	Mxx_sp_s[3299380]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[6]*Hs[20] + Hs[4]*Hs[22]));
	Mxx_sp_s[3305524]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[6]*Hs[20] + Hs[4]*Hs[22]))/pow(zbar,rrho);
	Mxx_sp_s[3319348]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[20] + Hs[4]*Hs[23]));
	Mxx_sp_s[3320884]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[20] + Hs[4]*Hs[23]);
	Mxx_sp_s[3323956]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[7]*Hs[20] + Hs[4]*Hs[23]));
	Mxx_sp_s[3330100]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[7]*Hs[20] + Hs[4]*Hs[23]))/pow(zbar,rrho);
	Mxx_sp_s[3466804]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[5]*Hs[21]);
	Mxx_sp_s[3468340]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[5]*Hs[21];
	Mxx_sp_s[3471412]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[5]*Hs[21]);
	Mxx_sp_s[3477556]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[5]*Hs[21])/pow(zbar,rrho);
	Mxx_sp_s[3491380]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[21] + Hs[5]*Hs[22]));
	Mxx_sp_s[3492916]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[21] + Hs[5]*Hs[22]);
	Mxx_sp_s[3495988]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[6]*Hs[21] + Hs[5]*Hs[22]));
	Mxx_sp_s[3502132]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[6]*Hs[21] + Hs[5]*Hs[22]))/pow(zbar,rrho);
	Mxx_sp_s[3515956]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[21] + Hs[5]*Hs[23]));
	Mxx_sp_s[3517492]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[21] + Hs[5]*Hs[23]);
	Mxx_sp_s[3520564]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[7]*Hs[21] + Hs[5]*Hs[23]));
	Mxx_sp_s[3526708]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[7]*Hs[21] + Hs[5]*Hs[23]))/pow(zbar,rrho);
	Mxx_sp_s[3687988]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[6]*Hs[22]);
	Mxx_sp_s[3689524]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[6]*Hs[22];
	Mxx_sp_s[3692596]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[6]*Hs[22]);
	Mxx_sp_s[3698740]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[6]*Hs[22])/pow(zbar,rrho);
	Mxx_sp_s[3712564]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[22] + Hs[6]*Hs[23]));
	Mxx_sp_s[3714100]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[22] + Hs[6]*Hs[23]);
	Mxx_sp_s[3717172]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[7]*Hs[22] + Hs[6]*Hs[23]));
	Mxx_sp_s[3723316]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[7]*Hs[22] + Hs[6]*Hs[23]))/pow(zbar,rrho);
	Mxx_sp_s[3909172]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[7]*Hs[23]);
	Mxx_sp_s[3910708]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[7]*Hs[23];
	Mxx_sp_s[3913780]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[7]*Hs[23]);
	Mxx_sp_s[3919924]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[7]*Hs[23])/pow(zbar,rrho);
	Mxx_sp_s[24629]=iiota*Pssp*zbar;
	Mxx_sp_s[29237]=iiota*Pssp*zbar;
	Mxx_sp_s[844853]=-Pssp;
	Mxx_sp_s[837174]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mxx_sp_s[846390]=-(pow(E,yss[7])*Pssp);
	Mxx_sp_s[849462]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxx_sp_s[850998]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxx_sp_s[26167]=-((Pssp*zbar)/(1 + yss[5]));
	Mxx_sp_s[27703]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[29239]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mxx_sp_s[30775]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mxx_sp_s[33847]=-(pow(E,yss[11])*ebar*Pssp);
	Mxx_sp_s[835639]=-(pow(E,yss[0])*Pssp);
	Mxx_sp_s[837175]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mxx_sp_s[838711]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mxx_sp_s[840247]=-(pow(E,yss[3])*Pssp);
	Mxx_sp_s[843319]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mxx_sp_s[846391]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mxx_sp_s[849463]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxx_sp_s[850999]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxx_sp_s[24632]=-(pow(E,xss[0])*Pssp*zbar);
	Mxx_sp_s[29240]=-(pow(E,xss[0])*Pssp*zbar);
	Mxx_sp_s[840248]=pow(E,yss[3])*Pssp;
	Mxx_sp_s[849464]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxx_sp_s[851000]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxx_sp_s[24633]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxx_sp_s[26169]=(Pssp*zbar)/(1 + yss[5]);
	Mxx_sp_s[29241]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mxx_sp_s[30777]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxx_sp_s[837177]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxx_sp_s[838713]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxx_sp_s[843321]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mxx_sp_s[844857]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxx_sp_s[846393]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxx_sp_s[849465]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxx_sp_s[851001]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxx_sp_s[849466]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxx_sp_s[851002]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxx_sp_s[26171]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mxx_sp_s[32315]=Pssp;
	Mxx_sp_s[843323]=-Pssp;
	Mxx_sp_s[849467]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxx_sp_s[851003]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxx_sp_s[24636]=pow(E,xss[0])*Pssp;
	Mxx_sp_s[841788]=-(pow(E,xss[0])*Pssp);
	Mxx_sp_s[27709]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[29245]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[30781]=pow(E,yss[2])*pbar*Pssp;
	Mxx_sp_s[837181]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[838717]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mxx_sp_s[849469]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxx_sp_s[851005]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxx_sp_s[852541]=pow(E,yss[11])*Pssp;
	Mxx_sp_s[26174]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxx_sp_s[29246]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxx_sp_s[849470]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxx_sp_s[851006]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxx_sp_s[852542]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mxx_sp_s[854078]=Pssp;
	Mxx_sp_s[26175]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxx_sp_s[29247]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxx_sp_s[849471]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxx_sp_s[851007]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxx_sp_s[852543]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mxx_sp_s[855615]=Pssp;
	Mxx_sp_s[33856]=ebar*Pssp;
	Mxx_sp_s[835648]=pow(E,yss[0] - yss[11])*Pssp;
	Mxx_sp_s[840256]=pow(E,yss[3] - yss[11])*Pssp;
	Mxx_sp_s[849472]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxx_sp_s[851008]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxx_sp_s[852544]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mxx_sp_s[857152]=Pssp;
	Mxx_sp_s[24641]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[26177]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[27713]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[29249]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mxx_sp_s[30785]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[32321]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[33857]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[35393]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[849473]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[851009]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[858689]=Pssp;
	Mxx_sp_s[2371649]=(Pssp*pow(zbar,rrho)*Hs[0]*Hs[16]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2396225]=(Pssp*pow(zbar,rrho)*(Hs[1]*Hs[16] + Hs[0]*Hs[17])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2420801]=(Pssp*pow(zbar,rrho)*(Hs[2]*Hs[16] + Hs[0]*Hs[18])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2445377]=(Pssp*pow(zbar,rrho)*(Hs[3]*Hs[16] + Hs[0]*Hs[19])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2469953]=(Pssp*pow(zbar,rrho)*(Hs[4]*Hs[16] + Hs[0]*Hs[20])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2494529]=(Pssp*pow(zbar,rrho)*(Hs[5]*Hs[16] + Hs[0]*Hs[21])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2519105]=(Pssp*pow(zbar,rrho)*(Hs[6]*Hs[16] + Hs[0]*Hs[22])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2543681]=(Pssp*pow(zbar,rrho)*(Hs[7]*Hs[16] + Hs[0]*Hs[23])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2592833]=(Pssp*pow(zbar,rrho)*Hs[1]*Hs[17]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2617409]=(Pssp*pow(zbar,rrho)*(Hs[2]*Hs[17] + Hs[1]*Hs[18])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2641985]=(Pssp*pow(zbar,rrho)*(Hs[3]*Hs[17] + Hs[1]*Hs[19])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2666561]=(Pssp*pow(zbar,rrho)*(Hs[4]*Hs[17] + Hs[1]*Hs[20])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2691137]=(Pssp*pow(zbar,rrho)*(Hs[5]*Hs[17] + Hs[1]*Hs[21])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2715713]=(Pssp*pow(zbar,rrho)*(Hs[6]*Hs[17] + Hs[1]*Hs[22])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2740289]=(Pssp*pow(zbar,rrho)*(Hs[7]*Hs[17] + Hs[1]*Hs[23])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2814017]=(Pssp*pow(zbar,rrho)*Hs[2]*Hs[18]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2838593]=(Pssp*pow(zbar,rrho)*(Hs[3]*Hs[18] + Hs[2]*Hs[19])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2863169]=(Pssp*pow(zbar,rrho)*(Hs[4]*Hs[18] + Hs[2]*Hs[20])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2887745]=(Pssp*pow(zbar,rrho)*(Hs[5]*Hs[18] + Hs[2]*Hs[21])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2912321]=(Pssp*pow(zbar,rrho)*(Hs[6]*Hs[18] + Hs[2]*Hs[22])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2936897]=(Pssp*pow(zbar,rrho)*(Hs[7]*Hs[18] + Hs[2]*Hs[23])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3035201]=(Pssp*pow(zbar,rrho)*Hs[3]*Hs[19]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3059777]=(Pssp*pow(zbar,rrho)*(Hs[4]*Hs[19] + Hs[3]*Hs[20])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3084353]=(Pssp*pow(zbar,rrho)*(Hs[5]*Hs[19] + Hs[3]*Hs[21])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3108929]=(Pssp*pow(zbar,rrho)*(Hs[6]*Hs[19] + Hs[3]*Hs[22])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3133505]=(Pssp*pow(zbar,rrho)*(Hs[7]*Hs[19] + Hs[3]*Hs[23])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3256385]=(Pssp*pow(zbar,rrho)*Hs[4]*Hs[20]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3280961]=(Pssp*pow(zbar,rrho)*(Hs[5]*Hs[20] + Hs[4]*Hs[21])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3305537]=(Pssp*pow(zbar,rrho)*(Hs[6]*Hs[20] + Hs[4]*Hs[22])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3330113]=(Pssp*pow(zbar,rrho)*(Hs[7]*Hs[20] + Hs[4]*Hs[23])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3477569]=(Pssp*pow(zbar,rrho)*Hs[5]*Hs[21]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3502145]=(Pssp*pow(zbar,rrho)*(Hs[6]*Hs[21] + Hs[5]*Hs[22])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3526721]=(Pssp*pow(zbar,rrho)*(Hs[7]*Hs[21] + Hs[5]*Hs[23])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3698753]=(Pssp*pow(zbar,rrho)*Hs[6]*Hs[22]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3723329]=(Pssp*pow(zbar,rrho)*(Hs[7]*Hs[22] + Hs[6]*Hs[23])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3919937]=(Pssp*pow(zbar,rrho)*Hs[7]*Hs[23]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[27714]=-Pssp;
	Mxx_sp_s[29251]=-Pssp;
	Mxx_sp_s[30788]=-Pssp;
	Mxx_sp_s[35397]=-Pssp;
	Mxx_sp_s[33862]=-Pssp;
	Mxx_sp_s[32327]=-Pssp;
	Mxx_sp_s[47688]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mxx_sp_s[860232]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mxx_sp_s[861768]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mxx_sp_s[872520]=-(pow(E,yss[8])*Pssp);
	Mxx_sp_s[874056]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxx_sp_s[875592]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxx_sp_s[40009]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[41545]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[43081]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[861769]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[863305]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[867913]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mxx_sp_s[872521]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mxx_sp_s[874057]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[875593]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[40010]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[41546]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[861770]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[863306]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[867914]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mxx_sp_s[870986]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[872522]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mxx_sp_s[874058]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[875594]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[36939]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[38475]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[40011]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[41547]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mxx_sp_s[43083]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[44619]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[46155]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[47691]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[867915]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mxx_sp_s[872523]=-(pow(E,yss[8])*Pssp);
	Mxx_sp_s[874059]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mxx_sp_s[875595]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mxx_sp_s[2371659]=(bbeta*pow(E,yss[8])*Pssp*Hs[0]*Hs[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2396235]=(bbeta*pow(E,yss[8])*Pssp*(Hs[1]*Hs[24] + Hs[0]*Hs[25])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2420811]=(bbeta*pow(E,yss[8])*Pssp*(Hs[2]*Hs[24] + Hs[0]*Hs[26])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2445387]=(bbeta*pow(E,yss[8])*Pssp*(Hs[3]*Hs[24] + Hs[0]*Hs[27])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2469963]=(bbeta*pow(E,yss[8])*Pssp*(Hs[4]*Hs[24] + Hs[0]*Hs[28])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2494539]=(bbeta*pow(E,yss[8])*Pssp*(Hs[5]*Hs[24] + Hs[0]*Hs[29])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2519115]=(bbeta*pow(E,yss[8])*Pssp*(Hs[6]*Hs[24] + Hs[0]*Hs[30])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2543691]=(bbeta*pow(E,yss[8])*Pssp*(Hs[7]*Hs[24] + Hs[0]*Hs[31])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2592843]=(bbeta*pow(E,yss[8])*Pssp*Hs[1]*Hs[25]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2617419]=(bbeta*pow(E,yss[8])*Pssp*(Hs[2]*Hs[25] + Hs[1]*Hs[26])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2641995]=(bbeta*pow(E,yss[8])*Pssp*(Hs[3]*Hs[25] + Hs[1]*Hs[27])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2666571]=(bbeta*pow(E,yss[8])*Pssp*(Hs[4]*Hs[25] + Hs[1]*Hs[28])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2691147]=(bbeta*pow(E,yss[8])*Pssp*(Hs[5]*Hs[25] + Hs[1]*Hs[29])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2715723]=(bbeta*pow(E,yss[8])*Pssp*(Hs[6]*Hs[25] + Hs[1]*Hs[30])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2740299]=(bbeta*pow(E,yss[8])*Pssp*(Hs[7]*Hs[25] + Hs[1]*Hs[31])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2814027]=(bbeta*pow(E,yss[8])*Pssp*Hs[2]*Hs[26]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2838603]=(bbeta*pow(E,yss[8])*Pssp*(Hs[3]*Hs[26] + Hs[2]*Hs[27])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2863179]=(bbeta*pow(E,yss[8])*Pssp*(Hs[4]*Hs[26] + Hs[2]*Hs[28])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2887755]=(bbeta*pow(E,yss[8])*Pssp*(Hs[5]*Hs[26] + Hs[2]*Hs[29])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2912331]=(bbeta*pow(E,yss[8])*Pssp*(Hs[6]*Hs[26] + Hs[2]*Hs[30])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2936907]=(bbeta*pow(E,yss[8])*Pssp*(Hs[7]*Hs[26] + Hs[2]*Hs[31])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3035211]=(bbeta*pow(E,yss[8])*Pssp*Hs[3]*Hs[27]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3059787]=(bbeta*pow(E,yss[8])*Pssp*(Hs[4]*Hs[27] + Hs[3]*Hs[28])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3084363]=(bbeta*pow(E,yss[8])*Pssp*(Hs[5]*Hs[27] + Hs[3]*Hs[29])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3108939]=(bbeta*pow(E,yss[8])*Pssp*(Hs[6]*Hs[27] + Hs[3]*Hs[30])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3133515]=(bbeta*pow(E,yss[8])*Pssp*(Hs[7]*Hs[27] + Hs[3]*Hs[31])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3256395]=(bbeta*pow(E,yss[8])*Pssp*Hs[4]*Hs[28]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3280971]=(bbeta*pow(E,yss[8])*Pssp*(Hs[5]*Hs[28] + Hs[4]*Hs[29])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3305547]=(bbeta*pow(E,yss[8])*Pssp*(Hs[6]*Hs[28] + Hs[4]*Hs[30])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3330123]=(bbeta*pow(E,yss[8])*Pssp*(Hs[7]*Hs[28] + Hs[4]*Hs[31])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3477579]=(bbeta*pow(E,yss[8])*Pssp*Hs[5]*Hs[29]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3502155]=(bbeta*pow(E,yss[8])*Pssp*(Hs[6]*Hs[29] + Hs[5]*Hs[30])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3526731]=(bbeta*pow(E,yss[8])*Pssp*(Hs[7]*Hs[29] + Hs[5]*Hs[31])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3698763]=(bbeta*pow(E,yss[8])*Pssp*Hs[6]*Hs[30]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3723339]=(bbeta*pow(E,yss[8])*Pssp*(Hs[7]*Hs[30] + Hs[6]*Hs[31])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3919947]=(bbeta*pow(E,yss[8])*Pssp*Hs[7]*Hs[31]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[36940]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mxx_sp_s[38476]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mxx_sp_s[40012]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mxx_sp_s[41548]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mxx_sp_s[43084]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mxx_sp_s[44620]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mxx_sp_s[46156]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mxx_sp_s[47692]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mxx_sp_s[869452]=-(kkappa*Pssp*yss[9]);
	Mxx_sp_s[872524]=pow(E,yss[8])*Pssp;
	Mxx_sp_s[874060]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mxx_sp_s[875596]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mxx_sp_s[2360908]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[0]*Hs[24]);
	Mxx_sp_s[2362444]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[0]*Hs[24];
	Mxx_sp_s[2365516]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[0]*Hs[24]);
	Mxx_sp_s[2371660]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[0]*Hs[24])/pow(zbar,rrho);
	Mxx_sp_s[2385484]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[1]*Hs[24] + Hs[0]*Hs[25]));
	Mxx_sp_s[2387020]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[1]*Hs[24] + Hs[0]*Hs[25]);
	Mxx_sp_s[2390092]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[1]*Hs[24] + Hs[0]*Hs[25]));
	Mxx_sp_s[2396236]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[1]*Hs[24] + Hs[0]*Hs[25]))/pow(zbar,rrho);
	Mxx_sp_s[2410060]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[2]*Hs[24] + Hs[0]*Hs[26]));
	Mxx_sp_s[2411596]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[2]*Hs[24] + Hs[0]*Hs[26]);
	Mxx_sp_s[2414668]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[2]*Hs[24] + Hs[0]*Hs[26]));
	Mxx_sp_s[2420812]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[2]*Hs[24] + Hs[0]*Hs[26]))/pow(zbar,rrho);
	Mxx_sp_s[2434636]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[3]*Hs[24] + Hs[0]*Hs[27]));
	Mxx_sp_s[2436172]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[3]*Hs[24] + Hs[0]*Hs[27]);
	Mxx_sp_s[2439244]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[3]*Hs[24] + Hs[0]*Hs[27]));
	Mxx_sp_s[2445388]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[3]*Hs[24] + Hs[0]*Hs[27]))/pow(zbar,rrho);
	Mxx_sp_s[2459212]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[4]*Hs[24] + Hs[0]*Hs[28]));
	Mxx_sp_s[2460748]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[4]*Hs[24] + Hs[0]*Hs[28]);
	Mxx_sp_s[2463820]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[4]*Hs[24] + Hs[0]*Hs[28]));
	Mxx_sp_s[2469964]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[4]*Hs[24] + Hs[0]*Hs[28]))/pow(zbar,rrho);
	Mxx_sp_s[2483788]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[5]*Hs[24] + Hs[0]*Hs[29]));
	Mxx_sp_s[2485324]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[5]*Hs[24] + Hs[0]*Hs[29]);
	Mxx_sp_s[2488396]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[5]*Hs[24] + Hs[0]*Hs[29]));
	Mxx_sp_s[2494540]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[5]*Hs[24] + Hs[0]*Hs[29]))/pow(zbar,rrho);
	Mxx_sp_s[2508364]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[24] + Hs[0]*Hs[30]));
	Mxx_sp_s[2509900]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[24] + Hs[0]*Hs[30]);
	Mxx_sp_s[2512972]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[6]*Hs[24] + Hs[0]*Hs[30]));
	Mxx_sp_s[2519116]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[6]*Hs[24] + Hs[0]*Hs[30]))/pow(zbar,rrho);
	Mxx_sp_s[2532940]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[24] + Hs[0]*Hs[31]));
	Mxx_sp_s[2534476]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[24] + Hs[0]*Hs[31]);
	Mxx_sp_s[2537548]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[7]*Hs[24] + Hs[0]*Hs[31]));
	Mxx_sp_s[2543692]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[7]*Hs[24] + Hs[0]*Hs[31]))/pow(zbar,rrho);
	Mxx_sp_s[2582092]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[1]*Hs[25]);
	Mxx_sp_s[2583628]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[1]*Hs[25];
	Mxx_sp_s[2586700]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[1]*Hs[25]);
	Mxx_sp_s[2592844]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[1]*Hs[25])/pow(zbar,rrho);
	Mxx_sp_s[2606668]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[2]*Hs[25] + Hs[1]*Hs[26]));
	Mxx_sp_s[2608204]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[2]*Hs[25] + Hs[1]*Hs[26]);
	Mxx_sp_s[2611276]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[2]*Hs[25] + Hs[1]*Hs[26]));
	Mxx_sp_s[2617420]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[2]*Hs[25] + Hs[1]*Hs[26]))/pow(zbar,rrho);
	Mxx_sp_s[2631244]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[3]*Hs[25] + Hs[1]*Hs[27]));
	Mxx_sp_s[2632780]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[3]*Hs[25] + Hs[1]*Hs[27]);
	Mxx_sp_s[2635852]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[3]*Hs[25] + Hs[1]*Hs[27]));
	Mxx_sp_s[2641996]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[3]*Hs[25] + Hs[1]*Hs[27]))/pow(zbar,rrho);
	Mxx_sp_s[2655820]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[4]*Hs[25] + Hs[1]*Hs[28]));
	Mxx_sp_s[2657356]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[4]*Hs[25] + Hs[1]*Hs[28]);
	Mxx_sp_s[2660428]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[4]*Hs[25] + Hs[1]*Hs[28]));
	Mxx_sp_s[2666572]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[4]*Hs[25] + Hs[1]*Hs[28]))/pow(zbar,rrho);
	Mxx_sp_s[2680396]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[5]*Hs[25] + Hs[1]*Hs[29]));
	Mxx_sp_s[2681932]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[5]*Hs[25] + Hs[1]*Hs[29]);
	Mxx_sp_s[2685004]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[5]*Hs[25] + Hs[1]*Hs[29]));
	Mxx_sp_s[2691148]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[5]*Hs[25] + Hs[1]*Hs[29]))/pow(zbar,rrho);
	Mxx_sp_s[2704972]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[25] + Hs[1]*Hs[30]));
	Mxx_sp_s[2706508]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[25] + Hs[1]*Hs[30]);
	Mxx_sp_s[2709580]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[6]*Hs[25] + Hs[1]*Hs[30]));
	Mxx_sp_s[2715724]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[6]*Hs[25] + Hs[1]*Hs[30]))/pow(zbar,rrho);
	Mxx_sp_s[2729548]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[25] + Hs[1]*Hs[31]));
	Mxx_sp_s[2731084]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[25] + Hs[1]*Hs[31]);
	Mxx_sp_s[2734156]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[7]*Hs[25] + Hs[1]*Hs[31]));
	Mxx_sp_s[2740300]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[7]*Hs[25] + Hs[1]*Hs[31]))/pow(zbar,rrho);
	Mxx_sp_s[2803276]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[2]*Hs[26]);
	Mxx_sp_s[2804812]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[2]*Hs[26];
	Mxx_sp_s[2807884]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[2]*Hs[26]);
	Mxx_sp_s[2814028]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[2]*Hs[26])/pow(zbar,rrho);
	Mxx_sp_s[2827852]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[3]*Hs[26] + Hs[2]*Hs[27]));
	Mxx_sp_s[2829388]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[3]*Hs[26] + Hs[2]*Hs[27]);
	Mxx_sp_s[2832460]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[3]*Hs[26] + Hs[2]*Hs[27]));
	Mxx_sp_s[2838604]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[3]*Hs[26] + Hs[2]*Hs[27]))/pow(zbar,rrho);
	Mxx_sp_s[2852428]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[4]*Hs[26] + Hs[2]*Hs[28]));
	Mxx_sp_s[2853964]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[4]*Hs[26] + Hs[2]*Hs[28]);
	Mxx_sp_s[2857036]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[4]*Hs[26] + Hs[2]*Hs[28]));
	Mxx_sp_s[2863180]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[4]*Hs[26] + Hs[2]*Hs[28]))/pow(zbar,rrho);
	Mxx_sp_s[2877004]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[5]*Hs[26] + Hs[2]*Hs[29]));
	Mxx_sp_s[2878540]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[5]*Hs[26] + Hs[2]*Hs[29]);
	Mxx_sp_s[2881612]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[5]*Hs[26] + Hs[2]*Hs[29]));
	Mxx_sp_s[2887756]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[5]*Hs[26] + Hs[2]*Hs[29]))/pow(zbar,rrho);
	Mxx_sp_s[2901580]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[26] + Hs[2]*Hs[30]));
	Mxx_sp_s[2903116]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[26] + Hs[2]*Hs[30]);
	Mxx_sp_s[2906188]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[6]*Hs[26] + Hs[2]*Hs[30]));
	Mxx_sp_s[2912332]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[6]*Hs[26] + Hs[2]*Hs[30]))/pow(zbar,rrho);
	Mxx_sp_s[2926156]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[26] + Hs[2]*Hs[31]));
	Mxx_sp_s[2927692]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[26] + Hs[2]*Hs[31]);
	Mxx_sp_s[2930764]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[7]*Hs[26] + Hs[2]*Hs[31]));
	Mxx_sp_s[2936908]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[7]*Hs[26] + Hs[2]*Hs[31]))/pow(zbar,rrho);
	Mxx_sp_s[3024460]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[3]*Hs[27]);
	Mxx_sp_s[3025996]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[3]*Hs[27];
	Mxx_sp_s[3029068]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[3]*Hs[27]);
	Mxx_sp_s[3035212]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[3]*Hs[27])/pow(zbar,rrho);
	Mxx_sp_s[3049036]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[4]*Hs[27] + Hs[3]*Hs[28]));
	Mxx_sp_s[3050572]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[4]*Hs[27] + Hs[3]*Hs[28]);
	Mxx_sp_s[3053644]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[4]*Hs[27] + Hs[3]*Hs[28]));
	Mxx_sp_s[3059788]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[4]*Hs[27] + Hs[3]*Hs[28]))/pow(zbar,rrho);
	Mxx_sp_s[3073612]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[5]*Hs[27] + Hs[3]*Hs[29]));
	Mxx_sp_s[3075148]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[5]*Hs[27] + Hs[3]*Hs[29]);
	Mxx_sp_s[3078220]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[5]*Hs[27] + Hs[3]*Hs[29]));
	Mxx_sp_s[3084364]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[5]*Hs[27] + Hs[3]*Hs[29]))/pow(zbar,rrho);
	Mxx_sp_s[3098188]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[27] + Hs[3]*Hs[30]));
	Mxx_sp_s[3099724]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[27] + Hs[3]*Hs[30]);
	Mxx_sp_s[3102796]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[6]*Hs[27] + Hs[3]*Hs[30]));
	Mxx_sp_s[3108940]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[6]*Hs[27] + Hs[3]*Hs[30]))/pow(zbar,rrho);
	Mxx_sp_s[3122764]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[27] + Hs[3]*Hs[31]));
	Mxx_sp_s[3124300]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[27] + Hs[3]*Hs[31]);
	Mxx_sp_s[3127372]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[7]*Hs[27] + Hs[3]*Hs[31]));
	Mxx_sp_s[3133516]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[7]*Hs[27] + Hs[3]*Hs[31]))/pow(zbar,rrho);
	Mxx_sp_s[3245644]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[4]*Hs[28]);
	Mxx_sp_s[3247180]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[4]*Hs[28];
	Mxx_sp_s[3250252]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[4]*Hs[28]);
	Mxx_sp_s[3256396]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[4]*Hs[28])/pow(zbar,rrho);
	Mxx_sp_s[3270220]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[5]*Hs[28] + Hs[4]*Hs[29]));
	Mxx_sp_s[3271756]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[5]*Hs[28] + Hs[4]*Hs[29]);
	Mxx_sp_s[3274828]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[5]*Hs[28] + Hs[4]*Hs[29]));
	Mxx_sp_s[3280972]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[5]*Hs[28] + Hs[4]*Hs[29]))/pow(zbar,rrho);
	Mxx_sp_s[3294796]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[28] + Hs[4]*Hs[30]));
	Mxx_sp_s[3296332]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[28] + Hs[4]*Hs[30]);
	Mxx_sp_s[3299404]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[6]*Hs[28] + Hs[4]*Hs[30]));
	Mxx_sp_s[3305548]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[6]*Hs[28] + Hs[4]*Hs[30]))/pow(zbar,rrho);
	Mxx_sp_s[3319372]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[28] + Hs[4]*Hs[31]));
	Mxx_sp_s[3320908]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[28] + Hs[4]*Hs[31]);
	Mxx_sp_s[3323980]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[7]*Hs[28] + Hs[4]*Hs[31]));
	Mxx_sp_s[3330124]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[7]*Hs[28] + Hs[4]*Hs[31]))/pow(zbar,rrho);
	Mxx_sp_s[3466828]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[5]*Hs[29]);
	Mxx_sp_s[3468364]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[5]*Hs[29];
	Mxx_sp_s[3471436]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[5]*Hs[29]);
	Mxx_sp_s[3477580]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[5]*Hs[29])/pow(zbar,rrho);
	Mxx_sp_s[3491404]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[29] + Hs[5]*Hs[30]));
	Mxx_sp_s[3492940]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[29] + Hs[5]*Hs[30]);
	Mxx_sp_s[3496012]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[6]*Hs[29] + Hs[5]*Hs[30]));
	Mxx_sp_s[3502156]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[6]*Hs[29] + Hs[5]*Hs[30]))/pow(zbar,rrho);
	Mxx_sp_s[3515980]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[29] + Hs[5]*Hs[31]));
	Mxx_sp_s[3517516]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[29] + Hs[5]*Hs[31]);
	Mxx_sp_s[3520588]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[7]*Hs[29] + Hs[5]*Hs[31]));
	Mxx_sp_s[3526732]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[7]*Hs[29] + Hs[5]*Hs[31]))/pow(zbar,rrho);
	Mxx_sp_s[3688012]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[6]*Hs[30]);
	Mxx_sp_s[3689548]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[6]*Hs[30];
	Mxx_sp_s[3692620]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[6]*Hs[30]);
	Mxx_sp_s[3698764]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[6]*Hs[30])/pow(zbar,rrho);
	Mxx_sp_s[3712588]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[30] + Hs[6]*Hs[31]));
	Mxx_sp_s[3714124]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[30] + Hs[6]*Hs[31]);
	Mxx_sp_s[3717196]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[7]*Hs[30] + Hs[6]*Hs[31]));
	Mxx_sp_s[3723340]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[7]*Hs[30] + Hs[6]*Hs[31]))/pow(zbar,rrho);
	Mxx_sp_s[3909196]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[7]*Hs[31]);
	Mxx_sp_s[3910732]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[7]*Hs[31];
	Mxx_sp_s[3913804]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[7]*Hs[31]);
	Mxx_sp_s[3919948]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[7]*Hs[31])/pow(zbar,rrho);
	Mxx_sp_s[36941]=iiota*Pssp*zbar;
	Mxx_sp_s[41549]=iiota*Pssp*zbar;
	Mxx_sp_s[869453]=-Pssp;
	Mxx_sp_s[861774]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mxx_sp_s[870990]=-(pow(E,yss[7])*Pssp);
	Mxx_sp_s[874062]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxx_sp_s[875598]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxx_sp_s[38479]=-((Pssp*zbar)/(1 + yss[5]));
	Mxx_sp_s[40015]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[41551]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mxx_sp_s[43087]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mxx_sp_s[46159]=-(pow(E,yss[11])*ebar*Pssp);
	Mxx_sp_s[860239]=-(pow(E,yss[0])*Pssp);
	Mxx_sp_s[861775]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mxx_sp_s[863311]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mxx_sp_s[864847]=-(pow(E,yss[3])*Pssp);
	Mxx_sp_s[867919]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mxx_sp_s[870991]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mxx_sp_s[874063]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxx_sp_s[875599]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxx_sp_s[36944]=-(pow(E,xss[0])*Pssp*zbar);
	Mxx_sp_s[41552]=-(pow(E,xss[0])*Pssp*zbar);
	Mxx_sp_s[864848]=pow(E,yss[3])*Pssp;
	Mxx_sp_s[874064]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxx_sp_s[875600]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxx_sp_s[36945]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxx_sp_s[38481]=(Pssp*zbar)/(1 + yss[5]);
	Mxx_sp_s[41553]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mxx_sp_s[43089]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxx_sp_s[861777]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxx_sp_s[863313]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxx_sp_s[867921]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mxx_sp_s[869457]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxx_sp_s[870993]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxx_sp_s[874065]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxx_sp_s[875601]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxx_sp_s[874066]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxx_sp_s[875602]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxx_sp_s[38483]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mxx_sp_s[44627]=Pssp;
	Mxx_sp_s[867923]=-Pssp;
	Mxx_sp_s[874067]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxx_sp_s[875603]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxx_sp_s[36948]=pow(E,xss[0])*Pssp;
	Mxx_sp_s[866388]=-(pow(E,xss[0])*Pssp);
	Mxx_sp_s[40021]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[41557]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[43093]=pow(E,yss[2])*pbar*Pssp;
	Mxx_sp_s[861781]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[863317]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mxx_sp_s[874069]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxx_sp_s[875605]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxx_sp_s[877141]=pow(E,yss[11])*Pssp;
	Mxx_sp_s[38486]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxx_sp_s[41558]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxx_sp_s[874070]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxx_sp_s[875606]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxx_sp_s[877142]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mxx_sp_s[878678]=Pssp;
	Mxx_sp_s[38487]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxx_sp_s[41559]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxx_sp_s[874071]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxx_sp_s[875607]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxx_sp_s[877143]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mxx_sp_s[880215]=Pssp;
	Mxx_sp_s[46168]=ebar*Pssp;
	Mxx_sp_s[860248]=pow(E,yss[0] - yss[11])*Pssp;
	Mxx_sp_s[864856]=pow(E,yss[3] - yss[11])*Pssp;
	Mxx_sp_s[874072]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxx_sp_s[875608]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxx_sp_s[877144]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mxx_sp_s[881752]=Pssp;
	Mxx_sp_s[36953]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[38489]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[40025]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[41561]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mxx_sp_s[43097]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[44633]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[46169]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[47705]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[874073]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[875609]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[883289]=Pssp;
	Mxx_sp_s[2371673]=(Pssp*pow(zbar,rrho)*Hs[0]*Hs[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2396249]=(Pssp*pow(zbar,rrho)*(Hs[1]*Hs[24] + Hs[0]*Hs[25])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2420825]=(Pssp*pow(zbar,rrho)*(Hs[2]*Hs[24] + Hs[0]*Hs[26])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2445401]=(Pssp*pow(zbar,rrho)*(Hs[3]*Hs[24] + Hs[0]*Hs[27])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2469977]=(Pssp*pow(zbar,rrho)*(Hs[4]*Hs[24] + Hs[0]*Hs[28])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2494553]=(Pssp*pow(zbar,rrho)*(Hs[5]*Hs[24] + Hs[0]*Hs[29])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2519129]=(Pssp*pow(zbar,rrho)*(Hs[6]*Hs[24] + Hs[0]*Hs[30])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2543705]=(Pssp*pow(zbar,rrho)*(Hs[7]*Hs[24] + Hs[0]*Hs[31])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2592857]=(Pssp*pow(zbar,rrho)*Hs[1]*Hs[25]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2617433]=(Pssp*pow(zbar,rrho)*(Hs[2]*Hs[25] + Hs[1]*Hs[26])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2642009]=(Pssp*pow(zbar,rrho)*(Hs[3]*Hs[25] + Hs[1]*Hs[27])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2666585]=(Pssp*pow(zbar,rrho)*(Hs[4]*Hs[25] + Hs[1]*Hs[28])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2691161]=(Pssp*pow(zbar,rrho)*(Hs[5]*Hs[25] + Hs[1]*Hs[29])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2715737]=(Pssp*pow(zbar,rrho)*(Hs[6]*Hs[25] + Hs[1]*Hs[30])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2740313]=(Pssp*pow(zbar,rrho)*(Hs[7]*Hs[25] + Hs[1]*Hs[31])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2814041]=(Pssp*pow(zbar,rrho)*Hs[2]*Hs[26]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2838617]=(Pssp*pow(zbar,rrho)*(Hs[3]*Hs[26] + Hs[2]*Hs[27])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2863193]=(Pssp*pow(zbar,rrho)*(Hs[4]*Hs[26] + Hs[2]*Hs[28])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2887769]=(Pssp*pow(zbar,rrho)*(Hs[5]*Hs[26] + Hs[2]*Hs[29])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2912345]=(Pssp*pow(zbar,rrho)*(Hs[6]*Hs[26] + Hs[2]*Hs[30])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2936921]=(Pssp*pow(zbar,rrho)*(Hs[7]*Hs[26] + Hs[2]*Hs[31])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3035225]=(Pssp*pow(zbar,rrho)*Hs[3]*Hs[27]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3059801]=(Pssp*pow(zbar,rrho)*(Hs[4]*Hs[27] + Hs[3]*Hs[28])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3084377]=(Pssp*pow(zbar,rrho)*(Hs[5]*Hs[27] + Hs[3]*Hs[29])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3108953]=(Pssp*pow(zbar,rrho)*(Hs[6]*Hs[27] + Hs[3]*Hs[30])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3133529]=(Pssp*pow(zbar,rrho)*(Hs[7]*Hs[27] + Hs[3]*Hs[31])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3256409]=(Pssp*pow(zbar,rrho)*Hs[4]*Hs[28]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3280985]=(Pssp*pow(zbar,rrho)*(Hs[5]*Hs[28] + Hs[4]*Hs[29])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3305561]=(Pssp*pow(zbar,rrho)*(Hs[6]*Hs[28] + Hs[4]*Hs[30])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3330137]=(Pssp*pow(zbar,rrho)*(Hs[7]*Hs[28] + Hs[4]*Hs[31])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3477593]=(Pssp*pow(zbar,rrho)*Hs[5]*Hs[29]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3502169]=(Pssp*pow(zbar,rrho)*(Hs[6]*Hs[29] + Hs[5]*Hs[30])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3526745]=(Pssp*pow(zbar,rrho)*(Hs[7]*Hs[29] + Hs[5]*Hs[31])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3698777]=(Pssp*pow(zbar,rrho)*Hs[6]*Hs[30]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3723353]=(Pssp*pow(zbar,rrho)*(Hs[7]*Hs[30] + Hs[6]*Hs[31])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3919961]=(Pssp*pow(zbar,rrho)*Hs[7]*Hs[31]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[40026]=-Pssp;
	Mxx_sp_s[41563]=-Pssp;
	Mxx_sp_s[43100]=-Pssp;
	Mxx_sp_s[47709]=-Pssp;
	Mxx_sp_s[46174]=-Pssp;
	Mxx_sp_s[44639]=-Pssp;
	Mxx_sp_s[60000]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mxx_sp_s[884832]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mxx_sp_s[886368]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mxx_sp_s[897120]=-(pow(E,yss[8])*Pssp);
	Mxx_sp_s[898656]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxx_sp_s[900192]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxx_sp_s[52321]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[53857]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[55393]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[886369]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[887905]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[892513]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mxx_sp_s[897121]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mxx_sp_s[898657]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[900193]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[52322]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[53858]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[886370]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[887906]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[892514]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mxx_sp_s[895586]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[897122]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mxx_sp_s[898658]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[900194]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[49251]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[50787]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[52323]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[53859]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mxx_sp_s[55395]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[56931]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[58467]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[60003]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[892515]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mxx_sp_s[897123]=-(pow(E,yss[8])*Pssp);
	Mxx_sp_s[898659]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mxx_sp_s[900195]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mxx_sp_s[2371683]=(bbeta*pow(E,yss[8])*Pssp*Hs[0]*Hs[32]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2396259]=(bbeta*pow(E,yss[8])*Pssp*(Hs[1]*Hs[32] + Hs[0]*Hs[33])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2420835]=(bbeta*pow(E,yss[8])*Pssp*(Hs[2]*Hs[32] + Hs[0]*Hs[34])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2445411]=(bbeta*pow(E,yss[8])*Pssp*(Hs[3]*Hs[32] + Hs[0]*Hs[35])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2469987]=(bbeta*pow(E,yss[8])*Pssp*(Hs[4]*Hs[32] + Hs[0]*Hs[36])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2494563]=(bbeta*pow(E,yss[8])*Pssp*(Hs[5]*Hs[32] + Hs[0]*Hs[37])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2519139]=(bbeta*pow(E,yss[8])*Pssp*(Hs[6]*Hs[32] + Hs[0]*Hs[38])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2543715]=(bbeta*pow(E,yss[8])*Pssp*(Hs[7]*Hs[32] + Hs[0]*Hs[39])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2592867]=(bbeta*pow(E,yss[8])*Pssp*Hs[1]*Hs[33]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2617443]=(bbeta*pow(E,yss[8])*Pssp*(Hs[2]*Hs[33] + Hs[1]*Hs[34])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2642019]=(bbeta*pow(E,yss[8])*Pssp*(Hs[3]*Hs[33] + Hs[1]*Hs[35])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2666595]=(bbeta*pow(E,yss[8])*Pssp*(Hs[4]*Hs[33] + Hs[1]*Hs[36])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2691171]=(bbeta*pow(E,yss[8])*Pssp*(Hs[5]*Hs[33] + Hs[1]*Hs[37])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2715747]=(bbeta*pow(E,yss[8])*Pssp*(Hs[6]*Hs[33] + Hs[1]*Hs[38])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2740323]=(bbeta*pow(E,yss[8])*Pssp*(Hs[7]*Hs[33] + Hs[1]*Hs[39])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2814051]=(bbeta*pow(E,yss[8])*Pssp*Hs[2]*Hs[34]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2838627]=(bbeta*pow(E,yss[8])*Pssp*(Hs[3]*Hs[34] + Hs[2]*Hs[35])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2863203]=(bbeta*pow(E,yss[8])*Pssp*(Hs[4]*Hs[34] + Hs[2]*Hs[36])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2887779]=(bbeta*pow(E,yss[8])*Pssp*(Hs[5]*Hs[34] + Hs[2]*Hs[37])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2912355]=(bbeta*pow(E,yss[8])*Pssp*(Hs[6]*Hs[34] + Hs[2]*Hs[38])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2936931]=(bbeta*pow(E,yss[8])*Pssp*(Hs[7]*Hs[34] + Hs[2]*Hs[39])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3035235]=(bbeta*pow(E,yss[8])*Pssp*Hs[3]*Hs[35]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3059811]=(bbeta*pow(E,yss[8])*Pssp*(Hs[4]*Hs[35] + Hs[3]*Hs[36])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3084387]=(bbeta*pow(E,yss[8])*Pssp*(Hs[5]*Hs[35] + Hs[3]*Hs[37])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3108963]=(bbeta*pow(E,yss[8])*Pssp*(Hs[6]*Hs[35] + Hs[3]*Hs[38])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3133539]=(bbeta*pow(E,yss[8])*Pssp*(Hs[7]*Hs[35] + Hs[3]*Hs[39])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3256419]=(bbeta*pow(E,yss[8])*Pssp*Hs[4]*Hs[36]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3280995]=(bbeta*pow(E,yss[8])*Pssp*(Hs[5]*Hs[36] + Hs[4]*Hs[37])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3305571]=(bbeta*pow(E,yss[8])*Pssp*(Hs[6]*Hs[36] + Hs[4]*Hs[38])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3330147]=(bbeta*pow(E,yss[8])*Pssp*(Hs[7]*Hs[36] + Hs[4]*Hs[39])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3477603]=(bbeta*pow(E,yss[8])*Pssp*Hs[5]*Hs[37]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3502179]=(bbeta*pow(E,yss[8])*Pssp*(Hs[6]*Hs[37] + Hs[5]*Hs[38])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3526755]=(bbeta*pow(E,yss[8])*Pssp*(Hs[7]*Hs[37] + Hs[5]*Hs[39])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3698787]=(bbeta*pow(E,yss[8])*Pssp*Hs[6]*Hs[38]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3723363]=(bbeta*pow(E,yss[8])*Pssp*(Hs[7]*Hs[38] + Hs[6]*Hs[39])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3919971]=(bbeta*pow(E,yss[8])*Pssp*Hs[7]*Hs[39]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[49252]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mxx_sp_s[50788]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mxx_sp_s[52324]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mxx_sp_s[53860]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mxx_sp_s[55396]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mxx_sp_s[56932]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mxx_sp_s[58468]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mxx_sp_s[60004]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mxx_sp_s[894052]=-(kkappa*Pssp*yss[9]);
	Mxx_sp_s[897124]=pow(E,yss[8])*Pssp;
	Mxx_sp_s[898660]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mxx_sp_s[900196]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mxx_sp_s[2360932]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[0]*Hs[32]);
	Mxx_sp_s[2362468]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[0]*Hs[32];
	Mxx_sp_s[2365540]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[0]*Hs[32]);
	Mxx_sp_s[2371684]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[0]*Hs[32])/pow(zbar,rrho);
	Mxx_sp_s[2385508]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[1]*Hs[32] + Hs[0]*Hs[33]));
	Mxx_sp_s[2387044]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[1]*Hs[32] + Hs[0]*Hs[33]);
	Mxx_sp_s[2390116]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[1]*Hs[32] + Hs[0]*Hs[33]));
	Mxx_sp_s[2396260]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[1]*Hs[32] + Hs[0]*Hs[33]))/pow(zbar,rrho);
	Mxx_sp_s[2410084]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[2]*Hs[32] + Hs[0]*Hs[34]));
	Mxx_sp_s[2411620]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[2]*Hs[32] + Hs[0]*Hs[34]);
	Mxx_sp_s[2414692]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[2]*Hs[32] + Hs[0]*Hs[34]));
	Mxx_sp_s[2420836]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[2]*Hs[32] + Hs[0]*Hs[34]))/pow(zbar,rrho);
	Mxx_sp_s[2434660]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[3]*Hs[32] + Hs[0]*Hs[35]));
	Mxx_sp_s[2436196]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[3]*Hs[32] + Hs[0]*Hs[35]);
	Mxx_sp_s[2439268]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[3]*Hs[32] + Hs[0]*Hs[35]));
	Mxx_sp_s[2445412]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[3]*Hs[32] + Hs[0]*Hs[35]))/pow(zbar,rrho);
	Mxx_sp_s[2459236]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[4]*Hs[32] + Hs[0]*Hs[36]));
	Mxx_sp_s[2460772]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[4]*Hs[32] + Hs[0]*Hs[36]);
	Mxx_sp_s[2463844]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[4]*Hs[32] + Hs[0]*Hs[36]));
	Mxx_sp_s[2469988]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[4]*Hs[32] + Hs[0]*Hs[36]))/pow(zbar,rrho);
	Mxx_sp_s[2483812]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[5]*Hs[32] + Hs[0]*Hs[37]));
	Mxx_sp_s[2485348]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[5]*Hs[32] + Hs[0]*Hs[37]);
	Mxx_sp_s[2488420]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[5]*Hs[32] + Hs[0]*Hs[37]));
	Mxx_sp_s[2494564]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[5]*Hs[32] + Hs[0]*Hs[37]))/pow(zbar,rrho);
	Mxx_sp_s[2508388]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[32] + Hs[0]*Hs[38]));
	Mxx_sp_s[2509924]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[32] + Hs[0]*Hs[38]);
	Mxx_sp_s[2512996]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[6]*Hs[32] + Hs[0]*Hs[38]));
	Mxx_sp_s[2519140]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[6]*Hs[32] + Hs[0]*Hs[38]))/pow(zbar,rrho);
	Mxx_sp_s[2532964]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[32] + Hs[0]*Hs[39]));
	Mxx_sp_s[2534500]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[32] + Hs[0]*Hs[39]);
	Mxx_sp_s[2537572]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[7]*Hs[32] + Hs[0]*Hs[39]));
	Mxx_sp_s[2543716]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[7]*Hs[32] + Hs[0]*Hs[39]))/pow(zbar,rrho);
	Mxx_sp_s[2582116]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[1]*Hs[33]);
	Mxx_sp_s[2583652]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[1]*Hs[33];
	Mxx_sp_s[2586724]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[1]*Hs[33]);
	Mxx_sp_s[2592868]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[1]*Hs[33])/pow(zbar,rrho);
	Mxx_sp_s[2606692]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[2]*Hs[33] + Hs[1]*Hs[34]));
	Mxx_sp_s[2608228]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[2]*Hs[33] + Hs[1]*Hs[34]);
	Mxx_sp_s[2611300]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[2]*Hs[33] + Hs[1]*Hs[34]));
	Mxx_sp_s[2617444]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[2]*Hs[33] + Hs[1]*Hs[34]))/pow(zbar,rrho);
	Mxx_sp_s[2631268]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[3]*Hs[33] + Hs[1]*Hs[35]));
	Mxx_sp_s[2632804]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[3]*Hs[33] + Hs[1]*Hs[35]);
	Mxx_sp_s[2635876]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[3]*Hs[33] + Hs[1]*Hs[35]));
	Mxx_sp_s[2642020]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[3]*Hs[33] + Hs[1]*Hs[35]))/pow(zbar,rrho);
	Mxx_sp_s[2655844]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[4]*Hs[33] + Hs[1]*Hs[36]));
	Mxx_sp_s[2657380]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[4]*Hs[33] + Hs[1]*Hs[36]);
	Mxx_sp_s[2660452]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[4]*Hs[33] + Hs[1]*Hs[36]));
	Mxx_sp_s[2666596]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[4]*Hs[33] + Hs[1]*Hs[36]))/pow(zbar,rrho);
	Mxx_sp_s[2680420]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[5]*Hs[33] + Hs[1]*Hs[37]));
	Mxx_sp_s[2681956]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[5]*Hs[33] + Hs[1]*Hs[37]);
	Mxx_sp_s[2685028]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[5]*Hs[33] + Hs[1]*Hs[37]));
	Mxx_sp_s[2691172]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[5]*Hs[33] + Hs[1]*Hs[37]))/pow(zbar,rrho);
	Mxx_sp_s[2704996]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[33] + Hs[1]*Hs[38]));
	Mxx_sp_s[2706532]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[33] + Hs[1]*Hs[38]);
	Mxx_sp_s[2709604]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[6]*Hs[33] + Hs[1]*Hs[38]));
	Mxx_sp_s[2715748]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[6]*Hs[33] + Hs[1]*Hs[38]))/pow(zbar,rrho);
	Mxx_sp_s[2729572]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[33] + Hs[1]*Hs[39]));
	Mxx_sp_s[2731108]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[33] + Hs[1]*Hs[39]);
	Mxx_sp_s[2734180]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[7]*Hs[33] + Hs[1]*Hs[39]));
	Mxx_sp_s[2740324]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[7]*Hs[33] + Hs[1]*Hs[39]))/pow(zbar,rrho);
	Mxx_sp_s[2803300]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[2]*Hs[34]);
	Mxx_sp_s[2804836]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[2]*Hs[34];
	Mxx_sp_s[2807908]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[2]*Hs[34]);
	Mxx_sp_s[2814052]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[2]*Hs[34])/pow(zbar,rrho);
	Mxx_sp_s[2827876]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[3]*Hs[34] + Hs[2]*Hs[35]));
	Mxx_sp_s[2829412]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[3]*Hs[34] + Hs[2]*Hs[35]);
	Mxx_sp_s[2832484]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[3]*Hs[34] + Hs[2]*Hs[35]));
	Mxx_sp_s[2838628]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[3]*Hs[34] + Hs[2]*Hs[35]))/pow(zbar,rrho);
	Mxx_sp_s[2852452]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[4]*Hs[34] + Hs[2]*Hs[36]));
	Mxx_sp_s[2853988]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[4]*Hs[34] + Hs[2]*Hs[36]);
	Mxx_sp_s[2857060]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[4]*Hs[34] + Hs[2]*Hs[36]));
	Mxx_sp_s[2863204]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[4]*Hs[34] + Hs[2]*Hs[36]))/pow(zbar,rrho);
	Mxx_sp_s[2877028]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[5]*Hs[34] + Hs[2]*Hs[37]));
	Mxx_sp_s[2878564]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[5]*Hs[34] + Hs[2]*Hs[37]);
	Mxx_sp_s[2881636]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[5]*Hs[34] + Hs[2]*Hs[37]));
	Mxx_sp_s[2887780]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[5]*Hs[34] + Hs[2]*Hs[37]))/pow(zbar,rrho);
	Mxx_sp_s[2901604]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[34] + Hs[2]*Hs[38]));
	Mxx_sp_s[2903140]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[34] + Hs[2]*Hs[38]);
	Mxx_sp_s[2906212]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[6]*Hs[34] + Hs[2]*Hs[38]));
	Mxx_sp_s[2912356]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[6]*Hs[34] + Hs[2]*Hs[38]))/pow(zbar,rrho);
	Mxx_sp_s[2926180]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[34] + Hs[2]*Hs[39]));
	Mxx_sp_s[2927716]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[34] + Hs[2]*Hs[39]);
	Mxx_sp_s[2930788]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[7]*Hs[34] + Hs[2]*Hs[39]));
	Mxx_sp_s[2936932]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[7]*Hs[34] + Hs[2]*Hs[39]))/pow(zbar,rrho);
	Mxx_sp_s[3024484]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[3]*Hs[35]);
	Mxx_sp_s[3026020]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[3]*Hs[35];
	Mxx_sp_s[3029092]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[3]*Hs[35]);
	Mxx_sp_s[3035236]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[3]*Hs[35])/pow(zbar,rrho);
	Mxx_sp_s[3049060]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[4]*Hs[35] + Hs[3]*Hs[36]));
	Mxx_sp_s[3050596]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[4]*Hs[35] + Hs[3]*Hs[36]);
	Mxx_sp_s[3053668]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[4]*Hs[35] + Hs[3]*Hs[36]));
	Mxx_sp_s[3059812]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[4]*Hs[35] + Hs[3]*Hs[36]))/pow(zbar,rrho);
	Mxx_sp_s[3073636]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[5]*Hs[35] + Hs[3]*Hs[37]));
	Mxx_sp_s[3075172]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[5]*Hs[35] + Hs[3]*Hs[37]);
	Mxx_sp_s[3078244]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[5]*Hs[35] + Hs[3]*Hs[37]));
	Mxx_sp_s[3084388]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[5]*Hs[35] + Hs[3]*Hs[37]))/pow(zbar,rrho);
	Mxx_sp_s[3098212]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[35] + Hs[3]*Hs[38]));
	Mxx_sp_s[3099748]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[35] + Hs[3]*Hs[38]);
	Mxx_sp_s[3102820]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[6]*Hs[35] + Hs[3]*Hs[38]));
	Mxx_sp_s[3108964]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[6]*Hs[35] + Hs[3]*Hs[38]))/pow(zbar,rrho);
	Mxx_sp_s[3122788]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[35] + Hs[3]*Hs[39]));
	Mxx_sp_s[3124324]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[35] + Hs[3]*Hs[39]);
	Mxx_sp_s[3127396]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[7]*Hs[35] + Hs[3]*Hs[39]));
	Mxx_sp_s[3133540]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[7]*Hs[35] + Hs[3]*Hs[39]))/pow(zbar,rrho);
	Mxx_sp_s[3245668]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[4]*Hs[36]);
	Mxx_sp_s[3247204]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[4]*Hs[36];
	Mxx_sp_s[3250276]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[4]*Hs[36]);
	Mxx_sp_s[3256420]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[4]*Hs[36])/pow(zbar,rrho);
	Mxx_sp_s[3270244]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[5]*Hs[36] + Hs[4]*Hs[37]));
	Mxx_sp_s[3271780]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[5]*Hs[36] + Hs[4]*Hs[37]);
	Mxx_sp_s[3274852]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[5]*Hs[36] + Hs[4]*Hs[37]));
	Mxx_sp_s[3280996]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[5]*Hs[36] + Hs[4]*Hs[37]))/pow(zbar,rrho);
	Mxx_sp_s[3294820]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[36] + Hs[4]*Hs[38]));
	Mxx_sp_s[3296356]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[36] + Hs[4]*Hs[38]);
	Mxx_sp_s[3299428]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[6]*Hs[36] + Hs[4]*Hs[38]));
	Mxx_sp_s[3305572]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[6]*Hs[36] + Hs[4]*Hs[38]))/pow(zbar,rrho);
	Mxx_sp_s[3319396]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[36] + Hs[4]*Hs[39]));
	Mxx_sp_s[3320932]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[36] + Hs[4]*Hs[39]);
	Mxx_sp_s[3324004]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[7]*Hs[36] + Hs[4]*Hs[39]));
	Mxx_sp_s[3330148]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[7]*Hs[36] + Hs[4]*Hs[39]))/pow(zbar,rrho);
	Mxx_sp_s[3466852]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[5]*Hs[37]);
	Mxx_sp_s[3468388]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[5]*Hs[37];
	Mxx_sp_s[3471460]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[5]*Hs[37]);
	Mxx_sp_s[3477604]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[5]*Hs[37])/pow(zbar,rrho);
	Mxx_sp_s[3491428]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[37] + Hs[5]*Hs[38]));
	Mxx_sp_s[3492964]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[37] + Hs[5]*Hs[38]);
	Mxx_sp_s[3496036]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[6]*Hs[37] + Hs[5]*Hs[38]));
	Mxx_sp_s[3502180]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[6]*Hs[37] + Hs[5]*Hs[38]))/pow(zbar,rrho);
	Mxx_sp_s[3516004]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[37] + Hs[5]*Hs[39]));
	Mxx_sp_s[3517540]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[37] + Hs[5]*Hs[39]);
	Mxx_sp_s[3520612]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[7]*Hs[37] + Hs[5]*Hs[39]));
	Mxx_sp_s[3526756]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[7]*Hs[37] + Hs[5]*Hs[39]))/pow(zbar,rrho);
	Mxx_sp_s[3688036]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[6]*Hs[38]);
	Mxx_sp_s[3689572]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[6]*Hs[38];
	Mxx_sp_s[3692644]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[6]*Hs[38]);
	Mxx_sp_s[3698788]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[6]*Hs[38])/pow(zbar,rrho);
	Mxx_sp_s[3712612]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[38] + Hs[6]*Hs[39]));
	Mxx_sp_s[3714148]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[38] + Hs[6]*Hs[39]);
	Mxx_sp_s[3717220]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[7]*Hs[38] + Hs[6]*Hs[39]));
	Mxx_sp_s[3723364]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[7]*Hs[38] + Hs[6]*Hs[39]))/pow(zbar,rrho);
	Mxx_sp_s[3909220]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[7]*Hs[39]);
	Mxx_sp_s[3910756]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[7]*Hs[39];
	Mxx_sp_s[3913828]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[7]*Hs[39]);
	Mxx_sp_s[3919972]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[7]*Hs[39])/pow(zbar,rrho);
	Mxx_sp_s[49253]=iiota*Pssp*zbar;
	Mxx_sp_s[53861]=iiota*Pssp*zbar;
	Mxx_sp_s[894053]=-Pssp;
	Mxx_sp_s[886374]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mxx_sp_s[895590]=-(pow(E,yss[7])*Pssp);
	Mxx_sp_s[898662]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxx_sp_s[900198]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxx_sp_s[50791]=-((Pssp*zbar)/(1 + yss[5]));
	Mxx_sp_s[52327]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[53863]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mxx_sp_s[55399]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mxx_sp_s[58471]=-(pow(E,yss[11])*ebar*Pssp);
	Mxx_sp_s[884839]=-(pow(E,yss[0])*Pssp);
	Mxx_sp_s[886375]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mxx_sp_s[887911]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mxx_sp_s[889447]=-(pow(E,yss[3])*Pssp);
	Mxx_sp_s[892519]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mxx_sp_s[895591]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mxx_sp_s[898663]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxx_sp_s[900199]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxx_sp_s[49256]=-(pow(E,xss[0])*Pssp*zbar);
	Mxx_sp_s[53864]=-(pow(E,xss[0])*Pssp*zbar);
	Mxx_sp_s[889448]=pow(E,yss[3])*Pssp;
	Mxx_sp_s[898664]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxx_sp_s[900200]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxx_sp_s[49257]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxx_sp_s[50793]=(Pssp*zbar)/(1 + yss[5]);
	Mxx_sp_s[53865]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mxx_sp_s[55401]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxx_sp_s[886377]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxx_sp_s[887913]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxx_sp_s[892521]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mxx_sp_s[894057]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxx_sp_s[895593]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxx_sp_s[898665]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxx_sp_s[900201]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxx_sp_s[898666]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxx_sp_s[900202]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxx_sp_s[50795]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mxx_sp_s[56939]=Pssp;
	Mxx_sp_s[892523]=-Pssp;
	Mxx_sp_s[898667]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxx_sp_s[900203]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxx_sp_s[49260]=pow(E,xss[0])*Pssp;
	Mxx_sp_s[890988]=-(pow(E,xss[0])*Pssp);
	Mxx_sp_s[52333]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[53869]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[55405]=pow(E,yss[2])*pbar*Pssp;
	Mxx_sp_s[886381]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[887917]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mxx_sp_s[898669]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxx_sp_s[900205]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxx_sp_s[901741]=pow(E,yss[11])*Pssp;
	Mxx_sp_s[50798]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxx_sp_s[53870]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxx_sp_s[898670]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxx_sp_s[900206]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxx_sp_s[901742]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mxx_sp_s[903278]=Pssp;
	Mxx_sp_s[50799]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxx_sp_s[53871]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxx_sp_s[898671]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxx_sp_s[900207]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxx_sp_s[901743]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mxx_sp_s[904815]=Pssp;
	Mxx_sp_s[58480]=ebar*Pssp;
	Mxx_sp_s[884848]=pow(E,yss[0] - yss[11])*Pssp;
	Mxx_sp_s[889456]=pow(E,yss[3] - yss[11])*Pssp;
	Mxx_sp_s[898672]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxx_sp_s[900208]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxx_sp_s[901744]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mxx_sp_s[906352]=Pssp;
	Mxx_sp_s[49265]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[50801]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[52337]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[53873]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mxx_sp_s[55409]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[56945]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[58481]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[60017]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[898673]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[900209]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[907889]=Pssp;
	Mxx_sp_s[2371697]=(Pssp*pow(zbar,rrho)*Hs[0]*Hs[32]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2396273]=(Pssp*pow(zbar,rrho)*(Hs[1]*Hs[32] + Hs[0]*Hs[33])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2420849]=(Pssp*pow(zbar,rrho)*(Hs[2]*Hs[32] + Hs[0]*Hs[34])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2445425]=(Pssp*pow(zbar,rrho)*(Hs[3]*Hs[32] + Hs[0]*Hs[35])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2470001]=(Pssp*pow(zbar,rrho)*(Hs[4]*Hs[32] + Hs[0]*Hs[36])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2494577]=(Pssp*pow(zbar,rrho)*(Hs[5]*Hs[32] + Hs[0]*Hs[37])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2519153]=(Pssp*pow(zbar,rrho)*(Hs[6]*Hs[32] + Hs[0]*Hs[38])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2543729]=(Pssp*pow(zbar,rrho)*(Hs[7]*Hs[32] + Hs[0]*Hs[39])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2592881]=(Pssp*pow(zbar,rrho)*Hs[1]*Hs[33]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2617457]=(Pssp*pow(zbar,rrho)*(Hs[2]*Hs[33] + Hs[1]*Hs[34])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2642033]=(Pssp*pow(zbar,rrho)*(Hs[3]*Hs[33] + Hs[1]*Hs[35])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2666609]=(Pssp*pow(zbar,rrho)*(Hs[4]*Hs[33] + Hs[1]*Hs[36])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2691185]=(Pssp*pow(zbar,rrho)*(Hs[5]*Hs[33] + Hs[1]*Hs[37])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2715761]=(Pssp*pow(zbar,rrho)*(Hs[6]*Hs[33] + Hs[1]*Hs[38])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2740337]=(Pssp*pow(zbar,rrho)*(Hs[7]*Hs[33] + Hs[1]*Hs[39])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2814065]=(Pssp*pow(zbar,rrho)*Hs[2]*Hs[34]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2838641]=(Pssp*pow(zbar,rrho)*(Hs[3]*Hs[34] + Hs[2]*Hs[35])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2863217]=(Pssp*pow(zbar,rrho)*(Hs[4]*Hs[34] + Hs[2]*Hs[36])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2887793]=(Pssp*pow(zbar,rrho)*(Hs[5]*Hs[34] + Hs[2]*Hs[37])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2912369]=(Pssp*pow(zbar,rrho)*(Hs[6]*Hs[34] + Hs[2]*Hs[38])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2936945]=(Pssp*pow(zbar,rrho)*(Hs[7]*Hs[34] + Hs[2]*Hs[39])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3035249]=(Pssp*pow(zbar,rrho)*Hs[3]*Hs[35]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3059825]=(Pssp*pow(zbar,rrho)*(Hs[4]*Hs[35] + Hs[3]*Hs[36])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3084401]=(Pssp*pow(zbar,rrho)*(Hs[5]*Hs[35] + Hs[3]*Hs[37])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3108977]=(Pssp*pow(zbar,rrho)*(Hs[6]*Hs[35] + Hs[3]*Hs[38])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3133553]=(Pssp*pow(zbar,rrho)*(Hs[7]*Hs[35] + Hs[3]*Hs[39])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3256433]=(Pssp*pow(zbar,rrho)*Hs[4]*Hs[36]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3281009]=(Pssp*pow(zbar,rrho)*(Hs[5]*Hs[36] + Hs[4]*Hs[37])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3305585]=(Pssp*pow(zbar,rrho)*(Hs[6]*Hs[36] + Hs[4]*Hs[38])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3330161]=(Pssp*pow(zbar,rrho)*(Hs[7]*Hs[36] + Hs[4]*Hs[39])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3477617]=(Pssp*pow(zbar,rrho)*Hs[5]*Hs[37]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3502193]=(Pssp*pow(zbar,rrho)*(Hs[6]*Hs[37] + Hs[5]*Hs[38])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3526769]=(Pssp*pow(zbar,rrho)*(Hs[7]*Hs[37] + Hs[5]*Hs[39])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3698801]=(Pssp*pow(zbar,rrho)*Hs[6]*Hs[38]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3723377]=(Pssp*pow(zbar,rrho)*(Hs[7]*Hs[38] + Hs[6]*Hs[39])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3919985]=(Pssp*pow(zbar,rrho)*Hs[7]*Hs[39]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[52338]=-Pssp;
	Mxx_sp_s[53875]=-Pssp;
	Mxx_sp_s[55412]=-Pssp;
	Mxx_sp_s[60021]=-Pssp;
	Mxx_sp_s[58486]=-Pssp;
	Mxx_sp_s[56951]=-Pssp;
	Mxx_sp_s[72312]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mxx_sp_s[909432]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mxx_sp_s[910968]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mxx_sp_s[921720]=-(pow(E,yss[8])*Pssp);
	Mxx_sp_s[923256]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxx_sp_s[924792]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxx_sp_s[64633]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[66169]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[67705]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[910969]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[912505]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[917113]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mxx_sp_s[921721]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mxx_sp_s[923257]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[924793]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[64634]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[66170]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[910970]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[912506]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[917114]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mxx_sp_s[920186]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[921722]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mxx_sp_s[923258]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[924794]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[61563]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[63099]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[64635]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[66171]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mxx_sp_s[67707]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[69243]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[70779]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[72315]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[917115]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mxx_sp_s[921723]=-(pow(E,yss[8])*Pssp);
	Mxx_sp_s[923259]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mxx_sp_s[924795]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mxx_sp_s[2371707]=(bbeta*pow(E,yss[8])*Pssp*Hs[0]*Hs[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2396283]=(bbeta*pow(E,yss[8])*Pssp*(Hs[1]*Hs[40] + Hs[0]*Hs[41])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2420859]=(bbeta*pow(E,yss[8])*Pssp*(Hs[2]*Hs[40] + Hs[0]*Hs[42])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2445435]=(bbeta*pow(E,yss[8])*Pssp*(Hs[3]*Hs[40] + Hs[0]*Hs[43])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2470011]=(bbeta*pow(E,yss[8])*Pssp*(Hs[4]*Hs[40] + Hs[0]*Hs[44])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2494587]=(bbeta*pow(E,yss[8])*Pssp*(Hs[5]*Hs[40] + Hs[0]*Hs[45])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2519163]=(bbeta*pow(E,yss[8])*Pssp*(Hs[6]*Hs[40] + Hs[0]*Hs[46])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2543739]=(bbeta*pow(E,yss[8])*Pssp*(Hs[7]*Hs[40] + Hs[0]*Hs[47])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2592891]=(bbeta*pow(E,yss[8])*Pssp*Hs[1]*Hs[41]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2617467]=(bbeta*pow(E,yss[8])*Pssp*(Hs[2]*Hs[41] + Hs[1]*Hs[42])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2642043]=(bbeta*pow(E,yss[8])*Pssp*(Hs[3]*Hs[41] + Hs[1]*Hs[43])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2666619]=(bbeta*pow(E,yss[8])*Pssp*(Hs[4]*Hs[41] + Hs[1]*Hs[44])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2691195]=(bbeta*pow(E,yss[8])*Pssp*(Hs[5]*Hs[41] + Hs[1]*Hs[45])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2715771]=(bbeta*pow(E,yss[8])*Pssp*(Hs[6]*Hs[41] + Hs[1]*Hs[46])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2740347]=(bbeta*pow(E,yss[8])*Pssp*(Hs[7]*Hs[41] + Hs[1]*Hs[47])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2814075]=(bbeta*pow(E,yss[8])*Pssp*Hs[2]*Hs[42]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2838651]=(bbeta*pow(E,yss[8])*Pssp*(Hs[3]*Hs[42] + Hs[2]*Hs[43])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2863227]=(bbeta*pow(E,yss[8])*Pssp*(Hs[4]*Hs[42] + Hs[2]*Hs[44])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2887803]=(bbeta*pow(E,yss[8])*Pssp*(Hs[5]*Hs[42] + Hs[2]*Hs[45])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2912379]=(bbeta*pow(E,yss[8])*Pssp*(Hs[6]*Hs[42] + Hs[2]*Hs[46])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2936955]=(bbeta*pow(E,yss[8])*Pssp*(Hs[7]*Hs[42] + Hs[2]*Hs[47])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3035259]=(bbeta*pow(E,yss[8])*Pssp*Hs[3]*Hs[43]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3059835]=(bbeta*pow(E,yss[8])*Pssp*(Hs[4]*Hs[43] + Hs[3]*Hs[44])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3084411]=(bbeta*pow(E,yss[8])*Pssp*(Hs[5]*Hs[43] + Hs[3]*Hs[45])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3108987]=(bbeta*pow(E,yss[8])*Pssp*(Hs[6]*Hs[43] + Hs[3]*Hs[46])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3133563]=(bbeta*pow(E,yss[8])*Pssp*(Hs[7]*Hs[43] + Hs[3]*Hs[47])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3256443]=(bbeta*pow(E,yss[8])*Pssp*Hs[4]*Hs[44]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3281019]=(bbeta*pow(E,yss[8])*Pssp*(Hs[5]*Hs[44] + Hs[4]*Hs[45])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3305595]=(bbeta*pow(E,yss[8])*Pssp*(Hs[6]*Hs[44] + Hs[4]*Hs[46])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3330171]=(bbeta*pow(E,yss[8])*Pssp*(Hs[7]*Hs[44] + Hs[4]*Hs[47])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3477627]=(bbeta*pow(E,yss[8])*Pssp*Hs[5]*Hs[45]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3502203]=(bbeta*pow(E,yss[8])*Pssp*(Hs[6]*Hs[45] + Hs[5]*Hs[46])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3526779]=(bbeta*pow(E,yss[8])*Pssp*(Hs[7]*Hs[45] + Hs[5]*Hs[47])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3698811]=(bbeta*pow(E,yss[8])*Pssp*Hs[6]*Hs[46]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3723387]=(bbeta*pow(E,yss[8])*Pssp*(Hs[7]*Hs[46] + Hs[6]*Hs[47])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3919995]=(bbeta*pow(E,yss[8])*Pssp*Hs[7]*Hs[47]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[61564]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mxx_sp_s[63100]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mxx_sp_s[64636]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mxx_sp_s[66172]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mxx_sp_s[67708]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mxx_sp_s[69244]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mxx_sp_s[70780]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mxx_sp_s[72316]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mxx_sp_s[918652]=-(kkappa*Pssp*yss[9]);
	Mxx_sp_s[921724]=pow(E,yss[8])*Pssp;
	Mxx_sp_s[923260]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mxx_sp_s[924796]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mxx_sp_s[2360956]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[0]*Hs[40]);
	Mxx_sp_s[2362492]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[0]*Hs[40];
	Mxx_sp_s[2365564]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[0]*Hs[40]);
	Mxx_sp_s[2371708]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[0]*Hs[40])/pow(zbar,rrho);
	Mxx_sp_s[2385532]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[1]*Hs[40] + Hs[0]*Hs[41]));
	Mxx_sp_s[2387068]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[1]*Hs[40] + Hs[0]*Hs[41]);
	Mxx_sp_s[2390140]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[1]*Hs[40] + Hs[0]*Hs[41]));
	Mxx_sp_s[2396284]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[1]*Hs[40] + Hs[0]*Hs[41]))/pow(zbar,rrho);
	Mxx_sp_s[2410108]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[2]*Hs[40] + Hs[0]*Hs[42]));
	Mxx_sp_s[2411644]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[2]*Hs[40] + Hs[0]*Hs[42]);
	Mxx_sp_s[2414716]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[2]*Hs[40] + Hs[0]*Hs[42]));
	Mxx_sp_s[2420860]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[2]*Hs[40] + Hs[0]*Hs[42]))/pow(zbar,rrho);
	Mxx_sp_s[2434684]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[3]*Hs[40] + Hs[0]*Hs[43]));
	Mxx_sp_s[2436220]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[3]*Hs[40] + Hs[0]*Hs[43]);
	Mxx_sp_s[2439292]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[3]*Hs[40] + Hs[0]*Hs[43]));
	Mxx_sp_s[2445436]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[3]*Hs[40] + Hs[0]*Hs[43]))/pow(zbar,rrho);
	Mxx_sp_s[2459260]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[4]*Hs[40] + Hs[0]*Hs[44]));
	Mxx_sp_s[2460796]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[4]*Hs[40] + Hs[0]*Hs[44]);
	Mxx_sp_s[2463868]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[4]*Hs[40] + Hs[0]*Hs[44]));
	Mxx_sp_s[2470012]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[4]*Hs[40] + Hs[0]*Hs[44]))/pow(zbar,rrho);
	Mxx_sp_s[2483836]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[5]*Hs[40] + Hs[0]*Hs[45]));
	Mxx_sp_s[2485372]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[5]*Hs[40] + Hs[0]*Hs[45]);
	Mxx_sp_s[2488444]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[5]*Hs[40] + Hs[0]*Hs[45]));
	Mxx_sp_s[2494588]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[5]*Hs[40] + Hs[0]*Hs[45]))/pow(zbar,rrho);
	Mxx_sp_s[2508412]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[40] + Hs[0]*Hs[46]));
	Mxx_sp_s[2509948]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[40] + Hs[0]*Hs[46]);
	Mxx_sp_s[2513020]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[6]*Hs[40] + Hs[0]*Hs[46]));
	Mxx_sp_s[2519164]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[6]*Hs[40] + Hs[0]*Hs[46]))/pow(zbar,rrho);
	Mxx_sp_s[2532988]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[40] + Hs[0]*Hs[47]));
	Mxx_sp_s[2534524]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[40] + Hs[0]*Hs[47]);
	Mxx_sp_s[2537596]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[7]*Hs[40] + Hs[0]*Hs[47]));
	Mxx_sp_s[2543740]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[7]*Hs[40] + Hs[0]*Hs[47]))/pow(zbar,rrho);
	Mxx_sp_s[2582140]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[1]*Hs[41]);
	Mxx_sp_s[2583676]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[1]*Hs[41];
	Mxx_sp_s[2586748]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[1]*Hs[41]);
	Mxx_sp_s[2592892]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[1]*Hs[41])/pow(zbar,rrho);
	Mxx_sp_s[2606716]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[2]*Hs[41] + Hs[1]*Hs[42]));
	Mxx_sp_s[2608252]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[2]*Hs[41] + Hs[1]*Hs[42]);
	Mxx_sp_s[2611324]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[2]*Hs[41] + Hs[1]*Hs[42]));
	Mxx_sp_s[2617468]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[2]*Hs[41] + Hs[1]*Hs[42]))/pow(zbar,rrho);
	Mxx_sp_s[2631292]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[3]*Hs[41] + Hs[1]*Hs[43]));
	Mxx_sp_s[2632828]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[3]*Hs[41] + Hs[1]*Hs[43]);
	Mxx_sp_s[2635900]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[3]*Hs[41] + Hs[1]*Hs[43]));
	Mxx_sp_s[2642044]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[3]*Hs[41] + Hs[1]*Hs[43]))/pow(zbar,rrho);
	Mxx_sp_s[2655868]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[4]*Hs[41] + Hs[1]*Hs[44]));
	Mxx_sp_s[2657404]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[4]*Hs[41] + Hs[1]*Hs[44]);
	Mxx_sp_s[2660476]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[4]*Hs[41] + Hs[1]*Hs[44]));
	Mxx_sp_s[2666620]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[4]*Hs[41] + Hs[1]*Hs[44]))/pow(zbar,rrho);
	Mxx_sp_s[2680444]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[5]*Hs[41] + Hs[1]*Hs[45]));
	Mxx_sp_s[2681980]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[5]*Hs[41] + Hs[1]*Hs[45]);
	Mxx_sp_s[2685052]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[5]*Hs[41] + Hs[1]*Hs[45]));
	Mxx_sp_s[2691196]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[5]*Hs[41] + Hs[1]*Hs[45]))/pow(zbar,rrho);
	Mxx_sp_s[2705020]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[41] + Hs[1]*Hs[46]));
	Mxx_sp_s[2706556]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[41] + Hs[1]*Hs[46]);
	Mxx_sp_s[2709628]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[6]*Hs[41] + Hs[1]*Hs[46]));
	Mxx_sp_s[2715772]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[6]*Hs[41] + Hs[1]*Hs[46]))/pow(zbar,rrho);
	Mxx_sp_s[2729596]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[41] + Hs[1]*Hs[47]));
	Mxx_sp_s[2731132]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[41] + Hs[1]*Hs[47]);
	Mxx_sp_s[2734204]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[7]*Hs[41] + Hs[1]*Hs[47]));
	Mxx_sp_s[2740348]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[7]*Hs[41] + Hs[1]*Hs[47]))/pow(zbar,rrho);
	Mxx_sp_s[2803324]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[2]*Hs[42]);
	Mxx_sp_s[2804860]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[2]*Hs[42];
	Mxx_sp_s[2807932]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[2]*Hs[42]);
	Mxx_sp_s[2814076]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[2]*Hs[42])/pow(zbar,rrho);
	Mxx_sp_s[2827900]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[3]*Hs[42] + Hs[2]*Hs[43]));
	Mxx_sp_s[2829436]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[3]*Hs[42] + Hs[2]*Hs[43]);
	Mxx_sp_s[2832508]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[3]*Hs[42] + Hs[2]*Hs[43]));
	Mxx_sp_s[2838652]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[3]*Hs[42] + Hs[2]*Hs[43]))/pow(zbar,rrho);
	Mxx_sp_s[2852476]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[4]*Hs[42] + Hs[2]*Hs[44]));
	Mxx_sp_s[2854012]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[4]*Hs[42] + Hs[2]*Hs[44]);
	Mxx_sp_s[2857084]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[4]*Hs[42] + Hs[2]*Hs[44]));
	Mxx_sp_s[2863228]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[4]*Hs[42] + Hs[2]*Hs[44]))/pow(zbar,rrho);
	Mxx_sp_s[2877052]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[5]*Hs[42] + Hs[2]*Hs[45]));
	Mxx_sp_s[2878588]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[5]*Hs[42] + Hs[2]*Hs[45]);
	Mxx_sp_s[2881660]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[5]*Hs[42] + Hs[2]*Hs[45]));
	Mxx_sp_s[2887804]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[5]*Hs[42] + Hs[2]*Hs[45]))/pow(zbar,rrho);
	Mxx_sp_s[2901628]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[42] + Hs[2]*Hs[46]));
	Mxx_sp_s[2903164]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[42] + Hs[2]*Hs[46]);
	Mxx_sp_s[2906236]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[6]*Hs[42] + Hs[2]*Hs[46]));
	Mxx_sp_s[2912380]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[6]*Hs[42] + Hs[2]*Hs[46]))/pow(zbar,rrho);
	Mxx_sp_s[2926204]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[42] + Hs[2]*Hs[47]));
	Mxx_sp_s[2927740]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[42] + Hs[2]*Hs[47]);
	Mxx_sp_s[2930812]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[7]*Hs[42] + Hs[2]*Hs[47]));
	Mxx_sp_s[2936956]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[7]*Hs[42] + Hs[2]*Hs[47]))/pow(zbar,rrho);
	Mxx_sp_s[3024508]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[3]*Hs[43]);
	Mxx_sp_s[3026044]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[3]*Hs[43];
	Mxx_sp_s[3029116]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[3]*Hs[43]);
	Mxx_sp_s[3035260]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[3]*Hs[43])/pow(zbar,rrho);
	Mxx_sp_s[3049084]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[4]*Hs[43] + Hs[3]*Hs[44]));
	Mxx_sp_s[3050620]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[4]*Hs[43] + Hs[3]*Hs[44]);
	Mxx_sp_s[3053692]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[4]*Hs[43] + Hs[3]*Hs[44]));
	Mxx_sp_s[3059836]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[4]*Hs[43] + Hs[3]*Hs[44]))/pow(zbar,rrho);
	Mxx_sp_s[3073660]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[5]*Hs[43] + Hs[3]*Hs[45]));
	Mxx_sp_s[3075196]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[5]*Hs[43] + Hs[3]*Hs[45]);
	Mxx_sp_s[3078268]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[5]*Hs[43] + Hs[3]*Hs[45]));
	Mxx_sp_s[3084412]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[5]*Hs[43] + Hs[3]*Hs[45]))/pow(zbar,rrho);
	Mxx_sp_s[3098236]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[43] + Hs[3]*Hs[46]));
	Mxx_sp_s[3099772]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[43] + Hs[3]*Hs[46]);
	Mxx_sp_s[3102844]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[6]*Hs[43] + Hs[3]*Hs[46]));
	Mxx_sp_s[3108988]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[6]*Hs[43] + Hs[3]*Hs[46]))/pow(zbar,rrho);
	Mxx_sp_s[3122812]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[43] + Hs[3]*Hs[47]));
	Mxx_sp_s[3124348]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[43] + Hs[3]*Hs[47]);
	Mxx_sp_s[3127420]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[7]*Hs[43] + Hs[3]*Hs[47]));
	Mxx_sp_s[3133564]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[7]*Hs[43] + Hs[3]*Hs[47]))/pow(zbar,rrho);
	Mxx_sp_s[3245692]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[4]*Hs[44]);
	Mxx_sp_s[3247228]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[4]*Hs[44];
	Mxx_sp_s[3250300]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[4]*Hs[44]);
	Mxx_sp_s[3256444]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[4]*Hs[44])/pow(zbar,rrho);
	Mxx_sp_s[3270268]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[5]*Hs[44] + Hs[4]*Hs[45]));
	Mxx_sp_s[3271804]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[5]*Hs[44] + Hs[4]*Hs[45]);
	Mxx_sp_s[3274876]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[5]*Hs[44] + Hs[4]*Hs[45]));
	Mxx_sp_s[3281020]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[5]*Hs[44] + Hs[4]*Hs[45]))/pow(zbar,rrho);
	Mxx_sp_s[3294844]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[44] + Hs[4]*Hs[46]));
	Mxx_sp_s[3296380]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[44] + Hs[4]*Hs[46]);
	Mxx_sp_s[3299452]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[6]*Hs[44] + Hs[4]*Hs[46]));
	Mxx_sp_s[3305596]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[6]*Hs[44] + Hs[4]*Hs[46]))/pow(zbar,rrho);
	Mxx_sp_s[3319420]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[44] + Hs[4]*Hs[47]));
	Mxx_sp_s[3320956]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[44] + Hs[4]*Hs[47]);
	Mxx_sp_s[3324028]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[7]*Hs[44] + Hs[4]*Hs[47]));
	Mxx_sp_s[3330172]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[7]*Hs[44] + Hs[4]*Hs[47]))/pow(zbar,rrho);
	Mxx_sp_s[3466876]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[5]*Hs[45]);
	Mxx_sp_s[3468412]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[5]*Hs[45];
	Mxx_sp_s[3471484]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[5]*Hs[45]);
	Mxx_sp_s[3477628]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[5]*Hs[45])/pow(zbar,rrho);
	Mxx_sp_s[3491452]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[45] + Hs[5]*Hs[46]));
	Mxx_sp_s[3492988]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[45] + Hs[5]*Hs[46]);
	Mxx_sp_s[3496060]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[6]*Hs[45] + Hs[5]*Hs[46]));
	Mxx_sp_s[3502204]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[6]*Hs[45] + Hs[5]*Hs[46]))/pow(zbar,rrho);
	Mxx_sp_s[3516028]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[45] + Hs[5]*Hs[47]));
	Mxx_sp_s[3517564]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[45] + Hs[5]*Hs[47]);
	Mxx_sp_s[3520636]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[7]*Hs[45] + Hs[5]*Hs[47]));
	Mxx_sp_s[3526780]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[7]*Hs[45] + Hs[5]*Hs[47]))/pow(zbar,rrho);
	Mxx_sp_s[3688060]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[6]*Hs[46]);
	Mxx_sp_s[3689596]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[6]*Hs[46];
	Mxx_sp_s[3692668]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[6]*Hs[46]);
	Mxx_sp_s[3698812]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[6]*Hs[46])/pow(zbar,rrho);
	Mxx_sp_s[3712636]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[46] + Hs[6]*Hs[47]));
	Mxx_sp_s[3714172]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[46] + Hs[6]*Hs[47]);
	Mxx_sp_s[3717244]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[7]*Hs[46] + Hs[6]*Hs[47]));
	Mxx_sp_s[3723388]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[7]*Hs[46] + Hs[6]*Hs[47]))/pow(zbar,rrho);
	Mxx_sp_s[3909244]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[7]*Hs[47]);
	Mxx_sp_s[3910780]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[7]*Hs[47];
	Mxx_sp_s[3913852]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[7]*Hs[47]);
	Mxx_sp_s[3919996]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[7]*Hs[47])/pow(zbar,rrho);
	Mxx_sp_s[61565]=iiota*Pssp*zbar;
	Mxx_sp_s[66173]=iiota*Pssp*zbar;
	Mxx_sp_s[918653]=-Pssp;
	Mxx_sp_s[910974]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mxx_sp_s[920190]=-(pow(E,yss[7])*Pssp);
	Mxx_sp_s[923262]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxx_sp_s[924798]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxx_sp_s[63103]=-((Pssp*zbar)/(1 + yss[5]));
	Mxx_sp_s[64639]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[66175]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mxx_sp_s[67711]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mxx_sp_s[70783]=-(pow(E,yss[11])*ebar*Pssp);
	Mxx_sp_s[909439]=-(pow(E,yss[0])*Pssp);
	Mxx_sp_s[910975]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mxx_sp_s[912511]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mxx_sp_s[914047]=-(pow(E,yss[3])*Pssp);
	Mxx_sp_s[917119]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mxx_sp_s[920191]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mxx_sp_s[923263]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxx_sp_s[924799]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxx_sp_s[61568]=-(pow(E,xss[0])*Pssp*zbar);
	Mxx_sp_s[66176]=-(pow(E,xss[0])*Pssp*zbar);
	Mxx_sp_s[914048]=pow(E,yss[3])*Pssp;
	Mxx_sp_s[923264]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxx_sp_s[924800]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxx_sp_s[61569]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxx_sp_s[63105]=(Pssp*zbar)/(1 + yss[5]);
	Mxx_sp_s[66177]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mxx_sp_s[67713]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxx_sp_s[910977]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxx_sp_s[912513]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxx_sp_s[917121]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mxx_sp_s[918657]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxx_sp_s[920193]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxx_sp_s[923265]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxx_sp_s[924801]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxx_sp_s[923266]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxx_sp_s[924802]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxx_sp_s[63107]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mxx_sp_s[69251]=Pssp;
	Mxx_sp_s[917123]=-Pssp;
	Mxx_sp_s[923267]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxx_sp_s[924803]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxx_sp_s[61572]=pow(E,xss[0])*Pssp;
	Mxx_sp_s[915588]=-(pow(E,xss[0])*Pssp);
	Mxx_sp_s[64645]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[66181]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[67717]=pow(E,yss[2])*pbar*Pssp;
	Mxx_sp_s[910981]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[912517]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mxx_sp_s[923269]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxx_sp_s[924805]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxx_sp_s[926341]=pow(E,yss[11])*Pssp;
	Mxx_sp_s[63110]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxx_sp_s[66182]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxx_sp_s[923270]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxx_sp_s[924806]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxx_sp_s[926342]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mxx_sp_s[927878]=Pssp;
	Mxx_sp_s[63111]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxx_sp_s[66183]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxx_sp_s[923271]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxx_sp_s[924807]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxx_sp_s[926343]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mxx_sp_s[929415]=Pssp;
	Mxx_sp_s[70792]=ebar*Pssp;
	Mxx_sp_s[909448]=pow(E,yss[0] - yss[11])*Pssp;
	Mxx_sp_s[914056]=pow(E,yss[3] - yss[11])*Pssp;
	Mxx_sp_s[923272]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxx_sp_s[924808]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxx_sp_s[926344]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mxx_sp_s[930952]=Pssp;
	Mxx_sp_s[61577]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[63113]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[64649]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[66185]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mxx_sp_s[67721]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[69257]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[70793]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[72329]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[923273]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[924809]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[932489]=Pssp;
	Mxx_sp_s[2371721]=(Pssp*pow(zbar,rrho)*Hs[0]*Hs[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2396297]=(Pssp*pow(zbar,rrho)*(Hs[1]*Hs[40] + Hs[0]*Hs[41])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2420873]=(Pssp*pow(zbar,rrho)*(Hs[2]*Hs[40] + Hs[0]*Hs[42])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2445449]=(Pssp*pow(zbar,rrho)*(Hs[3]*Hs[40] + Hs[0]*Hs[43])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2470025]=(Pssp*pow(zbar,rrho)*(Hs[4]*Hs[40] + Hs[0]*Hs[44])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2494601]=(Pssp*pow(zbar,rrho)*(Hs[5]*Hs[40] + Hs[0]*Hs[45])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2519177]=(Pssp*pow(zbar,rrho)*(Hs[6]*Hs[40] + Hs[0]*Hs[46])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2543753]=(Pssp*pow(zbar,rrho)*(Hs[7]*Hs[40] + Hs[0]*Hs[47])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2592905]=(Pssp*pow(zbar,rrho)*Hs[1]*Hs[41]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2617481]=(Pssp*pow(zbar,rrho)*(Hs[2]*Hs[41] + Hs[1]*Hs[42])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2642057]=(Pssp*pow(zbar,rrho)*(Hs[3]*Hs[41] + Hs[1]*Hs[43])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2666633]=(Pssp*pow(zbar,rrho)*(Hs[4]*Hs[41] + Hs[1]*Hs[44])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2691209]=(Pssp*pow(zbar,rrho)*(Hs[5]*Hs[41] + Hs[1]*Hs[45])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2715785]=(Pssp*pow(zbar,rrho)*(Hs[6]*Hs[41] + Hs[1]*Hs[46])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2740361]=(Pssp*pow(zbar,rrho)*(Hs[7]*Hs[41] + Hs[1]*Hs[47])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2814089]=(Pssp*pow(zbar,rrho)*Hs[2]*Hs[42]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2838665]=(Pssp*pow(zbar,rrho)*(Hs[3]*Hs[42] + Hs[2]*Hs[43])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2863241]=(Pssp*pow(zbar,rrho)*(Hs[4]*Hs[42] + Hs[2]*Hs[44])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2887817]=(Pssp*pow(zbar,rrho)*(Hs[5]*Hs[42] + Hs[2]*Hs[45])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2912393]=(Pssp*pow(zbar,rrho)*(Hs[6]*Hs[42] + Hs[2]*Hs[46])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2936969]=(Pssp*pow(zbar,rrho)*(Hs[7]*Hs[42] + Hs[2]*Hs[47])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3035273]=(Pssp*pow(zbar,rrho)*Hs[3]*Hs[43]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3059849]=(Pssp*pow(zbar,rrho)*(Hs[4]*Hs[43] + Hs[3]*Hs[44])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3084425]=(Pssp*pow(zbar,rrho)*(Hs[5]*Hs[43] + Hs[3]*Hs[45])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3109001]=(Pssp*pow(zbar,rrho)*(Hs[6]*Hs[43] + Hs[3]*Hs[46])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3133577]=(Pssp*pow(zbar,rrho)*(Hs[7]*Hs[43] + Hs[3]*Hs[47])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3256457]=(Pssp*pow(zbar,rrho)*Hs[4]*Hs[44]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3281033]=(Pssp*pow(zbar,rrho)*(Hs[5]*Hs[44] + Hs[4]*Hs[45])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3305609]=(Pssp*pow(zbar,rrho)*(Hs[6]*Hs[44] + Hs[4]*Hs[46])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3330185]=(Pssp*pow(zbar,rrho)*(Hs[7]*Hs[44] + Hs[4]*Hs[47])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3477641]=(Pssp*pow(zbar,rrho)*Hs[5]*Hs[45]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3502217]=(Pssp*pow(zbar,rrho)*(Hs[6]*Hs[45] + Hs[5]*Hs[46])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3526793]=(Pssp*pow(zbar,rrho)*(Hs[7]*Hs[45] + Hs[5]*Hs[47])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3698825]=(Pssp*pow(zbar,rrho)*Hs[6]*Hs[46]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3723401]=(Pssp*pow(zbar,rrho)*(Hs[7]*Hs[46] + Hs[6]*Hs[47])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3920009]=(Pssp*pow(zbar,rrho)*Hs[7]*Hs[47]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[64650]=-Pssp;
	Mxx_sp_s[66187]=-Pssp;
	Mxx_sp_s[67724]=-Pssp;
	Mxx_sp_s[72333]=-Pssp;
	Mxx_sp_s[70798]=-Pssp;
	Mxx_sp_s[69263]=-Pssp;
	Mxx_sp_s[84624]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mxx_sp_s[934032]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mxx_sp_s[935568]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mxx_sp_s[946320]=-(pow(E,yss[8])*Pssp);
	Mxx_sp_s[947856]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxx_sp_s[949392]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxx_sp_s[76945]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[78481]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[80017]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[935569]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[937105]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[941713]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mxx_sp_s[946321]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mxx_sp_s[947857]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[949393]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[76946]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[78482]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[935570]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[937106]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[941714]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mxx_sp_s[944786]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[946322]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mxx_sp_s[947858]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[949394]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[73875]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[75411]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[76947]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[78483]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mxx_sp_s[80019]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[81555]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[83091]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[84627]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[941715]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mxx_sp_s[946323]=-(pow(E,yss[8])*Pssp);
	Mxx_sp_s[947859]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mxx_sp_s[949395]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mxx_sp_s[2371731]=(bbeta*pow(E,yss[8])*Pssp*Hs[0]*Hs[48]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2396307]=(bbeta*pow(E,yss[8])*Pssp*(Hs[1]*Hs[48] + Hs[0]*Hs[49])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2420883]=(bbeta*pow(E,yss[8])*Pssp*(Hs[2]*Hs[48] + Hs[0]*Hs[50])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2445459]=(bbeta*pow(E,yss[8])*Pssp*(Hs[3]*Hs[48] + Hs[0]*Hs[51])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2470035]=(bbeta*pow(E,yss[8])*Pssp*(Hs[4]*Hs[48] + Hs[0]*Hs[52])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2494611]=(bbeta*pow(E,yss[8])*Pssp*(Hs[5]*Hs[48] + Hs[0]*Hs[53])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2519187]=(bbeta*pow(E,yss[8])*Pssp*(Hs[6]*Hs[48] + Hs[0]*Hs[54])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2543763]=(bbeta*pow(E,yss[8])*Pssp*(Hs[7]*Hs[48] + Hs[0]*Hs[55])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2592915]=(bbeta*pow(E,yss[8])*Pssp*Hs[1]*Hs[49]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2617491]=(bbeta*pow(E,yss[8])*Pssp*(Hs[2]*Hs[49] + Hs[1]*Hs[50])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2642067]=(bbeta*pow(E,yss[8])*Pssp*(Hs[3]*Hs[49] + Hs[1]*Hs[51])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2666643]=(bbeta*pow(E,yss[8])*Pssp*(Hs[4]*Hs[49] + Hs[1]*Hs[52])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2691219]=(bbeta*pow(E,yss[8])*Pssp*(Hs[5]*Hs[49] + Hs[1]*Hs[53])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2715795]=(bbeta*pow(E,yss[8])*Pssp*(Hs[6]*Hs[49] + Hs[1]*Hs[54])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2740371]=(bbeta*pow(E,yss[8])*Pssp*(Hs[7]*Hs[49] + Hs[1]*Hs[55])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2814099]=(bbeta*pow(E,yss[8])*Pssp*Hs[2]*Hs[50]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2838675]=(bbeta*pow(E,yss[8])*Pssp*(Hs[3]*Hs[50] + Hs[2]*Hs[51])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2863251]=(bbeta*pow(E,yss[8])*Pssp*(Hs[4]*Hs[50] + Hs[2]*Hs[52])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2887827]=(bbeta*pow(E,yss[8])*Pssp*(Hs[5]*Hs[50] + Hs[2]*Hs[53])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2912403]=(bbeta*pow(E,yss[8])*Pssp*(Hs[6]*Hs[50] + Hs[2]*Hs[54])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2936979]=(bbeta*pow(E,yss[8])*Pssp*(Hs[7]*Hs[50] + Hs[2]*Hs[55])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3035283]=(bbeta*pow(E,yss[8])*Pssp*Hs[3]*Hs[51]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3059859]=(bbeta*pow(E,yss[8])*Pssp*(Hs[4]*Hs[51] + Hs[3]*Hs[52])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3084435]=(bbeta*pow(E,yss[8])*Pssp*(Hs[5]*Hs[51] + Hs[3]*Hs[53])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3109011]=(bbeta*pow(E,yss[8])*Pssp*(Hs[6]*Hs[51] + Hs[3]*Hs[54])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3133587]=(bbeta*pow(E,yss[8])*Pssp*(Hs[7]*Hs[51] + Hs[3]*Hs[55])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3256467]=(bbeta*pow(E,yss[8])*Pssp*Hs[4]*Hs[52]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3281043]=(bbeta*pow(E,yss[8])*Pssp*(Hs[5]*Hs[52] + Hs[4]*Hs[53])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3305619]=(bbeta*pow(E,yss[8])*Pssp*(Hs[6]*Hs[52] + Hs[4]*Hs[54])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3330195]=(bbeta*pow(E,yss[8])*Pssp*(Hs[7]*Hs[52] + Hs[4]*Hs[55])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3477651]=(bbeta*pow(E,yss[8])*Pssp*Hs[5]*Hs[53]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3502227]=(bbeta*pow(E,yss[8])*Pssp*(Hs[6]*Hs[53] + Hs[5]*Hs[54])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3526803]=(bbeta*pow(E,yss[8])*Pssp*(Hs[7]*Hs[53] + Hs[5]*Hs[55])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3698835]=(bbeta*pow(E,yss[8])*Pssp*Hs[6]*Hs[54]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3723411]=(bbeta*pow(E,yss[8])*Pssp*(Hs[7]*Hs[54] + Hs[6]*Hs[55])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3920019]=(bbeta*pow(E,yss[8])*Pssp*Hs[7]*Hs[55]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[73876]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mxx_sp_s[75412]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mxx_sp_s[76948]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mxx_sp_s[78484]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mxx_sp_s[80020]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mxx_sp_s[81556]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mxx_sp_s[83092]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mxx_sp_s[84628]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mxx_sp_s[943252]=-(kkappa*Pssp*yss[9]);
	Mxx_sp_s[946324]=pow(E,yss[8])*Pssp;
	Mxx_sp_s[947860]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mxx_sp_s[949396]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mxx_sp_s[2360980]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[0]*Hs[48]);
	Mxx_sp_s[2362516]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[0]*Hs[48];
	Mxx_sp_s[2365588]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[0]*Hs[48]);
	Mxx_sp_s[2371732]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[0]*Hs[48])/pow(zbar,rrho);
	Mxx_sp_s[2385556]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[1]*Hs[48] + Hs[0]*Hs[49]));
	Mxx_sp_s[2387092]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[1]*Hs[48] + Hs[0]*Hs[49]);
	Mxx_sp_s[2390164]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[1]*Hs[48] + Hs[0]*Hs[49]));
	Mxx_sp_s[2396308]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[1]*Hs[48] + Hs[0]*Hs[49]))/pow(zbar,rrho);
	Mxx_sp_s[2410132]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[2]*Hs[48] + Hs[0]*Hs[50]));
	Mxx_sp_s[2411668]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[2]*Hs[48] + Hs[0]*Hs[50]);
	Mxx_sp_s[2414740]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[2]*Hs[48] + Hs[0]*Hs[50]));
	Mxx_sp_s[2420884]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[2]*Hs[48] + Hs[0]*Hs[50]))/pow(zbar,rrho);
	Mxx_sp_s[2434708]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[3]*Hs[48] + Hs[0]*Hs[51]));
	Mxx_sp_s[2436244]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[3]*Hs[48] + Hs[0]*Hs[51]);
	Mxx_sp_s[2439316]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[3]*Hs[48] + Hs[0]*Hs[51]));
	Mxx_sp_s[2445460]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[3]*Hs[48] + Hs[0]*Hs[51]))/pow(zbar,rrho);
	Mxx_sp_s[2459284]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[4]*Hs[48] + Hs[0]*Hs[52]));
	Mxx_sp_s[2460820]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[4]*Hs[48] + Hs[0]*Hs[52]);
	Mxx_sp_s[2463892]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[4]*Hs[48] + Hs[0]*Hs[52]));
	Mxx_sp_s[2470036]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[4]*Hs[48] + Hs[0]*Hs[52]))/pow(zbar,rrho);
	Mxx_sp_s[2483860]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[5]*Hs[48] + Hs[0]*Hs[53]));
	Mxx_sp_s[2485396]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[5]*Hs[48] + Hs[0]*Hs[53]);
	Mxx_sp_s[2488468]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[5]*Hs[48] + Hs[0]*Hs[53]));
	Mxx_sp_s[2494612]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[5]*Hs[48] + Hs[0]*Hs[53]))/pow(zbar,rrho);
	Mxx_sp_s[2508436]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[48] + Hs[0]*Hs[54]));
	Mxx_sp_s[2509972]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[48] + Hs[0]*Hs[54]);
	Mxx_sp_s[2513044]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[6]*Hs[48] + Hs[0]*Hs[54]));
	Mxx_sp_s[2519188]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[6]*Hs[48] + Hs[0]*Hs[54]))/pow(zbar,rrho);
	Mxx_sp_s[2533012]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[48] + Hs[0]*Hs[55]));
	Mxx_sp_s[2534548]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[48] + Hs[0]*Hs[55]);
	Mxx_sp_s[2537620]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[7]*Hs[48] + Hs[0]*Hs[55]));
	Mxx_sp_s[2543764]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[7]*Hs[48] + Hs[0]*Hs[55]))/pow(zbar,rrho);
	Mxx_sp_s[2582164]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[1]*Hs[49]);
	Mxx_sp_s[2583700]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[1]*Hs[49];
	Mxx_sp_s[2586772]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[1]*Hs[49]);
	Mxx_sp_s[2592916]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[1]*Hs[49])/pow(zbar,rrho);
	Mxx_sp_s[2606740]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[2]*Hs[49] + Hs[1]*Hs[50]));
	Mxx_sp_s[2608276]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[2]*Hs[49] + Hs[1]*Hs[50]);
	Mxx_sp_s[2611348]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[2]*Hs[49] + Hs[1]*Hs[50]));
	Mxx_sp_s[2617492]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[2]*Hs[49] + Hs[1]*Hs[50]))/pow(zbar,rrho);
	Mxx_sp_s[2631316]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[3]*Hs[49] + Hs[1]*Hs[51]));
	Mxx_sp_s[2632852]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[3]*Hs[49] + Hs[1]*Hs[51]);
	Mxx_sp_s[2635924]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[3]*Hs[49] + Hs[1]*Hs[51]));
	Mxx_sp_s[2642068]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[3]*Hs[49] + Hs[1]*Hs[51]))/pow(zbar,rrho);
	Mxx_sp_s[2655892]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[4]*Hs[49] + Hs[1]*Hs[52]));
	Mxx_sp_s[2657428]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[4]*Hs[49] + Hs[1]*Hs[52]);
	Mxx_sp_s[2660500]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[4]*Hs[49] + Hs[1]*Hs[52]));
	Mxx_sp_s[2666644]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[4]*Hs[49] + Hs[1]*Hs[52]))/pow(zbar,rrho);
	Mxx_sp_s[2680468]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[5]*Hs[49] + Hs[1]*Hs[53]));
	Mxx_sp_s[2682004]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[5]*Hs[49] + Hs[1]*Hs[53]);
	Mxx_sp_s[2685076]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[5]*Hs[49] + Hs[1]*Hs[53]));
	Mxx_sp_s[2691220]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[5]*Hs[49] + Hs[1]*Hs[53]))/pow(zbar,rrho);
	Mxx_sp_s[2705044]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[49] + Hs[1]*Hs[54]));
	Mxx_sp_s[2706580]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[49] + Hs[1]*Hs[54]);
	Mxx_sp_s[2709652]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[6]*Hs[49] + Hs[1]*Hs[54]));
	Mxx_sp_s[2715796]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[6]*Hs[49] + Hs[1]*Hs[54]))/pow(zbar,rrho);
	Mxx_sp_s[2729620]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[49] + Hs[1]*Hs[55]));
	Mxx_sp_s[2731156]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[49] + Hs[1]*Hs[55]);
	Mxx_sp_s[2734228]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[7]*Hs[49] + Hs[1]*Hs[55]));
	Mxx_sp_s[2740372]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[7]*Hs[49] + Hs[1]*Hs[55]))/pow(zbar,rrho);
	Mxx_sp_s[2803348]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[2]*Hs[50]);
	Mxx_sp_s[2804884]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[2]*Hs[50];
	Mxx_sp_s[2807956]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[2]*Hs[50]);
	Mxx_sp_s[2814100]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[2]*Hs[50])/pow(zbar,rrho);
	Mxx_sp_s[2827924]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[3]*Hs[50] + Hs[2]*Hs[51]));
	Mxx_sp_s[2829460]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[3]*Hs[50] + Hs[2]*Hs[51]);
	Mxx_sp_s[2832532]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[3]*Hs[50] + Hs[2]*Hs[51]));
	Mxx_sp_s[2838676]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[3]*Hs[50] + Hs[2]*Hs[51]))/pow(zbar,rrho);
	Mxx_sp_s[2852500]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[4]*Hs[50] + Hs[2]*Hs[52]));
	Mxx_sp_s[2854036]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[4]*Hs[50] + Hs[2]*Hs[52]);
	Mxx_sp_s[2857108]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[4]*Hs[50] + Hs[2]*Hs[52]));
	Mxx_sp_s[2863252]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[4]*Hs[50] + Hs[2]*Hs[52]))/pow(zbar,rrho);
	Mxx_sp_s[2877076]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[5]*Hs[50] + Hs[2]*Hs[53]));
	Mxx_sp_s[2878612]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[5]*Hs[50] + Hs[2]*Hs[53]);
	Mxx_sp_s[2881684]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[5]*Hs[50] + Hs[2]*Hs[53]));
	Mxx_sp_s[2887828]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[5]*Hs[50] + Hs[2]*Hs[53]))/pow(zbar,rrho);
	Mxx_sp_s[2901652]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[50] + Hs[2]*Hs[54]));
	Mxx_sp_s[2903188]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[50] + Hs[2]*Hs[54]);
	Mxx_sp_s[2906260]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[6]*Hs[50] + Hs[2]*Hs[54]));
	Mxx_sp_s[2912404]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[6]*Hs[50] + Hs[2]*Hs[54]))/pow(zbar,rrho);
	Mxx_sp_s[2926228]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[50] + Hs[2]*Hs[55]));
	Mxx_sp_s[2927764]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[50] + Hs[2]*Hs[55]);
	Mxx_sp_s[2930836]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[7]*Hs[50] + Hs[2]*Hs[55]));
	Mxx_sp_s[2936980]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[7]*Hs[50] + Hs[2]*Hs[55]))/pow(zbar,rrho);
	Mxx_sp_s[3024532]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[3]*Hs[51]);
	Mxx_sp_s[3026068]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[3]*Hs[51];
	Mxx_sp_s[3029140]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[3]*Hs[51]);
	Mxx_sp_s[3035284]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[3]*Hs[51])/pow(zbar,rrho);
	Mxx_sp_s[3049108]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[4]*Hs[51] + Hs[3]*Hs[52]));
	Mxx_sp_s[3050644]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[4]*Hs[51] + Hs[3]*Hs[52]);
	Mxx_sp_s[3053716]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[4]*Hs[51] + Hs[3]*Hs[52]));
	Mxx_sp_s[3059860]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[4]*Hs[51] + Hs[3]*Hs[52]))/pow(zbar,rrho);
	Mxx_sp_s[3073684]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[5]*Hs[51] + Hs[3]*Hs[53]));
	Mxx_sp_s[3075220]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[5]*Hs[51] + Hs[3]*Hs[53]);
	Mxx_sp_s[3078292]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[5]*Hs[51] + Hs[3]*Hs[53]));
	Mxx_sp_s[3084436]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[5]*Hs[51] + Hs[3]*Hs[53]))/pow(zbar,rrho);
	Mxx_sp_s[3098260]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[51] + Hs[3]*Hs[54]));
	Mxx_sp_s[3099796]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[51] + Hs[3]*Hs[54]);
	Mxx_sp_s[3102868]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[6]*Hs[51] + Hs[3]*Hs[54]));
	Mxx_sp_s[3109012]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[6]*Hs[51] + Hs[3]*Hs[54]))/pow(zbar,rrho);
	Mxx_sp_s[3122836]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[51] + Hs[3]*Hs[55]));
	Mxx_sp_s[3124372]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[51] + Hs[3]*Hs[55]);
	Mxx_sp_s[3127444]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[7]*Hs[51] + Hs[3]*Hs[55]));
	Mxx_sp_s[3133588]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[7]*Hs[51] + Hs[3]*Hs[55]))/pow(zbar,rrho);
	Mxx_sp_s[3245716]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[4]*Hs[52]);
	Mxx_sp_s[3247252]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[4]*Hs[52];
	Mxx_sp_s[3250324]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[4]*Hs[52]);
	Mxx_sp_s[3256468]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[4]*Hs[52])/pow(zbar,rrho);
	Mxx_sp_s[3270292]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[5]*Hs[52] + Hs[4]*Hs[53]));
	Mxx_sp_s[3271828]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[5]*Hs[52] + Hs[4]*Hs[53]);
	Mxx_sp_s[3274900]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[5]*Hs[52] + Hs[4]*Hs[53]));
	Mxx_sp_s[3281044]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[5]*Hs[52] + Hs[4]*Hs[53]))/pow(zbar,rrho);
	Mxx_sp_s[3294868]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[52] + Hs[4]*Hs[54]));
	Mxx_sp_s[3296404]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[52] + Hs[4]*Hs[54]);
	Mxx_sp_s[3299476]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[6]*Hs[52] + Hs[4]*Hs[54]));
	Mxx_sp_s[3305620]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[6]*Hs[52] + Hs[4]*Hs[54]))/pow(zbar,rrho);
	Mxx_sp_s[3319444]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[52] + Hs[4]*Hs[55]));
	Mxx_sp_s[3320980]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[52] + Hs[4]*Hs[55]);
	Mxx_sp_s[3324052]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[7]*Hs[52] + Hs[4]*Hs[55]));
	Mxx_sp_s[3330196]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[7]*Hs[52] + Hs[4]*Hs[55]))/pow(zbar,rrho);
	Mxx_sp_s[3466900]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[5]*Hs[53]);
	Mxx_sp_s[3468436]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[5]*Hs[53];
	Mxx_sp_s[3471508]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[5]*Hs[53]);
	Mxx_sp_s[3477652]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[5]*Hs[53])/pow(zbar,rrho);
	Mxx_sp_s[3491476]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[53] + Hs[5]*Hs[54]));
	Mxx_sp_s[3493012]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[53] + Hs[5]*Hs[54]);
	Mxx_sp_s[3496084]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[6]*Hs[53] + Hs[5]*Hs[54]));
	Mxx_sp_s[3502228]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[6]*Hs[53] + Hs[5]*Hs[54]))/pow(zbar,rrho);
	Mxx_sp_s[3516052]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[53] + Hs[5]*Hs[55]));
	Mxx_sp_s[3517588]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[53] + Hs[5]*Hs[55]);
	Mxx_sp_s[3520660]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[7]*Hs[53] + Hs[5]*Hs[55]));
	Mxx_sp_s[3526804]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[7]*Hs[53] + Hs[5]*Hs[55]))/pow(zbar,rrho);
	Mxx_sp_s[3688084]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[6]*Hs[54]);
	Mxx_sp_s[3689620]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[6]*Hs[54];
	Mxx_sp_s[3692692]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[6]*Hs[54]);
	Mxx_sp_s[3698836]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[6]*Hs[54])/pow(zbar,rrho);
	Mxx_sp_s[3712660]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[54] + Hs[6]*Hs[55]));
	Mxx_sp_s[3714196]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[54] + Hs[6]*Hs[55]);
	Mxx_sp_s[3717268]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[7]*Hs[54] + Hs[6]*Hs[55]));
	Mxx_sp_s[3723412]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[7]*Hs[54] + Hs[6]*Hs[55]))/pow(zbar,rrho);
	Mxx_sp_s[3909268]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[7]*Hs[55]);
	Mxx_sp_s[3910804]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[7]*Hs[55];
	Mxx_sp_s[3913876]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[7]*Hs[55]);
	Mxx_sp_s[3920020]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[7]*Hs[55])/pow(zbar,rrho);
	Mxx_sp_s[73877]=iiota*Pssp*zbar;
	Mxx_sp_s[78485]=iiota*Pssp*zbar;
	Mxx_sp_s[943253]=-Pssp;
	Mxx_sp_s[935574]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mxx_sp_s[944790]=-(pow(E,yss[7])*Pssp);
	Mxx_sp_s[947862]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxx_sp_s[949398]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxx_sp_s[75415]=-((Pssp*zbar)/(1 + yss[5]));
	Mxx_sp_s[76951]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[78487]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mxx_sp_s[80023]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mxx_sp_s[83095]=-(pow(E,yss[11])*ebar*Pssp);
	Mxx_sp_s[934039]=-(pow(E,yss[0])*Pssp);
	Mxx_sp_s[935575]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mxx_sp_s[937111]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mxx_sp_s[938647]=-(pow(E,yss[3])*Pssp);
	Mxx_sp_s[941719]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mxx_sp_s[944791]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mxx_sp_s[947863]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxx_sp_s[949399]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxx_sp_s[73880]=-(pow(E,xss[0])*Pssp*zbar);
	Mxx_sp_s[78488]=-(pow(E,xss[0])*Pssp*zbar);
	Mxx_sp_s[938648]=pow(E,yss[3])*Pssp;
	Mxx_sp_s[947864]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxx_sp_s[949400]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxx_sp_s[73881]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxx_sp_s[75417]=(Pssp*zbar)/(1 + yss[5]);
	Mxx_sp_s[78489]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mxx_sp_s[80025]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxx_sp_s[935577]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxx_sp_s[937113]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxx_sp_s[941721]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mxx_sp_s[943257]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxx_sp_s[944793]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxx_sp_s[947865]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxx_sp_s[949401]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxx_sp_s[947866]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxx_sp_s[949402]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxx_sp_s[75419]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mxx_sp_s[81563]=Pssp;
	Mxx_sp_s[941723]=-Pssp;
	Mxx_sp_s[947867]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxx_sp_s[949403]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxx_sp_s[73884]=pow(E,xss[0])*Pssp;
	Mxx_sp_s[940188]=-(pow(E,xss[0])*Pssp);
	Mxx_sp_s[76957]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[78493]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[80029]=pow(E,yss[2])*pbar*Pssp;
	Mxx_sp_s[935581]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[937117]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mxx_sp_s[947869]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxx_sp_s[949405]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxx_sp_s[950941]=pow(E,yss[11])*Pssp;
	Mxx_sp_s[75422]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxx_sp_s[78494]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxx_sp_s[947870]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxx_sp_s[949406]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxx_sp_s[950942]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mxx_sp_s[952478]=Pssp;
	Mxx_sp_s[75423]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxx_sp_s[78495]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxx_sp_s[947871]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxx_sp_s[949407]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxx_sp_s[950943]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mxx_sp_s[954015]=Pssp;
	Mxx_sp_s[83104]=ebar*Pssp;
	Mxx_sp_s[934048]=pow(E,yss[0] - yss[11])*Pssp;
	Mxx_sp_s[938656]=pow(E,yss[3] - yss[11])*Pssp;
	Mxx_sp_s[947872]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxx_sp_s[949408]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxx_sp_s[950944]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mxx_sp_s[955552]=Pssp;
	Mxx_sp_s[73889]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[75425]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[76961]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[78497]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mxx_sp_s[80033]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[81569]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[83105]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[84641]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[947873]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[949409]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[957089]=Pssp;
	Mxx_sp_s[2371745]=(Pssp*pow(zbar,rrho)*Hs[0]*Hs[48]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2396321]=(Pssp*pow(zbar,rrho)*(Hs[1]*Hs[48] + Hs[0]*Hs[49])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2420897]=(Pssp*pow(zbar,rrho)*(Hs[2]*Hs[48] + Hs[0]*Hs[50])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2445473]=(Pssp*pow(zbar,rrho)*(Hs[3]*Hs[48] + Hs[0]*Hs[51])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2470049]=(Pssp*pow(zbar,rrho)*(Hs[4]*Hs[48] + Hs[0]*Hs[52])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2494625]=(Pssp*pow(zbar,rrho)*(Hs[5]*Hs[48] + Hs[0]*Hs[53])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2519201]=(Pssp*pow(zbar,rrho)*(Hs[6]*Hs[48] + Hs[0]*Hs[54])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2543777]=(Pssp*pow(zbar,rrho)*(Hs[7]*Hs[48] + Hs[0]*Hs[55])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2592929]=(Pssp*pow(zbar,rrho)*Hs[1]*Hs[49]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2617505]=(Pssp*pow(zbar,rrho)*(Hs[2]*Hs[49] + Hs[1]*Hs[50])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2642081]=(Pssp*pow(zbar,rrho)*(Hs[3]*Hs[49] + Hs[1]*Hs[51])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2666657]=(Pssp*pow(zbar,rrho)*(Hs[4]*Hs[49] + Hs[1]*Hs[52])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2691233]=(Pssp*pow(zbar,rrho)*(Hs[5]*Hs[49] + Hs[1]*Hs[53])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2715809]=(Pssp*pow(zbar,rrho)*(Hs[6]*Hs[49] + Hs[1]*Hs[54])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2740385]=(Pssp*pow(zbar,rrho)*(Hs[7]*Hs[49] + Hs[1]*Hs[55])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2814113]=(Pssp*pow(zbar,rrho)*Hs[2]*Hs[50]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2838689]=(Pssp*pow(zbar,rrho)*(Hs[3]*Hs[50] + Hs[2]*Hs[51])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2863265]=(Pssp*pow(zbar,rrho)*(Hs[4]*Hs[50] + Hs[2]*Hs[52])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2887841]=(Pssp*pow(zbar,rrho)*(Hs[5]*Hs[50] + Hs[2]*Hs[53])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2912417]=(Pssp*pow(zbar,rrho)*(Hs[6]*Hs[50] + Hs[2]*Hs[54])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2936993]=(Pssp*pow(zbar,rrho)*(Hs[7]*Hs[50] + Hs[2]*Hs[55])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3035297]=(Pssp*pow(zbar,rrho)*Hs[3]*Hs[51]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3059873]=(Pssp*pow(zbar,rrho)*(Hs[4]*Hs[51] + Hs[3]*Hs[52])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3084449]=(Pssp*pow(zbar,rrho)*(Hs[5]*Hs[51] + Hs[3]*Hs[53])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3109025]=(Pssp*pow(zbar,rrho)*(Hs[6]*Hs[51] + Hs[3]*Hs[54])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3133601]=(Pssp*pow(zbar,rrho)*(Hs[7]*Hs[51] + Hs[3]*Hs[55])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3256481]=(Pssp*pow(zbar,rrho)*Hs[4]*Hs[52]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3281057]=(Pssp*pow(zbar,rrho)*(Hs[5]*Hs[52] + Hs[4]*Hs[53])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3305633]=(Pssp*pow(zbar,rrho)*(Hs[6]*Hs[52] + Hs[4]*Hs[54])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3330209]=(Pssp*pow(zbar,rrho)*(Hs[7]*Hs[52] + Hs[4]*Hs[55])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3477665]=(Pssp*pow(zbar,rrho)*Hs[5]*Hs[53]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3502241]=(Pssp*pow(zbar,rrho)*(Hs[6]*Hs[53] + Hs[5]*Hs[54])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3526817]=(Pssp*pow(zbar,rrho)*(Hs[7]*Hs[53] + Hs[5]*Hs[55])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3698849]=(Pssp*pow(zbar,rrho)*Hs[6]*Hs[54]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3723425]=(Pssp*pow(zbar,rrho)*(Hs[7]*Hs[54] + Hs[6]*Hs[55])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3920033]=(Pssp*pow(zbar,rrho)*Hs[7]*Hs[55]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[76962]=-Pssp;
	Mxx_sp_s[78499]=-Pssp;
	Mxx_sp_s[80036]=-Pssp;
	Mxx_sp_s[84645]=-Pssp;
	Mxx_sp_s[83110]=-Pssp;
	Mxx_sp_s[81575]=-Pssp;
	Mxx_sp_s[96936]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mxx_sp_s[958632]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mxx_sp_s[960168]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mxx_sp_s[970920]=-(pow(E,yss[8])*Pssp);
	Mxx_sp_s[972456]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxx_sp_s[973992]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxx_sp_s[89257]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[90793]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[92329]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[960169]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[961705]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[966313]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mxx_sp_s[970921]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mxx_sp_s[972457]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[973993]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[89258]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[90794]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[960170]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[961706]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[966314]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mxx_sp_s[969386]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[970922]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mxx_sp_s[972458]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[973994]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[86187]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[87723]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[89259]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[90795]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mxx_sp_s[92331]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[93867]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[95403]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[96939]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[966315]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mxx_sp_s[970923]=-(pow(E,yss[8])*Pssp);
	Mxx_sp_s[972459]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mxx_sp_s[973995]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mxx_sp_s[2371755]=(bbeta*pow(E,yss[8])*Pssp*Hs[0]*Hs[56]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2396331]=(bbeta*pow(E,yss[8])*Pssp*(Hs[1]*Hs[56] + Hs[0]*Hs[57])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2420907]=(bbeta*pow(E,yss[8])*Pssp*(Hs[2]*Hs[56] + Hs[0]*Hs[58])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2445483]=(bbeta*pow(E,yss[8])*Pssp*(Hs[3]*Hs[56] + Hs[0]*Hs[59])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2470059]=(bbeta*pow(E,yss[8])*Pssp*(Hs[4]*Hs[56] + Hs[0]*Hs[60])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2494635]=(bbeta*pow(E,yss[8])*Pssp*(Hs[5]*Hs[56] + Hs[0]*Hs[61])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2519211]=(bbeta*pow(E,yss[8])*Pssp*(Hs[6]*Hs[56] + Hs[0]*Hs[62])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2543787]=(bbeta*pow(E,yss[8])*Pssp*(Hs[7]*Hs[56] + Hs[0]*Hs[63])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2592939]=(bbeta*pow(E,yss[8])*Pssp*Hs[1]*Hs[57]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2617515]=(bbeta*pow(E,yss[8])*Pssp*(Hs[2]*Hs[57] + Hs[1]*Hs[58])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2642091]=(bbeta*pow(E,yss[8])*Pssp*(Hs[3]*Hs[57] + Hs[1]*Hs[59])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2666667]=(bbeta*pow(E,yss[8])*Pssp*(Hs[4]*Hs[57] + Hs[1]*Hs[60])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2691243]=(bbeta*pow(E,yss[8])*Pssp*(Hs[5]*Hs[57] + Hs[1]*Hs[61])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2715819]=(bbeta*pow(E,yss[8])*Pssp*(Hs[6]*Hs[57] + Hs[1]*Hs[62])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2740395]=(bbeta*pow(E,yss[8])*Pssp*(Hs[7]*Hs[57] + Hs[1]*Hs[63])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2814123]=(bbeta*pow(E,yss[8])*Pssp*Hs[2]*Hs[58]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2838699]=(bbeta*pow(E,yss[8])*Pssp*(Hs[3]*Hs[58] + Hs[2]*Hs[59])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2863275]=(bbeta*pow(E,yss[8])*Pssp*(Hs[4]*Hs[58] + Hs[2]*Hs[60])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2887851]=(bbeta*pow(E,yss[8])*Pssp*(Hs[5]*Hs[58] + Hs[2]*Hs[61])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2912427]=(bbeta*pow(E,yss[8])*Pssp*(Hs[6]*Hs[58] + Hs[2]*Hs[62])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2937003]=(bbeta*pow(E,yss[8])*Pssp*(Hs[7]*Hs[58] + Hs[2]*Hs[63])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3035307]=(bbeta*pow(E,yss[8])*Pssp*Hs[3]*Hs[59]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3059883]=(bbeta*pow(E,yss[8])*Pssp*(Hs[4]*Hs[59] + Hs[3]*Hs[60])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3084459]=(bbeta*pow(E,yss[8])*Pssp*(Hs[5]*Hs[59] + Hs[3]*Hs[61])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3109035]=(bbeta*pow(E,yss[8])*Pssp*(Hs[6]*Hs[59] + Hs[3]*Hs[62])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3133611]=(bbeta*pow(E,yss[8])*Pssp*(Hs[7]*Hs[59] + Hs[3]*Hs[63])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3256491]=(bbeta*pow(E,yss[8])*Pssp*Hs[4]*Hs[60]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3281067]=(bbeta*pow(E,yss[8])*Pssp*(Hs[5]*Hs[60] + Hs[4]*Hs[61])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3305643]=(bbeta*pow(E,yss[8])*Pssp*(Hs[6]*Hs[60] + Hs[4]*Hs[62])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3330219]=(bbeta*pow(E,yss[8])*Pssp*(Hs[7]*Hs[60] + Hs[4]*Hs[63])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3477675]=(bbeta*pow(E,yss[8])*Pssp*Hs[5]*Hs[61]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3502251]=(bbeta*pow(E,yss[8])*Pssp*(Hs[6]*Hs[61] + Hs[5]*Hs[62])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3526827]=(bbeta*pow(E,yss[8])*Pssp*(Hs[7]*Hs[61] + Hs[5]*Hs[63])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3698859]=(bbeta*pow(E,yss[8])*Pssp*Hs[6]*Hs[62]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3723435]=(bbeta*pow(E,yss[8])*Pssp*(Hs[7]*Hs[62] + Hs[6]*Hs[63])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3920043]=(bbeta*pow(E,yss[8])*Pssp*Hs[7]*Hs[63]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[86188]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mxx_sp_s[87724]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mxx_sp_s[89260]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mxx_sp_s[90796]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mxx_sp_s[92332]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mxx_sp_s[93868]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mxx_sp_s[95404]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mxx_sp_s[96940]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mxx_sp_s[967852]=-(kkappa*Pssp*yss[9]);
	Mxx_sp_s[970924]=pow(E,yss[8])*Pssp;
	Mxx_sp_s[972460]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mxx_sp_s[973996]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mxx_sp_s[2361004]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[0]*Hs[56]);
	Mxx_sp_s[2362540]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[0]*Hs[56];
	Mxx_sp_s[2365612]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[0]*Hs[56]);
	Mxx_sp_s[2371756]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[0]*Hs[56])/pow(zbar,rrho);
	Mxx_sp_s[2385580]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[1]*Hs[56] + Hs[0]*Hs[57]));
	Mxx_sp_s[2387116]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[1]*Hs[56] + Hs[0]*Hs[57]);
	Mxx_sp_s[2390188]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[1]*Hs[56] + Hs[0]*Hs[57]));
	Mxx_sp_s[2396332]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[1]*Hs[56] + Hs[0]*Hs[57]))/pow(zbar,rrho);
	Mxx_sp_s[2410156]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[2]*Hs[56] + Hs[0]*Hs[58]));
	Mxx_sp_s[2411692]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[2]*Hs[56] + Hs[0]*Hs[58]);
	Mxx_sp_s[2414764]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[2]*Hs[56] + Hs[0]*Hs[58]));
	Mxx_sp_s[2420908]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[2]*Hs[56] + Hs[0]*Hs[58]))/pow(zbar,rrho);
	Mxx_sp_s[2434732]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[3]*Hs[56] + Hs[0]*Hs[59]));
	Mxx_sp_s[2436268]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[3]*Hs[56] + Hs[0]*Hs[59]);
	Mxx_sp_s[2439340]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[3]*Hs[56] + Hs[0]*Hs[59]));
	Mxx_sp_s[2445484]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[3]*Hs[56] + Hs[0]*Hs[59]))/pow(zbar,rrho);
	Mxx_sp_s[2459308]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[4]*Hs[56] + Hs[0]*Hs[60]));
	Mxx_sp_s[2460844]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[4]*Hs[56] + Hs[0]*Hs[60]);
	Mxx_sp_s[2463916]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[4]*Hs[56] + Hs[0]*Hs[60]));
	Mxx_sp_s[2470060]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[4]*Hs[56] + Hs[0]*Hs[60]))/pow(zbar,rrho);
	Mxx_sp_s[2483884]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[5]*Hs[56] + Hs[0]*Hs[61]));
	Mxx_sp_s[2485420]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[5]*Hs[56] + Hs[0]*Hs[61]);
	Mxx_sp_s[2488492]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[5]*Hs[56] + Hs[0]*Hs[61]));
	Mxx_sp_s[2494636]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[5]*Hs[56] + Hs[0]*Hs[61]))/pow(zbar,rrho);
	Mxx_sp_s[2508460]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[56] + Hs[0]*Hs[62]));
	Mxx_sp_s[2509996]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[56] + Hs[0]*Hs[62]);
	Mxx_sp_s[2513068]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[6]*Hs[56] + Hs[0]*Hs[62]));
	Mxx_sp_s[2519212]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[6]*Hs[56] + Hs[0]*Hs[62]))/pow(zbar,rrho);
	Mxx_sp_s[2533036]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[56] + Hs[0]*Hs[63]));
	Mxx_sp_s[2534572]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[56] + Hs[0]*Hs[63]);
	Mxx_sp_s[2537644]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[7]*Hs[56] + Hs[0]*Hs[63]));
	Mxx_sp_s[2543788]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[7]*Hs[56] + Hs[0]*Hs[63]))/pow(zbar,rrho);
	Mxx_sp_s[2582188]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[1]*Hs[57]);
	Mxx_sp_s[2583724]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[1]*Hs[57];
	Mxx_sp_s[2586796]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[1]*Hs[57]);
	Mxx_sp_s[2592940]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[1]*Hs[57])/pow(zbar,rrho);
	Mxx_sp_s[2606764]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[2]*Hs[57] + Hs[1]*Hs[58]));
	Mxx_sp_s[2608300]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[2]*Hs[57] + Hs[1]*Hs[58]);
	Mxx_sp_s[2611372]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[2]*Hs[57] + Hs[1]*Hs[58]));
	Mxx_sp_s[2617516]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[2]*Hs[57] + Hs[1]*Hs[58]))/pow(zbar,rrho);
	Mxx_sp_s[2631340]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[3]*Hs[57] + Hs[1]*Hs[59]));
	Mxx_sp_s[2632876]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[3]*Hs[57] + Hs[1]*Hs[59]);
	Mxx_sp_s[2635948]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[3]*Hs[57] + Hs[1]*Hs[59]));
	Mxx_sp_s[2642092]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[3]*Hs[57] + Hs[1]*Hs[59]))/pow(zbar,rrho);
	Mxx_sp_s[2655916]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[4]*Hs[57] + Hs[1]*Hs[60]));
	Mxx_sp_s[2657452]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[4]*Hs[57] + Hs[1]*Hs[60]);
	Mxx_sp_s[2660524]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[4]*Hs[57] + Hs[1]*Hs[60]));
	Mxx_sp_s[2666668]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[4]*Hs[57] + Hs[1]*Hs[60]))/pow(zbar,rrho);
	Mxx_sp_s[2680492]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[5]*Hs[57] + Hs[1]*Hs[61]));
	Mxx_sp_s[2682028]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[5]*Hs[57] + Hs[1]*Hs[61]);
	Mxx_sp_s[2685100]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[5]*Hs[57] + Hs[1]*Hs[61]));
	Mxx_sp_s[2691244]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[5]*Hs[57] + Hs[1]*Hs[61]))/pow(zbar,rrho);
	Mxx_sp_s[2705068]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[57] + Hs[1]*Hs[62]));
	Mxx_sp_s[2706604]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[57] + Hs[1]*Hs[62]);
	Mxx_sp_s[2709676]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[6]*Hs[57] + Hs[1]*Hs[62]));
	Mxx_sp_s[2715820]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[6]*Hs[57] + Hs[1]*Hs[62]))/pow(zbar,rrho);
	Mxx_sp_s[2729644]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[57] + Hs[1]*Hs[63]));
	Mxx_sp_s[2731180]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[57] + Hs[1]*Hs[63]);
	Mxx_sp_s[2734252]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[7]*Hs[57] + Hs[1]*Hs[63]));
	Mxx_sp_s[2740396]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[7]*Hs[57] + Hs[1]*Hs[63]))/pow(zbar,rrho);
	Mxx_sp_s[2803372]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[2]*Hs[58]);
	Mxx_sp_s[2804908]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[2]*Hs[58];
	Mxx_sp_s[2807980]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[2]*Hs[58]);
	Mxx_sp_s[2814124]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[2]*Hs[58])/pow(zbar,rrho);
	Mxx_sp_s[2827948]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[3]*Hs[58] + Hs[2]*Hs[59]));
	Mxx_sp_s[2829484]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[3]*Hs[58] + Hs[2]*Hs[59]);
	Mxx_sp_s[2832556]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[3]*Hs[58] + Hs[2]*Hs[59]));
	Mxx_sp_s[2838700]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[3]*Hs[58] + Hs[2]*Hs[59]))/pow(zbar,rrho);
	Mxx_sp_s[2852524]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[4]*Hs[58] + Hs[2]*Hs[60]));
	Mxx_sp_s[2854060]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[4]*Hs[58] + Hs[2]*Hs[60]);
	Mxx_sp_s[2857132]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[4]*Hs[58] + Hs[2]*Hs[60]));
	Mxx_sp_s[2863276]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[4]*Hs[58] + Hs[2]*Hs[60]))/pow(zbar,rrho);
	Mxx_sp_s[2877100]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[5]*Hs[58] + Hs[2]*Hs[61]));
	Mxx_sp_s[2878636]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[5]*Hs[58] + Hs[2]*Hs[61]);
	Mxx_sp_s[2881708]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[5]*Hs[58] + Hs[2]*Hs[61]));
	Mxx_sp_s[2887852]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[5]*Hs[58] + Hs[2]*Hs[61]))/pow(zbar,rrho);
	Mxx_sp_s[2901676]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[58] + Hs[2]*Hs[62]));
	Mxx_sp_s[2903212]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[58] + Hs[2]*Hs[62]);
	Mxx_sp_s[2906284]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[6]*Hs[58] + Hs[2]*Hs[62]));
	Mxx_sp_s[2912428]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[6]*Hs[58] + Hs[2]*Hs[62]))/pow(zbar,rrho);
	Mxx_sp_s[2926252]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[58] + Hs[2]*Hs[63]));
	Mxx_sp_s[2927788]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[58] + Hs[2]*Hs[63]);
	Mxx_sp_s[2930860]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[7]*Hs[58] + Hs[2]*Hs[63]));
	Mxx_sp_s[2937004]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[7]*Hs[58] + Hs[2]*Hs[63]))/pow(zbar,rrho);
	Mxx_sp_s[3024556]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[3]*Hs[59]);
	Mxx_sp_s[3026092]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[3]*Hs[59];
	Mxx_sp_s[3029164]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[3]*Hs[59]);
	Mxx_sp_s[3035308]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[3]*Hs[59])/pow(zbar,rrho);
	Mxx_sp_s[3049132]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[4]*Hs[59] + Hs[3]*Hs[60]));
	Mxx_sp_s[3050668]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[4]*Hs[59] + Hs[3]*Hs[60]);
	Mxx_sp_s[3053740]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[4]*Hs[59] + Hs[3]*Hs[60]));
	Mxx_sp_s[3059884]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[4]*Hs[59] + Hs[3]*Hs[60]))/pow(zbar,rrho);
	Mxx_sp_s[3073708]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[5]*Hs[59] + Hs[3]*Hs[61]));
	Mxx_sp_s[3075244]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[5]*Hs[59] + Hs[3]*Hs[61]);
	Mxx_sp_s[3078316]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[5]*Hs[59] + Hs[3]*Hs[61]));
	Mxx_sp_s[3084460]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[5]*Hs[59] + Hs[3]*Hs[61]))/pow(zbar,rrho);
	Mxx_sp_s[3098284]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[59] + Hs[3]*Hs[62]));
	Mxx_sp_s[3099820]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[59] + Hs[3]*Hs[62]);
	Mxx_sp_s[3102892]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[6]*Hs[59] + Hs[3]*Hs[62]));
	Mxx_sp_s[3109036]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[6]*Hs[59] + Hs[3]*Hs[62]))/pow(zbar,rrho);
	Mxx_sp_s[3122860]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[59] + Hs[3]*Hs[63]));
	Mxx_sp_s[3124396]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[59] + Hs[3]*Hs[63]);
	Mxx_sp_s[3127468]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[7]*Hs[59] + Hs[3]*Hs[63]));
	Mxx_sp_s[3133612]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[7]*Hs[59] + Hs[3]*Hs[63]))/pow(zbar,rrho);
	Mxx_sp_s[3245740]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[4]*Hs[60]);
	Mxx_sp_s[3247276]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[4]*Hs[60];
	Mxx_sp_s[3250348]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[4]*Hs[60]);
	Mxx_sp_s[3256492]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[4]*Hs[60])/pow(zbar,rrho);
	Mxx_sp_s[3270316]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[5]*Hs[60] + Hs[4]*Hs[61]));
	Mxx_sp_s[3271852]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[5]*Hs[60] + Hs[4]*Hs[61]);
	Mxx_sp_s[3274924]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[5]*Hs[60] + Hs[4]*Hs[61]));
	Mxx_sp_s[3281068]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[5]*Hs[60] + Hs[4]*Hs[61]))/pow(zbar,rrho);
	Mxx_sp_s[3294892]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[60] + Hs[4]*Hs[62]));
	Mxx_sp_s[3296428]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[60] + Hs[4]*Hs[62]);
	Mxx_sp_s[3299500]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[6]*Hs[60] + Hs[4]*Hs[62]));
	Mxx_sp_s[3305644]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[6]*Hs[60] + Hs[4]*Hs[62]))/pow(zbar,rrho);
	Mxx_sp_s[3319468]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[60] + Hs[4]*Hs[63]));
	Mxx_sp_s[3321004]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[60] + Hs[4]*Hs[63]);
	Mxx_sp_s[3324076]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[7]*Hs[60] + Hs[4]*Hs[63]));
	Mxx_sp_s[3330220]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[7]*Hs[60] + Hs[4]*Hs[63]))/pow(zbar,rrho);
	Mxx_sp_s[3466924]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[5]*Hs[61]);
	Mxx_sp_s[3468460]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[5]*Hs[61];
	Mxx_sp_s[3471532]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[5]*Hs[61]);
	Mxx_sp_s[3477676]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[5]*Hs[61])/pow(zbar,rrho);
	Mxx_sp_s[3491500]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[61] + Hs[5]*Hs[62]));
	Mxx_sp_s[3493036]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[6]*Hs[61] + Hs[5]*Hs[62]);
	Mxx_sp_s[3496108]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[6]*Hs[61] + Hs[5]*Hs[62]));
	Mxx_sp_s[3502252]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[6]*Hs[61] + Hs[5]*Hs[62]))/pow(zbar,rrho);
	Mxx_sp_s[3516076]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[61] + Hs[5]*Hs[63]));
	Mxx_sp_s[3517612]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[61] + Hs[5]*Hs[63]);
	Mxx_sp_s[3520684]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[7]*Hs[61] + Hs[5]*Hs[63]));
	Mxx_sp_s[3526828]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[7]*Hs[61] + Hs[5]*Hs[63]))/pow(zbar,rrho);
	Mxx_sp_s[3688108]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[6]*Hs[62]);
	Mxx_sp_s[3689644]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[6]*Hs[62];
	Mxx_sp_s[3692716]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[6]*Hs[62]);
	Mxx_sp_s[3698860]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[6]*Hs[62])/pow(zbar,rrho);
	Mxx_sp_s[3712684]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[62] + Hs[6]*Hs[63]));
	Mxx_sp_s[3714220]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[7]*Hs[62] + Hs[6]*Hs[63]);
	Mxx_sp_s[3717292]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[7]*Hs[62] + Hs[6]*Hs[63]));
	Mxx_sp_s[3723436]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[7]*Hs[62] + Hs[6]*Hs[63]))/pow(zbar,rrho);
	Mxx_sp_s[3909292]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[7]*Hs[63]);
	Mxx_sp_s[3910828]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[7]*Hs[63];
	Mxx_sp_s[3913900]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[7]*Hs[63]);
	Mxx_sp_s[3920044]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[7]*Hs[63])/pow(zbar,rrho);
	Mxx_sp_s[86189]=iiota*Pssp*zbar;
	Mxx_sp_s[90797]=iiota*Pssp*zbar;
	Mxx_sp_s[967853]=-Pssp;
	Mxx_sp_s[960174]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mxx_sp_s[969390]=-(pow(E,yss[7])*Pssp);
	Mxx_sp_s[972462]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxx_sp_s[973998]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxx_sp_s[87727]=-((Pssp*zbar)/(1 + yss[5]));
	Mxx_sp_s[89263]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[90799]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mxx_sp_s[92335]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mxx_sp_s[95407]=-(pow(E,yss[11])*ebar*Pssp);
	Mxx_sp_s[958639]=-(pow(E,yss[0])*Pssp);
	Mxx_sp_s[960175]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mxx_sp_s[961711]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mxx_sp_s[963247]=-(pow(E,yss[3])*Pssp);
	Mxx_sp_s[966319]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mxx_sp_s[969391]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mxx_sp_s[972463]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxx_sp_s[973999]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxx_sp_s[86192]=-(pow(E,xss[0])*Pssp*zbar);
	Mxx_sp_s[90800]=-(pow(E,xss[0])*Pssp*zbar);
	Mxx_sp_s[963248]=pow(E,yss[3])*Pssp;
	Mxx_sp_s[972464]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxx_sp_s[974000]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxx_sp_s[86193]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxx_sp_s[87729]=(Pssp*zbar)/(1 + yss[5]);
	Mxx_sp_s[90801]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mxx_sp_s[92337]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxx_sp_s[960177]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxx_sp_s[961713]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxx_sp_s[966321]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mxx_sp_s[967857]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxx_sp_s[969393]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxx_sp_s[972465]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxx_sp_s[974001]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxx_sp_s[972466]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxx_sp_s[974002]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxx_sp_s[87731]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mxx_sp_s[93875]=Pssp;
	Mxx_sp_s[966323]=-Pssp;
	Mxx_sp_s[972467]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxx_sp_s[974003]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxx_sp_s[86196]=pow(E,xss[0])*Pssp;
	Mxx_sp_s[964788]=-(pow(E,xss[0])*Pssp);
	Mxx_sp_s[89269]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[90805]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[92341]=pow(E,yss[2])*pbar*Pssp;
	Mxx_sp_s[960181]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[961717]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mxx_sp_s[972469]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxx_sp_s[974005]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxx_sp_s[975541]=pow(E,yss[11])*Pssp;
	Mxx_sp_s[87734]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxx_sp_s[90806]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxx_sp_s[972470]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxx_sp_s[974006]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxx_sp_s[975542]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mxx_sp_s[977078]=Pssp;
	Mxx_sp_s[87735]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxx_sp_s[90807]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxx_sp_s[972471]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxx_sp_s[974007]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxx_sp_s[975543]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mxx_sp_s[978615]=Pssp;
	Mxx_sp_s[95416]=ebar*Pssp;
	Mxx_sp_s[958648]=pow(E,yss[0] - yss[11])*Pssp;
	Mxx_sp_s[963256]=pow(E,yss[3] - yss[11])*Pssp;
	Mxx_sp_s[972472]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxx_sp_s[974008]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxx_sp_s[975544]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mxx_sp_s[980152]=Pssp;
	Mxx_sp_s[86201]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[87737]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[89273]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[90809]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mxx_sp_s[92345]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[93881]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[95417]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[96953]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[972473]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[974009]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[981689]=Pssp;
	Mxx_sp_s[2371769]=(Pssp*pow(zbar,rrho)*Hs[0]*Hs[56]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2396345]=(Pssp*pow(zbar,rrho)*(Hs[1]*Hs[56] + Hs[0]*Hs[57])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2420921]=(Pssp*pow(zbar,rrho)*(Hs[2]*Hs[56] + Hs[0]*Hs[58])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2445497]=(Pssp*pow(zbar,rrho)*(Hs[3]*Hs[56] + Hs[0]*Hs[59])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2470073]=(Pssp*pow(zbar,rrho)*(Hs[4]*Hs[56] + Hs[0]*Hs[60])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2494649]=(Pssp*pow(zbar,rrho)*(Hs[5]*Hs[56] + Hs[0]*Hs[61])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2519225]=(Pssp*pow(zbar,rrho)*(Hs[6]*Hs[56] + Hs[0]*Hs[62])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2543801]=(Pssp*pow(zbar,rrho)*(Hs[7]*Hs[56] + Hs[0]*Hs[63])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2592953]=(Pssp*pow(zbar,rrho)*Hs[1]*Hs[57]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2617529]=(Pssp*pow(zbar,rrho)*(Hs[2]*Hs[57] + Hs[1]*Hs[58])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2642105]=(Pssp*pow(zbar,rrho)*(Hs[3]*Hs[57] + Hs[1]*Hs[59])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2666681]=(Pssp*pow(zbar,rrho)*(Hs[4]*Hs[57] + Hs[1]*Hs[60])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2691257]=(Pssp*pow(zbar,rrho)*(Hs[5]*Hs[57] + Hs[1]*Hs[61])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2715833]=(Pssp*pow(zbar,rrho)*(Hs[6]*Hs[57] + Hs[1]*Hs[62])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2740409]=(Pssp*pow(zbar,rrho)*(Hs[7]*Hs[57] + Hs[1]*Hs[63])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2814137]=(Pssp*pow(zbar,rrho)*Hs[2]*Hs[58]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2838713]=(Pssp*pow(zbar,rrho)*(Hs[3]*Hs[58] + Hs[2]*Hs[59])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2863289]=(Pssp*pow(zbar,rrho)*(Hs[4]*Hs[58] + Hs[2]*Hs[60])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2887865]=(Pssp*pow(zbar,rrho)*(Hs[5]*Hs[58] + Hs[2]*Hs[61])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2912441]=(Pssp*pow(zbar,rrho)*(Hs[6]*Hs[58] + Hs[2]*Hs[62])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2937017]=(Pssp*pow(zbar,rrho)*(Hs[7]*Hs[58] + Hs[2]*Hs[63])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3035321]=(Pssp*pow(zbar,rrho)*Hs[3]*Hs[59]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3059897]=(Pssp*pow(zbar,rrho)*(Hs[4]*Hs[59] + Hs[3]*Hs[60])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3084473]=(Pssp*pow(zbar,rrho)*(Hs[5]*Hs[59] + Hs[3]*Hs[61])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3109049]=(Pssp*pow(zbar,rrho)*(Hs[6]*Hs[59] + Hs[3]*Hs[62])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3133625]=(Pssp*pow(zbar,rrho)*(Hs[7]*Hs[59] + Hs[3]*Hs[63])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3256505]=(Pssp*pow(zbar,rrho)*Hs[4]*Hs[60]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3281081]=(Pssp*pow(zbar,rrho)*(Hs[5]*Hs[60] + Hs[4]*Hs[61])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3305657]=(Pssp*pow(zbar,rrho)*(Hs[6]*Hs[60] + Hs[4]*Hs[62])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3330233]=(Pssp*pow(zbar,rrho)*(Hs[7]*Hs[60] + Hs[4]*Hs[63])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3477689]=(Pssp*pow(zbar,rrho)*Hs[5]*Hs[61]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3502265]=(Pssp*pow(zbar,rrho)*(Hs[6]*Hs[61] + Hs[5]*Hs[62])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3526841]=(Pssp*pow(zbar,rrho)*(Hs[7]*Hs[61] + Hs[5]*Hs[63])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3698873]=(Pssp*pow(zbar,rrho)*Hs[6]*Hs[62]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3723449]=(Pssp*pow(zbar,rrho)*(Hs[7]*Hs[62] + Hs[6]*Hs[63])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3920057]=(Pssp*pow(zbar,rrho)*Hs[7]*Hs[63]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[89274]=-Pssp;
	Mxx_sp_s[90811]=-Pssp;
	Mxx_sp_s[92348]=-Pssp;
	Mxx_sp_s[96957]=-Pssp;
	Mxx_sp_s[95422]=-Pssp;
	Mxx_sp_s[93887]=-Pssp;
	Mxx_sp_s[12480]=1;
	Mxx_sp_s[98496]=-1;
	Mxx_sp_s[14017]=1;
	Mxx_sp_s[100033]=-1;
	Mxx_sp_s[15554]=1;
	Mxx_sp_s[101570]=-1;
	Mxx_sp_s[17091]=1;
	Mxx_sp_s[103107]=-1;
	Mxx_sp_s[18628]=1;
	Mxx_sp_s[104644]=-1;
	Mxx_sp_s[20165]=1;
	Mxx_sp_s[106181]=-1;
	Mxx_sp_s[21702]=1;
	Mxx_sp_s[107718]=-1;
	Mxx_sp_s[23239]=1;
	Mxx_sp_s[109255]=-1;
	Mxx_sp_s[811208]=1;
	Mxx_sp_s[983240]=-1;
	Mxx_sp_s[812745]=1;
	Mxx_sp_s[984777]=-1;
	Mxx_sp_s[814282]=1;
	Mxx_sp_s[986314]=-1;
	Mxx_sp_s[815819]=1;
	Mxx_sp_s[987851]=-1;
	Mxx_sp_s[817356]=1;
	Mxx_sp_s[989388]=-1;
	Mxx_sp_s[818893]=1;
	Mxx_sp_s[990925]=-1;
	Mxx_sp_s[820430]=1;
	Mxx_sp_s[992462]=-1;
	Mxx_sp_s[821967]=1;
	Mxx_sp_s[993999]=-1;
	Mxx_sp_s[823504]=1;
	Mxx_sp_s[995536]=-1;
	Mxx_sp_s[825041]=1;
	Mxx_sp_s[997073]=-1;
	Mxx_sp_s[826578]=1;
	Mxx_sp_s[998610]=-1;
	Mxx_sp_s[828115]=1;
	Mxx_sp_s[1000147]=-1;
	Mxx_sp_s[829652]=1;
	Mxx_sp_s[1001684]=-1;
	Mxx_sp_s[831189]=1;
	Mxx_sp_s[1003221]=-1;
	Mxx_sp_s[832726]=1;
	Mxx_sp_s[1004758]=-1;
	Mxx_sp_s[834263]=1;
	Mxx_sp_s[1006295]=-1;
	Mxx_sp_s[121560]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mxx_sp_s[1007832]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mxx_sp_s[1009368]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mxx_sp_s[1020120]=-(pow(E,yss[8])*Pssp);
	Mxx_sp_s[1021656]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxx_sp_s[1023192]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxx_sp_s[113881]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[115417]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[116953]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[1009369]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[1010905]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[1015513]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mxx_sp_s[1020121]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mxx_sp_s[1021657]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[1023193]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[113882]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[115418]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[1009370]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[1010906]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[1015514]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mxx_sp_s[1018586]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[1020122]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mxx_sp_s[1021658]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[1023194]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[110811]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[112347]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[113883]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[115419]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mxx_sp_s[116955]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[118491]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[120027]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[121563]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[1015515]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mxx_sp_s[1020123]=-(pow(E,yss[8])*Pssp);
	Mxx_sp_s[1021659]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mxx_sp_s[1023195]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mxx_sp_s[2371803]=(bbeta*pow(E,yss[8])*Pssp*pow(Hs[8],2)*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2396379]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[8]*Hs[9]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2420955]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[8]*Hs[10]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2445531]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[8]*Hs[11]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2470107]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[8]*Hs[12]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2494683]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[8]*Hs[13]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2519259]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[8]*Hs[14]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2543835]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[8]*Hs[15]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2592987]=(bbeta*pow(E,yss[8])*Pssp*pow(Hs[9],2)*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2617563]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[9]*Hs[10]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2642139]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[9]*Hs[11]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2666715]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[9]*Hs[12]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2691291]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[9]*Hs[13]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2715867]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[9]*Hs[14]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2740443]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[9]*Hs[15]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2814171]=(bbeta*pow(E,yss[8])*Pssp*pow(Hs[10],2)*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2838747]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[10]*Hs[11]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2863323]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[10]*Hs[12]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2887899]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[10]*Hs[13]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2912475]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[10]*Hs[14]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2937051]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[10]*Hs[15]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3035355]=(bbeta*pow(E,yss[8])*Pssp*pow(Hs[11],2)*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3059931]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[11]*Hs[12]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3084507]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[11]*Hs[13]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3109083]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[11]*Hs[14]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3133659]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[11]*Hs[15]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3256539]=(bbeta*pow(E,yss[8])*Pssp*pow(Hs[12],2)*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3281115]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[12]*Hs[13]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3305691]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[12]*Hs[14]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3330267]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[12]*Hs[15]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3477723]=(bbeta*pow(E,yss[8])*Pssp*pow(Hs[13],2)*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3502299]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[13]*Hs[14]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3526875]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[13]*Hs[15]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3698907]=(bbeta*pow(E,yss[8])*Pssp*pow(Hs[14],2)*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3723483]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[14]*Hs[15]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3920091]=(bbeta*pow(E,yss[8])*Pssp*pow(Hs[15],2)*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[110812]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mxx_sp_s[112348]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mxx_sp_s[113884]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mxx_sp_s[115420]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mxx_sp_s[116956]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mxx_sp_s[118492]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mxx_sp_s[120028]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mxx_sp_s[121564]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mxx_sp_s[1017052]=-(kkappa*Pssp*yss[9]);
	Mxx_sp_s[1020124]=pow(E,yss[8])*Pssp;
	Mxx_sp_s[1021660]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mxx_sp_s[1023196]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mxx_sp_s[2361052]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*pow(Hs[8],2));
	Mxx_sp_s[2362588]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*pow(Hs[8],2);
	Mxx_sp_s[2365660]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*pow(Hs[8],2));
	Mxx_sp_s[2371804]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*pow(Hs[8],2))/pow(zbar,rrho);
	Mxx_sp_s[2385628]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[8]*Hs[9];
	Mxx_sp_s[2387164]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[8]*Hs[9];
	Mxx_sp_s[2390236]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[8]*Hs[9];
	Mxx_sp_s[2396380]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[8]*Hs[9])/pow(zbar,rrho);
	Mxx_sp_s[2410204]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[8]*Hs[10];
	Mxx_sp_s[2411740]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[8]*Hs[10];
	Mxx_sp_s[2414812]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[8]*Hs[10];
	Mxx_sp_s[2420956]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[8]*Hs[10])/pow(zbar,rrho);
	Mxx_sp_s[2434780]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[8]*Hs[11];
	Mxx_sp_s[2436316]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[8]*Hs[11];
	Mxx_sp_s[2439388]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[8]*Hs[11];
	Mxx_sp_s[2445532]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[8]*Hs[11])/pow(zbar,rrho);
	Mxx_sp_s[2459356]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[8]*Hs[12];
	Mxx_sp_s[2460892]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[8]*Hs[12];
	Mxx_sp_s[2463964]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[8]*Hs[12];
	Mxx_sp_s[2470108]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[8]*Hs[12])/pow(zbar,rrho);
	Mxx_sp_s[2483932]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[8]*Hs[13];
	Mxx_sp_s[2485468]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[8]*Hs[13];
	Mxx_sp_s[2488540]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[8]*Hs[13];
	Mxx_sp_s[2494684]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[8]*Hs[13])/pow(zbar,rrho);
	Mxx_sp_s[2508508]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[8]*Hs[14];
	Mxx_sp_s[2510044]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[8]*Hs[14];
	Mxx_sp_s[2513116]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[8]*Hs[14];
	Mxx_sp_s[2519260]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[8]*Hs[14])/pow(zbar,rrho);
	Mxx_sp_s[2533084]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[8]*Hs[15];
	Mxx_sp_s[2534620]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[8]*Hs[15];
	Mxx_sp_s[2537692]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[8]*Hs[15];
	Mxx_sp_s[2543836]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[8]*Hs[15])/pow(zbar,rrho);
	Mxx_sp_s[2582236]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*pow(Hs[9],2));
	Mxx_sp_s[2583772]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*pow(Hs[9],2);
	Mxx_sp_s[2586844]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*pow(Hs[9],2));
	Mxx_sp_s[2592988]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*pow(Hs[9],2))/pow(zbar,rrho);
	Mxx_sp_s[2606812]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[9]*Hs[10];
	Mxx_sp_s[2608348]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[9]*Hs[10];
	Mxx_sp_s[2611420]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[9]*Hs[10];
	Mxx_sp_s[2617564]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[9]*Hs[10])/pow(zbar,rrho);
	Mxx_sp_s[2631388]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[9]*Hs[11];
	Mxx_sp_s[2632924]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[9]*Hs[11];
	Mxx_sp_s[2635996]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[9]*Hs[11];
	Mxx_sp_s[2642140]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[9]*Hs[11])/pow(zbar,rrho);
	Mxx_sp_s[2655964]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[9]*Hs[12];
	Mxx_sp_s[2657500]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[9]*Hs[12];
	Mxx_sp_s[2660572]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[9]*Hs[12];
	Mxx_sp_s[2666716]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[9]*Hs[12])/pow(zbar,rrho);
	Mxx_sp_s[2680540]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[9]*Hs[13];
	Mxx_sp_s[2682076]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[9]*Hs[13];
	Mxx_sp_s[2685148]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[9]*Hs[13];
	Mxx_sp_s[2691292]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[9]*Hs[13])/pow(zbar,rrho);
	Mxx_sp_s[2705116]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[9]*Hs[14];
	Mxx_sp_s[2706652]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[9]*Hs[14];
	Mxx_sp_s[2709724]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[9]*Hs[14];
	Mxx_sp_s[2715868]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[9]*Hs[14])/pow(zbar,rrho);
	Mxx_sp_s[2729692]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[9]*Hs[15];
	Mxx_sp_s[2731228]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[9]*Hs[15];
	Mxx_sp_s[2734300]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[9]*Hs[15];
	Mxx_sp_s[2740444]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[9]*Hs[15])/pow(zbar,rrho);
	Mxx_sp_s[2803420]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*pow(Hs[10],2));
	Mxx_sp_s[2804956]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*pow(Hs[10],2);
	Mxx_sp_s[2808028]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*pow(Hs[10],2));
	Mxx_sp_s[2814172]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*pow(Hs[10],2))/pow(zbar,rrho);
	Mxx_sp_s[2827996]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[10]*Hs[11];
	Mxx_sp_s[2829532]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[10]*Hs[11];
	Mxx_sp_s[2832604]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[10]*Hs[11];
	Mxx_sp_s[2838748]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[10]*Hs[11])/pow(zbar,rrho);
	Mxx_sp_s[2852572]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[10]*Hs[12];
	Mxx_sp_s[2854108]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[10]*Hs[12];
	Mxx_sp_s[2857180]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[10]*Hs[12];
	Mxx_sp_s[2863324]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[10]*Hs[12])/pow(zbar,rrho);
	Mxx_sp_s[2877148]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[10]*Hs[13];
	Mxx_sp_s[2878684]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[10]*Hs[13];
	Mxx_sp_s[2881756]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[10]*Hs[13];
	Mxx_sp_s[2887900]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[10]*Hs[13])/pow(zbar,rrho);
	Mxx_sp_s[2901724]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[10]*Hs[14];
	Mxx_sp_s[2903260]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[10]*Hs[14];
	Mxx_sp_s[2906332]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[10]*Hs[14];
	Mxx_sp_s[2912476]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[10]*Hs[14])/pow(zbar,rrho);
	Mxx_sp_s[2926300]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[10]*Hs[15];
	Mxx_sp_s[2927836]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[10]*Hs[15];
	Mxx_sp_s[2930908]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[10]*Hs[15];
	Mxx_sp_s[2937052]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[10]*Hs[15])/pow(zbar,rrho);
	Mxx_sp_s[3024604]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*pow(Hs[11],2));
	Mxx_sp_s[3026140]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*pow(Hs[11],2);
	Mxx_sp_s[3029212]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*pow(Hs[11],2));
	Mxx_sp_s[3035356]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*pow(Hs[11],2))/pow(zbar,rrho);
	Mxx_sp_s[3049180]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[11]*Hs[12];
	Mxx_sp_s[3050716]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[11]*Hs[12];
	Mxx_sp_s[3053788]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[11]*Hs[12];
	Mxx_sp_s[3059932]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[11]*Hs[12])/pow(zbar,rrho);
	Mxx_sp_s[3073756]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[11]*Hs[13];
	Mxx_sp_s[3075292]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[11]*Hs[13];
	Mxx_sp_s[3078364]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[11]*Hs[13];
	Mxx_sp_s[3084508]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[11]*Hs[13])/pow(zbar,rrho);
	Mxx_sp_s[3098332]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[11]*Hs[14];
	Mxx_sp_s[3099868]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[11]*Hs[14];
	Mxx_sp_s[3102940]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[11]*Hs[14];
	Mxx_sp_s[3109084]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[11]*Hs[14])/pow(zbar,rrho);
	Mxx_sp_s[3122908]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[11]*Hs[15];
	Mxx_sp_s[3124444]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[11]*Hs[15];
	Mxx_sp_s[3127516]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[11]*Hs[15];
	Mxx_sp_s[3133660]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[11]*Hs[15])/pow(zbar,rrho);
	Mxx_sp_s[3245788]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*pow(Hs[12],2));
	Mxx_sp_s[3247324]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*pow(Hs[12],2);
	Mxx_sp_s[3250396]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*pow(Hs[12],2));
	Mxx_sp_s[3256540]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*pow(Hs[12],2))/pow(zbar,rrho);
	Mxx_sp_s[3270364]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[12]*Hs[13];
	Mxx_sp_s[3271900]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[12]*Hs[13];
	Mxx_sp_s[3274972]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[12]*Hs[13];
	Mxx_sp_s[3281116]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[12]*Hs[13])/pow(zbar,rrho);
	Mxx_sp_s[3294940]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[12]*Hs[14];
	Mxx_sp_s[3296476]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[12]*Hs[14];
	Mxx_sp_s[3299548]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[12]*Hs[14];
	Mxx_sp_s[3305692]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[12]*Hs[14])/pow(zbar,rrho);
	Mxx_sp_s[3319516]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[12]*Hs[15];
	Mxx_sp_s[3321052]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[12]*Hs[15];
	Mxx_sp_s[3324124]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[12]*Hs[15];
	Mxx_sp_s[3330268]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[12]*Hs[15])/pow(zbar,rrho);
	Mxx_sp_s[3466972]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*pow(Hs[13],2));
	Mxx_sp_s[3468508]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*pow(Hs[13],2);
	Mxx_sp_s[3471580]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*pow(Hs[13],2));
	Mxx_sp_s[3477724]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*pow(Hs[13],2))/pow(zbar,rrho);
	Mxx_sp_s[3491548]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[13]*Hs[14];
	Mxx_sp_s[3493084]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[13]*Hs[14];
	Mxx_sp_s[3496156]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[13]*Hs[14];
	Mxx_sp_s[3502300]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[13]*Hs[14])/pow(zbar,rrho);
	Mxx_sp_s[3516124]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[13]*Hs[15];
	Mxx_sp_s[3517660]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[13]*Hs[15];
	Mxx_sp_s[3520732]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[13]*Hs[15];
	Mxx_sp_s[3526876]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[13]*Hs[15])/pow(zbar,rrho);
	Mxx_sp_s[3688156]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*pow(Hs[14],2));
	Mxx_sp_s[3689692]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*pow(Hs[14],2);
	Mxx_sp_s[3692764]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*pow(Hs[14],2));
	Mxx_sp_s[3698908]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*pow(Hs[14],2))/pow(zbar,rrho);
	Mxx_sp_s[3712732]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[14]*Hs[15];
	Mxx_sp_s[3714268]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[14]*Hs[15];
	Mxx_sp_s[3717340]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[14]*Hs[15];
	Mxx_sp_s[3723484]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[14]*Hs[15])/pow(zbar,rrho);
	Mxx_sp_s[3909340]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*pow(Hs[15],2));
	Mxx_sp_s[3910876]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*pow(Hs[15],2);
	Mxx_sp_s[3913948]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*pow(Hs[15],2));
	Mxx_sp_s[3920092]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*pow(Hs[15],2))/pow(zbar,rrho);
	Mxx_sp_s[110813]=iiota*Pssp*zbar;
	Mxx_sp_s[115421]=iiota*Pssp*zbar;
	Mxx_sp_s[1017053]=-Pssp;
	Mxx_sp_s[1009374]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mxx_sp_s[1018590]=-(pow(E,yss[7])*Pssp);
	Mxx_sp_s[1021662]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxx_sp_s[1023198]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxx_sp_s[112351]=-((Pssp*zbar)/(1 + yss[5]));
	Mxx_sp_s[113887]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[115423]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mxx_sp_s[116959]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mxx_sp_s[120031]=-(pow(E,yss[11])*ebar*Pssp);
	Mxx_sp_s[1007839]=-(pow(E,yss[0])*Pssp);
	Mxx_sp_s[1009375]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mxx_sp_s[1010911]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mxx_sp_s[1012447]=-(pow(E,yss[3])*Pssp);
	Mxx_sp_s[1015519]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mxx_sp_s[1018591]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mxx_sp_s[1021663]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxx_sp_s[1023199]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxx_sp_s[110816]=-(pow(E,xss[0])*Pssp*zbar);
	Mxx_sp_s[115424]=-(pow(E,xss[0])*Pssp*zbar);
	Mxx_sp_s[1012448]=pow(E,yss[3])*Pssp;
	Mxx_sp_s[1021664]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxx_sp_s[1023200]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxx_sp_s[110817]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxx_sp_s[112353]=(Pssp*zbar)/(1 + yss[5]);
	Mxx_sp_s[115425]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mxx_sp_s[116961]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxx_sp_s[1009377]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxx_sp_s[1010913]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxx_sp_s[1015521]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mxx_sp_s[1017057]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxx_sp_s[1018593]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxx_sp_s[1021665]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxx_sp_s[1023201]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxx_sp_s[1021666]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxx_sp_s[1023202]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxx_sp_s[112355]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mxx_sp_s[118499]=Pssp;
	Mxx_sp_s[1015523]=-Pssp;
	Mxx_sp_s[1021667]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxx_sp_s[1023203]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxx_sp_s[110820]=pow(E,xss[0])*Pssp;
	Mxx_sp_s[1013988]=-(pow(E,xss[0])*Pssp);
	Mxx_sp_s[113893]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[115429]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[116965]=pow(E,yss[2])*pbar*Pssp;
	Mxx_sp_s[1009381]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[1010917]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mxx_sp_s[1021669]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxx_sp_s[1023205]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxx_sp_s[1024741]=pow(E,yss[11])*Pssp;
	Mxx_sp_s[112358]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxx_sp_s[115430]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxx_sp_s[1021670]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxx_sp_s[1023206]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxx_sp_s[1024742]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mxx_sp_s[1026278]=Pssp;
	Mxx_sp_s[112359]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxx_sp_s[115431]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxx_sp_s[1021671]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxx_sp_s[1023207]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxx_sp_s[1024743]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mxx_sp_s[1027815]=Pssp;
	Mxx_sp_s[120040]=ebar*Pssp;
	Mxx_sp_s[1007848]=pow(E,yss[0] - yss[11])*Pssp;
	Mxx_sp_s[1012456]=pow(E,yss[3] - yss[11])*Pssp;
	Mxx_sp_s[1021672]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxx_sp_s[1023208]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxx_sp_s[1024744]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mxx_sp_s[1029352]=Pssp;
	Mxx_sp_s[110825]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[112361]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[113897]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[115433]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mxx_sp_s[116969]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[118505]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[120041]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[121577]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[1021673]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[1023209]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[1030889]=Pssp;
	Mxx_sp_s[2371817]=(Pssp*pow(zbar,rrho)*pow(Hs[8],2)*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2396393]=(2*Pssp*pow(zbar,rrho)*Hs[8]*Hs[9]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2420969]=(2*Pssp*pow(zbar,rrho)*Hs[8]*Hs[10]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2445545]=(2*Pssp*pow(zbar,rrho)*Hs[8]*Hs[11]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2470121]=(2*Pssp*pow(zbar,rrho)*Hs[8]*Hs[12]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2494697]=(2*Pssp*pow(zbar,rrho)*Hs[8]*Hs[13]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2519273]=(2*Pssp*pow(zbar,rrho)*Hs[8]*Hs[14]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2543849]=(2*Pssp*pow(zbar,rrho)*Hs[8]*Hs[15]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2593001]=(Pssp*pow(zbar,rrho)*pow(Hs[9],2)*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2617577]=(2*Pssp*pow(zbar,rrho)*Hs[9]*Hs[10]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2642153]=(2*Pssp*pow(zbar,rrho)*Hs[9]*Hs[11]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2666729]=(2*Pssp*pow(zbar,rrho)*Hs[9]*Hs[12]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2691305]=(2*Pssp*pow(zbar,rrho)*Hs[9]*Hs[13]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2715881]=(2*Pssp*pow(zbar,rrho)*Hs[9]*Hs[14]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2740457]=(2*Pssp*pow(zbar,rrho)*Hs[9]*Hs[15]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2814185]=(Pssp*pow(zbar,rrho)*pow(Hs[10],2)*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2838761]=(2*Pssp*pow(zbar,rrho)*Hs[10]*Hs[11]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2863337]=(2*Pssp*pow(zbar,rrho)*Hs[10]*Hs[12]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2887913]=(2*Pssp*pow(zbar,rrho)*Hs[10]*Hs[13]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2912489]=(2*Pssp*pow(zbar,rrho)*Hs[10]*Hs[14]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2937065]=(2*Pssp*pow(zbar,rrho)*Hs[10]*Hs[15]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3035369]=(Pssp*pow(zbar,rrho)*pow(Hs[11],2)*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3059945]=(2*Pssp*pow(zbar,rrho)*Hs[11]*Hs[12]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3084521]=(2*Pssp*pow(zbar,rrho)*Hs[11]*Hs[13]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3109097]=(2*Pssp*pow(zbar,rrho)*Hs[11]*Hs[14]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3133673]=(2*Pssp*pow(zbar,rrho)*Hs[11]*Hs[15]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3256553]=(Pssp*pow(zbar,rrho)*pow(Hs[12],2)*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3281129]=(2*Pssp*pow(zbar,rrho)*Hs[12]*Hs[13]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3305705]=(2*Pssp*pow(zbar,rrho)*Hs[12]*Hs[14]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3330281]=(2*Pssp*pow(zbar,rrho)*Hs[12]*Hs[15]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3477737]=(Pssp*pow(zbar,rrho)*pow(Hs[13],2)*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3502313]=(2*Pssp*pow(zbar,rrho)*Hs[13]*Hs[14]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3526889]=(2*Pssp*pow(zbar,rrho)*Hs[13]*Hs[15]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3698921]=(Pssp*pow(zbar,rrho)*pow(Hs[14],2)*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3723497]=(2*Pssp*pow(zbar,rrho)*Hs[14]*Hs[15]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3920105]=(Pssp*pow(zbar,rrho)*pow(Hs[15],2)*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[113898]=-Pssp;
	Mxx_sp_s[115435]=-Pssp;
	Mxx_sp_s[116972]=-Pssp;
	Mxx_sp_s[121581]=-Pssp;
	Mxx_sp_s[120046]=-Pssp;
	Mxx_sp_s[118511]=-Pssp;
	Mxx_sp_s[133872]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mxx_sp_s[1032432]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mxx_sp_s[1033968]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mxx_sp_s[1044720]=-(pow(E,yss[8])*Pssp);
	Mxx_sp_s[1046256]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxx_sp_s[1047792]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxx_sp_s[126193]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[127729]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[129265]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[1033969]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[1035505]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[1040113]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mxx_sp_s[1044721]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mxx_sp_s[1046257]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[1047793]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[126194]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[127730]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[1033970]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[1035506]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[1040114]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mxx_sp_s[1043186]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[1044722]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mxx_sp_s[1046258]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[1047794]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[123123]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[124659]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[126195]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[127731]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mxx_sp_s[129267]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[130803]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[132339]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[133875]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[1040115]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mxx_sp_s[1044723]=-(pow(E,yss[8])*Pssp);
	Mxx_sp_s[1046259]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mxx_sp_s[1047795]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mxx_sp_s[2371827]=(bbeta*pow(E,yss[8])*Pssp*Hs[8]*Hs[16]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2396403]=(bbeta*pow(E,yss[8])*Pssp*(Hs[9]*Hs[16] + Hs[8]*Hs[17])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2420979]=(bbeta*pow(E,yss[8])*Pssp*(Hs[10]*Hs[16] + Hs[8]*Hs[18])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2445555]=(bbeta*pow(E,yss[8])*Pssp*(Hs[11]*Hs[16] + Hs[8]*Hs[19])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2470131]=(bbeta*pow(E,yss[8])*Pssp*(Hs[12]*Hs[16] + Hs[8]*Hs[20])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2494707]=(bbeta*pow(E,yss[8])*Pssp*(Hs[13]*Hs[16] + Hs[8]*Hs[21])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2519283]=(bbeta*pow(E,yss[8])*Pssp*(Hs[14]*Hs[16] + Hs[8]*Hs[22])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2543859]=(bbeta*pow(E,yss[8])*Pssp*(Hs[15]*Hs[16] + Hs[8]*Hs[23])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2593011]=(bbeta*pow(E,yss[8])*Pssp*Hs[9]*Hs[17]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2617587]=(bbeta*pow(E,yss[8])*Pssp*(Hs[10]*Hs[17] + Hs[9]*Hs[18])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2642163]=(bbeta*pow(E,yss[8])*Pssp*(Hs[11]*Hs[17] + Hs[9]*Hs[19])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2666739]=(bbeta*pow(E,yss[8])*Pssp*(Hs[12]*Hs[17] + Hs[9]*Hs[20])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2691315]=(bbeta*pow(E,yss[8])*Pssp*(Hs[13]*Hs[17] + Hs[9]*Hs[21])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2715891]=(bbeta*pow(E,yss[8])*Pssp*(Hs[14]*Hs[17] + Hs[9]*Hs[22])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2740467]=(bbeta*pow(E,yss[8])*Pssp*(Hs[15]*Hs[17] + Hs[9]*Hs[23])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2814195]=(bbeta*pow(E,yss[8])*Pssp*Hs[10]*Hs[18]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2838771]=(bbeta*pow(E,yss[8])*Pssp*(Hs[11]*Hs[18] + Hs[10]*Hs[19])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2863347]=(bbeta*pow(E,yss[8])*Pssp*(Hs[12]*Hs[18] + Hs[10]*Hs[20])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2887923]=(bbeta*pow(E,yss[8])*Pssp*(Hs[13]*Hs[18] + Hs[10]*Hs[21])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2912499]=(bbeta*pow(E,yss[8])*Pssp*(Hs[14]*Hs[18] + Hs[10]*Hs[22])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2937075]=(bbeta*pow(E,yss[8])*Pssp*(Hs[15]*Hs[18] + Hs[10]*Hs[23])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3035379]=(bbeta*pow(E,yss[8])*Pssp*Hs[11]*Hs[19]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3059955]=(bbeta*pow(E,yss[8])*Pssp*(Hs[12]*Hs[19] + Hs[11]*Hs[20])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3084531]=(bbeta*pow(E,yss[8])*Pssp*(Hs[13]*Hs[19] + Hs[11]*Hs[21])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3109107]=(bbeta*pow(E,yss[8])*Pssp*(Hs[14]*Hs[19] + Hs[11]*Hs[22])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3133683]=(bbeta*pow(E,yss[8])*Pssp*(Hs[15]*Hs[19] + Hs[11]*Hs[23])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3256563]=(bbeta*pow(E,yss[8])*Pssp*Hs[12]*Hs[20]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3281139]=(bbeta*pow(E,yss[8])*Pssp*(Hs[13]*Hs[20] + Hs[12]*Hs[21])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3305715]=(bbeta*pow(E,yss[8])*Pssp*(Hs[14]*Hs[20] + Hs[12]*Hs[22])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3330291]=(bbeta*pow(E,yss[8])*Pssp*(Hs[15]*Hs[20] + Hs[12]*Hs[23])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3477747]=(bbeta*pow(E,yss[8])*Pssp*Hs[13]*Hs[21]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3502323]=(bbeta*pow(E,yss[8])*Pssp*(Hs[14]*Hs[21] + Hs[13]*Hs[22])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3526899]=(bbeta*pow(E,yss[8])*Pssp*(Hs[15]*Hs[21] + Hs[13]*Hs[23])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3698931]=(bbeta*pow(E,yss[8])*Pssp*Hs[14]*Hs[22]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3723507]=(bbeta*pow(E,yss[8])*Pssp*(Hs[15]*Hs[22] + Hs[14]*Hs[23])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3920115]=(bbeta*pow(E,yss[8])*Pssp*Hs[15]*Hs[23]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[123124]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mxx_sp_s[124660]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mxx_sp_s[126196]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mxx_sp_s[127732]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mxx_sp_s[129268]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mxx_sp_s[130804]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mxx_sp_s[132340]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mxx_sp_s[133876]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mxx_sp_s[1041652]=-(kkappa*Pssp*yss[9]);
	Mxx_sp_s[1044724]=pow(E,yss[8])*Pssp;
	Mxx_sp_s[1046260]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mxx_sp_s[1047796]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mxx_sp_s[2361076]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[8]*Hs[16]);
	Mxx_sp_s[2362612]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[8]*Hs[16];
	Mxx_sp_s[2365684]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[8]*Hs[16]);
	Mxx_sp_s[2371828]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[8]*Hs[16])/pow(zbar,rrho);
	Mxx_sp_s[2385652]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[9]*Hs[16] + Hs[8]*Hs[17]));
	Mxx_sp_s[2387188]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[9]*Hs[16] + Hs[8]*Hs[17]);
	Mxx_sp_s[2390260]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[9]*Hs[16] + Hs[8]*Hs[17]));
	Mxx_sp_s[2396404]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[9]*Hs[16] + Hs[8]*Hs[17]))/pow(zbar,rrho);
	Mxx_sp_s[2410228]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[10]*Hs[16] + Hs[8]*Hs[18]));
	Mxx_sp_s[2411764]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[10]*Hs[16] + Hs[8]*Hs[18]);
	Mxx_sp_s[2414836]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[10]*Hs[16] + Hs[8]*Hs[18]));
	Mxx_sp_s[2420980]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[10]*Hs[16] + Hs[8]*Hs[18]))/pow(zbar,rrho);
	Mxx_sp_s[2434804]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[11]*Hs[16] + Hs[8]*Hs[19]));
	Mxx_sp_s[2436340]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[11]*Hs[16] + Hs[8]*Hs[19]);
	Mxx_sp_s[2439412]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[11]*Hs[16] + Hs[8]*Hs[19]));
	Mxx_sp_s[2445556]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[11]*Hs[16] + Hs[8]*Hs[19]))/pow(zbar,rrho);
	Mxx_sp_s[2459380]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[12]*Hs[16] + Hs[8]*Hs[20]));
	Mxx_sp_s[2460916]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[12]*Hs[16] + Hs[8]*Hs[20]);
	Mxx_sp_s[2463988]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[12]*Hs[16] + Hs[8]*Hs[20]));
	Mxx_sp_s[2470132]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[12]*Hs[16] + Hs[8]*Hs[20]))/pow(zbar,rrho);
	Mxx_sp_s[2483956]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[13]*Hs[16] + Hs[8]*Hs[21]));
	Mxx_sp_s[2485492]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[13]*Hs[16] + Hs[8]*Hs[21]);
	Mxx_sp_s[2488564]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[13]*Hs[16] + Hs[8]*Hs[21]));
	Mxx_sp_s[2494708]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[13]*Hs[16] + Hs[8]*Hs[21]))/pow(zbar,rrho);
	Mxx_sp_s[2508532]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[14]*Hs[16] + Hs[8]*Hs[22]));
	Mxx_sp_s[2510068]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[14]*Hs[16] + Hs[8]*Hs[22]);
	Mxx_sp_s[2513140]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[14]*Hs[16] + Hs[8]*Hs[22]));
	Mxx_sp_s[2519284]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[14]*Hs[16] + Hs[8]*Hs[22]))/pow(zbar,rrho);
	Mxx_sp_s[2533108]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[16] + Hs[8]*Hs[23]));
	Mxx_sp_s[2534644]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[16] + Hs[8]*Hs[23]);
	Mxx_sp_s[2537716]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[15]*Hs[16] + Hs[8]*Hs[23]));
	Mxx_sp_s[2543860]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[15]*Hs[16] + Hs[8]*Hs[23]))/pow(zbar,rrho);
	Mxx_sp_s[2582260]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[9]*Hs[17]);
	Mxx_sp_s[2583796]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[9]*Hs[17];
	Mxx_sp_s[2586868]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[9]*Hs[17]);
	Mxx_sp_s[2593012]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[9]*Hs[17])/pow(zbar,rrho);
	Mxx_sp_s[2606836]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[10]*Hs[17] + Hs[9]*Hs[18]));
	Mxx_sp_s[2608372]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[10]*Hs[17] + Hs[9]*Hs[18]);
	Mxx_sp_s[2611444]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[10]*Hs[17] + Hs[9]*Hs[18]));
	Mxx_sp_s[2617588]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[10]*Hs[17] + Hs[9]*Hs[18]))/pow(zbar,rrho);
	Mxx_sp_s[2631412]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[11]*Hs[17] + Hs[9]*Hs[19]));
	Mxx_sp_s[2632948]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[11]*Hs[17] + Hs[9]*Hs[19]);
	Mxx_sp_s[2636020]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[11]*Hs[17] + Hs[9]*Hs[19]));
	Mxx_sp_s[2642164]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[11]*Hs[17] + Hs[9]*Hs[19]))/pow(zbar,rrho);
	Mxx_sp_s[2655988]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[12]*Hs[17] + Hs[9]*Hs[20]));
	Mxx_sp_s[2657524]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[12]*Hs[17] + Hs[9]*Hs[20]);
	Mxx_sp_s[2660596]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[12]*Hs[17] + Hs[9]*Hs[20]));
	Mxx_sp_s[2666740]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[12]*Hs[17] + Hs[9]*Hs[20]))/pow(zbar,rrho);
	Mxx_sp_s[2680564]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[13]*Hs[17] + Hs[9]*Hs[21]));
	Mxx_sp_s[2682100]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[13]*Hs[17] + Hs[9]*Hs[21]);
	Mxx_sp_s[2685172]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[13]*Hs[17] + Hs[9]*Hs[21]));
	Mxx_sp_s[2691316]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[13]*Hs[17] + Hs[9]*Hs[21]))/pow(zbar,rrho);
	Mxx_sp_s[2705140]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[14]*Hs[17] + Hs[9]*Hs[22]));
	Mxx_sp_s[2706676]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[14]*Hs[17] + Hs[9]*Hs[22]);
	Mxx_sp_s[2709748]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[14]*Hs[17] + Hs[9]*Hs[22]));
	Mxx_sp_s[2715892]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[14]*Hs[17] + Hs[9]*Hs[22]))/pow(zbar,rrho);
	Mxx_sp_s[2729716]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[17] + Hs[9]*Hs[23]));
	Mxx_sp_s[2731252]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[17] + Hs[9]*Hs[23]);
	Mxx_sp_s[2734324]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[15]*Hs[17] + Hs[9]*Hs[23]));
	Mxx_sp_s[2740468]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[15]*Hs[17] + Hs[9]*Hs[23]))/pow(zbar,rrho);
	Mxx_sp_s[2803444]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[10]*Hs[18]);
	Mxx_sp_s[2804980]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[10]*Hs[18];
	Mxx_sp_s[2808052]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[10]*Hs[18]);
	Mxx_sp_s[2814196]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[10]*Hs[18])/pow(zbar,rrho);
	Mxx_sp_s[2828020]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[11]*Hs[18] + Hs[10]*Hs[19]));
	Mxx_sp_s[2829556]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[11]*Hs[18] + Hs[10]*Hs[19]);
	Mxx_sp_s[2832628]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[11]*Hs[18] + Hs[10]*Hs[19]));
	Mxx_sp_s[2838772]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[11]*Hs[18] + Hs[10]*Hs[19]))/pow(zbar,rrho);
	Mxx_sp_s[2852596]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[12]*Hs[18] + Hs[10]*Hs[20]));
	Mxx_sp_s[2854132]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[12]*Hs[18] + Hs[10]*Hs[20]);
	Mxx_sp_s[2857204]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[12]*Hs[18] + Hs[10]*Hs[20]));
	Mxx_sp_s[2863348]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[12]*Hs[18] + Hs[10]*Hs[20]))/pow(zbar,rrho);
	Mxx_sp_s[2877172]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[13]*Hs[18] + Hs[10]*Hs[21]));
	Mxx_sp_s[2878708]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[13]*Hs[18] + Hs[10]*Hs[21]);
	Mxx_sp_s[2881780]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[13]*Hs[18] + Hs[10]*Hs[21]));
	Mxx_sp_s[2887924]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[13]*Hs[18] + Hs[10]*Hs[21]))/pow(zbar,rrho);
	Mxx_sp_s[2901748]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[14]*Hs[18] + Hs[10]*Hs[22]));
	Mxx_sp_s[2903284]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[14]*Hs[18] + Hs[10]*Hs[22]);
	Mxx_sp_s[2906356]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[14]*Hs[18] + Hs[10]*Hs[22]));
	Mxx_sp_s[2912500]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[14]*Hs[18] + Hs[10]*Hs[22]))/pow(zbar,rrho);
	Mxx_sp_s[2926324]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[18] + Hs[10]*Hs[23]));
	Mxx_sp_s[2927860]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[18] + Hs[10]*Hs[23]);
	Mxx_sp_s[2930932]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[15]*Hs[18] + Hs[10]*Hs[23]));
	Mxx_sp_s[2937076]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[15]*Hs[18] + Hs[10]*Hs[23]))/pow(zbar,rrho);
	Mxx_sp_s[3024628]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[11]*Hs[19]);
	Mxx_sp_s[3026164]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[11]*Hs[19];
	Mxx_sp_s[3029236]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[11]*Hs[19]);
	Mxx_sp_s[3035380]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[11]*Hs[19])/pow(zbar,rrho);
	Mxx_sp_s[3049204]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[12]*Hs[19] + Hs[11]*Hs[20]));
	Mxx_sp_s[3050740]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[12]*Hs[19] + Hs[11]*Hs[20]);
	Mxx_sp_s[3053812]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[12]*Hs[19] + Hs[11]*Hs[20]));
	Mxx_sp_s[3059956]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[12]*Hs[19] + Hs[11]*Hs[20]))/pow(zbar,rrho);
	Mxx_sp_s[3073780]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[13]*Hs[19] + Hs[11]*Hs[21]));
	Mxx_sp_s[3075316]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[13]*Hs[19] + Hs[11]*Hs[21]);
	Mxx_sp_s[3078388]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[13]*Hs[19] + Hs[11]*Hs[21]));
	Mxx_sp_s[3084532]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[13]*Hs[19] + Hs[11]*Hs[21]))/pow(zbar,rrho);
	Mxx_sp_s[3098356]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[14]*Hs[19] + Hs[11]*Hs[22]));
	Mxx_sp_s[3099892]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[14]*Hs[19] + Hs[11]*Hs[22]);
	Mxx_sp_s[3102964]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[14]*Hs[19] + Hs[11]*Hs[22]));
	Mxx_sp_s[3109108]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[14]*Hs[19] + Hs[11]*Hs[22]))/pow(zbar,rrho);
	Mxx_sp_s[3122932]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[19] + Hs[11]*Hs[23]));
	Mxx_sp_s[3124468]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[19] + Hs[11]*Hs[23]);
	Mxx_sp_s[3127540]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[15]*Hs[19] + Hs[11]*Hs[23]));
	Mxx_sp_s[3133684]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[15]*Hs[19] + Hs[11]*Hs[23]))/pow(zbar,rrho);
	Mxx_sp_s[3245812]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[12]*Hs[20]);
	Mxx_sp_s[3247348]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[12]*Hs[20];
	Mxx_sp_s[3250420]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[12]*Hs[20]);
	Mxx_sp_s[3256564]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[12]*Hs[20])/pow(zbar,rrho);
	Mxx_sp_s[3270388]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[13]*Hs[20] + Hs[12]*Hs[21]));
	Mxx_sp_s[3271924]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[13]*Hs[20] + Hs[12]*Hs[21]);
	Mxx_sp_s[3274996]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[13]*Hs[20] + Hs[12]*Hs[21]));
	Mxx_sp_s[3281140]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[13]*Hs[20] + Hs[12]*Hs[21]))/pow(zbar,rrho);
	Mxx_sp_s[3294964]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[14]*Hs[20] + Hs[12]*Hs[22]));
	Mxx_sp_s[3296500]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[14]*Hs[20] + Hs[12]*Hs[22]);
	Mxx_sp_s[3299572]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[14]*Hs[20] + Hs[12]*Hs[22]));
	Mxx_sp_s[3305716]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[14]*Hs[20] + Hs[12]*Hs[22]))/pow(zbar,rrho);
	Mxx_sp_s[3319540]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[20] + Hs[12]*Hs[23]));
	Mxx_sp_s[3321076]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[20] + Hs[12]*Hs[23]);
	Mxx_sp_s[3324148]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[15]*Hs[20] + Hs[12]*Hs[23]));
	Mxx_sp_s[3330292]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[15]*Hs[20] + Hs[12]*Hs[23]))/pow(zbar,rrho);
	Mxx_sp_s[3466996]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[13]*Hs[21]);
	Mxx_sp_s[3468532]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[13]*Hs[21];
	Mxx_sp_s[3471604]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[13]*Hs[21]);
	Mxx_sp_s[3477748]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[13]*Hs[21])/pow(zbar,rrho);
	Mxx_sp_s[3491572]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[14]*Hs[21] + Hs[13]*Hs[22]));
	Mxx_sp_s[3493108]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[14]*Hs[21] + Hs[13]*Hs[22]);
	Mxx_sp_s[3496180]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[14]*Hs[21] + Hs[13]*Hs[22]));
	Mxx_sp_s[3502324]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[14]*Hs[21] + Hs[13]*Hs[22]))/pow(zbar,rrho);
	Mxx_sp_s[3516148]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[21] + Hs[13]*Hs[23]));
	Mxx_sp_s[3517684]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[21] + Hs[13]*Hs[23]);
	Mxx_sp_s[3520756]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[15]*Hs[21] + Hs[13]*Hs[23]));
	Mxx_sp_s[3526900]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[15]*Hs[21] + Hs[13]*Hs[23]))/pow(zbar,rrho);
	Mxx_sp_s[3688180]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[14]*Hs[22]);
	Mxx_sp_s[3689716]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[14]*Hs[22];
	Mxx_sp_s[3692788]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[14]*Hs[22]);
	Mxx_sp_s[3698932]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[14]*Hs[22])/pow(zbar,rrho);
	Mxx_sp_s[3712756]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[22] + Hs[14]*Hs[23]));
	Mxx_sp_s[3714292]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[22] + Hs[14]*Hs[23]);
	Mxx_sp_s[3717364]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[15]*Hs[22] + Hs[14]*Hs[23]));
	Mxx_sp_s[3723508]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[15]*Hs[22] + Hs[14]*Hs[23]))/pow(zbar,rrho);
	Mxx_sp_s[3909364]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[15]*Hs[23]);
	Mxx_sp_s[3910900]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[15]*Hs[23];
	Mxx_sp_s[3913972]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[15]*Hs[23]);
	Mxx_sp_s[3920116]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[15]*Hs[23])/pow(zbar,rrho);
	Mxx_sp_s[123125]=iiota*Pssp*zbar;
	Mxx_sp_s[127733]=iiota*Pssp*zbar;
	Mxx_sp_s[1041653]=-Pssp;
	Mxx_sp_s[1033974]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mxx_sp_s[1043190]=-(pow(E,yss[7])*Pssp);
	Mxx_sp_s[1046262]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxx_sp_s[1047798]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxx_sp_s[124663]=-((Pssp*zbar)/(1 + yss[5]));
	Mxx_sp_s[126199]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[127735]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mxx_sp_s[129271]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mxx_sp_s[132343]=-(pow(E,yss[11])*ebar*Pssp);
	Mxx_sp_s[1032439]=-(pow(E,yss[0])*Pssp);
	Mxx_sp_s[1033975]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mxx_sp_s[1035511]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mxx_sp_s[1037047]=-(pow(E,yss[3])*Pssp);
	Mxx_sp_s[1040119]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mxx_sp_s[1043191]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mxx_sp_s[1046263]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxx_sp_s[1047799]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxx_sp_s[123128]=-(pow(E,xss[0])*Pssp*zbar);
	Mxx_sp_s[127736]=-(pow(E,xss[0])*Pssp*zbar);
	Mxx_sp_s[1037048]=pow(E,yss[3])*Pssp;
	Mxx_sp_s[1046264]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxx_sp_s[1047800]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxx_sp_s[123129]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxx_sp_s[124665]=(Pssp*zbar)/(1 + yss[5]);
	Mxx_sp_s[127737]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mxx_sp_s[129273]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxx_sp_s[1033977]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxx_sp_s[1035513]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxx_sp_s[1040121]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mxx_sp_s[1041657]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxx_sp_s[1043193]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxx_sp_s[1046265]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxx_sp_s[1047801]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxx_sp_s[1046266]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxx_sp_s[1047802]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxx_sp_s[124667]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mxx_sp_s[130811]=Pssp;
	Mxx_sp_s[1040123]=-Pssp;
	Mxx_sp_s[1046267]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxx_sp_s[1047803]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxx_sp_s[123132]=pow(E,xss[0])*Pssp;
	Mxx_sp_s[1038588]=-(pow(E,xss[0])*Pssp);
	Mxx_sp_s[126205]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[127741]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[129277]=pow(E,yss[2])*pbar*Pssp;
	Mxx_sp_s[1033981]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[1035517]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mxx_sp_s[1046269]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxx_sp_s[1047805]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxx_sp_s[1049341]=pow(E,yss[11])*Pssp;
	Mxx_sp_s[124670]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxx_sp_s[127742]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxx_sp_s[1046270]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxx_sp_s[1047806]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxx_sp_s[1049342]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mxx_sp_s[1050878]=Pssp;
	Mxx_sp_s[124671]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxx_sp_s[127743]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxx_sp_s[1046271]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxx_sp_s[1047807]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxx_sp_s[1049343]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mxx_sp_s[1052415]=Pssp;
	Mxx_sp_s[132352]=ebar*Pssp;
	Mxx_sp_s[1032448]=pow(E,yss[0] - yss[11])*Pssp;
	Mxx_sp_s[1037056]=pow(E,yss[3] - yss[11])*Pssp;
	Mxx_sp_s[1046272]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxx_sp_s[1047808]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxx_sp_s[1049344]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mxx_sp_s[1053952]=Pssp;
	Mxx_sp_s[123137]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[124673]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[126209]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[127745]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mxx_sp_s[129281]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[130817]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[132353]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[133889]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[1046273]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[1047809]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[1055489]=Pssp;
	Mxx_sp_s[2371841]=(Pssp*pow(zbar,rrho)*Hs[8]*Hs[16]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2396417]=(Pssp*pow(zbar,rrho)*(Hs[9]*Hs[16] + Hs[8]*Hs[17])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2420993]=(Pssp*pow(zbar,rrho)*(Hs[10]*Hs[16] + Hs[8]*Hs[18])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2445569]=(Pssp*pow(zbar,rrho)*(Hs[11]*Hs[16] + Hs[8]*Hs[19])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2470145]=(Pssp*pow(zbar,rrho)*(Hs[12]*Hs[16] + Hs[8]*Hs[20])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2494721]=(Pssp*pow(zbar,rrho)*(Hs[13]*Hs[16] + Hs[8]*Hs[21])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2519297]=(Pssp*pow(zbar,rrho)*(Hs[14]*Hs[16] + Hs[8]*Hs[22])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2543873]=(Pssp*pow(zbar,rrho)*(Hs[15]*Hs[16] + Hs[8]*Hs[23])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2593025]=(Pssp*pow(zbar,rrho)*Hs[9]*Hs[17]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2617601]=(Pssp*pow(zbar,rrho)*(Hs[10]*Hs[17] + Hs[9]*Hs[18])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2642177]=(Pssp*pow(zbar,rrho)*(Hs[11]*Hs[17] + Hs[9]*Hs[19])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2666753]=(Pssp*pow(zbar,rrho)*(Hs[12]*Hs[17] + Hs[9]*Hs[20])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2691329]=(Pssp*pow(zbar,rrho)*(Hs[13]*Hs[17] + Hs[9]*Hs[21])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2715905]=(Pssp*pow(zbar,rrho)*(Hs[14]*Hs[17] + Hs[9]*Hs[22])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2740481]=(Pssp*pow(zbar,rrho)*(Hs[15]*Hs[17] + Hs[9]*Hs[23])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2814209]=(Pssp*pow(zbar,rrho)*Hs[10]*Hs[18]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2838785]=(Pssp*pow(zbar,rrho)*(Hs[11]*Hs[18] + Hs[10]*Hs[19])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2863361]=(Pssp*pow(zbar,rrho)*(Hs[12]*Hs[18] + Hs[10]*Hs[20])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2887937]=(Pssp*pow(zbar,rrho)*(Hs[13]*Hs[18] + Hs[10]*Hs[21])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2912513]=(Pssp*pow(zbar,rrho)*(Hs[14]*Hs[18] + Hs[10]*Hs[22])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2937089]=(Pssp*pow(zbar,rrho)*(Hs[15]*Hs[18] + Hs[10]*Hs[23])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3035393]=(Pssp*pow(zbar,rrho)*Hs[11]*Hs[19]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3059969]=(Pssp*pow(zbar,rrho)*(Hs[12]*Hs[19] + Hs[11]*Hs[20])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3084545]=(Pssp*pow(zbar,rrho)*(Hs[13]*Hs[19] + Hs[11]*Hs[21])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3109121]=(Pssp*pow(zbar,rrho)*(Hs[14]*Hs[19] + Hs[11]*Hs[22])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3133697]=(Pssp*pow(zbar,rrho)*(Hs[15]*Hs[19] + Hs[11]*Hs[23])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3256577]=(Pssp*pow(zbar,rrho)*Hs[12]*Hs[20]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3281153]=(Pssp*pow(zbar,rrho)*(Hs[13]*Hs[20] + Hs[12]*Hs[21])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3305729]=(Pssp*pow(zbar,rrho)*(Hs[14]*Hs[20] + Hs[12]*Hs[22])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3330305]=(Pssp*pow(zbar,rrho)*(Hs[15]*Hs[20] + Hs[12]*Hs[23])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3477761]=(Pssp*pow(zbar,rrho)*Hs[13]*Hs[21]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3502337]=(Pssp*pow(zbar,rrho)*(Hs[14]*Hs[21] + Hs[13]*Hs[22])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3526913]=(Pssp*pow(zbar,rrho)*(Hs[15]*Hs[21] + Hs[13]*Hs[23])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3698945]=(Pssp*pow(zbar,rrho)*Hs[14]*Hs[22]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3723521]=(Pssp*pow(zbar,rrho)*(Hs[15]*Hs[22] + Hs[14]*Hs[23])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3920129]=(Pssp*pow(zbar,rrho)*Hs[15]*Hs[23]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[126210]=-Pssp;
	Mxx_sp_s[127747]=-Pssp;
	Mxx_sp_s[129284]=-Pssp;
	Mxx_sp_s[133893]=-Pssp;
	Mxx_sp_s[132358]=-Pssp;
	Mxx_sp_s[130823]=-Pssp;
	Mxx_sp_s[146184]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mxx_sp_s[1057032]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mxx_sp_s[1058568]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mxx_sp_s[1069320]=-(pow(E,yss[8])*Pssp);
	Mxx_sp_s[1070856]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxx_sp_s[1072392]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxx_sp_s[138505]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[140041]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[141577]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[1058569]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[1060105]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[1064713]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mxx_sp_s[1069321]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mxx_sp_s[1070857]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[1072393]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[138506]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[140042]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[1058570]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[1060106]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[1064714]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mxx_sp_s[1067786]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[1069322]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mxx_sp_s[1070858]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[1072394]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[135435]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[136971]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[138507]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[140043]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mxx_sp_s[141579]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[143115]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[144651]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[146187]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[1064715]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mxx_sp_s[1069323]=-(pow(E,yss[8])*Pssp);
	Mxx_sp_s[1070859]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mxx_sp_s[1072395]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mxx_sp_s[2371851]=(bbeta*pow(E,yss[8])*Pssp*Hs[8]*Hs[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2396427]=(bbeta*pow(E,yss[8])*Pssp*(Hs[9]*Hs[24] + Hs[8]*Hs[25])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2421003]=(bbeta*pow(E,yss[8])*Pssp*(Hs[10]*Hs[24] + Hs[8]*Hs[26])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2445579]=(bbeta*pow(E,yss[8])*Pssp*(Hs[11]*Hs[24] + Hs[8]*Hs[27])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2470155]=(bbeta*pow(E,yss[8])*Pssp*(Hs[12]*Hs[24] + Hs[8]*Hs[28])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2494731]=(bbeta*pow(E,yss[8])*Pssp*(Hs[13]*Hs[24] + Hs[8]*Hs[29])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2519307]=(bbeta*pow(E,yss[8])*Pssp*(Hs[14]*Hs[24] + Hs[8]*Hs[30])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2543883]=(bbeta*pow(E,yss[8])*Pssp*(Hs[15]*Hs[24] + Hs[8]*Hs[31])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2593035]=(bbeta*pow(E,yss[8])*Pssp*Hs[9]*Hs[25]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2617611]=(bbeta*pow(E,yss[8])*Pssp*(Hs[10]*Hs[25] + Hs[9]*Hs[26])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2642187]=(bbeta*pow(E,yss[8])*Pssp*(Hs[11]*Hs[25] + Hs[9]*Hs[27])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2666763]=(bbeta*pow(E,yss[8])*Pssp*(Hs[12]*Hs[25] + Hs[9]*Hs[28])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2691339]=(bbeta*pow(E,yss[8])*Pssp*(Hs[13]*Hs[25] + Hs[9]*Hs[29])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2715915]=(bbeta*pow(E,yss[8])*Pssp*(Hs[14]*Hs[25] + Hs[9]*Hs[30])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2740491]=(bbeta*pow(E,yss[8])*Pssp*(Hs[15]*Hs[25] + Hs[9]*Hs[31])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2814219]=(bbeta*pow(E,yss[8])*Pssp*Hs[10]*Hs[26]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2838795]=(bbeta*pow(E,yss[8])*Pssp*(Hs[11]*Hs[26] + Hs[10]*Hs[27])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2863371]=(bbeta*pow(E,yss[8])*Pssp*(Hs[12]*Hs[26] + Hs[10]*Hs[28])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2887947]=(bbeta*pow(E,yss[8])*Pssp*(Hs[13]*Hs[26] + Hs[10]*Hs[29])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2912523]=(bbeta*pow(E,yss[8])*Pssp*(Hs[14]*Hs[26] + Hs[10]*Hs[30])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2937099]=(bbeta*pow(E,yss[8])*Pssp*(Hs[15]*Hs[26] + Hs[10]*Hs[31])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3035403]=(bbeta*pow(E,yss[8])*Pssp*Hs[11]*Hs[27]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3059979]=(bbeta*pow(E,yss[8])*Pssp*(Hs[12]*Hs[27] + Hs[11]*Hs[28])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3084555]=(bbeta*pow(E,yss[8])*Pssp*(Hs[13]*Hs[27] + Hs[11]*Hs[29])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3109131]=(bbeta*pow(E,yss[8])*Pssp*(Hs[14]*Hs[27] + Hs[11]*Hs[30])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3133707]=(bbeta*pow(E,yss[8])*Pssp*(Hs[15]*Hs[27] + Hs[11]*Hs[31])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3256587]=(bbeta*pow(E,yss[8])*Pssp*Hs[12]*Hs[28]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3281163]=(bbeta*pow(E,yss[8])*Pssp*(Hs[13]*Hs[28] + Hs[12]*Hs[29])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3305739]=(bbeta*pow(E,yss[8])*Pssp*(Hs[14]*Hs[28] + Hs[12]*Hs[30])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3330315]=(bbeta*pow(E,yss[8])*Pssp*(Hs[15]*Hs[28] + Hs[12]*Hs[31])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3477771]=(bbeta*pow(E,yss[8])*Pssp*Hs[13]*Hs[29]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3502347]=(bbeta*pow(E,yss[8])*Pssp*(Hs[14]*Hs[29] + Hs[13]*Hs[30])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3526923]=(bbeta*pow(E,yss[8])*Pssp*(Hs[15]*Hs[29] + Hs[13]*Hs[31])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3698955]=(bbeta*pow(E,yss[8])*Pssp*Hs[14]*Hs[30]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3723531]=(bbeta*pow(E,yss[8])*Pssp*(Hs[15]*Hs[30] + Hs[14]*Hs[31])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3920139]=(bbeta*pow(E,yss[8])*Pssp*Hs[15]*Hs[31]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[135436]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mxx_sp_s[136972]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mxx_sp_s[138508]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mxx_sp_s[140044]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mxx_sp_s[141580]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mxx_sp_s[143116]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mxx_sp_s[144652]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mxx_sp_s[146188]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mxx_sp_s[1066252]=-(kkappa*Pssp*yss[9]);
	Mxx_sp_s[1069324]=pow(E,yss[8])*Pssp;
	Mxx_sp_s[1070860]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mxx_sp_s[1072396]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mxx_sp_s[2361100]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[8]*Hs[24]);
	Mxx_sp_s[2362636]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[8]*Hs[24];
	Mxx_sp_s[2365708]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[8]*Hs[24]);
	Mxx_sp_s[2371852]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[8]*Hs[24])/pow(zbar,rrho);
	Mxx_sp_s[2385676]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[9]*Hs[24] + Hs[8]*Hs[25]));
	Mxx_sp_s[2387212]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[9]*Hs[24] + Hs[8]*Hs[25]);
	Mxx_sp_s[2390284]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[9]*Hs[24] + Hs[8]*Hs[25]));
	Mxx_sp_s[2396428]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[9]*Hs[24] + Hs[8]*Hs[25]))/pow(zbar,rrho);
	Mxx_sp_s[2410252]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[10]*Hs[24] + Hs[8]*Hs[26]));
	Mxx_sp_s[2411788]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[10]*Hs[24] + Hs[8]*Hs[26]);
	Mxx_sp_s[2414860]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[10]*Hs[24] + Hs[8]*Hs[26]));
	Mxx_sp_s[2421004]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[10]*Hs[24] + Hs[8]*Hs[26]))/pow(zbar,rrho);
	Mxx_sp_s[2434828]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[11]*Hs[24] + Hs[8]*Hs[27]));
	Mxx_sp_s[2436364]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[11]*Hs[24] + Hs[8]*Hs[27]);
	Mxx_sp_s[2439436]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[11]*Hs[24] + Hs[8]*Hs[27]));
	Mxx_sp_s[2445580]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[11]*Hs[24] + Hs[8]*Hs[27]))/pow(zbar,rrho);
	Mxx_sp_s[2459404]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[12]*Hs[24] + Hs[8]*Hs[28]));
	Mxx_sp_s[2460940]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[12]*Hs[24] + Hs[8]*Hs[28]);
	Mxx_sp_s[2464012]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[12]*Hs[24] + Hs[8]*Hs[28]));
	Mxx_sp_s[2470156]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[12]*Hs[24] + Hs[8]*Hs[28]))/pow(zbar,rrho);
	Mxx_sp_s[2483980]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[13]*Hs[24] + Hs[8]*Hs[29]));
	Mxx_sp_s[2485516]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[13]*Hs[24] + Hs[8]*Hs[29]);
	Mxx_sp_s[2488588]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[13]*Hs[24] + Hs[8]*Hs[29]));
	Mxx_sp_s[2494732]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[13]*Hs[24] + Hs[8]*Hs[29]))/pow(zbar,rrho);
	Mxx_sp_s[2508556]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[14]*Hs[24] + Hs[8]*Hs[30]));
	Mxx_sp_s[2510092]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[14]*Hs[24] + Hs[8]*Hs[30]);
	Mxx_sp_s[2513164]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[14]*Hs[24] + Hs[8]*Hs[30]));
	Mxx_sp_s[2519308]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[14]*Hs[24] + Hs[8]*Hs[30]))/pow(zbar,rrho);
	Mxx_sp_s[2533132]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[24] + Hs[8]*Hs[31]));
	Mxx_sp_s[2534668]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[24] + Hs[8]*Hs[31]);
	Mxx_sp_s[2537740]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[15]*Hs[24] + Hs[8]*Hs[31]));
	Mxx_sp_s[2543884]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[15]*Hs[24] + Hs[8]*Hs[31]))/pow(zbar,rrho);
	Mxx_sp_s[2582284]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[9]*Hs[25]);
	Mxx_sp_s[2583820]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[9]*Hs[25];
	Mxx_sp_s[2586892]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[9]*Hs[25]);
	Mxx_sp_s[2593036]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[9]*Hs[25])/pow(zbar,rrho);
	Mxx_sp_s[2606860]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[10]*Hs[25] + Hs[9]*Hs[26]));
	Mxx_sp_s[2608396]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[10]*Hs[25] + Hs[9]*Hs[26]);
	Mxx_sp_s[2611468]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[10]*Hs[25] + Hs[9]*Hs[26]));
	Mxx_sp_s[2617612]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[10]*Hs[25] + Hs[9]*Hs[26]))/pow(zbar,rrho);
	Mxx_sp_s[2631436]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[11]*Hs[25] + Hs[9]*Hs[27]));
	Mxx_sp_s[2632972]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[11]*Hs[25] + Hs[9]*Hs[27]);
	Mxx_sp_s[2636044]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[11]*Hs[25] + Hs[9]*Hs[27]));
	Mxx_sp_s[2642188]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[11]*Hs[25] + Hs[9]*Hs[27]))/pow(zbar,rrho);
	Mxx_sp_s[2656012]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[12]*Hs[25] + Hs[9]*Hs[28]));
	Mxx_sp_s[2657548]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[12]*Hs[25] + Hs[9]*Hs[28]);
	Mxx_sp_s[2660620]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[12]*Hs[25] + Hs[9]*Hs[28]));
	Mxx_sp_s[2666764]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[12]*Hs[25] + Hs[9]*Hs[28]))/pow(zbar,rrho);
	Mxx_sp_s[2680588]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[13]*Hs[25] + Hs[9]*Hs[29]));
	Mxx_sp_s[2682124]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[13]*Hs[25] + Hs[9]*Hs[29]);
	Mxx_sp_s[2685196]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[13]*Hs[25] + Hs[9]*Hs[29]));
	Mxx_sp_s[2691340]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[13]*Hs[25] + Hs[9]*Hs[29]))/pow(zbar,rrho);
	Mxx_sp_s[2705164]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[14]*Hs[25] + Hs[9]*Hs[30]));
	Mxx_sp_s[2706700]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[14]*Hs[25] + Hs[9]*Hs[30]);
	Mxx_sp_s[2709772]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[14]*Hs[25] + Hs[9]*Hs[30]));
	Mxx_sp_s[2715916]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[14]*Hs[25] + Hs[9]*Hs[30]))/pow(zbar,rrho);
	Mxx_sp_s[2729740]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[25] + Hs[9]*Hs[31]));
	Mxx_sp_s[2731276]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[25] + Hs[9]*Hs[31]);
	Mxx_sp_s[2734348]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[15]*Hs[25] + Hs[9]*Hs[31]));
	Mxx_sp_s[2740492]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[15]*Hs[25] + Hs[9]*Hs[31]))/pow(zbar,rrho);
	Mxx_sp_s[2803468]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[10]*Hs[26]);
	Mxx_sp_s[2805004]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[10]*Hs[26];
	Mxx_sp_s[2808076]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[10]*Hs[26]);
	Mxx_sp_s[2814220]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[10]*Hs[26])/pow(zbar,rrho);
	Mxx_sp_s[2828044]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[11]*Hs[26] + Hs[10]*Hs[27]));
	Mxx_sp_s[2829580]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[11]*Hs[26] + Hs[10]*Hs[27]);
	Mxx_sp_s[2832652]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[11]*Hs[26] + Hs[10]*Hs[27]));
	Mxx_sp_s[2838796]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[11]*Hs[26] + Hs[10]*Hs[27]))/pow(zbar,rrho);
	Mxx_sp_s[2852620]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[12]*Hs[26] + Hs[10]*Hs[28]));
	Mxx_sp_s[2854156]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[12]*Hs[26] + Hs[10]*Hs[28]);
	Mxx_sp_s[2857228]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[12]*Hs[26] + Hs[10]*Hs[28]));
	Mxx_sp_s[2863372]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[12]*Hs[26] + Hs[10]*Hs[28]))/pow(zbar,rrho);
	Mxx_sp_s[2877196]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[13]*Hs[26] + Hs[10]*Hs[29]));
	Mxx_sp_s[2878732]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[13]*Hs[26] + Hs[10]*Hs[29]);
	Mxx_sp_s[2881804]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[13]*Hs[26] + Hs[10]*Hs[29]));
	Mxx_sp_s[2887948]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[13]*Hs[26] + Hs[10]*Hs[29]))/pow(zbar,rrho);
	Mxx_sp_s[2901772]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[14]*Hs[26] + Hs[10]*Hs[30]));
	Mxx_sp_s[2903308]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[14]*Hs[26] + Hs[10]*Hs[30]);
	Mxx_sp_s[2906380]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[14]*Hs[26] + Hs[10]*Hs[30]));
	Mxx_sp_s[2912524]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[14]*Hs[26] + Hs[10]*Hs[30]))/pow(zbar,rrho);
	Mxx_sp_s[2926348]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[26] + Hs[10]*Hs[31]));
	Mxx_sp_s[2927884]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[26] + Hs[10]*Hs[31]);
	Mxx_sp_s[2930956]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[15]*Hs[26] + Hs[10]*Hs[31]));
	Mxx_sp_s[2937100]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[15]*Hs[26] + Hs[10]*Hs[31]))/pow(zbar,rrho);
	Mxx_sp_s[3024652]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[11]*Hs[27]);
	Mxx_sp_s[3026188]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[11]*Hs[27];
	Mxx_sp_s[3029260]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[11]*Hs[27]);
	Mxx_sp_s[3035404]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[11]*Hs[27])/pow(zbar,rrho);
	Mxx_sp_s[3049228]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[12]*Hs[27] + Hs[11]*Hs[28]));
	Mxx_sp_s[3050764]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[12]*Hs[27] + Hs[11]*Hs[28]);
	Mxx_sp_s[3053836]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[12]*Hs[27] + Hs[11]*Hs[28]));
	Mxx_sp_s[3059980]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[12]*Hs[27] + Hs[11]*Hs[28]))/pow(zbar,rrho);
	Mxx_sp_s[3073804]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[13]*Hs[27] + Hs[11]*Hs[29]));
	Mxx_sp_s[3075340]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[13]*Hs[27] + Hs[11]*Hs[29]);
	Mxx_sp_s[3078412]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[13]*Hs[27] + Hs[11]*Hs[29]));
	Mxx_sp_s[3084556]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[13]*Hs[27] + Hs[11]*Hs[29]))/pow(zbar,rrho);
	Mxx_sp_s[3098380]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[14]*Hs[27] + Hs[11]*Hs[30]));
	Mxx_sp_s[3099916]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[14]*Hs[27] + Hs[11]*Hs[30]);
	Mxx_sp_s[3102988]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[14]*Hs[27] + Hs[11]*Hs[30]));
	Mxx_sp_s[3109132]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[14]*Hs[27] + Hs[11]*Hs[30]))/pow(zbar,rrho);
	Mxx_sp_s[3122956]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[27] + Hs[11]*Hs[31]));
	Mxx_sp_s[3124492]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[27] + Hs[11]*Hs[31]);
	Mxx_sp_s[3127564]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[15]*Hs[27] + Hs[11]*Hs[31]));
	Mxx_sp_s[3133708]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[15]*Hs[27] + Hs[11]*Hs[31]))/pow(zbar,rrho);
	Mxx_sp_s[3245836]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[12]*Hs[28]);
	Mxx_sp_s[3247372]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[12]*Hs[28];
	Mxx_sp_s[3250444]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[12]*Hs[28]);
	Mxx_sp_s[3256588]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[12]*Hs[28])/pow(zbar,rrho);
	Mxx_sp_s[3270412]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[13]*Hs[28] + Hs[12]*Hs[29]));
	Mxx_sp_s[3271948]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[13]*Hs[28] + Hs[12]*Hs[29]);
	Mxx_sp_s[3275020]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[13]*Hs[28] + Hs[12]*Hs[29]));
	Mxx_sp_s[3281164]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[13]*Hs[28] + Hs[12]*Hs[29]))/pow(zbar,rrho);
	Mxx_sp_s[3294988]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[14]*Hs[28] + Hs[12]*Hs[30]));
	Mxx_sp_s[3296524]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[14]*Hs[28] + Hs[12]*Hs[30]);
	Mxx_sp_s[3299596]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[14]*Hs[28] + Hs[12]*Hs[30]));
	Mxx_sp_s[3305740]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[14]*Hs[28] + Hs[12]*Hs[30]))/pow(zbar,rrho);
	Mxx_sp_s[3319564]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[28] + Hs[12]*Hs[31]));
	Mxx_sp_s[3321100]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[28] + Hs[12]*Hs[31]);
	Mxx_sp_s[3324172]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[15]*Hs[28] + Hs[12]*Hs[31]));
	Mxx_sp_s[3330316]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[15]*Hs[28] + Hs[12]*Hs[31]))/pow(zbar,rrho);
	Mxx_sp_s[3467020]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[13]*Hs[29]);
	Mxx_sp_s[3468556]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[13]*Hs[29];
	Mxx_sp_s[3471628]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[13]*Hs[29]);
	Mxx_sp_s[3477772]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[13]*Hs[29])/pow(zbar,rrho);
	Mxx_sp_s[3491596]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[14]*Hs[29] + Hs[13]*Hs[30]));
	Mxx_sp_s[3493132]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[14]*Hs[29] + Hs[13]*Hs[30]);
	Mxx_sp_s[3496204]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[14]*Hs[29] + Hs[13]*Hs[30]));
	Mxx_sp_s[3502348]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[14]*Hs[29] + Hs[13]*Hs[30]))/pow(zbar,rrho);
	Mxx_sp_s[3516172]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[29] + Hs[13]*Hs[31]));
	Mxx_sp_s[3517708]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[29] + Hs[13]*Hs[31]);
	Mxx_sp_s[3520780]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[15]*Hs[29] + Hs[13]*Hs[31]));
	Mxx_sp_s[3526924]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[15]*Hs[29] + Hs[13]*Hs[31]))/pow(zbar,rrho);
	Mxx_sp_s[3688204]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[14]*Hs[30]);
	Mxx_sp_s[3689740]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[14]*Hs[30];
	Mxx_sp_s[3692812]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[14]*Hs[30]);
	Mxx_sp_s[3698956]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[14]*Hs[30])/pow(zbar,rrho);
	Mxx_sp_s[3712780]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[30] + Hs[14]*Hs[31]));
	Mxx_sp_s[3714316]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[30] + Hs[14]*Hs[31]);
	Mxx_sp_s[3717388]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[15]*Hs[30] + Hs[14]*Hs[31]));
	Mxx_sp_s[3723532]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[15]*Hs[30] + Hs[14]*Hs[31]))/pow(zbar,rrho);
	Mxx_sp_s[3909388]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[15]*Hs[31]);
	Mxx_sp_s[3910924]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[15]*Hs[31];
	Mxx_sp_s[3913996]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[15]*Hs[31]);
	Mxx_sp_s[3920140]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[15]*Hs[31])/pow(zbar,rrho);
	Mxx_sp_s[135437]=iiota*Pssp*zbar;
	Mxx_sp_s[140045]=iiota*Pssp*zbar;
	Mxx_sp_s[1066253]=-Pssp;
	Mxx_sp_s[1058574]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mxx_sp_s[1067790]=-(pow(E,yss[7])*Pssp);
	Mxx_sp_s[1070862]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxx_sp_s[1072398]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxx_sp_s[136975]=-((Pssp*zbar)/(1 + yss[5]));
	Mxx_sp_s[138511]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[140047]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mxx_sp_s[141583]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mxx_sp_s[144655]=-(pow(E,yss[11])*ebar*Pssp);
	Mxx_sp_s[1057039]=-(pow(E,yss[0])*Pssp);
	Mxx_sp_s[1058575]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mxx_sp_s[1060111]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mxx_sp_s[1061647]=-(pow(E,yss[3])*Pssp);
	Mxx_sp_s[1064719]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mxx_sp_s[1067791]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mxx_sp_s[1070863]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxx_sp_s[1072399]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxx_sp_s[135440]=-(pow(E,xss[0])*Pssp*zbar);
	Mxx_sp_s[140048]=-(pow(E,xss[0])*Pssp*zbar);
	Mxx_sp_s[1061648]=pow(E,yss[3])*Pssp;
	Mxx_sp_s[1070864]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxx_sp_s[1072400]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxx_sp_s[135441]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxx_sp_s[136977]=(Pssp*zbar)/(1 + yss[5]);
	Mxx_sp_s[140049]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mxx_sp_s[141585]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxx_sp_s[1058577]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxx_sp_s[1060113]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxx_sp_s[1064721]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mxx_sp_s[1066257]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxx_sp_s[1067793]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxx_sp_s[1070865]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxx_sp_s[1072401]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxx_sp_s[1070866]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxx_sp_s[1072402]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxx_sp_s[136979]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mxx_sp_s[143123]=Pssp;
	Mxx_sp_s[1064723]=-Pssp;
	Mxx_sp_s[1070867]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxx_sp_s[1072403]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxx_sp_s[135444]=pow(E,xss[0])*Pssp;
	Mxx_sp_s[1063188]=-(pow(E,xss[0])*Pssp);
	Mxx_sp_s[138517]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[140053]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[141589]=pow(E,yss[2])*pbar*Pssp;
	Mxx_sp_s[1058581]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[1060117]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mxx_sp_s[1070869]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxx_sp_s[1072405]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxx_sp_s[1073941]=pow(E,yss[11])*Pssp;
	Mxx_sp_s[136982]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxx_sp_s[140054]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxx_sp_s[1070870]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxx_sp_s[1072406]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxx_sp_s[1073942]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mxx_sp_s[1075478]=Pssp;
	Mxx_sp_s[136983]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxx_sp_s[140055]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxx_sp_s[1070871]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxx_sp_s[1072407]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxx_sp_s[1073943]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mxx_sp_s[1077015]=Pssp;
	Mxx_sp_s[144664]=ebar*Pssp;
	Mxx_sp_s[1057048]=pow(E,yss[0] - yss[11])*Pssp;
	Mxx_sp_s[1061656]=pow(E,yss[3] - yss[11])*Pssp;
	Mxx_sp_s[1070872]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxx_sp_s[1072408]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxx_sp_s[1073944]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mxx_sp_s[1078552]=Pssp;
	Mxx_sp_s[135449]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[136985]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[138521]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[140057]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mxx_sp_s[141593]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[143129]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[144665]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[146201]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[1070873]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[1072409]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[1080089]=Pssp;
	Mxx_sp_s[2371865]=(Pssp*pow(zbar,rrho)*Hs[8]*Hs[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2396441]=(Pssp*pow(zbar,rrho)*(Hs[9]*Hs[24] + Hs[8]*Hs[25])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2421017]=(Pssp*pow(zbar,rrho)*(Hs[10]*Hs[24] + Hs[8]*Hs[26])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2445593]=(Pssp*pow(zbar,rrho)*(Hs[11]*Hs[24] + Hs[8]*Hs[27])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2470169]=(Pssp*pow(zbar,rrho)*(Hs[12]*Hs[24] + Hs[8]*Hs[28])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2494745]=(Pssp*pow(zbar,rrho)*(Hs[13]*Hs[24] + Hs[8]*Hs[29])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2519321]=(Pssp*pow(zbar,rrho)*(Hs[14]*Hs[24] + Hs[8]*Hs[30])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2543897]=(Pssp*pow(zbar,rrho)*(Hs[15]*Hs[24] + Hs[8]*Hs[31])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2593049]=(Pssp*pow(zbar,rrho)*Hs[9]*Hs[25]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2617625]=(Pssp*pow(zbar,rrho)*(Hs[10]*Hs[25] + Hs[9]*Hs[26])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2642201]=(Pssp*pow(zbar,rrho)*(Hs[11]*Hs[25] + Hs[9]*Hs[27])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2666777]=(Pssp*pow(zbar,rrho)*(Hs[12]*Hs[25] + Hs[9]*Hs[28])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2691353]=(Pssp*pow(zbar,rrho)*(Hs[13]*Hs[25] + Hs[9]*Hs[29])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2715929]=(Pssp*pow(zbar,rrho)*(Hs[14]*Hs[25] + Hs[9]*Hs[30])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2740505]=(Pssp*pow(zbar,rrho)*(Hs[15]*Hs[25] + Hs[9]*Hs[31])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2814233]=(Pssp*pow(zbar,rrho)*Hs[10]*Hs[26]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2838809]=(Pssp*pow(zbar,rrho)*(Hs[11]*Hs[26] + Hs[10]*Hs[27])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2863385]=(Pssp*pow(zbar,rrho)*(Hs[12]*Hs[26] + Hs[10]*Hs[28])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2887961]=(Pssp*pow(zbar,rrho)*(Hs[13]*Hs[26] + Hs[10]*Hs[29])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2912537]=(Pssp*pow(zbar,rrho)*(Hs[14]*Hs[26] + Hs[10]*Hs[30])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2937113]=(Pssp*pow(zbar,rrho)*(Hs[15]*Hs[26] + Hs[10]*Hs[31])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3035417]=(Pssp*pow(zbar,rrho)*Hs[11]*Hs[27]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3059993]=(Pssp*pow(zbar,rrho)*(Hs[12]*Hs[27] + Hs[11]*Hs[28])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3084569]=(Pssp*pow(zbar,rrho)*(Hs[13]*Hs[27] + Hs[11]*Hs[29])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3109145]=(Pssp*pow(zbar,rrho)*(Hs[14]*Hs[27] + Hs[11]*Hs[30])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3133721]=(Pssp*pow(zbar,rrho)*(Hs[15]*Hs[27] + Hs[11]*Hs[31])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3256601]=(Pssp*pow(zbar,rrho)*Hs[12]*Hs[28]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3281177]=(Pssp*pow(zbar,rrho)*(Hs[13]*Hs[28] + Hs[12]*Hs[29])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3305753]=(Pssp*pow(zbar,rrho)*(Hs[14]*Hs[28] + Hs[12]*Hs[30])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3330329]=(Pssp*pow(zbar,rrho)*(Hs[15]*Hs[28] + Hs[12]*Hs[31])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3477785]=(Pssp*pow(zbar,rrho)*Hs[13]*Hs[29]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3502361]=(Pssp*pow(zbar,rrho)*(Hs[14]*Hs[29] + Hs[13]*Hs[30])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3526937]=(Pssp*pow(zbar,rrho)*(Hs[15]*Hs[29] + Hs[13]*Hs[31])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3698969]=(Pssp*pow(zbar,rrho)*Hs[14]*Hs[30]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3723545]=(Pssp*pow(zbar,rrho)*(Hs[15]*Hs[30] + Hs[14]*Hs[31])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3920153]=(Pssp*pow(zbar,rrho)*Hs[15]*Hs[31]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[138522]=-Pssp;
	Mxx_sp_s[140059]=-Pssp;
	Mxx_sp_s[141596]=-Pssp;
	Mxx_sp_s[146205]=-Pssp;
	Mxx_sp_s[144670]=-Pssp;
	Mxx_sp_s[143135]=-Pssp;
	Mxx_sp_s[158496]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mxx_sp_s[1081632]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mxx_sp_s[1083168]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mxx_sp_s[1093920]=-(pow(E,yss[8])*Pssp);
	Mxx_sp_s[1095456]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxx_sp_s[1096992]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxx_sp_s[150817]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[152353]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[153889]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[1083169]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[1084705]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[1089313]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mxx_sp_s[1093921]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mxx_sp_s[1095457]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[1096993]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[150818]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[152354]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[1083170]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[1084706]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[1089314]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mxx_sp_s[1092386]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[1093922]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mxx_sp_s[1095458]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[1096994]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[147747]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[149283]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[150819]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[152355]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mxx_sp_s[153891]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[155427]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[156963]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[158499]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[1089315]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mxx_sp_s[1093923]=-(pow(E,yss[8])*Pssp);
	Mxx_sp_s[1095459]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mxx_sp_s[1096995]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mxx_sp_s[2371875]=(bbeta*pow(E,yss[8])*Pssp*Hs[8]*Hs[32]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2396451]=(bbeta*pow(E,yss[8])*Pssp*(Hs[9]*Hs[32] + Hs[8]*Hs[33])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2421027]=(bbeta*pow(E,yss[8])*Pssp*(Hs[10]*Hs[32] + Hs[8]*Hs[34])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2445603]=(bbeta*pow(E,yss[8])*Pssp*(Hs[11]*Hs[32] + Hs[8]*Hs[35])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2470179]=(bbeta*pow(E,yss[8])*Pssp*(Hs[12]*Hs[32] + Hs[8]*Hs[36])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2494755]=(bbeta*pow(E,yss[8])*Pssp*(Hs[13]*Hs[32] + Hs[8]*Hs[37])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2519331]=(bbeta*pow(E,yss[8])*Pssp*(Hs[14]*Hs[32] + Hs[8]*Hs[38])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2543907]=(bbeta*pow(E,yss[8])*Pssp*(Hs[15]*Hs[32] + Hs[8]*Hs[39])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2593059]=(bbeta*pow(E,yss[8])*Pssp*Hs[9]*Hs[33]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2617635]=(bbeta*pow(E,yss[8])*Pssp*(Hs[10]*Hs[33] + Hs[9]*Hs[34])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2642211]=(bbeta*pow(E,yss[8])*Pssp*(Hs[11]*Hs[33] + Hs[9]*Hs[35])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2666787]=(bbeta*pow(E,yss[8])*Pssp*(Hs[12]*Hs[33] + Hs[9]*Hs[36])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2691363]=(bbeta*pow(E,yss[8])*Pssp*(Hs[13]*Hs[33] + Hs[9]*Hs[37])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2715939]=(bbeta*pow(E,yss[8])*Pssp*(Hs[14]*Hs[33] + Hs[9]*Hs[38])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2740515]=(bbeta*pow(E,yss[8])*Pssp*(Hs[15]*Hs[33] + Hs[9]*Hs[39])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2814243]=(bbeta*pow(E,yss[8])*Pssp*Hs[10]*Hs[34]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2838819]=(bbeta*pow(E,yss[8])*Pssp*(Hs[11]*Hs[34] + Hs[10]*Hs[35])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2863395]=(bbeta*pow(E,yss[8])*Pssp*(Hs[12]*Hs[34] + Hs[10]*Hs[36])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2887971]=(bbeta*pow(E,yss[8])*Pssp*(Hs[13]*Hs[34] + Hs[10]*Hs[37])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2912547]=(bbeta*pow(E,yss[8])*Pssp*(Hs[14]*Hs[34] + Hs[10]*Hs[38])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2937123]=(bbeta*pow(E,yss[8])*Pssp*(Hs[15]*Hs[34] + Hs[10]*Hs[39])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3035427]=(bbeta*pow(E,yss[8])*Pssp*Hs[11]*Hs[35]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3060003]=(bbeta*pow(E,yss[8])*Pssp*(Hs[12]*Hs[35] + Hs[11]*Hs[36])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3084579]=(bbeta*pow(E,yss[8])*Pssp*(Hs[13]*Hs[35] + Hs[11]*Hs[37])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3109155]=(bbeta*pow(E,yss[8])*Pssp*(Hs[14]*Hs[35] + Hs[11]*Hs[38])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3133731]=(bbeta*pow(E,yss[8])*Pssp*(Hs[15]*Hs[35] + Hs[11]*Hs[39])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3256611]=(bbeta*pow(E,yss[8])*Pssp*Hs[12]*Hs[36]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3281187]=(bbeta*pow(E,yss[8])*Pssp*(Hs[13]*Hs[36] + Hs[12]*Hs[37])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3305763]=(bbeta*pow(E,yss[8])*Pssp*(Hs[14]*Hs[36] + Hs[12]*Hs[38])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3330339]=(bbeta*pow(E,yss[8])*Pssp*(Hs[15]*Hs[36] + Hs[12]*Hs[39])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3477795]=(bbeta*pow(E,yss[8])*Pssp*Hs[13]*Hs[37]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3502371]=(bbeta*pow(E,yss[8])*Pssp*(Hs[14]*Hs[37] + Hs[13]*Hs[38])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3526947]=(bbeta*pow(E,yss[8])*Pssp*(Hs[15]*Hs[37] + Hs[13]*Hs[39])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3698979]=(bbeta*pow(E,yss[8])*Pssp*Hs[14]*Hs[38]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3723555]=(bbeta*pow(E,yss[8])*Pssp*(Hs[15]*Hs[38] + Hs[14]*Hs[39])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3920163]=(bbeta*pow(E,yss[8])*Pssp*Hs[15]*Hs[39]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[147748]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mxx_sp_s[149284]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mxx_sp_s[150820]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mxx_sp_s[152356]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mxx_sp_s[153892]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mxx_sp_s[155428]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mxx_sp_s[156964]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mxx_sp_s[158500]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mxx_sp_s[1090852]=-(kkappa*Pssp*yss[9]);
	Mxx_sp_s[1093924]=pow(E,yss[8])*Pssp;
	Mxx_sp_s[1095460]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mxx_sp_s[1096996]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mxx_sp_s[2361124]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[8]*Hs[32]);
	Mxx_sp_s[2362660]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[8]*Hs[32];
	Mxx_sp_s[2365732]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[8]*Hs[32]);
	Mxx_sp_s[2371876]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[8]*Hs[32])/pow(zbar,rrho);
	Mxx_sp_s[2385700]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[9]*Hs[32] + Hs[8]*Hs[33]));
	Mxx_sp_s[2387236]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[9]*Hs[32] + Hs[8]*Hs[33]);
	Mxx_sp_s[2390308]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[9]*Hs[32] + Hs[8]*Hs[33]));
	Mxx_sp_s[2396452]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[9]*Hs[32] + Hs[8]*Hs[33]))/pow(zbar,rrho);
	Mxx_sp_s[2410276]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[10]*Hs[32] + Hs[8]*Hs[34]));
	Mxx_sp_s[2411812]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[10]*Hs[32] + Hs[8]*Hs[34]);
	Mxx_sp_s[2414884]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[10]*Hs[32] + Hs[8]*Hs[34]));
	Mxx_sp_s[2421028]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[10]*Hs[32] + Hs[8]*Hs[34]))/pow(zbar,rrho);
	Mxx_sp_s[2434852]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[11]*Hs[32] + Hs[8]*Hs[35]));
	Mxx_sp_s[2436388]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[11]*Hs[32] + Hs[8]*Hs[35]);
	Mxx_sp_s[2439460]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[11]*Hs[32] + Hs[8]*Hs[35]));
	Mxx_sp_s[2445604]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[11]*Hs[32] + Hs[8]*Hs[35]))/pow(zbar,rrho);
	Mxx_sp_s[2459428]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[12]*Hs[32] + Hs[8]*Hs[36]));
	Mxx_sp_s[2460964]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[12]*Hs[32] + Hs[8]*Hs[36]);
	Mxx_sp_s[2464036]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[12]*Hs[32] + Hs[8]*Hs[36]));
	Mxx_sp_s[2470180]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[12]*Hs[32] + Hs[8]*Hs[36]))/pow(zbar,rrho);
	Mxx_sp_s[2484004]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[13]*Hs[32] + Hs[8]*Hs[37]));
	Mxx_sp_s[2485540]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[13]*Hs[32] + Hs[8]*Hs[37]);
	Mxx_sp_s[2488612]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[13]*Hs[32] + Hs[8]*Hs[37]));
	Mxx_sp_s[2494756]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[13]*Hs[32] + Hs[8]*Hs[37]))/pow(zbar,rrho);
	Mxx_sp_s[2508580]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[14]*Hs[32] + Hs[8]*Hs[38]));
	Mxx_sp_s[2510116]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[14]*Hs[32] + Hs[8]*Hs[38]);
	Mxx_sp_s[2513188]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[14]*Hs[32] + Hs[8]*Hs[38]));
	Mxx_sp_s[2519332]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[14]*Hs[32] + Hs[8]*Hs[38]))/pow(zbar,rrho);
	Mxx_sp_s[2533156]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[32] + Hs[8]*Hs[39]));
	Mxx_sp_s[2534692]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[32] + Hs[8]*Hs[39]);
	Mxx_sp_s[2537764]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[15]*Hs[32] + Hs[8]*Hs[39]));
	Mxx_sp_s[2543908]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[15]*Hs[32] + Hs[8]*Hs[39]))/pow(zbar,rrho);
	Mxx_sp_s[2582308]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[9]*Hs[33]);
	Mxx_sp_s[2583844]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[9]*Hs[33];
	Mxx_sp_s[2586916]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[9]*Hs[33]);
	Mxx_sp_s[2593060]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[9]*Hs[33])/pow(zbar,rrho);
	Mxx_sp_s[2606884]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[10]*Hs[33] + Hs[9]*Hs[34]));
	Mxx_sp_s[2608420]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[10]*Hs[33] + Hs[9]*Hs[34]);
	Mxx_sp_s[2611492]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[10]*Hs[33] + Hs[9]*Hs[34]));
	Mxx_sp_s[2617636]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[10]*Hs[33] + Hs[9]*Hs[34]))/pow(zbar,rrho);
	Mxx_sp_s[2631460]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[11]*Hs[33] + Hs[9]*Hs[35]));
	Mxx_sp_s[2632996]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[11]*Hs[33] + Hs[9]*Hs[35]);
	Mxx_sp_s[2636068]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[11]*Hs[33] + Hs[9]*Hs[35]));
	Mxx_sp_s[2642212]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[11]*Hs[33] + Hs[9]*Hs[35]))/pow(zbar,rrho);
	Mxx_sp_s[2656036]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[12]*Hs[33] + Hs[9]*Hs[36]));
	Mxx_sp_s[2657572]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[12]*Hs[33] + Hs[9]*Hs[36]);
	Mxx_sp_s[2660644]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[12]*Hs[33] + Hs[9]*Hs[36]));
	Mxx_sp_s[2666788]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[12]*Hs[33] + Hs[9]*Hs[36]))/pow(zbar,rrho);
	Mxx_sp_s[2680612]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[13]*Hs[33] + Hs[9]*Hs[37]));
	Mxx_sp_s[2682148]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[13]*Hs[33] + Hs[9]*Hs[37]);
	Mxx_sp_s[2685220]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[13]*Hs[33] + Hs[9]*Hs[37]));
	Mxx_sp_s[2691364]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[13]*Hs[33] + Hs[9]*Hs[37]))/pow(zbar,rrho);
	Mxx_sp_s[2705188]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[14]*Hs[33] + Hs[9]*Hs[38]));
	Mxx_sp_s[2706724]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[14]*Hs[33] + Hs[9]*Hs[38]);
	Mxx_sp_s[2709796]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[14]*Hs[33] + Hs[9]*Hs[38]));
	Mxx_sp_s[2715940]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[14]*Hs[33] + Hs[9]*Hs[38]))/pow(zbar,rrho);
	Mxx_sp_s[2729764]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[33] + Hs[9]*Hs[39]));
	Mxx_sp_s[2731300]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[33] + Hs[9]*Hs[39]);
	Mxx_sp_s[2734372]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[15]*Hs[33] + Hs[9]*Hs[39]));
	Mxx_sp_s[2740516]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[15]*Hs[33] + Hs[9]*Hs[39]))/pow(zbar,rrho);
	Mxx_sp_s[2803492]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[10]*Hs[34]);
	Mxx_sp_s[2805028]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[10]*Hs[34];
	Mxx_sp_s[2808100]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[10]*Hs[34]);
	Mxx_sp_s[2814244]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[10]*Hs[34])/pow(zbar,rrho);
	Mxx_sp_s[2828068]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[11]*Hs[34] + Hs[10]*Hs[35]));
	Mxx_sp_s[2829604]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[11]*Hs[34] + Hs[10]*Hs[35]);
	Mxx_sp_s[2832676]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[11]*Hs[34] + Hs[10]*Hs[35]));
	Mxx_sp_s[2838820]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[11]*Hs[34] + Hs[10]*Hs[35]))/pow(zbar,rrho);
	Mxx_sp_s[2852644]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[12]*Hs[34] + Hs[10]*Hs[36]));
	Mxx_sp_s[2854180]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[12]*Hs[34] + Hs[10]*Hs[36]);
	Mxx_sp_s[2857252]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[12]*Hs[34] + Hs[10]*Hs[36]));
	Mxx_sp_s[2863396]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[12]*Hs[34] + Hs[10]*Hs[36]))/pow(zbar,rrho);
	Mxx_sp_s[2877220]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[13]*Hs[34] + Hs[10]*Hs[37]));
	Mxx_sp_s[2878756]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[13]*Hs[34] + Hs[10]*Hs[37]);
	Mxx_sp_s[2881828]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[13]*Hs[34] + Hs[10]*Hs[37]));
	Mxx_sp_s[2887972]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[13]*Hs[34] + Hs[10]*Hs[37]))/pow(zbar,rrho);
	Mxx_sp_s[2901796]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[14]*Hs[34] + Hs[10]*Hs[38]));
	Mxx_sp_s[2903332]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[14]*Hs[34] + Hs[10]*Hs[38]);
	Mxx_sp_s[2906404]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[14]*Hs[34] + Hs[10]*Hs[38]));
	Mxx_sp_s[2912548]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[14]*Hs[34] + Hs[10]*Hs[38]))/pow(zbar,rrho);
	Mxx_sp_s[2926372]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[34] + Hs[10]*Hs[39]));
	Mxx_sp_s[2927908]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[34] + Hs[10]*Hs[39]);
	Mxx_sp_s[2930980]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[15]*Hs[34] + Hs[10]*Hs[39]));
	Mxx_sp_s[2937124]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[15]*Hs[34] + Hs[10]*Hs[39]))/pow(zbar,rrho);
	Mxx_sp_s[3024676]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[11]*Hs[35]);
	Mxx_sp_s[3026212]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[11]*Hs[35];
	Mxx_sp_s[3029284]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[11]*Hs[35]);
	Mxx_sp_s[3035428]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[11]*Hs[35])/pow(zbar,rrho);
	Mxx_sp_s[3049252]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[12]*Hs[35] + Hs[11]*Hs[36]));
	Mxx_sp_s[3050788]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[12]*Hs[35] + Hs[11]*Hs[36]);
	Mxx_sp_s[3053860]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[12]*Hs[35] + Hs[11]*Hs[36]));
	Mxx_sp_s[3060004]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[12]*Hs[35] + Hs[11]*Hs[36]))/pow(zbar,rrho);
	Mxx_sp_s[3073828]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[13]*Hs[35] + Hs[11]*Hs[37]));
	Mxx_sp_s[3075364]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[13]*Hs[35] + Hs[11]*Hs[37]);
	Mxx_sp_s[3078436]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[13]*Hs[35] + Hs[11]*Hs[37]));
	Mxx_sp_s[3084580]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[13]*Hs[35] + Hs[11]*Hs[37]))/pow(zbar,rrho);
	Mxx_sp_s[3098404]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[14]*Hs[35] + Hs[11]*Hs[38]));
	Mxx_sp_s[3099940]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[14]*Hs[35] + Hs[11]*Hs[38]);
	Mxx_sp_s[3103012]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[14]*Hs[35] + Hs[11]*Hs[38]));
	Mxx_sp_s[3109156]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[14]*Hs[35] + Hs[11]*Hs[38]))/pow(zbar,rrho);
	Mxx_sp_s[3122980]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[35] + Hs[11]*Hs[39]));
	Mxx_sp_s[3124516]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[35] + Hs[11]*Hs[39]);
	Mxx_sp_s[3127588]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[15]*Hs[35] + Hs[11]*Hs[39]));
	Mxx_sp_s[3133732]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[15]*Hs[35] + Hs[11]*Hs[39]))/pow(zbar,rrho);
	Mxx_sp_s[3245860]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[12]*Hs[36]);
	Mxx_sp_s[3247396]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[12]*Hs[36];
	Mxx_sp_s[3250468]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[12]*Hs[36]);
	Mxx_sp_s[3256612]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[12]*Hs[36])/pow(zbar,rrho);
	Mxx_sp_s[3270436]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[13]*Hs[36] + Hs[12]*Hs[37]));
	Mxx_sp_s[3271972]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[13]*Hs[36] + Hs[12]*Hs[37]);
	Mxx_sp_s[3275044]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[13]*Hs[36] + Hs[12]*Hs[37]));
	Mxx_sp_s[3281188]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[13]*Hs[36] + Hs[12]*Hs[37]))/pow(zbar,rrho);
	Mxx_sp_s[3295012]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[14]*Hs[36] + Hs[12]*Hs[38]));
	Mxx_sp_s[3296548]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[14]*Hs[36] + Hs[12]*Hs[38]);
	Mxx_sp_s[3299620]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[14]*Hs[36] + Hs[12]*Hs[38]));
	Mxx_sp_s[3305764]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[14]*Hs[36] + Hs[12]*Hs[38]))/pow(zbar,rrho);
	Mxx_sp_s[3319588]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[36] + Hs[12]*Hs[39]));
	Mxx_sp_s[3321124]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[36] + Hs[12]*Hs[39]);
	Mxx_sp_s[3324196]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[15]*Hs[36] + Hs[12]*Hs[39]));
	Mxx_sp_s[3330340]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[15]*Hs[36] + Hs[12]*Hs[39]))/pow(zbar,rrho);
	Mxx_sp_s[3467044]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[13]*Hs[37]);
	Mxx_sp_s[3468580]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[13]*Hs[37];
	Mxx_sp_s[3471652]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[13]*Hs[37]);
	Mxx_sp_s[3477796]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[13]*Hs[37])/pow(zbar,rrho);
	Mxx_sp_s[3491620]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[14]*Hs[37] + Hs[13]*Hs[38]));
	Mxx_sp_s[3493156]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[14]*Hs[37] + Hs[13]*Hs[38]);
	Mxx_sp_s[3496228]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[14]*Hs[37] + Hs[13]*Hs[38]));
	Mxx_sp_s[3502372]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[14]*Hs[37] + Hs[13]*Hs[38]))/pow(zbar,rrho);
	Mxx_sp_s[3516196]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[37] + Hs[13]*Hs[39]));
	Mxx_sp_s[3517732]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[37] + Hs[13]*Hs[39]);
	Mxx_sp_s[3520804]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[15]*Hs[37] + Hs[13]*Hs[39]));
	Mxx_sp_s[3526948]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[15]*Hs[37] + Hs[13]*Hs[39]))/pow(zbar,rrho);
	Mxx_sp_s[3688228]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[14]*Hs[38]);
	Mxx_sp_s[3689764]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[14]*Hs[38];
	Mxx_sp_s[3692836]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[14]*Hs[38]);
	Mxx_sp_s[3698980]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[14]*Hs[38])/pow(zbar,rrho);
	Mxx_sp_s[3712804]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[38] + Hs[14]*Hs[39]));
	Mxx_sp_s[3714340]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[38] + Hs[14]*Hs[39]);
	Mxx_sp_s[3717412]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[15]*Hs[38] + Hs[14]*Hs[39]));
	Mxx_sp_s[3723556]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[15]*Hs[38] + Hs[14]*Hs[39]))/pow(zbar,rrho);
	Mxx_sp_s[3909412]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[15]*Hs[39]);
	Mxx_sp_s[3910948]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[15]*Hs[39];
	Mxx_sp_s[3914020]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[15]*Hs[39]);
	Mxx_sp_s[3920164]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[15]*Hs[39])/pow(zbar,rrho);
	Mxx_sp_s[147749]=iiota*Pssp*zbar;
	Mxx_sp_s[152357]=iiota*Pssp*zbar;
	Mxx_sp_s[1090853]=-Pssp;
	Mxx_sp_s[1083174]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mxx_sp_s[1092390]=-(pow(E,yss[7])*Pssp);
	Mxx_sp_s[1095462]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxx_sp_s[1096998]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxx_sp_s[149287]=-((Pssp*zbar)/(1 + yss[5]));
	Mxx_sp_s[150823]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[152359]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mxx_sp_s[153895]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mxx_sp_s[156967]=-(pow(E,yss[11])*ebar*Pssp);
	Mxx_sp_s[1081639]=-(pow(E,yss[0])*Pssp);
	Mxx_sp_s[1083175]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mxx_sp_s[1084711]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mxx_sp_s[1086247]=-(pow(E,yss[3])*Pssp);
	Mxx_sp_s[1089319]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mxx_sp_s[1092391]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mxx_sp_s[1095463]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxx_sp_s[1096999]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxx_sp_s[147752]=-(pow(E,xss[0])*Pssp*zbar);
	Mxx_sp_s[152360]=-(pow(E,xss[0])*Pssp*zbar);
	Mxx_sp_s[1086248]=pow(E,yss[3])*Pssp;
	Mxx_sp_s[1095464]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxx_sp_s[1097000]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxx_sp_s[147753]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxx_sp_s[149289]=(Pssp*zbar)/(1 + yss[5]);
	Mxx_sp_s[152361]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mxx_sp_s[153897]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxx_sp_s[1083177]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxx_sp_s[1084713]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxx_sp_s[1089321]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mxx_sp_s[1090857]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxx_sp_s[1092393]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxx_sp_s[1095465]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxx_sp_s[1097001]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxx_sp_s[1095466]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxx_sp_s[1097002]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxx_sp_s[149291]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mxx_sp_s[155435]=Pssp;
	Mxx_sp_s[1089323]=-Pssp;
	Mxx_sp_s[1095467]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxx_sp_s[1097003]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxx_sp_s[147756]=pow(E,xss[0])*Pssp;
	Mxx_sp_s[1087788]=-(pow(E,xss[0])*Pssp);
	Mxx_sp_s[150829]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[152365]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[153901]=pow(E,yss[2])*pbar*Pssp;
	Mxx_sp_s[1083181]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[1084717]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mxx_sp_s[1095469]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxx_sp_s[1097005]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxx_sp_s[1098541]=pow(E,yss[11])*Pssp;
	Mxx_sp_s[149294]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxx_sp_s[152366]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxx_sp_s[1095470]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxx_sp_s[1097006]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxx_sp_s[1098542]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mxx_sp_s[1100078]=Pssp;
	Mxx_sp_s[149295]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxx_sp_s[152367]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxx_sp_s[1095471]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxx_sp_s[1097007]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxx_sp_s[1098543]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mxx_sp_s[1101615]=Pssp;
	Mxx_sp_s[156976]=ebar*Pssp;
	Mxx_sp_s[1081648]=pow(E,yss[0] - yss[11])*Pssp;
	Mxx_sp_s[1086256]=pow(E,yss[3] - yss[11])*Pssp;
	Mxx_sp_s[1095472]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxx_sp_s[1097008]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxx_sp_s[1098544]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mxx_sp_s[1103152]=Pssp;
	Mxx_sp_s[147761]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[149297]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[150833]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[152369]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mxx_sp_s[153905]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[155441]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[156977]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[158513]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[1095473]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[1097009]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[1104689]=Pssp;
	Mxx_sp_s[2371889]=(Pssp*pow(zbar,rrho)*Hs[8]*Hs[32]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2396465]=(Pssp*pow(zbar,rrho)*(Hs[9]*Hs[32] + Hs[8]*Hs[33])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2421041]=(Pssp*pow(zbar,rrho)*(Hs[10]*Hs[32] + Hs[8]*Hs[34])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2445617]=(Pssp*pow(zbar,rrho)*(Hs[11]*Hs[32] + Hs[8]*Hs[35])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2470193]=(Pssp*pow(zbar,rrho)*(Hs[12]*Hs[32] + Hs[8]*Hs[36])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2494769]=(Pssp*pow(zbar,rrho)*(Hs[13]*Hs[32] + Hs[8]*Hs[37])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2519345]=(Pssp*pow(zbar,rrho)*(Hs[14]*Hs[32] + Hs[8]*Hs[38])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2543921]=(Pssp*pow(zbar,rrho)*(Hs[15]*Hs[32] + Hs[8]*Hs[39])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2593073]=(Pssp*pow(zbar,rrho)*Hs[9]*Hs[33]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2617649]=(Pssp*pow(zbar,rrho)*(Hs[10]*Hs[33] + Hs[9]*Hs[34])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2642225]=(Pssp*pow(zbar,rrho)*(Hs[11]*Hs[33] + Hs[9]*Hs[35])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2666801]=(Pssp*pow(zbar,rrho)*(Hs[12]*Hs[33] + Hs[9]*Hs[36])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2691377]=(Pssp*pow(zbar,rrho)*(Hs[13]*Hs[33] + Hs[9]*Hs[37])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2715953]=(Pssp*pow(zbar,rrho)*(Hs[14]*Hs[33] + Hs[9]*Hs[38])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2740529]=(Pssp*pow(zbar,rrho)*(Hs[15]*Hs[33] + Hs[9]*Hs[39])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2814257]=(Pssp*pow(zbar,rrho)*Hs[10]*Hs[34]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2838833]=(Pssp*pow(zbar,rrho)*(Hs[11]*Hs[34] + Hs[10]*Hs[35])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2863409]=(Pssp*pow(zbar,rrho)*(Hs[12]*Hs[34] + Hs[10]*Hs[36])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2887985]=(Pssp*pow(zbar,rrho)*(Hs[13]*Hs[34] + Hs[10]*Hs[37])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2912561]=(Pssp*pow(zbar,rrho)*(Hs[14]*Hs[34] + Hs[10]*Hs[38])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2937137]=(Pssp*pow(zbar,rrho)*(Hs[15]*Hs[34] + Hs[10]*Hs[39])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3035441]=(Pssp*pow(zbar,rrho)*Hs[11]*Hs[35]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3060017]=(Pssp*pow(zbar,rrho)*(Hs[12]*Hs[35] + Hs[11]*Hs[36])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3084593]=(Pssp*pow(zbar,rrho)*(Hs[13]*Hs[35] + Hs[11]*Hs[37])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3109169]=(Pssp*pow(zbar,rrho)*(Hs[14]*Hs[35] + Hs[11]*Hs[38])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3133745]=(Pssp*pow(zbar,rrho)*(Hs[15]*Hs[35] + Hs[11]*Hs[39])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3256625]=(Pssp*pow(zbar,rrho)*Hs[12]*Hs[36]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3281201]=(Pssp*pow(zbar,rrho)*(Hs[13]*Hs[36] + Hs[12]*Hs[37])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3305777]=(Pssp*pow(zbar,rrho)*(Hs[14]*Hs[36] + Hs[12]*Hs[38])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3330353]=(Pssp*pow(zbar,rrho)*(Hs[15]*Hs[36] + Hs[12]*Hs[39])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3477809]=(Pssp*pow(zbar,rrho)*Hs[13]*Hs[37]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3502385]=(Pssp*pow(zbar,rrho)*(Hs[14]*Hs[37] + Hs[13]*Hs[38])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3526961]=(Pssp*pow(zbar,rrho)*(Hs[15]*Hs[37] + Hs[13]*Hs[39])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3698993]=(Pssp*pow(zbar,rrho)*Hs[14]*Hs[38]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3723569]=(Pssp*pow(zbar,rrho)*(Hs[15]*Hs[38] + Hs[14]*Hs[39])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3920177]=(Pssp*pow(zbar,rrho)*Hs[15]*Hs[39]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[150834]=-Pssp;
	Mxx_sp_s[152371]=-Pssp;
	Mxx_sp_s[153908]=-Pssp;
	Mxx_sp_s[158517]=-Pssp;
	Mxx_sp_s[156982]=-Pssp;
	Mxx_sp_s[155447]=-Pssp;
	Mxx_sp_s[170808]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mxx_sp_s[1106232]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mxx_sp_s[1107768]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mxx_sp_s[1118520]=-(pow(E,yss[8])*Pssp);
	Mxx_sp_s[1120056]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxx_sp_s[1121592]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxx_sp_s[163129]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[164665]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[166201]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[1107769]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[1109305]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[1113913]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mxx_sp_s[1118521]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mxx_sp_s[1120057]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[1121593]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[163130]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[164666]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[1107770]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[1109306]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[1113914]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mxx_sp_s[1116986]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[1118522]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mxx_sp_s[1120058]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[1121594]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[160059]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[161595]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[163131]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[164667]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mxx_sp_s[166203]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[167739]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[169275]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[170811]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[1113915]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mxx_sp_s[1118523]=-(pow(E,yss[8])*Pssp);
	Mxx_sp_s[1120059]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mxx_sp_s[1121595]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mxx_sp_s[2371899]=(bbeta*pow(E,yss[8])*Pssp*Hs[8]*Hs[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2396475]=(bbeta*pow(E,yss[8])*Pssp*(Hs[9]*Hs[40] + Hs[8]*Hs[41])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2421051]=(bbeta*pow(E,yss[8])*Pssp*(Hs[10]*Hs[40] + Hs[8]*Hs[42])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2445627]=(bbeta*pow(E,yss[8])*Pssp*(Hs[11]*Hs[40] + Hs[8]*Hs[43])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2470203]=(bbeta*pow(E,yss[8])*Pssp*(Hs[12]*Hs[40] + Hs[8]*Hs[44])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2494779]=(bbeta*pow(E,yss[8])*Pssp*(Hs[13]*Hs[40] + Hs[8]*Hs[45])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2519355]=(bbeta*pow(E,yss[8])*Pssp*(Hs[14]*Hs[40] + Hs[8]*Hs[46])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2543931]=(bbeta*pow(E,yss[8])*Pssp*(Hs[15]*Hs[40] + Hs[8]*Hs[47])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2593083]=(bbeta*pow(E,yss[8])*Pssp*Hs[9]*Hs[41]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2617659]=(bbeta*pow(E,yss[8])*Pssp*(Hs[10]*Hs[41] + Hs[9]*Hs[42])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2642235]=(bbeta*pow(E,yss[8])*Pssp*(Hs[11]*Hs[41] + Hs[9]*Hs[43])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2666811]=(bbeta*pow(E,yss[8])*Pssp*(Hs[12]*Hs[41] + Hs[9]*Hs[44])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2691387]=(bbeta*pow(E,yss[8])*Pssp*(Hs[13]*Hs[41] + Hs[9]*Hs[45])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2715963]=(bbeta*pow(E,yss[8])*Pssp*(Hs[14]*Hs[41] + Hs[9]*Hs[46])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2740539]=(bbeta*pow(E,yss[8])*Pssp*(Hs[15]*Hs[41] + Hs[9]*Hs[47])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2814267]=(bbeta*pow(E,yss[8])*Pssp*Hs[10]*Hs[42]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2838843]=(bbeta*pow(E,yss[8])*Pssp*(Hs[11]*Hs[42] + Hs[10]*Hs[43])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2863419]=(bbeta*pow(E,yss[8])*Pssp*(Hs[12]*Hs[42] + Hs[10]*Hs[44])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2887995]=(bbeta*pow(E,yss[8])*Pssp*(Hs[13]*Hs[42] + Hs[10]*Hs[45])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2912571]=(bbeta*pow(E,yss[8])*Pssp*(Hs[14]*Hs[42] + Hs[10]*Hs[46])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2937147]=(bbeta*pow(E,yss[8])*Pssp*(Hs[15]*Hs[42] + Hs[10]*Hs[47])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3035451]=(bbeta*pow(E,yss[8])*Pssp*Hs[11]*Hs[43]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3060027]=(bbeta*pow(E,yss[8])*Pssp*(Hs[12]*Hs[43] + Hs[11]*Hs[44])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3084603]=(bbeta*pow(E,yss[8])*Pssp*(Hs[13]*Hs[43] + Hs[11]*Hs[45])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3109179]=(bbeta*pow(E,yss[8])*Pssp*(Hs[14]*Hs[43] + Hs[11]*Hs[46])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3133755]=(bbeta*pow(E,yss[8])*Pssp*(Hs[15]*Hs[43] + Hs[11]*Hs[47])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3256635]=(bbeta*pow(E,yss[8])*Pssp*Hs[12]*Hs[44]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3281211]=(bbeta*pow(E,yss[8])*Pssp*(Hs[13]*Hs[44] + Hs[12]*Hs[45])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3305787]=(bbeta*pow(E,yss[8])*Pssp*(Hs[14]*Hs[44] + Hs[12]*Hs[46])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3330363]=(bbeta*pow(E,yss[8])*Pssp*(Hs[15]*Hs[44] + Hs[12]*Hs[47])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3477819]=(bbeta*pow(E,yss[8])*Pssp*Hs[13]*Hs[45]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3502395]=(bbeta*pow(E,yss[8])*Pssp*(Hs[14]*Hs[45] + Hs[13]*Hs[46])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3526971]=(bbeta*pow(E,yss[8])*Pssp*(Hs[15]*Hs[45] + Hs[13]*Hs[47])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3699003]=(bbeta*pow(E,yss[8])*Pssp*Hs[14]*Hs[46]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3723579]=(bbeta*pow(E,yss[8])*Pssp*(Hs[15]*Hs[46] + Hs[14]*Hs[47])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3920187]=(bbeta*pow(E,yss[8])*Pssp*Hs[15]*Hs[47]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[160060]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mxx_sp_s[161596]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mxx_sp_s[163132]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mxx_sp_s[164668]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mxx_sp_s[166204]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mxx_sp_s[167740]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mxx_sp_s[169276]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mxx_sp_s[170812]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mxx_sp_s[1115452]=-(kkappa*Pssp*yss[9]);
	Mxx_sp_s[1118524]=pow(E,yss[8])*Pssp;
	Mxx_sp_s[1120060]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mxx_sp_s[1121596]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mxx_sp_s[2361148]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[8]*Hs[40]);
	Mxx_sp_s[2362684]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[8]*Hs[40];
	Mxx_sp_s[2365756]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[8]*Hs[40]);
	Mxx_sp_s[2371900]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[8]*Hs[40])/pow(zbar,rrho);
	Mxx_sp_s[2385724]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[9]*Hs[40] + Hs[8]*Hs[41]));
	Mxx_sp_s[2387260]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[9]*Hs[40] + Hs[8]*Hs[41]);
	Mxx_sp_s[2390332]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[9]*Hs[40] + Hs[8]*Hs[41]));
	Mxx_sp_s[2396476]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[9]*Hs[40] + Hs[8]*Hs[41]))/pow(zbar,rrho);
	Mxx_sp_s[2410300]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[10]*Hs[40] + Hs[8]*Hs[42]));
	Mxx_sp_s[2411836]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[10]*Hs[40] + Hs[8]*Hs[42]);
	Mxx_sp_s[2414908]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[10]*Hs[40] + Hs[8]*Hs[42]));
	Mxx_sp_s[2421052]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[10]*Hs[40] + Hs[8]*Hs[42]))/pow(zbar,rrho);
	Mxx_sp_s[2434876]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[11]*Hs[40] + Hs[8]*Hs[43]));
	Mxx_sp_s[2436412]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[11]*Hs[40] + Hs[8]*Hs[43]);
	Mxx_sp_s[2439484]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[11]*Hs[40] + Hs[8]*Hs[43]));
	Mxx_sp_s[2445628]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[11]*Hs[40] + Hs[8]*Hs[43]))/pow(zbar,rrho);
	Mxx_sp_s[2459452]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[12]*Hs[40] + Hs[8]*Hs[44]));
	Mxx_sp_s[2460988]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[12]*Hs[40] + Hs[8]*Hs[44]);
	Mxx_sp_s[2464060]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[12]*Hs[40] + Hs[8]*Hs[44]));
	Mxx_sp_s[2470204]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[12]*Hs[40] + Hs[8]*Hs[44]))/pow(zbar,rrho);
	Mxx_sp_s[2484028]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[13]*Hs[40] + Hs[8]*Hs[45]));
	Mxx_sp_s[2485564]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[13]*Hs[40] + Hs[8]*Hs[45]);
	Mxx_sp_s[2488636]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[13]*Hs[40] + Hs[8]*Hs[45]));
	Mxx_sp_s[2494780]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[13]*Hs[40] + Hs[8]*Hs[45]))/pow(zbar,rrho);
	Mxx_sp_s[2508604]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[14]*Hs[40] + Hs[8]*Hs[46]));
	Mxx_sp_s[2510140]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[14]*Hs[40] + Hs[8]*Hs[46]);
	Mxx_sp_s[2513212]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[14]*Hs[40] + Hs[8]*Hs[46]));
	Mxx_sp_s[2519356]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[14]*Hs[40] + Hs[8]*Hs[46]))/pow(zbar,rrho);
	Mxx_sp_s[2533180]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[40] + Hs[8]*Hs[47]));
	Mxx_sp_s[2534716]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[40] + Hs[8]*Hs[47]);
	Mxx_sp_s[2537788]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[15]*Hs[40] + Hs[8]*Hs[47]));
	Mxx_sp_s[2543932]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[15]*Hs[40] + Hs[8]*Hs[47]))/pow(zbar,rrho);
	Mxx_sp_s[2582332]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[9]*Hs[41]);
	Mxx_sp_s[2583868]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[9]*Hs[41];
	Mxx_sp_s[2586940]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[9]*Hs[41]);
	Mxx_sp_s[2593084]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[9]*Hs[41])/pow(zbar,rrho);
	Mxx_sp_s[2606908]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[10]*Hs[41] + Hs[9]*Hs[42]));
	Mxx_sp_s[2608444]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[10]*Hs[41] + Hs[9]*Hs[42]);
	Mxx_sp_s[2611516]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[10]*Hs[41] + Hs[9]*Hs[42]));
	Mxx_sp_s[2617660]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[10]*Hs[41] + Hs[9]*Hs[42]))/pow(zbar,rrho);
	Mxx_sp_s[2631484]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[11]*Hs[41] + Hs[9]*Hs[43]));
	Mxx_sp_s[2633020]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[11]*Hs[41] + Hs[9]*Hs[43]);
	Mxx_sp_s[2636092]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[11]*Hs[41] + Hs[9]*Hs[43]));
	Mxx_sp_s[2642236]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[11]*Hs[41] + Hs[9]*Hs[43]))/pow(zbar,rrho);
	Mxx_sp_s[2656060]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[12]*Hs[41] + Hs[9]*Hs[44]));
	Mxx_sp_s[2657596]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[12]*Hs[41] + Hs[9]*Hs[44]);
	Mxx_sp_s[2660668]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[12]*Hs[41] + Hs[9]*Hs[44]));
	Mxx_sp_s[2666812]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[12]*Hs[41] + Hs[9]*Hs[44]))/pow(zbar,rrho);
	Mxx_sp_s[2680636]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[13]*Hs[41] + Hs[9]*Hs[45]));
	Mxx_sp_s[2682172]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[13]*Hs[41] + Hs[9]*Hs[45]);
	Mxx_sp_s[2685244]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[13]*Hs[41] + Hs[9]*Hs[45]));
	Mxx_sp_s[2691388]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[13]*Hs[41] + Hs[9]*Hs[45]))/pow(zbar,rrho);
	Mxx_sp_s[2705212]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[14]*Hs[41] + Hs[9]*Hs[46]));
	Mxx_sp_s[2706748]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[14]*Hs[41] + Hs[9]*Hs[46]);
	Mxx_sp_s[2709820]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[14]*Hs[41] + Hs[9]*Hs[46]));
	Mxx_sp_s[2715964]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[14]*Hs[41] + Hs[9]*Hs[46]))/pow(zbar,rrho);
	Mxx_sp_s[2729788]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[41] + Hs[9]*Hs[47]));
	Mxx_sp_s[2731324]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[41] + Hs[9]*Hs[47]);
	Mxx_sp_s[2734396]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[15]*Hs[41] + Hs[9]*Hs[47]));
	Mxx_sp_s[2740540]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[15]*Hs[41] + Hs[9]*Hs[47]))/pow(zbar,rrho);
	Mxx_sp_s[2803516]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[10]*Hs[42]);
	Mxx_sp_s[2805052]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[10]*Hs[42];
	Mxx_sp_s[2808124]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[10]*Hs[42]);
	Mxx_sp_s[2814268]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[10]*Hs[42])/pow(zbar,rrho);
	Mxx_sp_s[2828092]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[11]*Hs[42] + Hs[10]*Hs[43]));
	Mxx_sp_s[2829628]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[11]*Hs[42] + Hs[10]*Hs[43]);
	Mxx_sp_s[2832700]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[11]*Hs[42] + Hs[10]*Hs[43]));
	Mxx_sp_s[2838844]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[11]*Hs[42] + Hs[10]*Hs[43]))/pow(zbar,rrho);
	Mxx_sp_s[2852668]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[12]*Hs[42] + Hs[10]*Hs[44]));
	Mxx_sp_s[2854204]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[12]*Hs[42] + Hs[10]*Hs[44]);
	Mxx_sp_s[2857276]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[12]*Hs[42] + Hs[10]*Hs[44]));
	Mxx_sp_s[2863420]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[12]*Hs[42] + Hs[10]*Hs[44]))/pow(zbar,rrho);
	Mxx_sp_s[2877244]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[13]*Hs[42] + Hs[10]*Hs[45]));
	Mxx_sp_s[2878780]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[13]*Hs[42] + Hs[10]*Hs[45]);
	Mxx_sp_s[2881852]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[13]*Hs[42] + Hs[10]*Hs[45]));
	Mxx_sp_s[2887996]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[13]*Hs[42] + Hs[10]*Hs[45]))/pow(zbar,rrho);
	Mxx_sp_s[2901820]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[14]*Hs[42] + Hs[10]*Hs[46]));
	Mxx_sp_s[2903356]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[14]*Hs[42] + Hs[10]*Hs[46]);
	Mxx_sp_s[2906428]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[14]*Hs[42] + Hs[10]*Hs[46]));
	Mxx_sp_s[2912572]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[14]*Hs[42] + Hs[10]*Hs[46]))/pow(zbar,rrho);
	Mxx_sp_s[2926396]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[42] + Hs[10]*Hs[47]));
	Mxx_sp_s[2927932]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[42] + Hs[10]*Hs[47]);
	Mxx_sp_s[2931004]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[15]*Hs[42] + Hs[10]*Hs[47]));
	Mxx_sp_s[2937148]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[15]*Hs[42] + Hs[10]*Hs[47]))/pow(zbar,rrho);
	Mxx_sp_s[3024700]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[11]*Hs[43]);
	Mxx_sp_s[3026236]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[11]*Hs[43];
	Mxx_sp_s[3029308]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[11]*Hs[43]);
	Mxx_sp_s[3035452]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[11]*Hs[43])/pow(zbar,rrho);
	Mxx_sp_s[3049276]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[12]*Hs[43] + Hs[11]*Hs[44]));
	Mxx_sp_s[3050812]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[12]*Hs[43] + Hs[11]*Hs[44]);
	Mxx_sp_s[3053884]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[12]*Hs[43] + Hs[11]*Hs[44]));
	Mxx_sp_s[3060028]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[12]*Hs[43] + Hs[11]*Hs[44]))/pow(zbar,rrho);
	Mxx_sp_s[3073852]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[13]*Hs[43] + Hs[11]*Hs[45]));
	Mxx_sp_s[3075388]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[13]*Hs[43] + Hs[11]*Hs[45]);
	Mxx_sp_s[3078460]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[13]*Hs[43] + Hs[11]*Hs[45]));
	Mxx_sp_s[3084604]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[13]*Hs[43] + Hs[11]*Hs[45]))/pow(zbar,rrho);
	Mxx_sp_s[3098428]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[14]*Hs[43] + Hs[11]*Hs[46]));
	Mxx_sp_s[3099964]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[14]*Hs[43] + Hs[11]*Hs[46]);
	Mxx_sp_s[3103036]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[14]*Hs[43] + Hs[11]*Hs[46]));
	Mxx_sp_s[3109180]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[14]*Hs[43] + Hs[11]*Hs[46]))/pow(zbar,rrho);
	Mxx_sp_s[3123004]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[43] + Hs[11]*Hs[47]));
	Mxx_sp_s[3124540]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[43] + Hs[11]*Hs[47]);
	Mxx_sp_s[3127612]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[15]*Hs[43] + Hs[11]*Hs[47]));
	Mxx_sp_s[3133756]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[15]*Hs[43] + Hs[11]*Hs[47]))/pow(zbar,rrho);
	Mxx_sp_s[3245884]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[12]*Hs[44]);
	Mxx_sp_s[3247420]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[12]*Hs[44];
	Mxx_sp_s[3250492]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[12]*Hs[44]);
	Mxx_sp_s[3256636]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[12]*Hs[44])/pow(zbar,rrho);
	Mxx_sp_s[3270460]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[13]*Hs[44] + Hs[12]*Hs[45]));
	Mxx_sp_s[3271996]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[13]*Hs[44] + Hs[12]*Hs[45]);
	Mxx_sp_s[3275068]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[13]*Hs[44] + Hs[12]*Hs[45]));
	Mxx_sp_s[3281212]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[13]*Hs[44] + Hs[12]*Hs[45]))/pow(zbar,rrho);
	Mxx_sp_s[3295036]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[14]*Hs[44] + Hs[12]*Hs[46]));
	Mxx_sp_s[3296572]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[14]*Hs[44] + Hs[12]*Hs[46]);
	Mxx_sp_s[3299644]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[14]*Hs[44] + Hs[12]*Hs[46]));
	Mxx_sp_s[3305788]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[14]*Hs[44] + Hs[12]*Hs[46]))/pow(zbar,rrho);
	Mxx_sp_s[3319612]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[44] + Hs[12]*Hs[47]));
	Mxx_sp_s[3321148]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[44] + Hs[12]*Hs[47]);
	Mxx_sp_s[3324220]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[15]*Hs[44] + Hs[12]*Hs[47]));
	Mxx_sp_s[3330364]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[15]*Hs[44] + Hs[12]*Hs[47]))/pow(zbar,rrho);
	Mxx_sp_s[3467068]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[13]*Hs[45]);
	Mxx_sp_s[3468604]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[13]*Hs[45];
	Mxx_sp_s[3471676]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[13]*Hs[45]);
	Mxx_sp_s[3477820]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[13]*Hs[45])/pow(zbar,rrho);
	Mxx_sp_s[3491644]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[14]*Hs[45] + Hs[13]*Hs[46]));
	Mxx_sp_s[3493180]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[14]*Hs[45] + Hs[13]*Hs[46]);
	Mxx_sp_s[3496252]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[14]*Hs[45] + Hs[13]*Hs[46]));
	Mxx_sp_s[3502396]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[14]*Hs[45] + Hs[13]*Hs[46]))/pow(zbar,rrho);
	Mxx_sp_s[3516220]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[45] + Hs[13]*Hs[47]));
	Mxx_sp_s[3517756]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[45] + Hs[13]*Hs[47]);
	Mxx_sp_s[3520828]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[15]*Hs[45] + Hs[13]*Hs[47]));
	Mxx_sp_s[3526972]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[15]*Hs[45] + Hs[13]*Hs[47]))/pow(zbar,rrho);
	Mxx_sp_s[3688252]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[14]*Hs[46]);
	Mxx_sp_s[3689788]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[14]*Hs[46];
	Mxx_sp_s[3692860]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[14]*Hs[46]);
	Mxx_sp_s[3699004]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[14]*Hs[46])/pow(zbar,rrho);
	Mxx_sp_s[3712828]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[46] + Hs[14]*Hs[47]));
	Mxx_sp_s[3714364]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[46] + Hs[14]*Hs[47]);
	Mxx_sp_s[3717436]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[15]*Hs[46] + Hs[14]*Hs[47]));
	Mxx_sp_s[3723580]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[15]*Hs[46] + Hs[14]*Hs[47]))/pow(zbar,rrho);
	Mxx_sp_s[3909436]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[15]*Hs[47]);
	Mxx_sp_s[3910972]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[15]*Hs[47];
	Mxx_sp_s[3914044]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[15]*Hs[47]);
	Mxx_sp_s[3920188]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[15]*Hs[47])/pow(zbar,rrho);
	Mxx_sp_s[160061]=iiota*Pssp*zbar;
	Mxx_sp_s[164669]=iiota*Pssp*zbar;
	Mxx_sp_s[1115453]=-Pssp;
	Mxx_sp_s[1107774]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mxx_sp_s[1116990]=-(pow(E,yss[7])*Pssp);
	Mxx_sp_s[1120062]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxx_sp_s[1121598]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxx_sp_s[161599]=-((Pssp*zbar)/(1 + yss[5]));
	Mxx_sp_s[163135]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[164671]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mxx_sp_s[166207]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mxx_sp_s[169279]=-(pow(E,yss[11])*ebar*Pssp);
	Mxx_sp_s[1106239]=-(pow(E,yss[0])*Pssp);
	Mxx_sp_s[1107775]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mxx_sp_s[1109311]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mxx_sp_s[1110847]=-(pow(E,yss[3])*Pssp);
	Mxx_sp_s[1113919]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mxx_sp_s[1116991]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mxx_sp_s[1120063]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxx_sp_s[1121599]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxx_sp_s[160064]=-(pow(E,xss[0])*Pssp*zbar);
	Mxx_sp_s[164672]=-(pow(E,xss[0])*Pssp*zbar);
	Mxx_sp_s[1110848]=pow(E,yss[3])*Pssp;
	Mxx_sp_s[1120064]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxx_sp_s[1121600]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxx_sp_s[160065]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxx_sp_s[161601]=(Pssp*zbar)/(1 + yss[5]);
	Mxx_sp_s[164673]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mxx_sp_s[166209]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxx_sp_s[1107777]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxx_sp_s[1109313]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxx_sp_s[1113921]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mxx_sp_s[1115457]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxx_sp_s[1116993]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxx_sp_s[1120065]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxx_sp_s[1121601]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxx_sp_s[1120066]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxx_sp_s[1121602]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxx_sp_s[161603]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mxx_sp_s[167747]=Pssp;
	Mxx_sp_s[1113923]=-Pssp;
	Mxx_sp_s[1120067]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxx_sp_s[1121603]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxx_sp_s[160068]=pow(E,xss[0])*Pssp;
	Mxx_sp_s[1112388]=-(pow(E,xss[0])*Pssp);
	Mxx_sp_s[163141]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[164677]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[166213]=pow(E,yss[2])*pbar*Pssp;
	Mxx_sp_s[1107781]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[1109317]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mxx_sp_s[1120069]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxx_sp_s[1121605]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxx_sp_s[1123141]=pow(E,yss[11])*Pssp;
	Mxx_sp_s[161606]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxx_sp_s[164678]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxx_sp_s[1120070]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxx_sp_s[1121606]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxx_sp_s[1123142]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mxx_sp_s[1124678]=Pssp;
	Mxx_sp_s[161607]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxx_sp_s[164679]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxx_sp_s[1120071]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxx_sp_s[1121607]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxx_sp_s[1123143]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mxx_sp_s[1126215]=Pssp;
	Mxx_sp_s[169288]=ebar*Pssp;
	Mxx_sp_s[1106248]=pow(E,yss[0] - yss[11])*Pssp;
	Mxx_sp_s[1110856]=pow(E,yss[3] - yss[11])*Pssp;
	Mxx_sp_s[1120072]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxx_sp_s[1121608]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxx_sp_s[1123144]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mxx_sp_s[1127752]=Pssp;
	Mxx_sp_s[160073]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[161609]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[163145]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[164681]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mxx_sp_s[166217]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[167753]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[169289]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[170825]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[1120073]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[1121609]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[1129289]=Pssp;
	Mxx_sp_s[2371913]=(Pssp*pow(zbar,rrho)*Hs[8]*Hs[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2396489]=(Pssp*pow(zbar,rrho)*(Hs[9]*Hs[40] + Hs[8]*Hs[41])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2421065]=(Pssp*pow(zbar,rrho)*(Hs[10]*Hs[40] + Hs[8]*Hs[42])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2445641]=(Pssp*pow(zbar,rrho)*(Hs[11]*Hs[40] + Hs[8]*Hs[43])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2470217]=(Pssp*pow(zbar,rrho)*(Hs[12]*Hs[40] + Hs[8]*Hs[44])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2494793]=(Pssp*pow(zbar,rrho)*(Hs[13]*Hs[40] + Hs[8]*Hs[45])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2519369]=(Pssp*pow(zbar,rrho)*(Hs[14]*Hs[40] + Hs[8]*Hs[46])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2543945]=(Pssp*pow(zbar,rrho)*(Hs[15]*Hs[40] + Hs[8]*Hs[47])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2593097]=(Pssp*pow(zbar,rrho)*Hs[9]*Hs[41]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2617673]=(Pssp*pow(zbar,rrho)*(Hs[10]*Hs[41] + Hs[9]*Hs[42])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2642249]=(Pssp*pow(zbar,rrho)*(Hs[11]*Hs[41] + Hs[9]*Hs[43])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2666825]=(Pssp*pow(zbar,rrho)*(Hs[12]*Hs[41] + Hs[9]*Hs[44])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2691401]=(Pssp*pow(zbar,rrho)*(Hs[13]*Hs[41] + Hs[9]*Hs[45])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2715977]=(Pssp*pow(zbar,rrho)*(Hs[14]*Hs[41] + Hs[9]*Hs[46])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2740553]=(Pssp*pow(zbar,rrho)*(Hs[15]*Hs[41] + Hs[9]*Hs[47])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2814281]=(Pssp*pow(zbar,rrho)*Hs[10]*Hs[42]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2838857]=(Pssp*pow(zbar,rrho)*(Hs[11]*Hs[42] + Hs[10]*Hs[43])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2863433]=(Pssp*pow(zbar,rrho)*(Hs[12]*Hs[42] + Hs[10]*Hs[44])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2888009]=(Pssp*pow(zbar,rrho)*(Hs[13]*Hs[42] + Hs[10]*Hs[45])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2912585]=(Pssp*pow(zbar,rrho)*(Hs[14]*Hs[42] + Hs[10]*Hs[46])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2937161]=(Pssp*pow(zbar,rrho)*(Hs[15]*Hs[42] + Hs[10]*Hs[47])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3035465]=(Pssp*pow(zbar,rrho)*Hs[11]*Hs[43]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3060041]=(Pssp*pow(zbar,rrho)*(Hs[12]*Hs[43] + Hs[11]*Hs[44])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3084617]=(Pssp*pow(zbar,rrho)*(Hs[13]*Hs[43] + Hs[11]*Hs[45])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3109193]=(Pssp*pow(zbar,rrho)*(Hs[14]*Hs[43] + Hs[11]*Hs[46])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3133769]=(Pssp*pow(zbar,rrho)*(Hs[15]*Hs[43] + Hs[11]*Hs[47])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3256649]=(Pssp*pow(zbar,rrho)*Hs[12]*Hs[44]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3281225]=(Pssp*pow(zbar,rrho)*(Hs[13]*Hs[44] + Hs[12]*Hs[45])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3305801]=(Pssp*pow(zbar,rrho)*(Hs[14]*Hs[44] + Hs[12]*Hs[46])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3330377]=(Pssp*pow(zbar,rrho)*(Hs[15]*Hs[44] + Hs[12]*Hs[47])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3477833]=(Pssp*pow(zbar,rrho)*Hs[13]*Hs[45]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3502409]=(Pssp*pow(zbar,rrho)*(Hs[14]*Hs[45] + Hs[13]*Hs[46])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3526985]=(Pssp*pow(zbar,rrho)*(Hs[15]*Hs[45] + Hs[13]*Hs[47])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3699017]=(Pssp*pow(zbar,rrho)*Hs[14]*Hs[46]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3723593]=(Pssp*pow(zbar,rrho)*(Hs[15]*Hs[46] + Hs[14]*Hs[47])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3920201]=(Pssp*pow(zbar,rrho)*Hs[15]*Hs[47]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[163146]=-Pssp;
	Mxx_sp_s[164683]=-Pssp;
	Mxx_sp_s[166220]=-Pssp;
	Mxx_sp_s[170829]=-Pssp;
	Mxx_sp_s[169294]=-Pssp;
	Mxx_sp_s[167759]=-Pssp;
	Mxx_sp_s[183120]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mxx_sp_s[1130832]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mxx_sp_s[1132368]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mxx_sp_s[1143120]=-(pow(E,yss[8])*Pssp);
	Mxx_sp_s[1144656]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxx_sp_s[1146192]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxx_sp_s[175441]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[176977]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[178513]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[1132369]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[1133905]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[1138513]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mxx_sp_s[1143121]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mxx_sp_s[1144657]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[1146193]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[175442]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[176978]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[1132370]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[1133906]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[1138514]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mxx_sp_s[1141586]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[1143122]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mxx_sp_s[1144658]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[1146194]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[172371]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[173907]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[175443]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[176979]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mxx_sp_s[178515]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[180051]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[181587]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[183123]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[1138515]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mxx_sp_s[1143123]=-(pow(E,yss[8])*Pssp);
	Mxx_sp_s[1144659]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mxx_sp_s[1146195]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mxx_sp_s[2371923]=(bbeta*pow(E,yss[8])*Pssp*Hs[8]*Hs[48]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2396499]=(bbeta*pow(E,yss[8])*Pssp*(Hs[9]*Hs[48] + Hs[8]*Hs[49])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2421075]=(bbeta*pow(E,yss[8])*Pssp*(Hs[10]*Hs[48] + Hs[8]*Hs[50])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2445651]=(bbeta*pow(E,yss[8])*Pssp*(Hs[11]*Hs[48] + Hs[8]*Hs[51])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2470227]=(bbeta*pow(E,yss[8])*Pssp*(Hs[12]*Hs[48] + Hs[8]*Hs[52])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2494803]=(bbeta*pow(E,yss[8])*Pssp*(Hs[13]*Hs[48] + Hs[8]*Hs[53])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2519379]=(bbeta*pow(E,yss[8])*Pssp*(Hs[14]*Hs[48] + Hs[8]*Hs[54])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2543955]=(bbeta*pow(E,yss[8])*Pssp*(Hs[15]*Hs[48] + Hs[8]*Hs[55])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2593107]=(bbeta*pow(E,yss[8])*Pssp*Hs[9]*Hs[49]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2617683]=(bbeta*pow(E,yss[8])*Pssp*(Hs[10]*Hs[49] + Hs[9]*Hs[50])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2642259]=(bbeta*pow(E,yss[8])*Pssp*(Hs[11]*Hs[49] + Hs[9]*Hs[51])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2666835]=(bbeta*pow(E,yss[8])*Pssp*(Hs[12]*Hs[49] + Hs[9]*Hs[52])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2691411]=(bbeta*pow(E,yss[8])*Pssp*(Hs[13]*Hs[49] + Hs[9]*Hs[53])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2715987]=(bbeta*pow(E,yss[8])*Pssp*(Hs[14]*Hs[49] + Hs[9]*Hs[54])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2740563]=(bbeta*pow(E,yss[8])*Pssp*(Hs[15]*Hs[49] + Hs[9]*Hs[55])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2814291]=(bbeta*pow(E,yss[8])*Pssp*Hs[10]*Hs[50]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2838867]=(bbeta*pow(E,yss[8])*Pssp*(Hs[11]*Hs[50] + Hs[10]*Hs[51])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2863443]=(bbeta*pow(E,yss[8])*Pssp*(Hs[12]*Hs[50] + Hs[10]*Hs[52])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2888019]=(bbeta*pow(E,yss[8])*Pssp*(Hs[13]*Hs[50] + Hs[10]*Hs[53])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2912595]=(bbeta*pow(E,yss[8])*Pssp*(Hs[14]*Hs[50] + Hs[10]*Hs[54])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2937171]=(bbeta*pow(E,yss[8])*Pssp*(Hs[15]*Hs[50] + Hs[10]*Hs[55])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3035475]=(bbeta*pow(E,yss[8])*Pssp*Hs[11]*Hs[51]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3060051]=(bbeta*pow(E,yss[8])*Pssp*(Hs[12]*Hs[51] + Hs[11]*Hs[52])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3084627]=(bbeta*pow(E,yss[8])*Pssp*(Hs[13]*Hs[51] + Hs[11]*Hs[53])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3109203]=(bbeta*pow(E,yss[8])*Pssp*(Hs[14]*Hs[51] + Hs[11]*Hs[54])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3133779]=(bbeta*pow(E,yss[8])*Pssp*(Hs[15]*Hs[51] + Hs[11]*Hs[55])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3256659]=(bbeta*pow(E,yss[8])*Pssp*Hs[12]*Hs[52]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3281235]=(bbeta*pow(E,yss[8])*Pssp*(Hs[13]*Hs[52] + Hs[12]*Hs[53])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3305811]=(bbeta*pow(E,yss[8])*Pssp*(Hs[14]*Hs[52] + Hs[12]*Hs[54])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3330387]=(bbeta*pow(E,yss[8])*Pssp*(Hs[15]*Hs[52] + Hs[12]*Hs[55])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3477843]=(bbeta*pow(E,yss[8])*Pssp*Hs[13]*Hs[53]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3502419]=(bbeta*pow(E,yss[8])*Pssp*(Hs[14]*Hs[53] + Hs[13]*Hs[54])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3526995]=(bbeta*pow(E,yss[8])*Pssp*(Hs[15]*Hs[53] + Hs[13]*Hs[55])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3699027]=(bbeta*pow(E,yss[8])*Pssp*Hs[14]*Hs[54]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3723603]=(bbeta*pow(E,yss[8])*Pssp*(Hs[15]*Hs[54] + Hs[14]*Hs[55])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3920211]=(bbeta*pow(E,yss[8])*Pssp*Hs[15]*Hs[55]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[172372]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mxx_sp_s[173908]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mxx_sp_s[175444]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mxx_sp_s[176980]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mxx_sp_s[178516]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mxx_sp_s[180052]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mxx_sp_s[181588]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mxx_sp_s[183124]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mxx_sp_s[1140052]=-(kkappa*Pssp*yss[9]);
	Mxx_sp_s[1143124]=pow(E,yss[8])*Pssp;
	Mxx_sp_s[1144660]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mxx_sp_s[1146196]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mxx_sp_s[2361172]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[8]*Hs[48]);
	Mxx_sp_s[2362708]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[8]*Hs[48];
	Mxx_sp_s[2365780]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[8]*Hs[48]);
	Mxx_sp_s[2371924]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[8]*Hs[48])/pow(zbar,rrho);
	Mxx_sp_s[2385748]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[9]*Hs[48] + Hs[8]*Hs[49]));
	Mxx_sp_s[2387284]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[9]*Hs[48] + Hs[8]*Hs[49]);
	Mxx_sp_s[2390356]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[9]*Hs[48] + Hs[8]*Hs[49]));
	Mxx_sp_s[2396500]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[9]*Hs[48] + Hs[8]*Hs[49]))/pow(zbar,rrho);
	Mxx_sp_s[2410324]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[10]*Hs[48] + Hs[8]*Hs[50]));
	Mxx_sp_s[2411860]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[10]*Hs[48] + Hs[8]*Hs[50]);
	Mxx_sp_s[2414932]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[10]*Hs[48] + Hs[8]*Hs[50]));
	Mxx_sp_s[2421076]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[10]*Hs[48] + Hs[8]*Hs[50]))/pow(zbar,rrho);
	Mxx_sp_s[2434900]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[11]*Hs[48] + Hs[8]*Hs[51]));
	Mxx_sp_s[2436436]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[11]*Hs[48] + Hs[8]*Hs[51]);
	Mxx_sp_s[2439508]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[11]*Hs[48] + Hs[8]*Hs[51]));
	Mxx_sp_s[2445652]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[11]*Hs[48] + Hs[8]*Hs[51]))/pow(zbar,rrho);
	Mxx_sp_s[2459476]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[12]*Hs[48] + Hs[8]*Hs[52]));
	Mxx_sp_s[2461012]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[12]*Hs[48] + Hs[8]*Hs[52]);
	Mxx_sp_s[2464084]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[12]*Hs[48] + Hs[8]*Hs[52]));
	Mxx_sp_s[2470228]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[12]*Hs[48] + Hs[8]*Hs[52]))/pow(zbar,rrho);
	Mxx_sp_s[2484052]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[13]*Hs[48] + Hs[8]*Hs[53]));
	Mxx_sp_s[2485588]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[13]*Hs[48] + Hs[8]*Hs[53]);
	Mxx_sp_s[2488660]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[13]*Hs[48] + Hs[8]*Hs[53]));
	Mxx_sp_s[2494804]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[13]*Hs[48] + Hs[8]*Hs[53]))/pow(zbar,rrho);
	Mxx_sp_s[2508628]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[14]*Hs[48] + Hs[8]*Hs[54]));
	Mxx_sp_s[2510164]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[14]*Hs[48] + Hs[8]*Hs[54]);
	Mxx_sp_s[2513236]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[14]*Hs[48] + Hs[8]*Hs[54]));
	Mxx_sp_s[2519380]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[14]*Hs[48] + Hs[8]*Hs[54]))/pow(zbar,rrho);
	Mxx_sp_s[2533204]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[48] + Hs[8]*Hs[55]));
	Mxx_sp_s[2534740]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[48] + Hs[8]*Hs[55]);
	Mxx_sp_s[2537812]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[15]*Hs[48] + Hs[8]*Hs[55]));
	Mxx_sp_s[2543956]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[15]*Hs[48] + Hs[8]*Hs[55]))/pow(zbar,rrho);
	Mxx_sp_s[2582356]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[9]*Hs[49]);
	Mxx_sp_s[2583892]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[9]*Hs[49];
	Mxx_sp_s[2586964]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[9]*Hs[49]);
	Mxx_sp_s[2593108]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[9]*Hs[49])/pow(zbar,rrho);
	Mxx_sp_s[2606932]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[10]*Hs[49] + Hs[9]*Hs[50]));
	Mxx_sp_s[2608468]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[10]*Hs[49] + Hs[9]*Hs[50]);
	Mxx_sp_s[2611540]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[10]*Hs[49] + Hs[9]*Hs[50]));
	Mxx_sp_s[2617684]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[10]*Hs[49] + Hs[9]*Hs[50]))/pow(zbar,rrho);
	Mxx_sp_s[2631508]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[11]*Hs[49] + Hs[9]*Hs[51]));
	Mxx_sp_s[2633044]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[11]*Hs[49] + Hs[9]*Hs[51]);
	Mxx_sp_s[2636116]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[11]*Hs[49] + Hs[9]*Hs[51]));
	Mxx_sp_s[2642260]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[11]*Hs[49] + Hs[9]*Hs[51]))/pow(zbar,rrho);
	Mxx_sp_s[2656084]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[12]*Hs[49] + Hs[9]*Hs[52]));
	Mxx_sp_s[2657620]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[12]*Hs[49] + Hs[9]*Hs[52]);
	Mxx_sp_s[2660692]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[12]*Hs[49] + Hs[9]*Hs[52]));
	Mxx_sp_s[2666836]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[12]*Hs[49] + Hs[9]*Hs[52]))/pow(zbar,rrho);
	Mxx_sp_s[2680660]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[13]*Hs[49] + Hs[9]*Hs[53]));
	Mxx_sp_s[2682196]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[13]*Hs[49] + Hs[9]*Hs[53]);
	Mxx_sp_s[2685268]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[13]*Hs[49] + Hs[9]*Hs[53]));
	Mxx_sp_s[2691412]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[13]*Hs[49] + Hs[9]*Hs[53]))/pow(zbar,rrho);
	Mxx_sp_s[2705236]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[14]*Hs[49] + Hs[9]*Hs[54]));
	Mxx_sp_s[2706772]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[14]*Hs[49] + Hs[9]*Hs[54]);
	Mxx_sp_s[2709844]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[14]*Hs[49] + Hs[9]*Hs[54]));
	Mxx_sp_s[2715988]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[14]*Hs[49] + Hs[9]*Hs[54]))/pow(zbar,rrho);
	Mxx_sp_s[2729812]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[49] + Hs[9]*Hs[55]));
	Mxx_sp_s[2731348]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[49] + Hs[9]*Hs[55]);
	Mxx_sp_s[2734420]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[15]*Hs[49] + Hs[9]*Hs[55]));
	Mxx_sp_s[2740564]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[15]*Hs[49] + Hs[9]*Hs[55]))/pow(zbar,rrho);
	Mxx_sp_s[2803540]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[10]*Hs[50]);
	Mxx_sp_s[2805076]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[10]*Hs[50];
	Mxx_sp_s[2808148]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[10]*Hs[50]);
	Mxx_sp_s[2814292]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[10]*Hs[50])/pow(zbar,rrho);
	Mxx_sp_s[2828116]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[11]*Hs[50] + Hs[10]*Hs[51]));
	Mxx_sp_s[2829652]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[11]*Hs[50] + Hs[10]*Hs[51]);
	Mxx_sp_s[2832724]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[11]*Hs[50] + Hs[10]*Hs[51]));
	Mxx_sp_s[2838868]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[11]*Hs[50] + Hs[10]*Hs[51]))/pow(zbar,rrho);
	Mxx_sp_s[2852692]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[12]*Hs[50] + Hs[10]*Hs[52]));
	Mxx_sp_s[2854228]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[12]*Hs[50] + Hs[10]*Hs[52]);
	Mxx_sp_s[2857300]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[12]*Hs[50] + Hs[10]*Hs[52]));
	Mxx_sp_s[2863444]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[12]*Hs[50] + Hs[10]*Hs[52]))/pow(zbar,rrho);
	Mxx_sp_s[2877268]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[13]*Hs[50] + Hs[10]*Hs[53]));
	Mxx_sp_s[2878804]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[13]*Hs[50] + Hs[10]*Hs[53]);
	Mxx_sp_s[2881876]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[13]*Hs[50] + Hs[10]*Hs[53]));
	Mxx_sp_s[2888020]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[13]*Hs[50] + Hs[10]*Hs[53]))/pow(zbar,rrho);
	Mxx_sp_s[2901844]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[14]*Hs[50] + Hs[10]*Hs[54]));
	Mxx_sp_s[2903380]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[14]*Hs[50] + Hs[10]*Hs[54]);
	Mxx_sp_s[2906452]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[14]*Hs[50] + Hs[10]*Hs[54]));
	Mxx_sp_s[2912596]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[14]*Hs[50] + Hs[10]*Hs[54]))/pow(zbar,rrho);
	Mxx_sp_s[2926420]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[50] + Hs[10]*Hs[55]));
	Mxx_sp_s[2927956]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[50] + Hs[10]*Hs[55]);
	Mxx_sp_s[2931028]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[15]*Hs[50] + Hs[10]*Hs[55]));
	Mxx_sp_s[2937172]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[15]*Hs[50] + Hs[10]*Hs[55]))/pow(zbar,rrho);
	Mxx_sp_s[3024724]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[11]*Hs[51]);
	Mxx_sp_s[3026260]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[11]*Hs[51];
	Mxx_sp_s[3029332]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[11]*Hs[51]);
	Mxx_sp_s[3035476]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[11]*Hs[51])/pow(zbar,rrho);
	Mxx_sp_s[3049300]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[12]*Hs[51] + Hs[11]*Hs[52]));
	Mxx_sp_s[3050836]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[12]*Hs[51] + Hs[11]*Hs[52]);
	Mxx_sp_s[3053908]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[12]*Hs[51] + Hs[11]*Hs[52]));
	Mxx_sp_s[3060052]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[12]*Hs[51] + Hs[11]*Hs[52]))/pow(zbar,rrho);
	Mxx_sp_s[3073876]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[13]*Hs[51] + Hs[11]*Hs[53]));
	Mxx_sp_s[3075412]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[13]*Hs[51] + Hs[11]*Hs[53]);
	Mxx_sp_s[3078484]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[13]*Hs[51] + Hs[11]*Hs[53]));
	Mxx_sp_s[3084628]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[13]*Hs[51] + Hs[11]*Hs[53]))/pow(zbar,rrho);
	Mxx_sp_s[3098452]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[14]*Hs[51] + Hs[11]*Hs[54]));
	Mxx_sp_s[3099988]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[14]*Hs[51] + Hs[11]*Hs[54]);
	Mxx_sp_s[3103060]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[14]*Hs[51] + Hs[11]*Hs[54]));
	Mxx_sp_s[3109204]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[14]*Hs[51] + Hs[11]*Hs[54]))/pow(zbar,rrho);
	Mxx_sp_s[3123028]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[51] + Hs[11]*Hs[55]));
	Mxx_sp_s[3124564]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[51] + Hs[11]*Hs[55]);
	Mxx_sp_s[3127636]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[15]*Hs[51] + Hs[11]*Hs[55]));
	Mxx_sp_s[3133780]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[15]*Hs[51] + Hs[11]*Hs[55]))/pow(zbar,rrho);
	Mxx_sp_s[3245908]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[12]*Hs[52]);
	Mxx_sp_s[3247444]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[12]*Hs[52];
	Mxx_sp_s[3250516]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[12]*Hs[52]);
	Mxx_sp_s[3256660]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[12]*Hs[52])/pow(zbar,rrho);
	Mxx_sp_s[3270484]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[13]*Hs[52] + Hs[12]*Hs[53]));
	Mxx_sp_s[3272020]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[13]*Hs[52] + Hs[12]*Hs[53]);
	Mxx_sp_s[3275092]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[13]*Hs[52] + Hs[12]*Hs[53]));
	Mxx_sp_s[3281236]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[13]*Hs[52] + Hs[12]*Hs[53]))/pow(zbar,rrho);
	Mxx_sp_s[3295060]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[14]*Hs[52] + Hs[12]*Hs[54]));
	Mxx_sp_s[3296596]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[14]*Hs[52] + Hs[12]*Hs[54]);
	Mxx_sp_s[3299668]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[14]*Hs[52] + Hs[12]*Hs[54]));
	Mxx_sp_s[3305812]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[14]*Hs[52] + Hs[12]*Hs[54]))/pow(zbar,rrho);
	Mxx_sp_s[3319636]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[52] + Hs[12]*Hs[55]));
	Mxx_sp_s[3321172]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[52] + Hs[12]*Hs[55]);
	Mxx_sp_s[3324244]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[15]*Hs[52] + Hs[12]*Hs[55]));
	Mxx_sp_s[3330388]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[15]*Hs[52] + Hs[12]*Hs[55]))/pow(zbar,rrho);
	Mxx_sp_s[3467092]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[13]*Hs[53]);
	Mxx_sp_s[3468628]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[13]*Hs[53];
	Mxx_sp_s[3471700]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[13]*Hs[53]);
	Mxx_sp_s[3477844]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[13]*Hs[53])/pow(zbar,rrho);
	Mxx_sp_s[3491668]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[14]*Hs[53] + Hs[13]*Hs[54]));
	Mxx_sp_s[3493204]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[14]*Hs[53] + Hs[13]*Hs[54]);
	Mxx_sp_s[3496276]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[14]*Hs[53] + Hs[13]*Hs[54]));
	Mxx_sp_s[3502420]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[14]*Hs[53] + Hs[13]*Hs[54]))/pow(zbar,rrho);
	Mxx_sp_s[3516244]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[53] + Hs[13]*Hs[55]));
	Mxx_sp_s[3517780]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[53] + Hs[13]*Hs[55]);
	Mxx_sp_s[3520852]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[15]*Hs[53] + Hs[13]*Hs[55]));
	Mxx_sp_s[3526996]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[15]*Hs[53] + Hs[13]*Hs[55]))/pow(zbar,rrho);
	Mxx_sp_s[3688276]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[14]*Hs[54]);
	Mxx_sp_s[3689812]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[14]*Hs[54];
	Mxx_sp_s[3692884]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[14]*Hs[54]);
	Mxx_sp_s[3699028]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[14]*Hs[54])/pow(zbar,rrho);
	Mxx_sp_s[3712852]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[54] + Hs[14]*Hs[55]));
	Mxx_sp_s[3714388]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[54] + Hs[14]*Hs[55]);
	Mxx_sp_s[3717460]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[15]*Hs[54] + Hs[14]*Hs[55]));
	Mxx_sp_s[3723604]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[15]*Hs[54] + Hs[14]*Hs[55]))/pow(zbar,rrho);
	Mxx_sp_s[3909460]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[15]*Hs[55]);
	Mxx_sp_s[3910996]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[15]*Hs[55];
	Mxx_sp_s[3914068]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[15]*Hs[55]);
	Mxx_sp_s[3920212]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[15]*Hs[55])/pow(zbar,rrho);
	Mxx_sp_s[172373]=iiota*Pssp*zbar;
	Mxx_sp_s[176981]=iiota*Pssp*zbar;
	Mxx_sp_s[1140053]=-Pssp;
	Mxx_sp_s[1132374]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mxx_sp_s[1141590]=-(pow(E,yss[7])*Pssp);
	Mxx_sp_s[1144662]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxx_sp_s[1146198]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxx_sp_s[173911]=-((Pssp*zbar)/(1 + yss[5]));
	Mxx_sp_s[175447]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[176983]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mxx_sp_s[178519]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mxx_sp_s[181591]=-(pow(E,yss[11])*ebar*Pssp);
	Mxx_sp_s[1130839]=-(pow(E,yss[0])*Pssp);
	Mxx_sp_s[1132375]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mxx_sp_s[1133911]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mxx_sp_s[1135447]=-(pow(E,yss[3])*Pssp);
	Mxx_sp_s[1138519]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mxx_sp_s[1141591]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mxx_sp_s[1144663]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxx_sp_s[1146199]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxx_sp_s[172376]=-(pow(E,xss[0])*Pssp*zbar);
	Mxx_sp_s[176984]=-(pow(E,xss[0])*Pssp*zbar);
	Mxx_sp_s[1135448]=pow(E,yss[3])*Pssp;
	Mxx_sp_s[1144664]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxx_sp_s[1146200]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxx_sp_s[172377]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxx_sp_s[173913]=(Pssp*zbar)/(1 + yss[5]);
	Mxx_sp_s[176985]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mxx_sp_s[178521]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxx_sp_s[1132377]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxx_sp_s[1133913]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxx_sp_s[1138521]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mxx_sp_s[1140057]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxx_sp_s[1141593]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxx_sp_s[1144665]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxx_sp_s[1146201]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxx_sp_s[1144666]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxx_sp_s[1146202]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxx_sp_s[173915]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mxx_sp_s[180059]=Pssp;
	Mxx_sp_s[1138523]=-Pssp;
	Mxx_sp_s[1144667]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxx_sp_s[1146203]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxx_sp_s[172380]=pow(E,xss[0])*Pssp;
	Mxx_sp_s[1136988]=-(pow(E,xss[0])*Pssp);
	Mxx_sp_s[175453]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[176989]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[178525]=pow(E,yss[2])*pbar*Pssp;
	Mxx_sp_s[1132381]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[1133917]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mxx_sp_s[1144669]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxx_sp_s[1146205]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxx_sp_s[1147741]=pow(E,yss[11])*Pssp;
	Mxx_sp_s[173918]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxx_sp_s[176990]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxx_sp_s[1144670]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxx_sp_s[1146206]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxx_sp_s[1147742]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mxx_sp_s[1149278]=Pssp;
	Mxx_sp_s[173919]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxx_sp_s[176991]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxx_sp_s[1144671]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxx_sp_s[1146207]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxx_sp_s[1147743]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mxx_sp_s[1150815]=Pssp;
	Mxx_sp_s[181600]=ebar*Pssp;
	Mxx_sp_s[1130848]=pow(E,yss[0] - yss[11])*Pssp;
	Mxx_sp_s[1135456]=pow(E,yss[3] - yss[11])*Pssp;
	Mxx_sp_s[1144672]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxx_sp_s[1146208]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxx_sp_s[1147744]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mxx_sp_s[1152352]=Pssp;
	Mxx_sp_s[172385]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[173921]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[175457]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[176993]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mxx_sp_s[178529]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[180065]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[181601]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[183137]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[1144673]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[1146209]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[1153889]=Pssp;
	Mxx_sp_s[2371937]=(Pssp*pow(zbar,rrho)*Hs[8]*Hs[48]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2396513]=(Pssp*pow(zbar,rrho)*(Hs[9]*Hs[48] + Hs[8]*Hs[49])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2421089]=(Pssp*pow(zbar,rrho)*(Hs[10]*Hs[48] + Hs[8]*Hs[50])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2445665]=(Pssp*pow(zbar,rrho)*(Hs[11]*Hs[48] + Hs[8]*Hs[51])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2470241]=(Pssp*pow(zbar,rrho)*(Hs[12]*Hs[48] + Hs[8]*Hs[52])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2494817]=(Pssp*pow(zbar,rrho)*(Hs[13]*Hs[48] + Hs[8]*Hs[53])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2519393]=(Pssp*pow(zbar,rrho)*(Hs[14]*Hs[48] + Hs[8]*Hs[54])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2543969]=(Pssp*pow(zbar,rrho)*(Hs[15]*Hs[48] + Hs[8]*Hs[55])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2593121]=(Pssp*pow(zbar,rrho)*Hs[9]*Hs[49]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2617697]=(Pssp*pow(zbar,rrho)*(Hs[10]*Hs[49] + Hs[9]*Hs[50])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2642273]=(Pssp*pow(zbar,rrho)*(Hs[11]*Hs[49] + Hs[9]*Hs[51])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2666849]=(Pssp*pow(zbar,rrho)*(Hs[12]*Hs[49] + Hs[9]*Hs[52])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2691425]=(Pssp*pow(zbar,rrho)*(Hs[13]*Hs[49] + Hs[9]*Hs[53])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2716001]=(Pssp*pow(zbar,rrho)*(Hs[14]*Hs[49] + Hs[9]*Hs[54])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2740577]=(Pssp*pow(zbar,rrho)*(Hs[15]*Hs[49] + Hs[9]*Hs[55])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2814305]=(Pssp*pow(zbar,rrho)*Hs[10]*Hs[50]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2838881]=(Pssp*pow(zbar,rrho)*(Hs[11]*Hs[50] + Hs[10]*Hs[51])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2863457]=(Pssp*pow(zbar,rrho)*(Hs[12]*Hs[50] + Hs[10]*Hs[52])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2888033]=(Pssp*pow(zbar,rrho)*(Hs[13]*Hs[50] + Hs[10]*Hs[53])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2912609]=(Pssp*pow(zbar,rrho)*(Hs[14]*Hs[50] + Hs[10]*Hs[54])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2937185]=(Pssp*pow(zbar,rrho)*(Hs[15]*Hs[50] + Hs[10]*Hs[55])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3035489]=(Pssp*pow(zbar,rrho)*Hs[11]*Hs[51]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3060065]=(Pssp*pow(zbar,rrho)*(Hs[12]*Hs[51] + Hs[11]*Hs[52])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3084641]=(Pssp*pow(zbar,rrho)*(Hs[13]*Hs[51] + Hs[11]*Hs[53])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3109217]=(Pssp*pow(zbar,rrho)*(Hs[14]*Hs[51] + Hs[11]*Hs[54])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3133793]=(Pssp*pow(zbar,rrho)*(Hs[15]*Hs[51] + Hs[11]*Hs[55])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3256673]=(Pssp*pow(zbar,rrho)*Hs[12]*Hs[52]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3281249]=(Pssp*pow(zbar,rrho)*(Hs[13]*Hs[52] + Hs[12]*Hs[53])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3305825]=(Pssp*pow(zbar,rrho)*(Hs[14]*Hs[52] + Hs[12]*Hs[54])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3330401]=(Pssp*pow(zbar,rrho)*(Hs[15]*Hs[52] + Hs[12]*Hs[55])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3477857]=(Pssp*pow(zbar,rrho)*Hs[13]*Hs[53]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3502433]=(Pssp*pow(zbar,rrho)*(Hs[14]*Hs[53] + Hs[13]*Hs[54])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3527009]=(Pssp*pow(zbar,rrho)*(Hs[15]*Hs[53] + Hs[13]*Hs[55])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3699041]=(Pssp*pow(zbar,rrho)*Hs[14]*Hs[54]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3723617]=(Pssp*pow(zbar,rrho)*(Hs[15]*Hs[54] + Hs[14]*Hs[55])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3920225]=(Pssp*pow(zbar,rrho)*Hs[15]*Hs[55]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[175458]=-Pssp;
	Mxx_sp_s[176995]=-Pssp;
	Mxx_sp_s[178532]=-Pssp;
	Mxx_sp_s[183141]=-Pssp;
	Mxx_sp_s[181606]=-Pssp;
	Mxx_sp_s[180071]=-Pssp;
	Mxx_sp_s[195432]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mxx_sp_s[1155432]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mxx_sp_s[1156968]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mxx_sp_s[1167720]=-(pow(E,yss[8])*Pssp);
	Mxx_sp_s[1169256]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxx_sp_s[1170792]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxx_sp_s[187753]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[189289]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[190825]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[1156969]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[1158505]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[1163113]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mxx_sp_s[1167721]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mxx_sp_s[1169257]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[1170793]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[187754]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[189290]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[1156970]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[1158506]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[1163114]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mxx_sp_s[1166186]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[1167722]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mxx_sp_s[1169258]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[1170794]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[184683]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[186219]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[187755]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[189291]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mxx_sp_s[190827]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[192363]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[193899]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[195435]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[1163115]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mxx_sp_s[1167723]=-(pow(E,yss[8])*Pssp);
	Mxx_sp_s[1169259]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mxx_sp_s[1170795]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mxx_sp_s[2371947]=(bbeta*pow(E,yss[8])*Pssp*Hs[8]*Hs[56]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2396523]=(bbeta*pow(E,yss[8])*Pssp*(Hs[9]*Hs[56] + Hs[8]*Hs[57])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2421099]=(bbeta*pow(E,yss[8])*Pssp*(Hs[10]*Hs[56] + Hs[8]*Hs[58])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2445675]=(bbeta*pow(E,yss[8])*Pssp*(Hs[11]*Hs[56] + Hs[8]*Hs[59])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2470251]=(bbeta*pow(E,yss[8])*Pssp*(Hs[12]*Hs[56] + Hs[8]*Hs[60])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2494827]=(bbeta*pow(E,yss[8])*Pssp*(Hs[13]*Hs[56] + Hs[8]*Hs[61])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2519403]=(bbeta*pow(E,yss[8])*Pssp*(Hs[14]*Hs[56] + Hs[8]*Hs[62])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2543979]=(bbeta*pow(E,yss[8])*Pssp*(Hs[15]*Hs[56] + Hs[8]*Hs[63])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2593131]=(bbeta*pow(E,yss[8])*Pssp*Hs[9]*Hs[57]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2617707]=(bbeta*pow(E,yss[8])*Pssp*(Hs[10]*Hs[57] + Hs[9]*Hs[58])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2642283]=(bbeta*pow(E,yss[8])*Pssp*(Hs[11]*Hs[57] + Hs[9]*Hs[59])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2666859]=(bbeta*pow(E,yss[8])*Pssp*(Hs[12]*Hs[57] + Hs[9]*Hs[60])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2691435]=(bbeta*pow(E,yss[8])*Pssp*(Hs[13]*Hs[57] + Hs[9]*Hs[61])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2716011]=(bbeta*pow(E,yss[8])*Pssp*(Hs[14]*Hs[57] + Hs[9]*Hs[62])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2740587]=(bbeta*pow(E,yss[8])*Pssp*(Hs[15]*Hs[57] + Hs[9]*Hs[63])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2814315]=(bbeta*pow(E,yss[8])*Pssp*Hs[10]*Hs[58]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2838891]=(bbeta*pow(E,yss[8])*Pssp*(Hs[11]*Hs[58] + Hs[10]*Hs[59])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2863467]=(bbeta*pow(E,yss[8])*Pssp*(Hs[12]*Hs[58] + Hs[10]*Hs[60])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2888043]=(bbeta*pow(E,yss[8])*Pssp*(Hs[13]*Hs[58] + Hs[10]*Hs[61])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2912619]=(bbeta*pow(E,yss[8])*Pssp*(Hs[14]*Hs[58] + Hs[10]*Hs[62])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2937195]=(bbeta*pow(E,yss[8])*Pssp*(Hs[15]*Hs[58] + Hs[10]*Hs[63])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3035499]=(bbeta*pow(E,yss[8])*Pssp*Hs[11]*Hs[59]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3060075]=(bbeta*pow(E,yss[8])*Pssp*(Hs[12]*Hs[59] + Hs[11]*Hs[60])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3084651]=(bbeta*pow(E,yss[8])*Pssp*(Hs[13]*Hs[59] + Hs[11]*Hs[61])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3109227]=(bbeta*pow(E,yss[8])*Pssp*(Hs[14]*Hs[59] + Hs[11]*Hs[62])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3133803]=(bbeta*pow(E,yss[8])*Pssp*(Hs[15]*Hs[59] + Hs[11]*Hs[63])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3256683]=(bbeta*pow(E,yss[8])*Pssp*Hs[12]*Hs[60]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3281259]=(bbeta*pow(E,yss[8])*Pssp*(Hs[13]*Hs[60] + Hs[12]*Hs[61])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3305835]=(bbeta*pow(E,yss[8])*Pssp*(Hs[14]*Hs[60] + Hs[12]*Hs[62])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3330411]=(bbeta*pow(E,yss[8])*Pssp*(Hs[15]*Hs[60] + Hs[12]*Hs[63])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3477867]=(bbeta*pow(E,yss[8])*Pssp*Hs[13]*Hs[61]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3502443]=(bbeta*pow(E,yss[8])*Pssp*(Hs[14]*Hs[61] + Hs[13]*Hs[62])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3527019]=(bbeta*pow(E,yss[8])*Pssp*(Hs[15]*Hs[61] + Hs[13]*Hs[63])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3699051]=(bbeta*pow(E,yss[8])*Pssp*Hs[14]*Hs[62]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3723627]=(bbeta*pow(E,yss[8])*Pssp*(Hs[15]*Hs[62] + Hs[14]*Hs[63])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3920235]=(bbeta*pow(E,yss[8])*Pssp*Hs[15]*Hs[63]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[184684]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mxx_sp_s[186220]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mxx_sp_s[187756]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mxx_sp_s[189292]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mxx_sp_s[190828]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mxx_sp_s[192364]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mxx_sp_s[193900]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mxx_sp_s[195436]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mxx_sp_s[1164652]=-(kkappa*Pssp*yss[9]);
	Mxx_sp_s[1167724]=pow(E,yss[8])*Pssp;
	Mxx_sp_s[1169260]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mxx_sp_s[1170796]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mxx_sp_s[2361196]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[8]*Hs[56]);
	Mxx_sp_s[2362732]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[8]*Hs[56];
	Mxx_sp_s[2365804]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[8]*Hs[56]);
	Mxx_sp_s[2371948]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[8]*Hs[56])/pow(zbar,rrho);
	Mxx_sp_s[2385772]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[9]*Hs[56] + Hs[8]*Hs[57]));
	Mxx_sp_s[2387308]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[9]*Hs[56] + Hs[8]*Hs[57]);
	Mxx_sp_s[2390380]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[9]*Hs[56] + Hs[8]*Hs[57]));
	Mxx_sp_s[2396524]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[9]*Hs[56] + Hs[8]*Hs[57]))/pow(zbar,rrho);
	Mxx_sp_s[2410348]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[10]*Hs[56] + Hs[8]*Hs[58]));
	Mxx_sp_s[2411884]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[10]*Hs[56] + Hs[8]*Hs[58]);
	Mxx_sp_s[2414956]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[10]*Hs[56] + Hs[8]*Hs[58]));
	Mxx_sp_s[2421100]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[10]*Hs[56] + Hs[8]*Hs[58]))/pow(zbar,rrho);
	Mxx_sp_s[2434924]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[11]*Hs[56] + Hs[8]*Hs[59]));
	Mxx_sp_s[2436460]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[11]*Hs[56] + Hs[8]*Hs[59]);
	Mxx_sp_s[2439532]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[11]*Hs[56] + Hs[8]*Hs[59]));
	Mxx_sp_s[2445676]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[11]*Hs[56] + Hs[8]*Hs[59]))/pow(zbar,rrho);
	Mxx_sp_s[2459500]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[12]*Hs[56] + Hs[8]*Hs[60]));
	Mxx_sp_s[2461036]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[12]*Hs[56] + Hs[8]*Hs[60]);
	Mxx_sp_s[2464108]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[12]*Hs[56] + Hs[8]*Hs[60]));
	Mxx_sp_s[2470252]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[12]*Hs[56] + Hs[8]*Hs[60]))/pow(zbar,rrho);
	Mxx_sp_s[2484076]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[13]*Hs[56] + Hs[8]*Hs[61]));
	Mxx_sp_s[2485612]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[13]*Hs[56] + Hs[8]*Hs[61]);
	Mxx_sp_s[2488684]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[13]*Hs[56] + Hs[8]*Hs[61]));
	Mxx_sp_s[2494828]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[13]*Hs[56] + Hs[8]*Hs[61]))/pow(zbar,rrho);
	Mxx_sp_s[2508652]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[14]*Hs[56] + Hs[8]*Hs[62]));
	Mxx_sp_s[2510188]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[14]*Hs[56] + Hs[8]*Hs[62]);
	Mxx_sp_s[2513260]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[14]*Hs[56] + Hs[8]*Hs[62]));
	Mxx_sp_s[2519404]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[14]*Hs[56] + Hs[8]*Hs[62]))/pow(zbar,rrho);
	Mxx_sp_s[2533228]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[56] + Hs[8]*Hs[63]));
	Mxx_sp_s[2534764]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[56] + Hs[8]*Hs[63]);
	Mxx_sp_s[2537836]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[15]*Hs[56] + Hs[8]*Hs[63]));
	Mxx_sp_s[2543980]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[15]*Hs[56] + Hs[8]*Hs[63]))/pow(zbar,rrho);
	Mxx_sp_s[2582380]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[9]*Hs[57]);
	Mxx_sp_s[2583916]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[9]*Hs[57];
	Mxx_sp_s[2586988]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[9]*Hs[57]);
	Mxx_sp_s[2593132]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[9]*Hs[57])/pow(zbar,rrho);
	Mxx_sp_s[2606956]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[10]*Hs[57] + Hs[9]*Hs[58]));
	Mxx_sp_s[2608492]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[10]*Hs[57] + Hs[9]*Hs[58]);
	Mxx_sp_s[2611564]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[10]*Hs[57] + Hs[9]*Hs[58]));
	Mxx_sp_s[2617708]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[10]*Hs[57] + Hs[9]*Hs[58]))/pow(zbar,rrho);
	Mxx_sp_s[2631532]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[11]*Hs[57] + Hs[9]*Hs[59]));
	Mxx_sp_s[2633068]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[11]*Hs[57] + Hs[9]*Hs[59]);
	Mxx_sp_s[2636140]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[11]*Hs[57] + Hs[9]*Hs[59]));
	Mxx_sp_s[2642284]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[11]*Hs[57] + Hs[9]*Hs[59]))/pow(zbar,rrho);
	Mxx_sp_s[2656108]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[12]*Hs[57] + Hs[9]*Hs[60]));
	Mxx_sp_s[2657644]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[12]*Hs[57] + Hs[9]*Hs[60]);
	Mxx_sp_s[2660716]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[12]*Hs[57] + Hs[9]*Hs[60]));
	Mxx_sp_s[2666860]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[12]*Hs[57] + Hs[9]*Hs[60]))/pow(zbar,rrho);
	Mxx_sp_s[2680684]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[13]*Hs[57] + Hs[9]*Hs[61]));
	Mxx_sp_s[2682220]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[13]*Hs[57] + Hs[9]*Hs[61]);
	Mxx_sp_s[2685292]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[13]*Hs[57] + Hs[9]*Hs[61]));
	Mxx_sp_s[2691436]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[13]*Hs[57] + Hs[9]*Hs[61]))/pow(zbar,rrho);
	Mxx_sp_s[2705260]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[14]*Hs[57] + Hs[9]*Hs[62]));
	Mxx_sp_s[2706796]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[14]*Hs[57] + Hs[9]*Hs[62]);
	Mxx_sp_s[2709868]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[14]*Hs[57] + Hs[9]*Hs[62]));
	Mxx_sp_s[2716012]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[14]*Hs[57] + Hs[9]*Hs[62]))/pow(zbar,rrho);
	Mxx_sp_s[2729836]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[57] + Hs[9]*Hs[63]));
	Mxx_sp_s[2731372]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[57] + Hs[9]*Hs[63]);
	Mxx_sp_s[2734444]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[15]*Hs[57] + Hs[9]*Hs[63]));
	Mxx_sp_s[2740588]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[15]*Hs[57] + Hs[9]*Hs[63]))/pow(zbar,rrho);
	Mxx_sp_s[2803564]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[10]*Hs[58]);
	Mxx_sp_s[2805100]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[10]*Hs[58];
	Mxx_sp_s[2808172]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[10]*Hs[58]);
	Mxx_sp_s[2814316]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[10]*Hs[58])/pow(zbar,rrho);
	Mxx_sp_s[2828140]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[11]*Hs[58] + Hs[10]*Hs[59]));
	Mxx_sp_s[2829676]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[11]*Hs[58] + Hs[10]*Hs[59]);
	Mxx_sp_s[2832748]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[11]*Hs[58] + Hs[10]*Hs[59]));
	Mxx_sp_s[2838892]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[11]*Hs[58] + Hs[10]*Hs[59]))/pow(zbar,rrho);
	Mxx_sp_s[2852716]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[12]*Hs[58] + Hs[10]*Hs[60]));
	Mxx_sp_s[2854252]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[12]*Hs[58] + Hs[10]*Hs[60]);
	Mxx_sp_s[2857324]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[12]*Hs[58] + Hs[10]*Hs[60]));
	Mxx_sp_s[2863468]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[12]*Hs[58] + Hs[10]*Hs[60]))/pow(zbar,rrho);
	Mxx_sp_s[2877292]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[13]*Hs[58] + Hs[10]*Hs[61]));
	Mxx_sp_s[2878828]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[13]*Hs[58] + Hs[10]*Hs[61]);
	Mxx_sp_s[2881900]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[13]*Hs[58] + Hs[10]*Hs[61]));
	Mxx_sp_s[2888044]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[13]*Hs[58] + Hs[10]*Hs[61]))/pow(zbar,rrho);
	Mxx_sp_s[2901868]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[14]*Hs[58] + Hs[10]*Hs[62]));
	Mxx_sp_s[2903404]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[14]*Hs[58] + Hs[10]*Hs[62]);
	Mxx_sp_s[2906476]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[14]*Hs[58] + Hs[10]*Hs[62]));
	Mxx_sp_s[2912620]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[14]*Hs[58] + Hs[10]*Hs[62]))/pow(zbar,rrho);
	Mxx_sp_s[2926444]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[58] + Hs[10]*Hs[63]));
	Mxx_sp_s[2927980]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[58] + Hs[10]*Hs[63]);
	Mxx_sp_s[2931052]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[15]*Hs[58] + Hs[10]*Hs[63]));
	Mxx_sp_s[2937196]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[15]*Hs[58] + Hs[10]*Hs[63]))/pow(zbar,rrho);
	Mxx_sp_s[3024748]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[11]*Hs[59]);
	Mxx_sp_s[3026284]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[11]*Hs[59];
	Mxx_sp_s[3029356]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[11]*Hs[59]);
	Mxx_sp_s[3035500]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[11]*Hs[59])/pow(zbar,rrho);
	Mxx_sp_s[3049324]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[12]*Hs[59] + Hs[11]*Hs[60]));
	Mxx_sp_s[3050860]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[12]*Hs[59] + Hs[11]*Hs[60]);
	Mxx_sp_s[3053932]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[12]*Hs[59] + Hs[11]*Hs[60]));
	Mxx_sp_s[3060076]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[12]*Hs[59] + Hs[11]*Hs[60]))/pow(zbar,rrho);
	Mxx_sp_s[3073900]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[13]*Hs[59] + Hs[11]*Hs[61]));
	Mxx_sp_s[3075436]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[13]*Hs[59] + Hs[11]*Hs[61]);
	Mxx_sp_s[3078508]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[13]*Hs[59] + Hs[11]*Hs[61]));
	Mxx_sp_s[3084652]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[13]*Hs[59] + Hs[11]*Hs[61]))/pow(zbar,rrho);
	Mxx_sp_s[3098476]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[14]*Hs[59] + Hs[11]*Hs[62]));
	Mxx_sp_s[3100012]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[14]*Hs[59] + Hs[11]*Hs[62]);
	Mxx_sp_s[3103084]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[14]*Hs[59] + Hs[11]*Hs[62]));
	Mxx_sp_s[3109228]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[14]*Hs[59] + Hs[11]*Hs[62]))/pow(zbar,rrho);
	Mxx_sp_s[3123052]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[59] + Hs[11]*Hs[63]));
	Mxx_sp_s[3124588]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[59] + Hs[11]*Hs[63]);
	Mxx_sp_s[3127660]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[15]*Hs[59] + Hs[11]*Hs[63]));
	Mxx_sp_s[3133804]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[15]*Hs[59] + Hs[11]*Hs[63]))/pow(zbar,rrho);
	Mxx_sp_s[3245932]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[12]*Hs[60]);
	Mxx_sp_s[3247468]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[12]*Hs[60];
	Mxx_sp_s[3250540]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[12]*Hs[60]);
	Mxx_sp_s[3256684]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[12]*Hs[60])/pow(zbar,rrho);
	Mxx_sp_s[3270508]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[13]*Hs[60] + Hs[12]*Hs[61]));
	Mxx_sp_s[3272044]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[13]*Hs[60] + Hs[12]*Hs[61]);
	Mxx_sp_s[3275116]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[13]*Hs[60] + Hs[12]*Hs[61]));
	Mxx_sp_s[3281260]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[13]*Hs[60] + Hs[12]*Hs[61]))/pow(zbar,rrho);
	Mxx_sp_s[3295084]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[14]*Hs[60] + Hs[12]*Hs[62]));
	Mxx_sp_s[3296620]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[14]*Hs[60] + Hs[12]*Hs[62]);
	Mxx_sp_s[3299692]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[14]*Hs[60] + Hs[12]*Hs[62]));
	Mxx_sp_s[3305836]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[14]*Hs[60] + Hs[12]*Hs[62]))/pow(zbar,rrho);
	Mxx_sp_s[3319660]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[60] + Hs[12]*Hs[63]));
	Mxx_sp_s[3321196]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[60] + Hs[12]*Hs[63]);
	Mxx_sp_s[3324268]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[15]*Hs[60] + Hs[12]*Hs[63]));
	Mxx_sp_s[3330412]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[15]*Hs[60] + Hs[12]*Hs[63]))/pow(zbar,rrho);
	Mxx_sp_s[3467116]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[13]*Hs[61]);
	Mxx_sp_s[3468652]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[13]*Hs[61];
	Mxx_sp_s[3471724]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[13]*Hs[61]);
	Mxx_sp_s[3477868]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[13]*Hs[61])/pow(zbar,rrho);
	Mxx_sp_s[3491692]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[14]*Hs[61] + Hs[13]*Hs[62]));
	Mxx_sp_s[3493228]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[14]*Hs[61] + Hs[13]*Hs[62]);
	Mxx_sp_s[3496300]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[14]*Hs[61] + Hs[13]*Hs[62]));
	Mxx_sp_s[3502444]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[14]*Hs[61] + Hs[13]*Hs[62]))/pow(zbar,rrho);
	Mxx_sp_s[3516268]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[61] + Hs[13]*Hs[63]));
	Mxx_sp_s[3517804]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[61] + Hs[13]*Hs[63]);
	Mxx_sp_s[3520876]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[15]*Hs[61] + Hs[13]*Hs[63]));
	Mxx_sp_s[3527020]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[15]*Hs[61] + Hs[13]*Hs[63]))/pow(zbar,rrho);
	Mxx_sp_s[3688300]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[14]*Hs[62]);
	Mxx_sp_s[3689836]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[14]*Hs[62];
	Mxx_sp_s[3692908]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[14]*Hs[62]);
	Mxx_sp_s[3699052]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[14]*Hs[62])/pow(zbar,rrho);
	Mxx_sp_s[3712876]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[62] + Hs[14]*Hs[63]));
	Mxx_sp_s[3714412]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[15]*Hs[62] + Hs[14]*Hs[63]);
	Mxx_sp_s[3717484]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[15]*Hs[62] + Hs[14]*Hs[63]));
	Mxx_sp_s[3723628]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[15]*Hs[62] + Hs[14]*Hs[63]))/pow(zbar,rrho);
	Mxx_sp_s[3909484]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[15]*Hs[63]);
	Mxx_sp_s[3911020]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[15]*Hs[63];
	Mxx_sp_s[3914092]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[15]*Hs[63]);
	Mxx_sp_s[3920236]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[15]*Hs[63])/pow(zbar,rrho);
	Mxx_sp_s[184685]=iiota*Pssp*zbar;
	Mxx_sp_s[189293]=iiota*Pssp*zbar;
	Mxx_sp_s[1164653]=-Pssp;
	Mxx_sp_s[1156974]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mxx_sp_s[1166190]=-(pow(E,yss[7])*Pssp);
	Mxx_sp_s[1169262]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxx_sp_s[1170798]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxx_sp_s[186223]=-((Pssp*zbar)/(1 + yss[5]));
	Mxx_sp_s[187759]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[189295]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mxx_sp_s[190831]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mxx_sp_s[193903]=-(pow(E,yss[11])*ebar*Pssp);
	Mxx_sp_s[1155439]=-(pow(E,yss[0])*Pssp);
	Mxx_sp_s[1156975]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mxx_sp_s[1158511]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mxx_sp_s[1160047]=-(pow(E,yss[3])*Pssp);
	Mxx_sp_s[1163119]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mxx_sp_s[1166191]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mxx_sp_s[1169263]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxx_sp_s[1170799]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxx_sp_s[184688]=-(pow(E,xss[0])*Pssp*zbar);
	Mxx_sp_s[189296]=-(pow(E,xss[0])*Pssp*zbar);
	Mxx_sp_s[1160048]=pow(E,yss[3])*Pssp;
	Mxx_sp_s[1169264]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxx_sp_s[1170800]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxx_sp_s[184689]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxx_sp_s[186225]=(Pssp*zbar)/(1 + yss[5]);
	Mxx_sp_s[189297]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mxx_sp_s[190833]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxx_sp_s[1156977]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxx_sp_s[1158513]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxx_sp_s[1163121]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mxx_sp_s[1164657]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxx_sp_s[1166193]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxx_sp_s[1169265]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxx_sp_s[1170801]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxx_sp_s[1169266]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxx_sp_s[1170802]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxx_sp_s[186227]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mxx_sp_s[192371]=Pssp;
	Mxx_sp_s[1163123]=-Pssp;
	Mxx_sp_s[1169267]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxx_sp_s[1170803]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxx_sp_s[184692]=pow(E,xss[0])*Pssp;
	Mxx_sp_s[1161588]=-(pow(E,xss[0])*Pssp);
	Mxx_sp_s[187765]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[189301]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[190837]=pow(E,yss[2])*pbar*Pssp;
	Mxx_sp_s[1156981]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[1158517]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mxx_sp_s[1169269]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxx_sp_s[1170805]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxx_sp_s[1172341]=pow(E,yss[11])*Pssp;
	Mxx_sp_s[186230]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxx_sp_s[189302]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxx_sp_s[1169270]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxx_sp_s[1170806]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxx_sp_s[1172342]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mxx_sp_s[1173878]=Pssp;
	Mxx_sp_s[186231]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxx_sp_s[189303]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxx_sp_s[1169271]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxx_sp_s[1170807]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxx_sp_s[1172343]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mxx_sp_s[1175415]=Pssp;
	Mxx_sp_s[193912]=ebar*Pssp;
	Mxx_sp_s[1155448]=pow(E,yss[0] - yss[11])*Pssp;
	Mxx_sp_s[1160056]=pow(E,yss[3] - yss[11])*Pssp;
	Mxx_sp_s[1169272]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxx_sp_s[1170808]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxx_sp_s[1172344]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mxx_sp_s[1176952]=Pssp;
	Mxx_sp_s[184697]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[186233]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[187769]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[189305]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mxx_sp_s[190841]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[192377]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[193913]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[195449]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[1169273]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[1170809]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[1178489]=Pssp;
	Mxx_sp_s[2371961]=(Pssp*pow(zbar,rrho)*Hs[8]*Hs[56]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2396537]=(Pssp*pow(zbar,rrho)*(Hs[9]*Hs[56] + Hs[8]*Hs[57])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2421113]=(Pssp*pow(zbar,rrho)*(Hs[10]*Hs[56] + Hs[8]*Hs[58])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2445689]=(Pssp*pow(zbar,rrho)*(Hs[11]*Hs[56] + Hs[8]*Hs[59])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2470265]=(Pssp*pow(zbar,rrho)*(Hs[12]*Hs[56] + Hs[8]*Hs[60])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2494841]=(Pssp*pow(zbar,rrho)*(Hs[13]*Hs[56] + Hs[8]*Hs[61])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2519417]=(Pssp*pow(zbar,rrho)*(Hs[14]*Hs[56] + Hs[8]*Hs[62])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2543993]=(Pssp*pow(zbar,rrho)*(Hs[15]*Hs[56] + Hs[8]*Hs[63])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2593145]=(Pssp*pow(zbar,rrho)*Hs[9]*Hs[57]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2617721]=(Pssp*pow(zbar,rrho)*(Hs[10]*Hs[57] + Hs[9]*Hs[58])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2642297]=(Pssp*pow(zbar,rrho)*(Hs[11]*Hs[57] + Hs[9]*Hs[59])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2666873]=(Pssp*pow(zbar,rrho)*(Hs[12]*Hs[57] + Hs[9]*Hs[60])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2691449]=(Pssp*pow(zbar,rrho)*(Hs[13]*Hs[57] + Hs[9]*Hs[61])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2716025]=(Pssp*pow(zbar,rrho)*(Hs[14]*Hs[57] + Hs[9]*Hs[62])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2740601]=(Pssp*pow(zbar,rrho)*(Hs[15]*Hs[57] + Hs[9]*Hs[63])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2814329]=(Pssp*pow(zbar,rrho)*Hs[10]*Hs[58]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2838905]=(Pssp*pow(zbar,rrho)*(Hs[11]*Hs[58] + Hs[10]*Hs[59])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2863481]=(Pssp*pow(zbar,rrho)*(Hs[12]*Hs[58] + Hs[10]*Hs[60])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2888057]=(Pssp*pow(zbar,rrho)*(Hs[13]*Hs[58] + Hs[10]*Hs[61])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2912633]=(Pssp*pow(zbar,rrho)*(Hs[14]*Hs[58] + Hs[10]*Hs[62])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2937209]=(Pssp*pow(zbar,rrho)*(Hs[15]*Hs[58] + Hs[10]*Hs[63])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3035513]=(Pssp*pow(zbar,rrho)*Hs[11]*Hs[59]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3060089]=(Pssp*pow(zbar,rrho)*(Hs[12]*Hs[59] + Hs[11]*Hs[60])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3084665]=(Pssp*pow(zbar,rrho)*(Hs[13]*Hs[59] + Hs[11]*Hs[61])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3109241]=(Pssp*pow(zbar,rrho)*(Hs[14]*Hs[59] + Hs[11]*Hs[62])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3133817]=(Pssp*pow(zbar,rrho)*(Hs[15]*Hs[59] + Hs[11]*Hs[63])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3256697]=(Pssp*pow(zbar,rrho)*Hs[12]*Hs[60]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3281273]=(Pssp*pow(zbar,rrho)*(Hs[13]*Hs[60] + Hs[12]*Hs[61])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3305849]=(Pssp*pow(zbar,rrho)*(Hs[14]*Hs[60] + Hs[12]*Hs[62])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3330425]=(Pssp*pow(zbar,rrho)*(Hs[15]*Hs[60] + Hs[12]*Hs[63])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3477881]=(Pssp*pow(zbar,rrho)*Hs[13]*Hs[61]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3502457]=(Pssp*pow(zbar,rrho)*(Hs[14]*Hs[61] + Hs[13]*Hs[62])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3527033]=(Pssp*pow(zbar,rrho)*(Hs[15]*Hs[61] + Hs[13]*Hs[63])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3699065]=(Pssp*pow(zbar,rrho)*Hs[14]*Hs[62]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3723641]=(Pssp*pow(zbar,rrho)*(Hs[15]*Hs[62] + Hs[14]*Hs[63])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3920249]=(Pssp*pow(zbar,rrho)*Hs[15]*Hs[63]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[187770]=-Pssp;
	Mxx_sp_s[189307]=-Pssp;
	Mxx_sp_s[190844]=-Pssp;
	Mxx_sp_s[195453]=-Pssp;
	Mxx_sp_s[193918]=-Pssp;
	Mxx_sp_s[192383]=-Pssp;
	Mxx_sp_s[24960]=1;
	Mxx_sp_s[196992]=-1;
	Mxx_sp_s[26497]=1;
	Mxx_sp_s[198529]=-1;
	Mxx_sp_s[28034]=1;
	Mxx_sp_s[200066]=-1;
	Mxx_sp_s[29571]=1;
	Mxx_sp_s[201603]=-1;
	Mxx_sp_s[31108]=1;
	Mxx_sp_s[203140]=-1;
	Mxx_sp_s[32645]=1;
	Mxx_sp_s[204677]=-1;
	Mxx_sp_s[34182]=1;
	Mxx_sp_s[206214]=-1;
	Mxx_sp_s[35719]=1;
	Mxx_sp_s[207751]=-1;
	Mxx_sp_s[835976]=1;
	Mxx_sp_s[1180040]=-1;
	Mxx_sp_s[837513]=1;
	Mxx_sp_s[1181577]=-1;
	Mxx_sp_s[839050]=1;
	Mxx_sp_s[1183114]=-1;
	Mxx_sp_s[840587]=1;
	Mxx_sp_s[1184651]=-1;
	Mxx_sp_s[842124]=1;
	Mxx_sp_s[1186188]=-1;
	Mxx_sp_s[843661]=1;
	Mxx_sp_s[1187725]=-1;
	Mxx_sp_s[845198]=1;
	Mxx_sp_s[1189262]=-1;
	Mxx_sp_s[846735]=1;
	Mxx_sp_s[1190799]=-1;
	Mxx_sp_s[848272]=1;
	Mxx_sp_s[1192336]=-1;
	Mxx_sp_s[849809]=1;
	Mxx_sp_s[1193873]=-1;
	Mxx_sp_s[851346]=1;
	Mxx_sp_s[1195410]=-1;
	Mxx_sp_s[852883]=1;
	Mxx_sp_s[1196947]=-1;
	Mxx_sp_s[854420]=1;
	Mxx_sp_s[1198484]=-1;
	Mxx_sp_s[855957]=1;
	Mxx_sp_s[1200021]=-1;
	Mxx_sp_s[857494]=1;
	Mxx_sp_s[1201558]=-1;
	Mxx_sp_s[859031]=1;
	Mxx_sp_s[1203095]=-1;
	Mxx_sp_s[123288]=1;
	Mxx_sp_s[209304]=-1;
	Mxx_sp_s[124825]=1;
	Mxx_sp_s[210841]=-1;
	Mxx_sp_s[126362]=1;
	Mxx_sp_s[212378]=-1;
	Mxx_sp_s[127899]=1;
	Mxx_sp_s[213915]=-1;
	Mxx_sp_s[129436]=1;
	Mxx_sp_s[215452]=-1;
	Mxx_sp_s[130973]=1;
	Mxx_sp_s[216989]=-1;
	Mxx_sp_s[132510]=1;
	Mxx_sp_s[218526]=-1;
	Mxx_sp_s[134047]=1;
	Mxx_sp_s[220063]=-1;
	Mxx_sp_s[1032608]=1;
	Mxx_sp_s[1204640]=-1;
	Mxx_sp_s[1034145]=1;
	Mxx_sp_s[1206177]=-1;
	Mxx_sp_s[1035682]=1;
	Mxx_sp_s[1207714]=-1;
	Mxx_sp_s[1037219]=1;
	Mxx_sp_s[1209251]=-1;
	Mxx_sp_s[1038756]=1;
	Mxx_sp_s[1210788]=-1;
	Mxx_sp_s[1040293]=1;
	Mxx_sp_s[1212325]=-1;
	Mxx_sp_s[1041830]=1;
	Mxx_sp_s[1213862]=-1;
	Mxx_sp_s[1043367]=1;
	Mxx_sp_s[1215399]=-1;
	Mxx_sp_s[1044904]=1;
	Mxx_sp_s[1216936]=-1;
	Mxx_sp_s[1046441]=1;
	Mxx_sp_s[1218473]=-1;
	Mxx_sp_s[1047978]=1;
	Mxx_sp_s[1220010]=-1;
	Mxx_sp_s[1049515]=1;
	Mxx_sp_s[1221547]=-1;
	Mxx_sp_s[1051052]=1;
	Mxx_sp_s[1223084]=-1;
	Mxx_sp_s[1052589]=1;
	Mxx_sp_s[1224621]=-1;
	Mxx_sp_s[1054126]=1;
	Mxx_sp_s[1226158]=-1;
	Mxx_sp_s[1055663]=1;
	Mxx_sp_s[1227695]=-1;
	Mxx_sp_s[232368]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mxx_sp_s[1229232]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mxx_sp_s[1230768]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mxx_sp_s[1241520]=-(pow(E,yss[8])*Pssp);
	Mxx_sp_s[1243056]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxx_sp_s[1244592]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxx_sp_s[224689]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[226225]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[227761]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[1230769]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[1232305]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[1236913]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mxx_sp_s[1241521]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mxx_sp_s[1243057]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[1244593]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[224690]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[226226]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[1230770]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[1232306]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[1236914]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mxx_sp_s[1239986]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[1241522]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mxx_sp_s[1243058]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[1244594]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[221619]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[223155]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[224691]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[226227]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mxx_sp_s[227763]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[229299]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[230835]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[232371]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[1236915]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mxx_sp_s[1241523]=-(pow(E,yss[8])*Pssp);
	Mxx_sp_s[1243059]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mxx_sp_s[1244595]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mxx_sp_s[2372019]=(bbeta*pow(E,yss[8])*Pssp*pow(Hs[16],2)*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2396595]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[16]*Hs[17]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2421171]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[16]*Hs[18]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2445747]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[16]*Hs[19]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2470323]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[16]*Hs[20]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2494899]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[16]*Hs[21]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2519475]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[16]*Hs[22]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2544051]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[16]*Hs[23]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2593203]=(bbeta*pow(E,yss[8])*Pssp*pow(Hs[17],2)*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2617779]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[17]*Hs[18]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2642355]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[17]*Hs[19]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2666931]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[17]*Hs[20]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2691507]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[17]*Hs[21]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2716083]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[17]*Hs[22]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2740659]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[17]*Hs[23]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2814387]=(bbeta*pow(E,yss[8])*Pssp*pow(Hs[18],2)*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2838963]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[18]*Hs[19]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2863539]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[18]*Hs[20]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2888115]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[18]*Hs[21]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2912691]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[18]*Hs[22]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2937267]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[18]*Hs[23]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3035571]=(bbeta*pow(E,yss[8])*Pssp*pow(Hs[19],2)*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3060147]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[19]*Hs[20]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3084723]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[19]*Hs[21]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3109299]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[19]*Hs[22]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3133875]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[19]*Hs[23]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3256755]=(bbeta*pow(E,yss[8])*Pssp*pow(Hs[20],2)*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3281331]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[20]*Hs[21]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3305907]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[20]*Hs[22]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3330483]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[20]*Hs[23]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3477939]=(bbeta*pow(E,yss[8])*Pssp*pow(Hs[21],2)*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3502515]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[21]*Hs[22]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3527091]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[21]*Hs[23]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3699123]=(bbeta*pow(E,yss[8])*Pssp*pow(Hs[22],2)*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3723699]=(2*bbeta*pow(E,yss[8])*Pssp*Hs[22]*Hs[23]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3920307]=(bbeta*pow(E,yss[8])*Pssp*pow(Hs[23],2)*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[221620]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mxx_sp_s[223156]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mxx_sp_s[224692]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mxx_sp_s[226228]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mxx_sp_s[227764]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mxx_sp_s[229300]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mxx_sp_s[230836]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mxx_sp_s[232372]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mxx_sp_s[1238452]=-(kkappa*Pssp*yss[9]);
	Mxx_sp_s[1241524]=pow(E,yss[8])*Pssp;
	Mxx_sp_s[1243060]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mxx_sp_s[1244596]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mxx_sp_s[2361268]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*pow(Hs[16],2));
	Mxx_sp_s[2362804]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*pow(Hs[16],2);
	Mxx_sp_s[2365876]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*pow(Hs[16],2));
	Mxx_sp_s[2372020]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*pow(Hs[16],2))/pow(zbar,rrho);
	Mxx_sp_s[2385844]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[16]*Hs[17];
	Mxx_sp_s[2387380]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[16]*Hs[17];
	Mxx_sp_s[2390452]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[16]*Hs[17];
	Mxx_sp_s[2396596]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[16]*Hs[17])/pow(zbar,rrho);
	Mxx_sp_s[2410420]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[16]*Hs[18];
	Mxx_sp_s[2411956]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[16]*Hs[18];
	Mxx_sp_s[2415028]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[16]*Hs[18];
	Mxx_sp_s[2421172]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[16]*Hs[18])/pow(zbar,rrho);
	Mxx_sp_s[2434996]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[16]*Hs[19];
	Mxx_sp_s[2436532]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[16]*Hs[19];
	Mxx_sp_s[2439604]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[16]*Hs[19];
	Mxx_sp_s[2445748]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[16]*Hs[19])/pow(zbar,rrho);
	Mxx_sp_s[2459572]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[16]*Hs[20];
	Mxx_sp_s[2461108]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[16]*Hs[20];
	Mxx_sp_s[2464180]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[16]*Hs[20];
	Mxx_sp_s[2470324]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[16]*Hs[20])/pow(zbar,rrho);
	Mxx_sp_s[2484148]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[16]*Hs[21];
	Mxx_sp_s[2485684]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[16]*Hs[21];
	Mxx_sp_s[2488756]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[16]*Hs[21];
	Mxx_sp_s[2494900]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[16]*Hs[21])/pow(zbar,rrho);
	Mxx_sp_s[2508724]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[16]*Hs[22];
	Mxx_sp_s[2510260]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[16]*Hs[22];
	Mxx_sp_s[2513332]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[16]*Hs[22];
	Mxx_sp_s[2519476]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[16]*Hs[22])/pow(zbar,rrho);
	Mxx_sp_s[2533300]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[16]*Hs[23];
	Mxx_sp_s[2534836]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[16]*Hs[23];
	Mxx_sp_s[2537908]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[16]*Hs[23];
	Mxx_sp_s[2544052]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[16]*Hs[23])/pow(zbar,rrho);
	Mxx_sp_s[2582452]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*pow(Hs[17],2));
	Mxx_sp_s[2583988]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*pow(Hs[17],2);
	Mxx_sp_s[2587060]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*pow(Hs[17],2));
	Mxx_sp_s[2593204]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*pow(Hs[17],2))/pow(zbar,rrho);
	Mxx_sp_s[2607028]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[17]*Hs[18];
	Mxx_sp_s[2608564]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[17]*Hs[18];
	Mxx_sp_s[2611636]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[17]*Hs[18];
	Mxx_sp_s[2617780]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[17]*Hs[18])/pow(zbar,rrho);
	Mxx_sp_s[2631604]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[17]*Hs[19];
	Mxx_sp_s[2633140]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[17]*Hs[19];
	Mxx_sp_s[2636212]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[17]*Hs[19];
	Mxx_sp_s[2642356]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[17]*Hs[19])/pow(zbar,rrho);
	Mxx_sp_s[2656180]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[17]*Hs[20];
	Mxx_sp_s[2657716]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[17]*Hs[20];
	Mxx_sp_s[2660788]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[17]*Hs[20];
	Mxx_sp_s[2666932]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[17]*Hs[20])/pow(zbar,rrho);
	Mxx_sp_s[2680756]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[17]*Hs[21];
	Mxx_sp_s[2682292]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[17]*Hs[21];
	Mxx_sp_s[2685364]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[17]*Hs[21];
	Mxx_sp_s[2691508]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[17]*Hs[21])/pow(zbar,rrho);
	Mxx_sp_s[2705332]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[17]*Hs[22];
	Mxx_sp_s[2706868]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[17]*Hs[22];
	Mxx_sp_s[2709940]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[17]*Hs[22];
	Mxx_sp_s[2716084]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[17]*Hs[22])/pow(zbar,rrho);
	Mxx_sp_s[2729908]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[17]*Hs[23];
	Mxx_sp_s[2731444]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[17]*Hs[23];
	Mxx_sp_s[2734516]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[17]*Hs[23];
	Mxx_sp_s[2740660]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[17]*Hs[23])/pow(zbar,rrho);
	Mxx_sp_s[2803636]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*pow(Hs[18],2));
	Mxx_sp_s[2805172]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*pow(Hs[18],2);
	Mxx_sp_s[2808244]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*pow(Hs[18],2));
	Mxx_sp_s[2814388]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*pow(Hs[18],2))/pow(zbar,rrho);
	Mxx_sp_s[2828212]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[18]*Hs[19];
	Mxx_sp_s[2829748]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[18]*Hs[19];
	Mxx_sp_s[2832820]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[18]*Hs[19];
	Mxx_sp_s[2838964]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[18]*Hs[19])/pow(zbar,rrho);
	Mxx_sp_s[2852788]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[18]*Hs[20];
	Mxx_sp_s[2854324]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[18]*Hs[20];
	Mxx_sp_s[2857396]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[18]*Hs[20];
	Mxx_sp_s[2863540]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[18]*Hs[20])/pow(zbar,rrho);
	Mxx_sp_s[2877364]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[18]*Hs[21];
	Mxx_sp_s[2878900]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[18]*Hs[21];
	Mxx_sp_s[2881972]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[18]*Hs[21];
	Mxx_sp_s[2888116]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[18]*Hs[21])/pow(zbar,rrho);
	Mxx_sp_s[2901940]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[18]*Hs[22];
	Mxx_sp_s[2903476]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[18]*Hs[22];
	Mxx_sp_s[2906548]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[18]*Hs[22];
	Mxx_sp_s[2912692]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[18]*Hs[22])/pow(zbar,rrho);
	Mxx_sp_s[2926516]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[18]*Hs[23];
	Mxx_sp_s[2928052]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[18]*Hs[23];
	Mxx_sp_s[2931124]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[18]*Hs[23];
	Mxx_sp_s[2937268]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[18]*Hs[23])/pow(zbar,rrho);
	Mxx_sp_s[3024820]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*pow(Hs[19],2));
	Mxx_sp_s[3026356]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*pow(Hs[19],2);
	Mxx_sp_s[3029428]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*pow(Hs[19],2));
	Mxx_sp_s[3035572]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*pow(Hs[19],2))/pow(zbar,rrho);
	Mxx_sp_s[3049396]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[19]*Hs[20];
	Mxx_sp_s[3050932]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[19]*Hs[20];
	Mxx_sp_s[3054004]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[19]*Hs[20];
	Mxx_sp_s[3060148]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[19]*Hs[20])/pow(zbar,rrho);
	Mxx_sp_s[3073972]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[19]*Hs[21];
	Mxx_sp_s[3075508]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[19]*Hs[21];
	Mxx_sp_s[3078580]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[19]*Hs[21];
	Mxx_sp_s[3084724]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[19]*Hs[21])/pow(zbar,rrho);
	Mxx_sp_s[3098548]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[19]*Hs[22];
	Mxx_sp_s[3100084]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[19]*Hs[22];
	Mxx_sp_s[3103156]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[19]*Hs[22];
	Mxx_sp_s[3109300]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[19]*Hs[22])/pow(zbar,rrho);
	Mxx_sp_s[3123124]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[19]*Hs[23];
	Mxx_sp_s[3124660]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[19]*Hs[23];
	Mxx_sp_s[3127732]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[19]*Hs[23];
	Mxx_sp_s[3133876]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[19]*Hs[23])/pow(zbar,rrho);
	Mxx_sp_s[3246004]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*pow(Hs[20],2));
	Mxx_sp_s[3247540]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*pow(Hs[20],2);
	Mxx_sp_s[3250612]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*pow(Hs[20],2));
	Mxx_sp_s[3256756]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*pow(Hs[20],2))/pow(zbar,rrho);
	Mxx_sp_s[3270580]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[20]*Hs[21];
	Mxx_sp_s[3272116]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[20]*Hs[21];
	Mxx_sp_s[3275188]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[20]*Hs[21];
	Mxx_sp_s[3281332]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[20]*Hs[21])/pow(zbar,rrho);
	Mxx_sp_s[3295156]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[20]*Hs[22];
	Mxx_sp_s[3296692]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[20]*Hs[22];
	Mxx_sp_s[3299764]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[20]*Hs[22];
	Mxx_sp_s[3305908]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[20]*Hs[22])/pow(zbar,rrho);
	Mxx_sp_s[3319732]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[20]*Hs[23];
	Mxx_sp_s[3321268]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[20]*Hs[23];
	Mxx_sp_s[3324340]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[20]*Hs[23];
	Mxx_sp_s[3330484]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[20]*Hs[23])/pow(zbar,rrho);
	Mxx_sp_s[3467188]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*pow(Hs[21],2));
	Mxx_sp_s[3468724]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*pow(Hs[21],2);
	Mxx_sp_s[3471796]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*pow(Hs[21],2));
	Mxx_sp_s[3477940]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*pow(Hs[21],2))/pow(zbar,rrho);
	Mxx_sp_s[3491764]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[21]*Hs[22];
	Mxx_sp_s[3493300]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[21]*Hs[22];
	Mxx_sp_s[3496372]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[21]*Hs[22];
	Mxx_sp_s[3502516]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[21]*Hs[22])/pow(zbar,rrho);
	Mxx_sp_s[3516340]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[21]*Hs[23];
	Mxx_sp_s[3517876]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[21]*Hs[23];
	Mxx_sp_s[3520948]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[21]*Hs[23];
	Mxx_sp_s[3527092]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[21]*Hs[23])/pow(zbar,rrho);
	Mxx_sp_s[3688372]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*pow(Hs[22],2));
	Mxx_sp_s[3689908]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*pow(Hs[22],2);
	Mxx_sp_s[3692980]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*pow(Hs[22],2));
	Mxx_sp_s[3699124]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*pow(Hs[22],2))/pow(zbar,rrho);
	Mxx_sp_s[3712948]=-2*aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[22]*Hs[23];
	Mxx_sp_s[3714484]=2*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[22]*Hs[23];
	Mxx_sp_s[3717556]=-2*bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[22]*Hs[23];
	Mxx_sp_s[3723700]=(2*bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[22]*Hs[23])/pow(zbar,rrho);
	Mxx_sp_s[3909556]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*pow(Hs[23],2));
	Mxx_sp_s[3911092]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*pow(Hs[23],2);
	Mxx_sp_s[3914164]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*pow(Hs[23],2));
	Mxx_sp_s[3920308]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*pow(Hs[23],2))/pow(zbar,rrho);
	Mxx_sp_s[221621]=iiota*Pssp*zbar;
	Mxx_sp_s[226229]=iiota*Pssp*zbar;
	Mxx_sp_s[1238453]=-Pssp;
	Mxx_sp_s[1230774]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mxx_sp_s[1239990]=-(pow(E,yss[7])*Pssp);
	Mxx_sp_s[1243062]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxx_sp_s[1244598]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxx_sp_s[223159]=-((Pssp*zbar)/(1 + yss[5]));
	Mxx_sp_s[224695]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[226231]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mxx_sp_s[227767]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mxx_sp_s[230839]=-(pow(E,yss[11])*ebar*Pssp);
	Mxx_sp_s[1229239]=-(pow(E,yss[0])*Pssp);
	Mxx_sp_s[1230775]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mxx_sp_s[1232311]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mxx_sp_s[1233847]=-(pow(E,yss[3])*Pssp);
	Mxx_sp_s[1236919]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mxx_sp_s[1239991]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mxx_sp_s[1243063]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxx_sp_s[1244599]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxx_sp_s[221624]=-(pow(E,xss[0])*Pssp*zbar);
	Mxx_sp_s[226232]=-(pow(E,xss[0])*Pssp*zbar);
	Mxx_sp_s[1233848]=pow(E,yss[3])*Pssp;
	Mxx_sp_s[1243064]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxx_sp_s[1244600]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxx_sp_s[221625]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxx_sp_s[223161]=(Pssp*zbar)/(1 + yss[5]);
	Mxx_sp_s[226233]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mxx_sp_s[227769]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxx_sp_s[1230777]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxx_sp_s[1232313]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxx_sp_s[1236921]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mxx_sp_s[1238457]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxx_sp_s[1239993]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxx_sp_s[1243065]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxx_sp_s[1244601]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxx_sp_s[1243066]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxx_sp_s[1244602]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxx_sp_s[223163]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mxx_sp_s[229307]=Pssp;
	Mxx_sp_s[1236923]=-Pssp;
	Mxx_sp_s[1243067]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxx_sp_s[1244603]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxx_sp_s[221628]=pow(E,xss[0])*Pssp;
	Mxx_sp_s[1235388]=-(pow(E,xss[0])*Pssp);
	Mxx_sp_s[224701]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[226237]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[227773]=pow(E,yss[2])*pbar*Pssp;
	Mxx_sp_s[1230781]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[1232317]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mxx_sp_s[1243069]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxx_sp_s[1244605]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxx_sp_s[1246141]=pow(E,yss[11])*Pssp;
	Mxx_sp_s[223166]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxx_sp_s[226238]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxx_sp_s[1243070]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxx_sp_s[1244606]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxx_sp_s[1246142]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mxx_sp_s[1247678]=Pssp;
	Mxx_sp_s[223167]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxx_sp_s[226239]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxx_sp_s[1243071]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxx_sp_s[1244607]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxx_sp_s[1246143]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mxx_sp_s[1249215]=Pssp;
	Mxx_sp_s[230848]=ebar*Pssp;
	Mxx_sp_s[1229248]=pow(E,yss[0] - yss[11])*Pssp;
	Mxx_sp_s[1233856]=pow(E,yss[3] - yss[11])*Pssp;
	Mxx_sp_s[1243072]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxx_sp_s[1244608]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxx_sp_s[1246144]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mxx_sp_s[1250752]=Pssp;
	Mxx_sp_s[221633]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[223169]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[224705]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[226241]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mxx_sp_s[227777]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[229313]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[230849]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[232385]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[1243073]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[1244609]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[1252289]=Pssp;
	Mxx_sp_s[2372033]=(Pssp*pow(zbar,rrho)*pow(Hs[16],2)*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2396609]=(2*Pssp*pow(zbar,rrho)*Hs[16]*Hs[17]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2421185]=(2*Pssp*pow(zbar,rrho)*Hs[16]*Hs[18]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2445761]=(2*Pssp*pow(zbar,rrho)*Hs[16]*Hs[19]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2470337]=(2*Pssp*pow(zbar,rrho)*Hs[16]*Hs[20]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2494913]=(2*Pssp*pow(zbar,rrho)*Hs[16]*Hs[21]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2519489]=(2*Pssp*pow(zbar,rrho)*Hs[16]*Hs[22]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2544065]=(2*Pssp*pow(zbar,rrho)*Hs[16]*Hs[23]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2593217]=(Pssp*pow(zbar,rrho)*pow(Hs[17],2)*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2617793]=(2*Pssp*pow(zbar,rrho)*Hs[17]*Hs[18]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2642369]=(2*Pssp*pow(zbar,rrho)*Hs[17]*Hs[19]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2666945]=(2*Pssp*pow(zbar,rrho)*Hs[17]*Hs[20]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2691521]=(2*Pssp*pow(zbar,rrho)*Hs[17]*Hs[21]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2716097]=(2*Pssp*pow(zbar,rrho)*Hs[17]*Hs[22]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2740673]=(2*Pssp*pow(zbar,rrho)*Hs[17]*Hs[23]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2814401]=(Pssp*pow(zbar,rrho)*pow(Hs[18],2)*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2838977]=(2*Pssp*pow(zbar,rrho)*Hs[18]*Hs[19]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2863553]=(2*Pssp*pow(zbar,rrho)*Hs[18]*Hs[20]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2888129]=(2*Pssp*pow(zbar,rrho)*Hs[18]*Hs[21]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2912705]=(2*Pssp*pow(zbar,rrho)*Hs[18]*Hs[22]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2937281]=(2*Pssp*pow(zbar,rrho)*Hs[18]*Hs[23]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3035585]=(Pssp*pow(zbar,rrho)*pow(Hs[19],2)*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3060161]=(2*Pssp*pow(zbar,rrho)*Hs[19]*Hs[20]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3084737]=(2*Pssp*pow(zbar,rrho)*Hs[19]*Hs[21]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3109313]=(2*Pssp*pow(zbar,rrho)*Hs[19]*Hs[22]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3133889]=(2*Pssp*pow(zbar,rrho)*Hs[19]*Hs[23]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3256769]=(Pssp*pow(zbar,rrho)*pow(Hs[20],2)*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3281345]=(2*Pssp*pow(zbar,rrho)*Hs[20]*Hs[21]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3305921]=(2*Pssp*pow(zbar,rrho)*Hs[20]*Hs[22]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3330497]=(2*Pssp*pow(zbar,rrho)*Hs[20]*Hs[23]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3477953]=(Pssp*pow(zbar,rrho)*pow(Hs[21],2)*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3502529]=(2*Pssp*pow(zbar,rrho)*Hs[21]*Hs[22]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3527105]=(2*Pssp*pow(zbar,rrho)*Hs[21]*Hs[23]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3699137]=(Pssp*pow(zbar,rrho)*pow(Hs[22],2)*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3723713]=(2*Pssp*pow(zbar,rrho)*Hs[22]*Hs[23]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3920321]=(Pssp*pow(zbar,rrho)*pow(Hs[23],2)*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[224706]=-Pssp;
	Mxx_sp_s[226243]=-Pssp;
	Mxx_sp_s[227780]=-Pssp;
	Mxx_sp_s[232389]=-Pssp;
	Mxx_sp_s[230854]=-Pssp;
	Mxx_sp_s[229319]=-Pssp;
	Mxx_sp_s[244680]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mxx_sp_s[1253832]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mxx_sp_s[1255368]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mxx_sp_s[1266120]=-(pow(E,yss[8])*Pssp);
	Mxx_sp_s[1267656]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxx_sp_s[1269192]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxx_sp_s[237001]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[238537]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[240073]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[1255369]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[1256905]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[1261513]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mxx_sp_s[1266121]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mxx_sp_s[1267657]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[1269193]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[237002]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[238538]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[1255370]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[1256906]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[1261514]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mxx_sp_s[1264586]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[1266122]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mxx_sp_s[1267658]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[1269194]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[233931]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[235467]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[237003]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[238539]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mxx_sp_s[240075]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[241611]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[243147]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[244683]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[1261515]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mxx_sp_s[1266123]=-(pow(E,yss[8])*Pssp);
	Mxx_sp_s[1267659]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mxx_sp_s[1269195]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mxx_sp_s[2372043]=(bbeta*pow(E,yss[8])*Pssp*Hs[16]*Hs[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2396619]=(bbeta*pow(E,yss[8])*Pssp*(Hs[17]*Hs[24] + Hs[16]*Hs[25])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2421195]=(bbeta*pow(E,yss[8])*Pssp*(Hs[18]*Hs[24] + Hs[16]*Hs[26])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2445771]=(bbeta*pow(E,yss[8])*Pssp*(Hs[19]*Hs[24] + Hs[16]*Hs[27])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2470347]=(bbeta*pow(E,yss[8])*Pssp*(Hs[20]*Hs[24] + Hs[16]*Hs[28])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2494923]=(bbeta*pow(E,yss[8])*Pssp*(Hs[21]*Hs[24] + Hs[16]*Hs[29])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2519499]=(bbeta*pow(E,yss[8])*Pssp*(Hs[22]*Hs[24] + Hs[16]*Hs[30])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2544075]=(bbeta*pow(E,yss[8])*Pssp*(Hs[23]*Hs[24] + Hs[16]*Hs[31])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2593227]=(bbeta*pow(E,yss[8])*Pssp*Hs[17]*Hs[25]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2617803]=(bbeta*pow(E,yss[8])*Pssp*(Hs[18]*Hs[25] + Hs[17]*Hs[26])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2642379]=(bbeta*pow(E,yss[8])*Pssp*(Hs[19]*Hs[25] + Hs[17]*Hs[27])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2666955]=(bbeta*pow(E,yss[8])*Pssp*(Hs[20]*Hs[25] + Hs[17]*Hs[28])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2691531]=(bbeta*pow(E,yss[8])*Pssp*(Hs[21]*Hs[25] + Hs[17]*Hs[29])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2716107]=(bbeta*pow(E,yss[8])*Pssp*(Hs[22]*Hs[25] + Hs[17]*Hs[30])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2740683]=(bbeta*pow(E,yss[8])*Pssp*(Hs[23]*Hs[25] + Hs[17]*Hs[31])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2814411]=(bbeta*pow(E,yss[8])*Pssp*Hs[18]*Hs[26]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2838987]=(bbeta*pow(E,yss[8])*Pssp*(Hs[19]*Hs[26] + Hs[18]*Hs[27])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2863563]=(bbeta*pow(E,yss[8])*Pssp*(Hs[20]*Hs[26] + Hs[18]*Hs[28])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2888139]=(bbeta*pow(E,yss[8])*Pssp*(Hs[21]*Hs[26] + Hs[18]*Hs[29])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2912715]=(bbeta*pow(E,yss[8])*Pssp*(Hs[22]*Hs[26] + Hs[18]*Hs[30])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2937291]=(bbeta*pow(E,yss[8])*Pssp*(Hs[23]*Hs[26] + Hs[18]*Hs[31])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3035595]=(bbeta*pow(E,yss[8])*Pssp*Hs[19]*Hs[27]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3060171]=(bbeta*pow(E,yss[8])*Pssp*(Hs[20]*Hs[27] + Hs[19]*Hs[28])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3084747]=(bbeta*pow(E,yss[8])*Pssp*(Hs[21]*Hs[27] + Hs[19]*Hs[29])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3109323]=(bbeta*pow(E,yss[8])*Pssp*(Hs[22]*Hs[27] + Hs[19]*Hs[30])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3133899]=(bbeta*pow(E,yss[8])*Pssp*(Hs[23]*Hs[27] + Hs[19]*Hs[31])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3256779]=(bbeta*pow(E,yss[8])*Pssp*Hs[20]*Hs[28]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3281355]=(bbeta*pow(E,yss[8])*Pssp*(Hs[21]*Hs[28] + Hs[20]*Hs[29])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3305931]=(bbeta*pow(E,yss[8])*Pssp*(Hs[22]*Hs[28] + Hs[20]*Hs[30])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3330507]=(bbeta*pow(E,yss[8])*Pssp*(Hs[23]*Hs[28] + Hs[20]*Hs[31])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3477963]=(bbeta*pow(E,yss[8])*Pssp*Hs[21]*Hs[29]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3502539]=(bbeta*pow(E,yss[8])*Pssp*(Hs[22]*Hs[29] + Hs[21]*Hs[30])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3527115]=(bbeta*pow(E,yss[8])*Pssp*(Hs[23]*Hs[29] + Hs[21]*Hs[31])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3699147]=(bbeta*pow(E,yss[8])*Pssp*Hs[22]*Hs[30]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3723723]=(bbeta*pow(E,yss[8])*Pssp*(Hs[23]*Hs[30] + Hs[22]*Hs[31])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3920331]=(bbeta*pow(E,yss[8])*Pssp*Hs[23]*Hs[31]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[233932]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mxx_sp_s[235468]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mxx_sp_s[237004]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mxx_sp_s[238540]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mxx_sp_s[240076]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mxx_sp_s[241612]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mxx_sp_s[243148]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mxx_sp_s[244684]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mxx_sp_s[1263052]=-(kkappa*Pssp*yss[9]);
	Mxx_sp_s[1266124]=pow(E,yss[8])*Pssp;
	Mxx_sp_s[1267660]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mxx_sp_s[1269196]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mxx_sp_s[2361292]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[16]*Hs[24]);
	Mxx_sp_s[2362828]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[16]*Hs[24];
	Mxx_sp_s[2365900]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[16]*Hs[24]);
	Mxx_sp_s[2372044]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[16]*Hs[24])/pow(zbar,rrho);
	Mxx_sp_s[2385868]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[17]*Hs[24] + Hs[16]*Hs[25]));
	Mxx_sp_s[2387404]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[17]*Hs[24] + Hs[16]*Hs[25]);
	Mxx_sp_s[2390476]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[17]*Hs[24] + Hs[16]*Hs[25]));
	Mxx_sp_s[2396620]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[17]*Hs[24] + Hs[16]*Hs[25]))/pow(zbar,rrho);
	Mxx_sp_s[2410444]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[18]*Hs[24] + Hs[16]*Hs[26]));
	Mxx_sp_s[2411980]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[18]*Hs[24] + Hs[16]*Hs[26]);
	Mxx_sp_s[2415052]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[18]*Hs[24] + Hs[16]*Hs[26]));
	Mxx_sp_s[2421196]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[18]*Hs[24] + Hs[16]*Hs[26]))/pow(zbar,rrho);
	Mxx_sp_s[2435020]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[19]*Hs[24] + Hs[16]*Hs[27]));
	Mxx_sp_s[2436556]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[19]*Hs[24] + Hs[16]*Hs[27]);
	Mxx_sp_s[2439628]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[19]*Hs[24] + Hs[16]*Hs[27]));
	Mxx_sp_s[2445772]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[19]*Hs[24] + Hs[16]*Hs[27]))/pow(zbar,rrho);
	Mxx_sp_s[2459596]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[20]*Hs[24] + Hs[16]*Hs[28]));
	Mxx_sp_s[2461132]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[20]*Hs[24] + Hs[16]*Hs[28]);
	Mxx_sp_s[2464204]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[20]*Hs[24] + Hs[16]*Hs[28]));
	Mxx_sp_s[2470348]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[20]*Hs[24] + Hs[16]*Hs[28]))/pow(zbar,rrho);
	Mxx_sp_s[2484172]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[21]*Hs[24] + Hs[16]*Hs[29]));
	Mxx_sp_s[2485708]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[21]*Hs[24] + Hs[16]*Hs[29]);
	Mxx_sp_s[2488780]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[21]*Hs[24] + Hs[16]*Hs[29]));
	Mxx_sp_s[2494924]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[21]*Hs[24] + Hs[16]*Hs[29]))/pow(zbar,rrho);
	Mxx_sp_s[2508748]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[22]*Hs[24] + Hs[16]*Hs[30]));
	Mxx_sp_s[2510284]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[22]*Hs[24] + Hs[16]*Hs[30]);
	Mxx_sp_s[2513356]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[22]*Hs[24] + Hs[16]*Hs[30]));
	Mxx_sp_s[2519500]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[22]*Hs[24] + Hs[16]*Hs[30]))/pow(zbar,rrho);
	Mxx_sp_s[2533324]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[23]*Hs[24] + Hs[16]*Hs[31]));
	Mxx_sp_s[2534860]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[23]*Hs[24] + Hs[16]*Hs[31]);
	Mxx_sp_s[2537932]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[23]*Hs[24] + Hs[16]*Hs[31]));
	Mxx_sp_s[2544076]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[23]*Hs[24] + Hs[16]*Hs[31]))/pow(zbar,rrho);
	Mxx_sp_s[2582476]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[17]*Hs[25]);
	Mxx_sp_s[2584012]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[17]*Hs[25];
	Mxx_sp_s[2587084]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[17]*Hs[25]);
	Mxx_sp_s[2593228]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[17]*Hs[25])/pow(zbar,rrho);
	Mxx_sp_s[2607052]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[18]*Hs[25] + Hs[17]*Hs[26]));
	Mxx_sp_s[2608588]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[18]*Hs[25] + Hs[17]*Hs[26]);
	Mxx_sp_s[2611660]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[18]*Hs[25] + Hs[17]*Hs[26]));
	Mxx_sp_s[2617804]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[18]*Hs[25] + Hs[17]*Hs[26]))/pow(zbar,rrho);
	Mxx_sp_s[2631628]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[19]*Hs[25] + Hs[17]*Hs[27]));
	Mxx_sp_s[2633164]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[19]*Hs[25] + Hs[17]*Hs[27]);
	Mxx_sp_s[2636236]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[19]*Hs[25] + Hs[17]*Hs[27]));
	Mxx_sp_s[2642380]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[19]*Hs[25] + Hs[17]*Hs[27]))/pow(zbar,rrho);
	Mxx_sp_s[2656204]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[20]*Hs[25] + Hs[17]*Hs[28]));
	Mxx_sp_s[2657740]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[20]*Hs[25] + Hs[17]*Hs[28]);
	Mxx_sp_s[2660812]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[20]*Hs[25] + Hs[17]*Hs[28]));
	Mxx_sp_s[2666956]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[20]*Hs[25] + Hs[17]*Hs[28]))/pow(zbar,rrho);
	Mxx_sp_s[2680780]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[21]*Hs[25] + Hs[17]*Hs[29]));
	Mxx_sp_s[2682316]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[21]*Hs[25] + Hs[17]*Hs[29]);
	Mxx_sp_s[2685388]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[21]*Hs[25] + Hs[17]*Hs[29]));
	Mxx_sp_s[2691532]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[21]*Hs[25] + Hs[17]*Hs[29]))/pow(zbar,rrho);
	Mxx_sp_s[2705356]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[22]*Hs[25] + Hs[17]*Hs[30]));
	Mxx_sp_s[2706892]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[22]*Hs[25] + Hs[17]*Hs[30]);
	Mxx_sp_s[2709964]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[22]*Hs[25] + Hs[17]*Hs[30]));
	Mxx_sp_s[2716108]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[22]*Hs[25] + Hs[17]*Hs[30]))/pow(zbar,rrho);
	Mxx_sp_s[2729932]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[23]*Hs[25] + Hs[17]*Hs[31]));
	Mxx_sp_s[2731468]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[23]*Hs[25] + Hs[17]*Hs[31]);
	Mxx_sp_s[2734540]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[23]*Hs[25] + Hs[17]*Hs[31]));
	Mxx_sp_s[2740684]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[23]*Hs[25] + Hs[17]*Hs[31]))/pow(zbar,rrho);
	Mxx_sp_s[2803660]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[18]*Hs[26]);
	Mxx_sp_s[2805196]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[18]*Hs[26];
	Mxx_sp_s[2808268]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[18]*Hs[26]);
	Mxx_sp_s[2814412]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[18]*Hs[26])/pow(zbar,rrho);
	Mxx_sp_s[2828236]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[19]*Hs[26] + Hs[18]*Hs[27]));
	Mxx_sp_s[2829772]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[19]*Hs[26] + Hs[18]*Hs[27]);
	Mxx_sp_s[2832844]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[19]*Hs[26] + Hs[18]*Hs[27]));
	Mxx_sp_s[2838988]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[19]*Hs[26] + Hs[18]*Hs[27]))/pow(zbar,rrho);
	Mxx_sp_s[2852812]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[20]*Hs[26] + Hs[18]*Hs[28]));
	Mxx_sp_s[2854348]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[20]*Hs[26] + Hs[18]*Hs[28]);
	Mxx_sp_s[2857420]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[20]*Hs[26] + Hs[18]*Hs[28]));
	Mxx_sp_s[2863564]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[20]*Hs[26] + Hs[18]*Hs[28]))/pow(zbar,rrho);
	Mxx_sp_s[2877388]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[21]*Hs[26] + Hs[18]*Hs[29]));
	Mxx_sp_s[2878924]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[21]*Hs[26] + Hs[18]*Hs[29]);
	Mxx_sp_s[2881996]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[21]*Hs[26] + Hs[18]*Hs[29]));
	Mxx_sp_s[2888140]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[21]*Hs[26] + Hs[18]*Hs[29]))/pow(zbar,rrho);
	Mxx_sp_s[2901964]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[22]*Hs[26] + Hs[18]*Hs[30]));
	Mxx_sp_s[2903500]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[22]*Hs[26] + Hs[18]*Hs[30]);
	Mxx_sp_s[2906572]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[22]*Hs[26] + Hs[18]*Hs[30]));
	Mxx_sp_s[2912716]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[22]*Hs[26] + Hs[18]*Hs[30]))/pow(zbar,rrho);
	Mxx_sp_s[2926540]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[23]*Hs[26] + Hs[18]*Hs[31]));
	Mxx_sp_s[2928076]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[23]*Hs[26] + Hs[18]*Hs[31]);
	Mxx_sp_s[2931148]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[23]*Hs[26] + Hs[18]*Hs[31]));
	Mxx_sp_s[2937292]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[23]*Hs[26] + Hs[18]*Hs[31]))/pow(zbar,rrho);
	Mxx_sp_s[3024844]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[19]*Hs[27]);
	Mxx_sp_s[3026380]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[19]*Hs[27];
	Mxx_sp_s[3029452]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[19]*Hs[27]);
	Mxx_sp_s[3035596]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[19]*Hs[27])/pow(zbar,rrho);
	Mxx_sp_s[3049420]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[20]*Hs[27] + Hs[19]*Hs[28]));
	Mxx_sp_s[3050956]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[20]*Hs[27] + Hs[19]*Hs[28]);
	Mxx_sp_s[3054028]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[20]*Hs[27] + Hs[19]*Hs[28]));
	Mxx_sp_s[3060172]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[20]*Hs[27] + Hs[19]*Hs[28]))/pow(zbar,rrho);
	Mxx_sp_s[3073996]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[21]*Hs[27] + Hs[19]*Hs[29]));
	Mxx_sp_s[3075532]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[21]*Hs[27] + Hs[19]*Hs[29]);
	Mxx_sp_s[3078604]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[21]*Hs[27] + Hs[19]*Hs[29]));
	Mxx_sp_s[3084748]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[21]*Hs[27] + Hs[19]*Hs[29]))/pow(zbar,rrho);
	Mxx_sp_s[3098572]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[22]*Hs[27] + Hs[19]*Hs[30]));
	Mxx_sp_s[3100108]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[22]*Hs[27] + Hs[19]*Hs[30]);
	Mxx_sp_s[3103180]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[22]*Hs[27] + Hs[19]*Hs[30]));
	Mxx_sp_s[3109324]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[22]*Hs[27] + Hs[19]*Hs[30]))/pow(zbar,rrho);
	Mxx_sp_s[3123148]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[23]*Hs[27] + Hs[19]*Hs[31]));
	Mxx_sp_s[3124684]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[23]*Hs[27] + Hs[19]*Hs[31]);
	Mxx_sp_s[3127756]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[23]*Hs[27] + Hs[19]*Hs[31]));
	Mxx_sp_s[3133900]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[23]*Hs[27] + Hs[19]*Hs[31]))/pow(zbar,rrho);
	Mxx_sp_s[3246028]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[20]*Hs[28]);
	Mxx_sp_s[3247564]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[20]*Hs[28];
	Mxx_sp_s[3250636]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[20]*Hs[28]);
	Mxx_sp_s[3256780]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[20]*Hs[28])/pow(zbar,rrho);
	Mxx_sp_s[3270604]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[21]*Hs[28] + Hs[20]*Hs[29]));
	Mxx_sp_s[3272140]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[21]*Hs[28] + Hs[20]*Hs[29]);
	Mxx_sp_s[3275212]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[21]*Hs[28] + Hs[20]*Hs[29]));
	Mxx_sp_s[3281356]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[21]*Hs[28] + Hs[20]*Hs[29]))/pow(zbar,rrho);
	Mxx_sp_s[3295180]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[22]*Hs[28] + Hs[20]*Hs[30]));
	Mxx_sp_s[3296716]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[22]*Hs[28] + Hs[20]*Hs[30]);
	Mxx_sp_s[3299788]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[22]*Hs[28] + Hs[20]*Hs[30]));
	Mxx_sp_s[3305932]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[22]*Hs[28] + Hs[20]*Hs[30]))/pow(zbar,rrho);
	Mxx_sp_s[3319756]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[23]*Hs[28] + Hs[20]*Hs[31]));
	Mxx_sp_s[3321292]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[23]*Hs[28] + Hs[20]*Hs[31]);
	Mxx_sp_s[3324364]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[23]*Hs[28] + Hs[20]*Hs[31]));
	Mxx_sp_s[3330508]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[23]*Hs[28] + Hs[20]*Hs[31]))/pow(zbar,rrho);
	Mxx_sp_s[3467212]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[21]*Hs[29]);
	Mxx_sp_s[3468748]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[21]*Hs[29];
	Mxx_sp_s[3471820]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[21]*Hs[29]);
	Mxx_sp_s[3477964]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[21]*Hs[29])/pow(zbar,rrho);
	Mxx_sp_s[3491788]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[22]*Hs[29] + Hs[21]*Hs[30]));
	Mxx_sp_s[3493324]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[22]*Hs[29] + Hs[21]*Hs[30]);
	Mxx_sp_s[3496396]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[22]*Hs[29] + Hs[21]*Hs[30]));
	Mxx_sp_s[3502540]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[22]*Hs[29] + Hs[21]*Hs[30]))/pow(zbar,rrho);
	Mxx_sp_s[3516364]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[23]*Hs[29] + Hs[21]*Hs[31]));
	Mxx_sp_s[3517900]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[23]*Hs[29] + Hs[21]*Hs[31]);
	Mxx_sp_s[3520972]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[23]*Hs[29] + Hs[21]*Hs[31]));
	Mxx_sp_s[3527116]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[23]*Hs[29] + Hs[21]*Hs[31]))/pow(zbar,rrho);
	Mxx_sp_s[3688396]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[22]*Hs[30]);
	Mxx_sp_s[3689932]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[22]*Hs[30];
	Mxx_sp_s[3693004]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[22]*Hs[30]);
	Mxx_sp_s[3699148]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[22]*Hs[30])/pow(zbar,rrho);
	Mxx_sp_s[3712972]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[23]*Hs[30] + Hs[22]*Hs[31]));
	Mxx_sp_s[3714508]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[23]*Hs[30] + Hs[22]*Hs[31]);
	Mxx_sp_s[3717580]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[23]*Hs[30] + Hs[22]*Hs[31]));
	Mxx_sp_s[3723724]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[23]*Hs[30] + Hs[22]*Hs[31]))/pow(zbar,rrho);
	Mxx_sp_s[3909580]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[23]*Hs[31]);
	Mxx_sp_s[3911116]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[23]*Hs[31];
	Mxx_sp_s[3914188]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[23]*Hs[31]);
	Mxx_sp_s[3920332]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[23]*Hs[31])/pow(zbar,rrho);
	Mxx_sp_s[233933]=iiota*Pssp*zbar;
	Mxx_sp_s[238541]=iiota*Pssp*zbar;
	Mxx_sp_s[1263053]=-Pssp;
	Mxx_sp_s[1255374]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mxx_sp_s[1264590]=-(pow(E,yss[7])*Pssp);
	Mxx_sp_s[1267662]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxx_sp_s[1269198]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxx_sp_s[235471]=-((Pssp*zbar)/(1 + yss[5]));
	Mxx_sp_s[237007]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[238543]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mxx_sp_s[240079]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mxx_sp_s[243151]=-(pow(E,yss[11])*ebar*Pssp);
	Mxx_sp_s[1253839]=-(pow(E,yss[0])*Pssp);
	Mxx_sp_s[1255375]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mxx_sp_s[1256911]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mxx_sp_s[1258447]=-(pow(E,yss[3])*Pssp);
	Mxx_sp_s[1261519]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mxx_sp_s[1264591]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mxx_sp_s[1267663]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxx_sp_s[1269199]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxx_sp_s[233936]=-(pow(E,xss[0])*Pssp*zbar);
	Mxx_sp_s[238544]=-(pow(E,xss[0])*Pssp*zbar);
	Mxx_sp_s[1258448]=pow(E,yss[3])*Pssp;
	Mxx_sp_s[1267664]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxx_sp_s[1269200]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxx_sp_s[233937]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxx_sp_s[235473]=(Pssp*zbar)/(1 + yss[5]);
	Mxx_sp_s[238545]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mxx_sp_s[240081]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxx_sp_s[1255377]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxx_sp_s[1256913]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxx_sp_s[1261521]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mxx_sp_s[1263057]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxx_sp_s[1264593]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxx_sp_s[1267665]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxx_sp_s[1269201]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxx_sp_s[1267666]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxx_sp_s[1269202]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxx_sp_s[235475]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mxx_sp_s[241619]=Pssp;
	Mxx_sp_s[1261523]=-Pssp;
	Mxx_sp_s[1267667]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxx_sp_s[1269203]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxx_sp_s[233940]=pow(E,xss[0])*Pssp;
	Mxx_sp_s[1259988]=-(pow(E,xss[0])*Pssp);
	Mxx_sp_s[237013]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[238549]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[240085]=pow(E,yss[2])*pbar*Pssp;
	Mxx_sp_s[1255381]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[1256917]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mxx_sp_s[1267669]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxx_sp_s[1269205]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxx_sp_s[1270741]=pow(E,yss[11])*Pssp;
	Mxx_sp_s[235478]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxx_sp_s[238550]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxx_sp_s[1267670]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxx_sp_s[1269206]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxx_sp_s[1270742]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mxx_sp_s[1272278]=Pssp;
	Mxx_sp_s[235479]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxx_sp_s[238551]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxx_sp_s[1267671]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxx_sp_s[1269207]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxx_sp_s[1270743]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mxx_sp_s[1273815]=Pssp;
	Mxx_sp_s[243160]=ebar*Pssp;
	Mxx_sp_s[1253848]=pow(E,yss[0] - yss[11])*Pssp;
	Mxx_sp_s[1258456]=pow(E,yss[3] - yss[11])*Pssp;
	Mxx_sp_s[1267672]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxx_sp_s[1269208]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxx_sp_s[1270744]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mxx_sp_s[1275352]=Pssp;
	Mxx_sp_s[233945]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[235481]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[237017]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[238553]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mxx_sp_s[240089]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[241625]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[243161]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[244697]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[1267673]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[1269209]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[1276889]=Pssp;
	Mxx_sp_s[2372057]=(Pssp*pow(zbar,rrho)*Hs[16]*Hs[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2396633]=(Pssp*pow(zbar,rrho)*(Hs[17]*Hs[24] + Hs[16]*Hs[25])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2421209]=(Pssp*pow(zbar,rrho)*(Hs[18]*Hs[24] + Hs[16]*Hs[26])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2445785]=(Pssp*pow(zbar,rrho)*(Hs[19]*Hs[24] + Hs[16]*Hs[27])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2470361]=(Pssp*pow(zbar,rrho)*(Hs[20]*Hs[24] + Hs[16]*Hs[28])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2494937]=(Pssp*pow(zbar,rrho)*(Hs[21]*Hs[24] + Hs[16]*Hs[29])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2519513]=(Pssp*pow(zbar,rrho)*(Hs[22]*Hs[24] + Hs[16]*Hs[30])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2544089]=(Pssp*pow(zbar,rrho)*(Hs[23]*Hs[24] + Hs[16]*Hs[31])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2593241]=(Pssp*pow(zbar,rrho)*Hs[17]*Hs[25]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2617817]=(Pssp*pow(zbar,rrho)*(Hs[18]*Hs[25] + Hs[17]*Hs[26])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2642393]=(Pssp*pow(zbar,rrho)*(Hs[19]*Hs[25] + Hs[17]*Hs[27])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2666969]=(Pssp*pow(zbar,rrho)*(Hs[20]*Hs[25] + Hs[17]*Hs[28])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2691545]=(Pssp*pow(zbar,rrho)*(Hs[21]*Hs[25] + Hs[17]*Hs[29])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2716121]=(Pssp*pow(zbar,rrho)*(Hs[22]*Hs[25] + Hs[17]*Hs[30])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2740697]=(Pssp*pow(zbar,rrho)*(Hs[23]*Hs[25] + Hs[17]*Hs[31])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2814425]=(Pssp*pow(zbar,rrho)*Hs[18]*Hs[26]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2839001]=(Pssp*pow(zbar,rrho)*(Hs[19]*Hs[26] + Hs[18]*Hs[27])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2863577]=(Pssp*pow(zbar,rrho)*(Hs[20]*Hs[26] + Hs[18]*Hs[28])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2888153]=(Pssp*pow(zbar,rrho)*(Hs[21]*Hs[26] + Hs[18]*Hs[29])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2912729]=(Pssp*pow(zbar,rrho)*(Hs[22]*Hs[26] + Hs[18]*Hs[30])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[2937305]=(Pssp*pow(zbar,rrho)*(Hs[23]*Hs[26] + Hs[18]*Hs[31])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3035609]=(Pssp*pow(zbar,rrho)*Hs[19]*Hs[27]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3060185]=(Pssp*pow(zbar,rrho)*(Hs[20]*Hs[27] + Hs[19]*Hs[28])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3084761]=(Pssp*pow(zbar,rrho)*(Hs[21]*Hs[27] + Hs[19]*Hs[29])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3109337]=(Pssp*pow(zbar,rrho)*(Hs[22]*Hs[27] + Hs[19]*Hs[30])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3133913]=(Pssp*pow(zbar,rrho)*(Hs[23]*Hs[27] + Hs[19]*Hs[31])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3256793]=(Pssp*pow(zbar,rrho)*Hs[20]*Hs[28]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3281369]=(Pssp*pow(zbar,rrho)*(Hs[21]*Hs[28] + Hs[20]*Hs[29])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3305945]=(Pssp*pow(zbar,rrho)*(Hs[22]*Hs[28] + Hs[20]*Hs[30])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3330521]=(Pssp*pow(zbar,rrho)*(Hs[23]*Hs[28] + Hs[20]*Hs[31])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3477977]=(Pssp*pow(zbar,rrho)*Hs[21]*Hs[29]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3502553]=(Pssp*pow(zbar,rrho)*(Hs[22]*Hs[29] + Hs[21]*Hs[30])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3527129]=(Pssp*pow(zbar,rrho)*(Hs[23]*Hs[29] + Hs[21]*Hs[31])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3699161]=(Pssp*pow(zbar,rrho)*Hs[22]*Hs[30]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3723737]=(Pssp*pow(zbar,rrho)*(Hs[23]*Hs[30] + Hs[22]*Hs[31])*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[3920345]=(Pssp*pow(zbar,rrho)*Hs[23]*Hs[31]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxx_sp_s[237018]=-Pssp;
	Mxx_sp_s[238555]=-Pssp;
	Mxx_sp_s[240092]=-Pssp;
	Mxx_sp_s[244701]=-Pssp;
	Mxx_sp_s[243166]=-Pssp;
	Mxx_sp_s[241631]=-Pssp;
	Mxx_sp_s[256992]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mxx_sp_s[1278432]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mxx_sp_s[1279968]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mxx_sp_s[1290720]=-(pow(E,yss[8])*Pssp);
	Mxx_sp_s[1292256]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxx_sp_s[1293792]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxx_sp_s[249313]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[250849]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[252385]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[1279969]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxx_sp_s[1281505]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[1286113]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mxx_sp_s[1290721]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mxx_sp_s[1292257]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[1293793]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[249314]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[250850]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[1279970]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[1281506]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxx_sp_s[1286114]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mxx_sp_s[1289186]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[1290722]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mxx_sp_s[1292258]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[1293794]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxx_sp_s[246243]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[247779]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[249315]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[250851]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mxx_sp_s[252387]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[253923]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[255459]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[256995]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[1286115]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mxx_sp_s[1290723]=-(pow(E,yss[8])*Pssp);
	Mxx_sp_s[1292259]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mxx_sp_s[1293795]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mxx_sp_s[2372067]=(bbeta*pow(E,yss[8])*Pssp*Hs[16]*Hs[32]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2396643]=(bbeta*pow(E,yss[8])*Pssp*(Hs[17]*Hs[32] + Hs[16]*Hs[33])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2421219]=(bbeta*pow(E,yss[8])*Pssp*(Hs[18]*Hs[32] + Hs[16]*Hs[34])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2445795]=(bbeta*pow(E,yss[8])*Pssp*(Hs[19]*Hs[32] + Hs[16]*Hs[35])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2470371]=(bbeta*pow(E,yss[8])*Pssp*(Hs[20]*Hs[32] + Hs[16]*Hs[36])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2494947]=(bbeta*pow(E,yss[8])*Pssp*(Hs[21]*Hs[32] + Hs[16]*Hs[37])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2519523]=(bbeta*pow(E,yss[8])*Pssp*(Hs[22]*Hs[32] + Hs[16]*Hs[38])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2544099]=(bbeta*pow(E,yss[8])*Pssp*(Hs[23]*Hs[32] + Hs[16]*Hs[39])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2593251]=(bbeta*pow(E,yss[8])*Pssp*Hs[17]*Hs[33]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2617827]=(bbeta*pow(E,yss[8])*Pssp*(Hs[18]*Hs[33] + Hs[17]*Hs[34])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2642403]=(bbeta*pow(E,yss[8])*Pssp*(Hs[19]*Hs[33] + Hs[17]*Hs[35])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2666979]=(bbeta*pow(E,yss[8])*Pssp*(Hs[20]*Hs[33] + Hs[17]*Hs[36])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2691555]=(bbeta*pow(E,yss[8])*Pssp*(Hs[21]*Hs[33] + Hs[17]*Hs[37])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2716131]=(bbeta*pow(E,yss[8])*Pssp*(Hs[22]*Hs[33] + Hs[17]*Hs[38])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2740707]=(bbeta*pow(E,yss[8])*Pssp*(Hs[23]*Hs[33] + Hs[17]*Hs[39])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2814435]=(bbeta*pow(E,yss[8])*Pssp*Hs[18]*Hs[34]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2839011]=(bbeta*pow(E,yss[8])*Pssp*(Hs[19]*Hs[34] + Hs[18]*Hs[35])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2863587]=(bbeta*pow(E,yss[8])*Pssp*(Hs[20]*Hs[34] + Hs[18]*Hs[36])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2888163]=(bbeta*pow(E,yss[8])*Pssp*(Hs[21]*Hs[34] + Hs[18]*Hs[37])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2912739]=(bbeta*pow(E,yss[8])*Pssp*(Hs[22]*Hs[34] + Hs[18]*Hs[38])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[2937315]=(bbeta*pow(E,yss[8])*Pssp*(Hs[23]*Hs[34] + Hs[18]*Hs[39])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3035619]=(bbeta*pow(E,yss[8])*Pssp*Hs[19]*Hs[35]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3060195]=(bbeta*pow(E,yss[8])*Pssp*(Hs[20]*Hs[35] + Hs[19]*Hs[36])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3084771]=(bbeta*pow(E,yss[8])*Pssp*(Hs[21]*Hs[35] + Hs[19]*Hs[37])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3109347]=(bbeta*pow(E,yss[8])*Pssp*(Hs[22]*Hs[35] + Hs[19]*Hs[38])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3133923]=(bbeta*pow(E,yss[8])*Pssp*(Hs[23]*Hs[35] + Hs[19]*Hs[39])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3256803]=(bbeta*pow(E,yss[8])*Pssp*Hs[20]*Hs[36]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3281379]=(bbeta*pow(E,yss[8])*Pssp*(Hs[21]*Hs[36] + Hs[20]*Hs[37])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3305955]=(bbeta*pow(E,yss[8])*Pssp*(Hs[22]*Hs[36] + Hs[20]*Hs[38])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3330531]=(bbeta*pow(E,yss[8])*Pssp*(Hs[23]*Hs[36] + Hs[20]*Hs[39])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3477987]=(bbeta*pow(E,yss[8])*Pssp*Hs[21]*Hs[37]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3502563]=(bbeta*pow(E,yss[8])*Pssp*(Hs[22]*Hs[37] + Hs[21]*Hs[38])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3527139]=(bbeta*pow(E,yss[8])*Pssp*(Hs[23]*Hs[37] + Hs[21]*Hs[39])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3699171]=(bbeta*pow(E,yss[8])*Pssp*Hs[22]*Hs[38]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3723747]=(bbeta*pow(E,yss[8])*Pssp*(Hs[23]*Hs[38] + Hs[22]*Hs[39])*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[3920355]=(bbeta*pow(E,yss[8])*Pssp*Hs[23]*Hs[39]*(1 + yss[5]))/pow(zbar,rrho);
	Mxx_sp_s[246244]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mxx_sp_s[247780]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mxx_sp_s[249316]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mxx_sp_s[250852]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mxx_sp_s[252388]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mxx_sp_s[253924]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mxx_sp_s[255460]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mxx_sp_s[256996]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mxx_sp_s[1287652]=-(kkappa*Pssp*yss[9]);
	Mxx_sp_s[1290724]=pow(E,yss[8])*Pssp;
	Mxx_sp_s[1292260]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mxx_sp_s[1293796]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mxx_sp_s[2361316]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[16]*Hs[32]);
	Mxx_sp_s[2362852]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[16]*Hs[32];
	Mxx_sp_s[2365924]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[16]*Hs[32]);
	Mxx_sp_s[2372068]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[16]*Hs[32])/pow(zbar,rrho);
	Mxx_sp_s[2385892]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[17]*Hs[32] + Hs[16]*Hs[33]));
	Mxx_sp_s[2387428]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[17]*Hs[32] + Hs[16]*Hs[33]);
	Mxx_sp_s[2390500]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[17]*Hs[32] + Hs[16]*Hs[33]));
	Mxx_sp_s[2396644]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[17]*Hs[32] + Hs[16]*Hs[33]))/pow(zbar,rrho);
	Mxx_sp_s[2410468]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[18]*Hs[32] + Hs[16]*Hs[34]));
	Mxx_sp_s[2412004]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[18]*Hs[32] + Hs[16]*Hs[34]);
	Mxx_sp_s[2415076]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[18]*Hs[32] + Hs[16]*Hs[34]));
	Mxx_sp_s[2421220]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[18]*Hs[32] + Hs[16]*Hs[34]))/pow(zbar,rrho);
	Mxx_sp_s[2435044]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[19]*Hs[32] + Hs[16]*Hs[35]));
	Mxx_sp_s[2436580]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[19]*Hs[32] + Hs[16]*Hs[35]);
	Mxx_sp_s[2439652]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[19]*Hs[32] + Hs[16]*Hs[35]));
	Mxx_sp_s[2445796]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[19]*Hs[32] + Hs[16]*Hs[35]))/pow(zbar,rrho);
	Mxx_sp_s[2459620]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[20]*Hs[32] + Hs[16]*Hs[36]));
	Mxx_sp_s[2461156]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[20]*Hs[32] + Hs[16]*Hs[36]);
	Mxx_sp_s[2464228]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[20]*Hs[32] + Hs[16]*Hs[36]));
	Mxx_sp_s[2470372]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[20]*Hs[32] + Hs[16]*Hs[36]))/pow(zbar,rrho);
	Mxx_sp_s[2484196]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[21]*Hs[32] + Hs[16]*Hs[37]));
	Mxx_sp_s[2485732]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[21]*Hs[32] + Hs[16]*Hs[37]);
	Mxx_sp_s[2488804]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[21]*Hs[32] + Hs[16]*Hs[37]));
	Mxx_sp_s[2494948]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[21]*Hs[32] + Hs[16]*Hs[37]))/pow(zbar,rrho);
	Mxx_sp_s[2508772]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[22]*Hs[32] + Hs[16]*Hs[38]));
	Mxx_sp_s[2510308]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[22]*Hs[32] + Hs[16]*Hs[38]);
	Mxx_sp_s[2513380]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[22]*Hs[32] + Hs[16]*Hs[38]));
	Mxx_sp_s[2519524]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[22]*Hs[32] + Hs[16]*Hs[38]))/pow(zbar,rrho);
	Mxx_sp_s[2533348]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[23]*Hs[32] + Hs[16]*Hs[39]));
	Mxx_sp_s[2534884]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[23]*Hs[32] + Hs[16]*Hs[39]);
	Mxx_sp_s[2537956]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[23]*Hs[32] + Hs[16]*Hs[39]));
	Mxx_sp_s[2544100]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[23]*Hs[32] + Hs[16]*Hs[39]))/pow(zbar,rrho);
	Mxx_sp_s[2582500]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[17]*Hs[33]);
	Mxx_sp_s[2584036]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[17]*Hs[33];
	Mxx_sp_s[2587108]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[17]*Hs[33]);
	Mxx_sp_s[2593252]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[17]*Hs[33])/pow(zbar,rrho);
	Mxx_sp_s[2607076]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[18]*Hs[33] + Hs[17]*Hs[34]));
	Mxx_sp_s[2608612]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[18]*Hs[33] + Hs[17]*Hs[34]);
	Mxx_sp_s[2611684]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[18]*Hs[33] + Hs[17]*Hs[34]));
	Mxx_sp_s[2617828]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[18]*Hs[33] + Hs[17]*Hs[34]))/pow(zbar,rrho);
	Mxx_sp_s[2631652]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[19]*Hs[33] + Hs[17]*Hs[35]));
	Mxx_sp_s[2633188]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[19]*Hs[33] + Hs[17]*Hs[35]);
	Mxx_sp_s[2636260]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[19]*Hs[33] + Hs[17]*Hs[35]));
	Mxx_sp_s[2642404]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[19]*Hs[33] + Hs[17]*Hs[35]))/pow(zbar,rrho);
	Mxx_sp_s[2656228]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[20]*Hs[33] + Hs[17]*Hs[36]));
	Mxx_sp_s[2657764]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[20]*Hs[33] + Hs[17]*Hs[36]);
	Mxx_sp_s[2660836]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[20]*Hs[33] + Hs[17]*Hs[36]));
	Mxx_sp_s[2666980]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[20]*Hs[33] + Hs[17]*Hs[36]))/pow(zbar,rrho);
	Mxx_sp_s[2680804]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[21]*Hs[33] + Hs[17]*Hs[37]));
	Mxx_sp_s[2682340]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[21]*Hs[33] + Hs[17]*Hs[37]);
	Mxx_sp_s[2685412]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[21]*Hs[33] + Hs[17]*Hs[37]));
	Mxx_sp_s[2691556]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[21]*Hs[33] + Hs[17]*Hs[37]))/pow(zbar,rrho);
	Mxx_sp_s[2705380]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[22]*Hs[33] + Hs[17]*Hs[38]));
	Mxx_sp_s[2706916]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[22]*Hs[33] + Hs[17]*Hs[38]);
	Mxx_sp_s[2709988]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[22]*Hs[33] + Hs[17]*Hs[38]));
	Mxx_sp_s[2716132]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[22]*Hs[33] + Hs[17]*Hs[38]))/pow(zbar,rrho);
	Mxx_sp_s[2729956]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[23]*Hs[33] + Hs[17]*Hs[39]));
	Mxx_sp_s[2731492]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[23]*Hs[33] + Hs[17]*Hs[39]);
	Mxx_sp_s[2734564]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[23]*Hs[33] + Hs[17]*Hs[39]));
	Mxx_sp_s[2740708]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[23]*Hs[33] + Hs[17]*Hs[39]))/pow(zbar,rrho);
	Mxx_sp_s[2803684]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[18]*Hs[34]);
	Mxx_sp_s[2805220]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[18]*Hs[34];
	Mxx_sp_s[2808292]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[18]*Hs[34]);
	Mxx_sp_s[2814436]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[18]*Hs[34])/pow(zbar,rrho);
	Mxx_sp_s[2828260]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[19]*Hs[34] + Hs[18]*Hs[35]));
	Mxx_sp_s[2829796]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[19]*Hs[34] + Hs[18]*Hs[35]);
	Mxx_sp_s[2832868]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Hs[19]*Hs[34] + Hs[18]*Hs[35]));
	Mxx_sp_s[2839012]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*(Hs[19]*Hs[34] + Hs[18]*Hs[35]))/pow(zbar,rrho);
	Mxx_sp_s[2852836]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Hs[20]*Hs[34] + Hs[18]*Hs[36]));
	Mxx_sp_s[2854372]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Hs[20]*Hs[34] + Hs[18]*Hs[36]);
	Mxx_sp_s